# バッチ設計書 33-compile-database

## 概要

本ドキュメントは、JuliaのCランタイムソースコード（`src/`、`src/flisp/`、`src/support/`）に対するコンパイルデータベース（`compile_commands.json`）を生成するMakefileターゲット `compile-database` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、JuliaのC/C++ソースコード群に対して、clangツーリング（clang-tidy、clangd等のLanguage Server Protocol対応ツール）が使用するコンパイルデータベースファイル（`compile_commands.json`）を生成する。`src/`ディレクトリ、`src/flisp/`ディレクトリ、`src/support/`ディレクトリの3つのコンポーネントについて個別にコンパイルデータベースを生成し、IDE支援や静的解析を可能にする。

**業務上の目的・背景**：JuliaのランタイムはC/C++で記述されており、開発者がコードナビゲーション、自動補完、静的解析などのIDE機能を活用するためには、各ソースファイルのコンパイルオプション（インクルードパス、マクロ定義、コンパイラフラグ等）を正確に記述したコンパイルデータベースが必要である。本バッチは、既存のclangツーリングインフラストラクチャを活用して、正確なコンパイルフラグ情報を含む`compile_commands.json`を自動生成する。これにより開発者の生産性向上とコード品質の維持に貢献する。

**バッチの実行タイミング**：`make compile-database`として手動実行される。また、`src/`ディレクトリ内のreleaseまたはdebugビルド時に`regenerate-compile_commands`ターゲットを通じて自動的に実行される。flisp/supportのビルド時も同様に自動実行される。

**主要な処理内容**：
1. `src/Makefile`の`regenerate-compile_commands`ターゲットで、メインソースコード（SRCS、CODEGEN_SRCS）のコンパイルデータベースを生成する
2. インクルードされるC/C++ファイル（INCLUDED_CXX_FILES等）のエントリも生成する
3. 追加ヘッダファイル（ADDITIONAL_C_HEADERS、ADDITIONAL_CXX_HEADERS）のエントリも生成する
4. `src/flisp/Makefile`の`compile-database`ターゲットでflispのコンパイルデータベースを生成する
5. `src/support/Makefile`の`compile-database`ターゲットでsupportライブラリのコンパイルデータベースを生成する
6. 各コンパイルデータベースは一時ファイルに書き出し、既存ファイルと差分がある場合のみ更新する（アトミック更新）

**前後の処理との関連**：本バッチはビルドシステムの静的解析インフラストラクチャ（`clang-sa-*`、`clang-tidy-*`、`clang-sagc-*`ターゲット）と同じコンパイラフラグ定義（`CLANG_TOOLING_C_FLAGS`、`CLANG_TOOLING_CXX_FLAGS`）を共有する。releaseおよびdebugビルド時に依存ターゲットとして自動実行される。

**影響範囲**：`src/`ビルドディレクトリ内の`compile_commands.json`ファイル（3箇所：src本体、flisp、support）が生成・更新される。IDE設定やエディタのLanguage Serverに影響する。

## バッチ種別

ユーティリティ処理（開発ツール支援 / コンパイルデータベース生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時自動 + 手動） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | `make compile-database`（手動）、またはrelease/debugビルド時に自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド環境の構成完了 | `Make.inc`が正しく設定され、LLVM関連のコンパイラフラグが解決可能であること |
| escape_json.shの存在 | `contrib/escape_json.sh`が利用可能であること（JSONエスケープ処理に使用） |
| mktemp利用可能 | 一時ファイル作成のためmktempコマンドが利用可能であること |
| cmp利用可能 | 差分比較のためcmpコマンドが利用可能であること |

### 実行可否判定

特別な実行可否判定はない。Makefileターゲットとして常に実行可能。ただしLLVM関連のコンパイラフラグが未設定の場合、不完全なコンパイルデータベースが生成される可能性がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| SRCS | Makefile変数 | Yes | Makefile内で定義 | メインソースファイル一覧（内部向けライブラリ） |
| CODEGEN_SRCS | Makefile変数 | Yes | Makefile内で定義 | コード生成関連ソースファイル一覧 |
| INCLUDED_CXX_FILES | Makefile変数 | No | Makefile内で定義 | インクルードされるC++ファイルのペア一覧 |
| ADDITIONAL_C_HEADERS | Makefile変数 | No | Makefile内で定義 | 追加のCヘッダファイル一覧 |
| ADDITIONAL_CXX_HEADERS | Makefile変数 | No | Makefile内で定義 | 追加のC++ヘッダファイル一覧 |
| CLANG_TOOLING_C_FLAGS | Makefile変数 | Yes | Makefile内で定義 | C言語用のclangツーリングフラグ |
| CLANG_TOOLING_CXX_FLAGS | Makefile変数 | Yes | Makefile内で定義 | C++用のclangツーリングフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Makefile | Makefile | メインソースのビルド定義とソースファイル一覧 |
| src/flisp/Makefile | Makefile | flispコンポーネントのビルド定義 |
| src/support/Makefile | Makefile | supportライブラリのビルド定義 |
| contrib/escape_json.sh | シェルスクリプト | コンパイラ引数のJSONエスケープ処理 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| `$(BUILDDIR)/compile_commands.json`（src） | JSON | メインソースのコンパイルデータベース |
| `$(BUILDDIR)/flisp/compile_commands.json` | JSON | flispのコンパイルデータベース |
| `$(BUILDDIR)/support/compile_commands.json` | JSON | supportのコンパイルデータベース |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `compile_commands.json` |
| 出力先 | 各コンポーネントのBUILDDIR |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（JSON形式） |

出力JSONの各エントリは以下の構造を持つ：

```json
{
  "directory": "<ソースディレクトリの絶対パス>",
  "file": "<ソースファイル名>",
  "arguments": ["clang", "<フラグ1>", "<フラグ2>", ..., "<ソースファイル名>"]
}
```

## 処理フロー

### 処理シーケンス

```
1. src/のcompile-database実行
   1.1 regenerate-compile_commands実行
       1.1.1 一時ファイルを作成（mktemp）
       1.1.2 CフラグとC++フラグをescape_json.shでJSON用にエスケープ
       1.1.3 SRCSの各ソースファイルについてJSONエントリを生成
             └─ .cpp/.cの拡張子に応じてC++/Cフラグを使い分け
             └─ INTERNAL/CODEGENのexportフラグを使い分け
       1.1.4 CODEGEN_SRCSの各ソースファイルについてJSONエントリを生成
       1.1.5 INCLUDED_CXX_FILESのインクルードファイルについてJSONエントリを生成
       1.1.6 ADDITIONAL_C_HEADERS/ADDITIONAL_CXX_HEADERSのエントリを生成
       1.1.7 一時ファイルと既存ファイルをcmpで比較
       1.1.8 差分がある場合のみmvで更新（アトミック更新）
       1.1.9 差分がない場合は一時ファイルを削除
2. src/flisp/のcompile-database実行
   └─ 同様のregenerate-compile_commandsを実行（flispソース用）
3. src/support/のcompile-database実行
   └─ 同様のregenerate-compile_commandsを実行（supportソース用）
4. 完了メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[make compile-database] --> B[src: regenerate-compile_commands]
    B --> C[一時ファイル作成]
    C --> D[コンパイラフラグをJSONエスケープ]
    D --> E[SRCSのJSONエントリ生成]
    E --> F[CODEGEN_SRCSのJSONエントリ生成]
    F --> G[インクルードファイルのJSONエントリ生成]
    G --> H[追加ヘッダのJSONエントリ生成]
    H --> I{既存ファイルと差分あり?}
    I -->|Yes| J[mvで更新]
    I -->|No| K[一時ファイル削除]
    J --> L[flisp: compile-database]
    K --> L
    L --> M[support: compile-database]
    M --> N[完了メッセージ出力]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルシステム上にJSONファイルを生成する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | mktemp失敗 | ディスク容量不足、BUILDDIRが存在しない | BUILDDIRの存在確認、ディスク容量の確認 |
| N/A | escape_json.sh失敗 | contrib/escape_json.shが見つからない | Juliaソースツリーの整合性を確認 |
| N/A | コンパイラフラグ解決失敗 | LLVM関連の設定が不完全 | Make.incの設定を確認、依存関係のインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構未実装） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

一時ファイルが残存する場合は手動で削除する。`make clean`を実行すると`compile_commands.json*`パターンのファイルが全て削除される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | コンポーネント単位（src、flisp、supportそれぞれ独立） |
| コミットタイミング | 一時ファイルへの書き込み完了後、cmp比較を経てmvで更新（アトミック更新） |
| ロールバック条件 | 差分がない場合は一時ファイルを削除し既存ファイルを保持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | src: 数十〜百数十ファイル、flisp: 約10ファイル、support: 約10ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制約なし（シェルスクリプトによるテキスト処理のみ） |

## 排他制御

同一BUILDDIRに対する複数のcompile-database実行は競合する可能性がある。mktemp + cmp + mvによるアトミック更新パターンにより、不完全なファイルが書き込まれるリスクを軽減している。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 完了ログ | 各コンポーネント処理完了時 | `Compilation database created for src`、`...for src/flisp`、`...for src/support` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | ビルドプロセス（Makefileが検出） |

## 備考

- `compile_commands.json`は[JSON Compilation Database Format Specification](https://clang.llvm.org/docs/JSONCompilationDatabase.html)に準拠している。
- 本バッチはreleaseおよびdebugビルド時に`regenerate-compile_commands`として自動実行されるため、通常の開発フローではビルドのたびに最新のコンパイルデータベースが維持される。
- アトミック更新パターン（一時ファイル → cmp比較 → mvまたは削除）により、コンパイルデータベースを参照中のIDEツールへの影響を最小化している。
- `CLANG_TOOLING_C_FLAGS`および`CLANG_TOOLING_CXX_FLAGS`は、静的解析（clang-sa、clang-tidy）と共有されるコンパイラフラグ定義である。
- C/C++ソースファイルの拡張子（`.c`/`.cpp`）に基づいてCフラグとC++フラグを自動的に使い分ける。
- `DJL_LIBRARY_EXPORTS_INTERNAL`と`DJL_LIBRARY_EXPORTS_CODEGEN`のエクスポートフラグは、ソースファイルがリンクされるライブラリに応じて自動設定される。
