# バッチ設計書 34-build-stats

## 概要

本ドキュメントは、Juliaのビルド成果物のバイナリサイズ統計と起動速度ベンチマークを表示するMakefileターゲット `build-stats` のバッチ設計書である。

### 本バッチの処理概要

本バッチは、Juliaのビルド完了後にビルド成果物（システムイメージ、共有ライブラリ、実行ファイル）のセクション別サイズ情報を`llvm-size`コマンドで表示し、さらにJuliaの起動速度を3回計測して表示する。ビルドの品質と性能を素早く確認するための開発者向けユーティリティである。

**業務上の目的・背景**：Juliaの開発において、ビルド成果物のサイズと起動速度は重要なパフォーマンス指標である。コードの変更がバイナリサイズの肥大化や起動速度の低下を引き起こしていないかを素早く確認するため、本バッチはワンコマンドでこれらの統計情報を出力する。CI環境でのリグレッション検出や、開発者のローカル環境でのビルド品質確認に活用される。

**バッチの実行タイミング**：`make build-stats`として手動実行される。ビルド完了後の検証工程で使用されることが想定される。

**主要な処理内容**：
1. BinaryBuilderを使用している場合、llvm-toolsの依存関係をインストールする
2. `llvm-size -A`コマンドで以下のバイナリのセクション別サイズを表示する：
   - `sys.$(SHLIB_EXT)`（システムイメージ）
   - `libjulia.$(SHLIB_EXT)`（Julia公開ライブラリ）
   - `libjulia-internal.$(SHLIB_EXT)`（Julia内部ライブラリ）
   - `libjulia-codegen.$(SHLIB_EXT)`（コード生成ライブラリ）
   - `julia`（実行ファイル）
   - `libLLVM.$(SHLIB_EXT)`（LLVMライブラリ、macOSとLinuxで異なるファイル名）
3. Juliaの起動速度を3回計測する（`time julia -e ''`）

**前後の処理との関連**：ビルド（`make release`または`make debug`）が完了していることが前提。本バッチは情報出力のみであり、後続処理への影響はない。

**影響範囲**：本バッチは読み取り専用の情報出力であり、ファイルシステムやビルド成果物に変更を加えない。標準出力にサイズ統計と計測結果を表示する。

## バッチ種別

ユーティリティ処理（ビルド品質計測 / レポート表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | `make build-stats`（手動実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | Juliaのビルド（release/debug）が完了し、成果物が存在すること |
| llvm-sizeの利用可能性 | システムLLVM使用時は`llvm-size`コマンド、それ以外はビルドされたllvm-sizeが利用可能であること |
| timeコマンド利用可能 | シェルのtime組み込みまたはtimeコマンドが利用可能であること |

### 実行可否判定

特別な実行可否判定はない。ビルド成果物が存在しない場合、llvm-sizeがエラーを報告する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| USE_SYSTEM_LLVM | Makefile変数 | No | 0 | システムのLLVMを使用するかどうか（1の場合はシステムのllvm-sizeを使用） |
| USE_BINARYBUILDER_LLVM | Makefile変数 | No | 1 | BinaryBuilderのLLVMを使用するかどうか（1の場合はllvm-toolsをインストール） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| `$(build_private_libdir)/sys.$(SHLIB_EXT)` | バイナリ | システムイメージ |
| `$(build_shlibdir)/libjulia.$(SHLIB_EXT)` | バイナリ | Julia公開共有ライブラリ |
| `$(build_shlibdir)/libjulia-internal.$(SHLIB_EXT)` | バイナリ | Julia内部共有ライブラリ |
| `$(build_shlibdir)/libjulia-codegen.$(SHLIB_EXT)` | バイナリ | コード生成共有ライブラリ |
| `$(build_bindir)/julia$(EXE)` | バイナリ | Julia実行ファイル |
| `$(build_shlibdir)/libLLVM.$(SHLIB_EXT)` | バイナリ | LLVMライブラリ（macOS） |
| `$(build_shlibdir)/$(LLVM_SHARED_LIB_NAME).$(SHLIB_EXT)` | バイナリ | LLVMライブラリ（Linux等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | セクション別バイナリサイズ統計（llvm-size -A形式） |
| 標準出力/標準エラー | テキスト | Julia起動速度計測結果（timeコマンド出力） |

### 出力ファイル仕様

本バッチはファイル出力を行わない。全ての出力は標準出力/標準エラーに対して行われる。

## 処理フロー

### 処理シーケンス

```
1. LLVM Tools依存関係のインストール（条件付き）
   └─ USE_BINARYBUILDER_LLVM=1の場合、make -C deps install-llvm-toolsを実行
2. バイナリサイズ表示ヘッダ出力
   └─ カラー付きで「==> ./julia binary sizes」を表示
3. メインバイナリのサイズ表示
   └─ llvm-size -A で以下のファイルのセクション別サイズを表示：
      sys.so/dylib、libjulia、libjulia-internal、libjulia-codegen、julia
4. LLVMライブラリのサイズ表示
   └─ macOSの場合: libLLVM.dylib
   └─ その他の場合: $(LLVM_SHARED_LIB_NAME).so
5. 起動速度計測ヘッダ出力
   └─ カラー付きで「==> ./julia launch speedtest」を表示
6. 起動速度計測（3回）
   └─ time julia -e '' を3回実行し、各回の実行時間を表示
```

### フローチャート

```mermaid
flowchart TD
    A[make build-stats] --> B{USE_BINARYBUILDER_LLVM=1?}
    B -->|Yes| C[make -C deps install-llvm-tools]
    B -->|No| D[スキップ]
    C --> E[バイナリサイズ表示ヘッダ出力]
    D --> E
    E --> F[llvm-size -A: sys, libjulia, libjulia-internal, libjulia-codegen, julia]
    F --> G{OS = Darwin?}
    G -->|Yes| H[llvm-size -A: libLLVM.dylib]
    G -->|No| I[llvm-size -A: LLVM_SHARED_LIB_NAME.so]
    H --> J[起動速度計測ヘッダ出力]
    I --> J
    J --> K[time julia -e '' 1回目]
    K --> L[time julia -e '' 2回目]
    L --> M[time julia -e '' 3回目]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。読み取り専用の情報出力バッチ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | llvm-size未検出 | llvm-sizeがPATHに存在しない | LLVMツールをインストール、またはUSE_BINARYBUILDER_LLVM=1でビルド |
| N/A | バイナリ未存在 | ビルドが完了していない | `make release`または`make debug`を先に実行 |
| N/A | julia起動失敗 | juliaバイナリが正常にビルドされていない | ビルドログを確認し、ビルドエラーを解決 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構未実装） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

本バッチは情報出力のみであり、障害時のリカバリは不要。エラーが発生した場合はビルド環境の整合性を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 6〜7個のバイナリファイル + 3回の起動計測 |
| 目標処理時間 | 数秒〜十数秒（Julia起動速度に依存） |
| メモリ使用量上限 | 特に制約なし（llvm-sizeおよびjuliaプロセスのメモリ使用量に依存） |

## 排他制御

読み取り専用の処理であるため、排他制御は不要。ただし起動速度計測は他のプロセスの負荷に影響を受けるため、正確な計測にはシステムが低負荷の状態であることが望ましい。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダログ | バイナリサイズ表示前 | `==> ./julia binary sizes`（カラー出力） |
| サイズ情報 | 各バイナリ処理時 | llvm-size -A の出力（セクション名、サイズ、アドレス） |
| ヘッダログ | 起動計測前 | `==> ./julia launch speedtest`（カラー出力） |
| 計測結果 | 各起動計測時 | timeコマンドの出力（real、user、sys） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | ビルドプロセス（Makefileが検出） |

## 備考

- `llvm-size -A`はSystem V形式でセクション別サイズを表示する。各セクション（.text、.data、.bss等）のサイズとアドレスが出力される。
- macOSとLinuxでLLVMライブラリの命名規則が異なるため、OS判定によりファイルパスを切り替えている。
- 起動速度計測を3回実行するのは、初回起動のオーバーヘッド（キャッシュのウォームアップ等）を考慮し、安定した計測値を得るためである。
- `JULCOLOR`および`ENDCOLOR`変数によるカラー出力はターミナルの視認性向上のために使用されている。
- `$(call spawn,...)`はJuliaのMakefileヘルパーで、コマンドの実行をラップする。
- `$(call cygpath_w,...)`はCygwin環境でのパス変換ヘルパーであり、Windowsビルドとの互換性を維持する。
