# バッチ設計書 5-cffconvert

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるcffconvert GitHub Actionsワークフローのバッチ設計書である。CITATION.cffファイルの変更時にCFF（Citation File Format）メタデータの妥当性を検証するCI/CDパイプラインの一部として機能する。

### 本バッチの処理概要

このバッチは、CITATION.cffファイルが変更されたプッシュまたはプルリクエスト時に自動実行され、CFFメタデータの形式が仕様に準拠しているかを検証するCI/CDワークフローである。

**業務上の目的・背景**：Juliaプロジェクトは学術論文での引用を支援するためにCITATION.cffファイルを提供している。CFF（Citation File Format）は学術ソフトウェアの引用情報を機械可読な形式で記述するための標準フォーマットである。このファイルが不正な形式で更新されると、引用情報の自動取得に失敗するため、変更時に自動的にバリデーションを実行し、形式の正当性を保証する。

**バッチの実行タイミング**：masterブランチまたはrelease-*ブランチへのプッシュ時、およびこれらのブランチに対するプルリクエスト時に、CITATION.cffファイルが変更された場合のみ自動実行される。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. citation-file-format/cffconvert-github-actionによるCITATION.cffの妥当性検証（--validateオプション）

**前後の処理との関連**：本バッチは独立したCIジョブであり、他のバッチとの直接的な依存関係はない。CITATION.cffファイルの更新はNo.18のupdateSPDX.jlとリリースプロセスで関連する可能性がある。

**影響範囲**：CITATION.cffファイルのみが検査対象。検証に失敗した場合はCIが失敗し、不正な引用メタデータのマージを防止する。

## バッチ種別

コード品質チェック（メタデータ検証）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | GitHub Actionsイベント（push/pull_request、CITATION.cffのパス変更時のみ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリ上で動作すること |
| ランナー環境 | ubuntu-latestが利用可能であること |
| CITATION.cff | リポジトリのルートにCITATION.cffが存在すること |

### 実行可否判定

以下の条件を満たす場合に自動的に実行される：
- イベントがmasterブランチまたはrelease-*ブランチへのpush、またはこれらのブランチに対するpull_request
- 変更ファイルにCITATION.cffが含まれていること（paths: CITATION.cff）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| args | String | Yes | "--validate" | cffconvertの実行引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CITATION.cff | YAML | プロジェクトの引用メタデータファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions Check | ステータス | 成功（バリデーションパス）または失敗（バリデーションエラー） |
| stdout/stderr | テキスト | cffconvertのバリデーション結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（ファイル出力なし） |
| 出力先 | GitHub Actions実行ログ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. リポジトリチェックアウト
   └─ actions/checkout@v6.0.2でリポジトリのソースコードを取得（persist-credentials: false）
2. CFFバリデーション
   └─ citation-file-format/cffconvert-github-action@2.0.0で--validateオプションを実行
      └─ CITATION.cffのスキーマ検証、必須フィールドの存在確認、値の型チェックなどを実施
```

### フローチャート

```mermaid
flowchart TD
    A[push/PR イベント - CITATION.cff変更] --> B[リポジトリチェックアウト]
    B --> C[cffconvert --validate 実行]
    C --> D{バリデーション結果}
    D -->|成功| E[チェック成功]
    D -->|失敗| F[チェック失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| validation error | CFF形式エラー | CITATION.cffがCFF仕様に準拠していない場合 | CITATION.cffの内容を修正して再プッシュ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

バリデーションエラーの場合は、cffconvertの出力メッセージを確認し、CITATION.cffの該当箇所を修正する。CFF仕様はhttps://citation-file-format.github.io/で確認できる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（CITATION.cffファイル） |
| 目標処理時間 | GitHub Actionsのデフォルトタイムアウト内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準上限 |

## 排他制御

読み取り専用の検証処理であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | GitHub Actionsのステップログに自動記録 |
| バリデーション結果 | 検証完了時 | cffconvertのバリデーション結果（成功/エラー詳細） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHub PR Checksタブ |

## 備考

- permissionsはcontents: readに設定されている
- citation-file-format/cffconvert-github-action@2.0.0（コミットハッシュ固定：4cf11baa70a673bfdf9dad0acc7ee33b3f4b6084）を使用
- 対象ブランチはmasterおよびrelease-*パターンに限定されている
- パスフィルタでCITATION.cffのみを対象としているため、他のファイル変更では実行されない
- timeout-minutesは明示的に設定されていない（GitHub Actionsのデフォルト：360分）
