# バッチ設計書 7-Dependabot

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるDependabot設定のバッチ設計書である。GitHub Actionsの依存関係を月次で自動更新するDependabot設定ファイルによって定義される自動化バッチである。

### 本バッチの処理概要

このバッチは、GitHubのDependabot機能を利用して、リポジトリ内のGitHub Actionsワークフローで使用されているアクションの依存関係を月次で自動チェック・更新するバッチ処理である。

**業務上の目的・背景**：Juliaプロジェクトでは多数のGitHub Actionsワークフロー（Whitespace、Typos、LabelCheck、PrAssignee、cffconvertなど）がサードパーティアクションに依存している。これらのアクションにセキュリティ修正や機能改善がリリースされた場合、迅速に更新する必要がある。Dependabotを使用することで、依存関係の更新を自動的に検出しPRとして提案し、人間によるレビュー・マージプロセスを通じて安全に更新を適用する。

**バッチの実行タイミング**：月次スケジュールで自動実行される。GitHubのDependabotサービスがバックグラウンドで定期実行する。

**主要な処理内容**：
1. リポジトリのルートディレクトリ（"/"）に存在するGitHub Actionsワークフローファイルをスキャン
2. 各ワークフローで使用されているアクションの最新バージョンを確認
3. 更新が利用可能な場合、自動的にPRを作成
4. PRには`dependencies`、`github-actions`、`ci`ラベルが自動付与される

**前後の処理との関連**：本バッチはDependabotサービスによる独立した自動処理であるが、No.4 PrAssigneeワークフローによりDependabotのPRは自動アサインがスキップされる（dependabotがコラボレーターリストに追加されているため）。

**影響範囲**：リポジトリ内の全GitHub Actionsワークフローファイル（.github/workflows/*.yml）が対象。更新PRが100件まで同時にオープン可能（open-pull-requests-limit: 100）。

## バッチ種別

自動化処理（依存関係管理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 月次 |
| 実行時刻 | GitHubが管理（設定なし） |
| 実行曜日 | GitHubが管理（設定なし） |
| 実行日 | GitHubが管理（設定なし） |
| トリガー | Dependabotスケジュール（monthly） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリでDependabotが有効であること |
| Dependabotサービス | GitHubのDependabotサービスが利用可能であること |

### 実行可否判定

GitHubのDependabotサービスにより月次で自動実行される。リポジトリ設定でDependabotが無効にされていない限り自動的に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| package-ecosystem | String | Yes | "github-actions" | スキャン対象のパッケージエコシステム |
| directory | String | Yes | "/" | スキャン対象のディレクトリ |
| schedule.interval | String | Yes | "monthly" | 実行間隔 |
| open-pull-requests-limit | Integer | Yes | 100 | 同時にオープン可能なPR数の上限 |
| labels | Array | Yes | ["dependencies", "github-actions", "ci"] | PRに付与するラベル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .github/workflows/*.yml | YAML | GitHub Actionsワークフローファイル |
| GitHub Actions Marketplace | API | 各アクションの最新バージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR | PR | 依存関係更新のプルリクエスト |
| PRラベル | テキスト | dependencies, github-actions, ciラベル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | PRの変更対象ワークフローファイル |
| 出力先 | GitHub PR（ブランチ上） |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Dependabotスケジュール実行（月次）
   └─ GitHubのDependabotサービスが起動
2. ワークフローファイルスキャン
   └─ ルートディレクトリ（"/"）配下のGitHub Actionsワークフローを解析
3. 依存関係チェック
   └─ 各ワークフローで使用されているアクションのバージョンを確認
4. 更新PR作成
   ├─ 更新が利用可能なアクションごとにPRを作成
   ├─ dependencies, github-actions, ciラベルを付与
   └─ 100件を上限として同時にPRをオープン
```

### フローチャート

```mermaid
flowchart TD
    A[月次スケジュール実行] --> B[ワークフローファイルスキャン]
    B --> C[各アクションの最新バージョン確認]
    C --> D{更新が利用可能?}
    D -->|Yes| E[更新PRを作成]
    E --> F[ラベル付与]
    F --> G{PR数が100未満?}
    G -->|Yes| D
    G -->|No| H[上限到達 - 処理終了]
    D -->|No| I[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはGitHub Dependabotサービスによる処理である。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| service error | Dependabotサービスエラー | GitHubのDependabotサービスが一時的に利用不可 | 次回スケジュール時に自動リトライ |
| PR limit | PR上限到達 | オープンPR数が100件に到達 | 既存のDependabot PRをレビュー・マージまたはクローズ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHubのDependabotサービス管理 |
| リトライ間隔 | GitHubのDependabotサービス管理 |
| リトライ対象エラー | GitHubのDependabotサービス管理 |

### 障害時対応

Dependabotの実行に問題がある場合は、GitHub Dependabotのセキュリティアラートおよびリポジトリの「Insights > Dependency graph > Dependabot」タブを確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（PRのクローズで対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リポジトリ内の全GitHub Actionsワークフローで使用されるアクション数 |
| 目標処理時間 | GitHubのDependabotサービス管理 |
| メモリ使用量上限 | GitHubのDependabotサービス管理 |

## 排他制御

GitHubのDependabotサービスにより管理されており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | Dependabot実行時 | GitHub Dependabotダッシュボードで確認可能 |
| PR作成 | 更新検出時 | PRのタイトルと変更内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| Dependabot実行状態 | N/A | GitHub Dependabotダッシュボード |
| セキュリティアラート | 脆弱性検出時 | GitHub Security Alerts |

## 備考

- Dependabotの設定ファイルはバージョン2形式（version: 2）を使用
- パッケージエコシステムは"github-actions"のみが対象（npm、pip等は含まれない）
- open-pull-requests-limitが100に設定されており、大量のPRが同時にオープンされる可能性がある
- PRに自動付与されるラベル（dependencies, github-actions, ci）はリポジトリ側で事前にラベルを作成しておく必要がある
- No.4 PrAssigneeワークフローではdependabotがコラボレーターリストに明示的に追加されており、DependabotのPRには自動アサインが行われない
