# バッチ設計書 9-write_base_cache.jl

## 概要

本ドキュメントは、Juliaプロジェクトにおけるwrite_base_cache.jlバッチスクリプトのバッチ設計書である。Baseモジュールのソースキャッシュファイル（base.cache）を生成するバッチスクリプトであり、Juliaのビルドプロセスの一部として機能する。

### 本バッチの処理概要

このバッチは、Juliaのビルドプロセスにおいて、Baseモジュールに含まれるソースファイルの内容をバイナリキャッシュファイル（base.cache）として書き出すスクリプトである。生成されたキャッシュファイルはBase._read_dependency_srcで読み込まれ、ソースコードの高速参照に使用される。

**業務上の目的・背景**：Juliaのパッケージプリコンパイルやコード解析において、Baseモジュールのソースコードを参照する必要がある場面がある。ファイルシステムから毎回読み込むのは非効率であるため、ビルド時にBaseモジュールの全ソースファイルを1つのバイナリキャッシュファイルにまとめて格納することで、ランタイム時のソースコード参照を高速化する。このスクリプトはMakefileのjulia-base-cacheターゲットから呼び出される。

**バッチの実行タイミング**：Juliaのビルドプロセス（`make`コマンド実行時）において、システムイメージ生成後にjulia-base-cacheターゲットの一部として自動実行される。

**主要な処理内容**：
1. 引数からキャッシュファイルのパスを取得
2. Base._included_filesからBaseモジュールに含まれるファイル一覧を取得
3. 各ファイルの内容を読み込み、ファイル名とソースコードをバイナリ形式で書き出し
4. 終端マーカー（Int32(0)）を書き出し

**前後の処理との関連**：本バッチはMakefileのjulia-base-cacheターゲットから呼び出される。前提として、julia-sysimg-（release/debug）ターゲットによるシステムイメージの生成が完了している必要がある。No.8 generate_precompile.jlとともにビルドプロセスの後半で実行される。

**影響範囲**：生成されるbase.cacheファイル（build_datarootdir/julia/base.cache）に影響を与える。このキャッシュファイルはJuliaランタイムでBase._read_dependency_srcが使用する。

## バッチ種別

ビルド処理（キャッシュ生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド時（随時） |
| 実行時刻 | N/A（ビルドプロセスの一部） |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Makefileのjulia-base-cacheターゲット |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Juliaバイナリ | ビルド済みのJulia実行ファイル（JULIA_EXECUTABLE）が利用可能であること |
| システムイメージ | julia-sysimg-release（またはdebug）が生成済みであること |
| ビルドディレクトリ | build_datarootdir/juliaディレクトリが存在すること |
| ARGS[1] | 出力先のキャッシュファイルパスが引数として指定されること |

### 実行可否判定

Makefileのjulia-base-cacheターゲットが依存関係として解決された場合に自動的に実行される。julia-sysimg-(JULIA_BUILD_MODE)が前提ターゲットとして設定されている。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ARGS[1] | String | Yes | N/A | 出力先キャッシュファイルのパス（例: build_datarootdir/julia/base.cache） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Base._included_files | Julia内部 | Baseモジュールに含まれるファイルの一覧（タプル配列） |
| 各ソースファイル | テキスト | Baseモジュールの各Juliaソースファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| base.cache | バイナリ | Baseモジュールのソースキャッシュファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | base.cache |
| 出力先 | build_datarootdir/julia/（Makefileで指定） |
| 文字コード | バイナリ（ソース部分はUTF-8） |
| 区切り文字 | N/A（バイナリフォーマット） |

#### バイナリフォーマット詳細

```
[繰り返し]
  Int32: ファイル名のバイト長
  String: ファイル名（バイト長分）
  UInt64: ソースコードのバイト長
  String: ソースコード（バイト長分）
[終端]
  Int32: 0（終端マーカー）
```

## 処理フロー

### 処理シーケンス

```
1. キャッシュファイルパスの取得
   └─ ARGS[1]から出力先パスを取得
2. ファイルオープン
   └─ open(cachefile, "w")で書き込みモードでオープン
3. ソースファイルの列挙と書き出し
   └─ Base._included_filesのイテレーション
      ├─ 各ファイルのパスからソースコードを読み込み
      ├─ Int32(sizeof(filename))を書き出し
      ├─ filenameを書き出し
      ├─ UInt64(sizeof(src))を書き出し
      └─ srcを書き出し
4. 終端マーカーの書き出し
   └─ Int32(0)を書き出し
5. ファイルクローズ
   └─ open doブロックにより自動クローズ
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[ARGS 1 からキャッシュファイルパス取得]
    B --> C[キャッシュファイルを書き込みモードでオープン]
    C --> D[Base._included_filesから次のファイル取得]
    D --> E{ファイルあり?}
    E -->|Yes| F[ソースコード読み込み]
    F --> G[ファイル名長 Int32 書き出し]
    G --> H[ファイル名書き出し]
    H --> I[ソースコード長 UInt64 書き出し]
    I --> J[ソースコード書き出し]
    J --> D
    E -->|No| K[終端マーカー Int32 0 書き出し]
    K --> L[ファイルクローズ]
    L --> M[スクリプト終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。本バッチはファイルシステム操作のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOError | ファイル読み込みエラー | _included_filesに列挙されたファイルが存在しない場合 | ビルド環境の整合性を確認 |
| IOError | ファイル書き込みエラー | 出力先ディレクトリが存在しないか書き込み権限がない場合 | ビルドディレクトリの状態を確認 |
| BoundsError | 引数不足 | ARGS[1]が指定されていない場合 | Makefile経由で正しく引数が渡されているか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ビルドエラーが発生した場合は、`make clean`後に再ビルドを行う。base.cacheファイルが破損した場合は、対象ファイルを削除して再ビルドする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（ファイル書き込みの途中失敗時は不完全なファイルが残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | Baseモジュールの全ソースファイル（数百ファイル） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 各ファイルの読み込みはファイル単位で行われるため、最大のソースファイルサイズ程度 |

## 排他制御

ビルドプロセスの一部として1回のみ実行されるため、排他制御は不要。ただし、並行ビルド時にjulia-base-cacheターゲットが複数回実行される場合、最後の書き込みが有効となる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | スクリプト自体にはログ出力がない。Makefileのレベルでビルドログが記録される |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルドエラー | 1回 | Makefileの実行ログ |

## 備考

- スクリプトは非常に簡潔（12行）で、単一目的のユーティリティである
- Base._included_filesはタプルの配列であり、各タプルの2番目の要素がファイルパスである（`_`で最初の要素をスキップ）
- キャッシュファイルのバイナリフォーマットはBase._read_dependency_srcと対になっている
- MakefileではJULIA_BINDIR、JULIA_FALLBACK_REPL=1、WINEPATH環境変数を設定して実行される
- --startup-file=noオプション付きでJuliaが起動される（Makefile定義）
- julia-base-cacheターゲットの依存関係はjulia-sysimg-$(JULIA_BUILD_MODE)であり、システムイメージが先に生成されている必要がある
