---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-Whitespace

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **PRマージブロック動作**：ワークフローがPRのマージをブロックするかはリポジトリ設定に依存し、ワークフロー定義のみからは確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/Whitespace.yml`
- E-02: `contrib/check-whitespace.jl`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.1行）
- E-04: `AGENTS.md`（fix-whitespace記述）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | masterブランチへのpushとpull_requestで実行される | E-01（on: push/pull_request） | ○ |
| C-02 | ubuntu-latestで実行される | E-01（runs-on: ubuntu-latest） | ○ |
| C-03 | タイムアウトは2分 | E-01（timeout-minutes: 2） | ○ |
| C-04 | actions/checkout v6.0.2を使用 | E-01（uses: actions/checkout@de0fac...） | ○ |
| C-05 | julia-actions/setup-julia v2.6.1でJulia 1.11.6をセットアップ | E-01（uses: julia-actions/setup-julia、version: '1.11.6'） | ○ |
| C-06 | contrib/check-whitespace.jlを実行 | E-01（run: contrib/check-whitespace.jl） | ○ |
| C-07 | 18種類のファイルパターンを検査対象とする | E-02（patterns定数） | ○ |
| C-08 | 非UNIX改行コード、非改行スペース、タブ、末尾空白等を検出 | E-02（check_whitespace関数内の各チェック） | ○ |
| C-09 | タブ許可ファイルのリスト（Makefile、Make.inc等） | E-02（allow_tabs関数） | ○ |
| C-10 | --fixオプションで自動修正が可能 | E-02（if "--fix" in ARGS分岐） | ○ |
| C-11 | GitHub Actions環境でアノテーション出力 | E-02（is_gha変数、::warning出力） | ○ |
| C-12 | エラーなしの場合exit 0、エラーありの場合exit 1 | E-02（exit(0)/exit(1)） | ○ |
| C-13 | permissionsは空に設定 | E-01（permissions: {}） | ○ |
| C-14 | persist-credentials: falseが設定されている | E-01（with: persist-credentials: false） | ○ |
| C-15 | git ls-filesで対象ファイル一覧を取得 | E-02（eachline(`git ls-files -- $patterns`)） | ○ |
| C-16 | No.16 check-whitespace.jlと同一スクリプトを利用 | E-03（No.16の備考欄にcontrib/check-whitespace.jl記載） | ○ |
| C-17 | make fix-whitespaceでローカル修正が推奨 | E-04（AGENTS.md記述） | ○ |
| C-18 | エラーがある場合PRのマージがブロックされる | **根拠なし**（リポジトリのブランチ保護設定に依存） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のPRマージブロック動作はリポジトリのブランチ保護設定（Branch Protection Rules）に依存するため、ワークフロー定義のみからは確認できない
  - 候補：GitHub リポジトリ設定 / Branch Protection Rules / CODEOWNERS

## 5) リスクフラグ（レビュー観点）
- C-18: 0（低リスク）- 一般的なOSSプロジェクトではCI失敗時のマージブロックは標準的な設定であり、実運用上の影響は小さい

## 6) レビュアーチェックリスト（最小）
- [ ] ワークフローのトリガーイベント（push/pull_request）が正しく記載されているか確認
- [ ] check-whitespace.jlの検査項目が網羅的に記載されているか確認
- [ ] タブ許可ファイルのリストが最新のソースコードと一致しているか確認
