---
generated_at: 2026-02-05 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：13-full-source-dist

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な計測データなし

## 2) 参照した情報（Evidence一覧）

- E-01: `Makefile` 683-698行（full-source-distターゲット定義）
- E-02: `Makefile` 645-666行（light-source-dist.tmpターゲット定義）
- E-03: `Makefile` 678-680行（source-dist非推奨メッセージ）
- E-04: `Makefile` 710-713行（cleanターゲットでの一時ファイル削除）
- E-05: `contrib/prepare_release.sh` 28-30行（full-source-dist呼び出し）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全依存関係を含む完全なソース配布物を作成する | E-01, E-06 | ○ |
| C-02 | light-source-dist.tmpを前提として使用する | E-01 | ○ |
| C-03 | deps getallで全依存関係をダウンロードする | E-01 | ○ |
| C-04 | light-source-dist.tmpをfull-source-dist.tmpにコピーする | E-01 | ○ |
| C-05 | deps/srccache/内の複数形式のアーカイブを含む | E-01 | ○ |
| C-06 | 出力ファイル名に-fullサフィックスが付与される | E-01 | ○ |
| C-07 | source-distは非推奨でfull-source-distが推奨 | E-03 | ○ |
| C-08 | prepare_release.shから呼び出される | E-05 | ○ |
| C-09 | DEPS_GIT=0でtarball形式取得 | E-01 | ○ |
| C-10 | USE_BINARYBUILDER=0でソースtarball取得 | E-01 | ○ |
| C-11 | make cleanで一時ファイルが削除される | E-04 | ○ |
| C-12 | --no-recursionオプションを使用 | E-01 | ○ |
| C-13 | 目標処理時間は10分〜30分程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な計測データが存在しない
  - 候補：CI/CDビルドログ / リリースプロセスの記録

## 5) リスクフラグ（レビュー観点）
- 0: パフォーマンス要件の数値は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] Makefileのfull-source-distターゲットの処理手順と設計書が一致しているか
- [ ] deps/srccache/に含まれるファイル形式の記述が網羅的か
- [ ] light-source-distとの差分の記述が正確か
