---
generated_at: 2026-02-05 10:25:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-check-whitespace.jl

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/check-whitespace.jl` 全体（スクリプト定義）
- E-02: `contrib/check-whitespace.jl` 3-18行（対象パターンリスト）
- E-03: `contrib/check-whitespace.jl` 25-33行（タブ許可ファイル定義）
- E-04: `contrib/check-whitespace.jl` 35-65行（--fixモード処理）
- E-05: `contrib/check-whitespace.jl` 67-108行（チェック処理）
- E-06: `contrib/check-whitespace.jl` 21行（GITHUB_ACTIONS環境変数）
- E-07: `contrib/check-whitespace.jl` 96-104行（GHAアノテーション出力）
- E-08: `AGENTS.md`（make fix-whitespaceの記載）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースコード内のホワイトスペースエラーを検出する | E-01, E-09 | ○ |
| C-02 | --fixオプションで自動修正可能 | E-04 | ○ |
| C-03 | 対象ファイルパターンが14種類 | E-02 | ○ |
| C-04 | タブ許可ファイルが定義されている | E-03 | ○ |
| C-05 | 引数なしの場合git ls-filesを使用 | E-01 | ○ |
| C-06 | GITHUB_ACTIONS環境変数を参照 | E-06 | ○ |
| C-07 | ::warning形式でGHAアノテーション出力 | E-07 | ○ |
| C-08 | 非UNIX改行を検出 | E-05 | ○ |
| C-09 | 非ブレーキングスペースを検出 | E-05 | ○ |
| C-10 | タブを検出（許可ファイル除外） | E-05 | ○ |
| C-11 | 行末空白を検出 | E-05 | ○ |
| C-12 | 末尾空行を検出 | E-05 | ○ |
| C-13 | 行末改行なしを検出 | E-05 | ○ |
| C-14 | --fixでタブを4スペースに変換 | E-04 | ○ |
| C-15 | エラー検出時に終了コード1で終了 | E-05 | ○ |
| C-16 | エラーなしで終了コード0 | E-05 | ○ |
| C-17 | AGENTS.mdでmake fix-whitespaceが推奨 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコードからの直接的な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 対象ファイルパターンリストがソースコードと一致しているか
- [ ] タブ許可ファイルリストがソースコードと一致しているか
- [ ] 検出エラー種別の記述が網羅的か
