---
generated_at: 2026-02-05 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-Typos

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **typos設定ファイルの除外設定**：偽陽性時の除外方法について具体的な設定ファイルパスが不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/Typos.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.2行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pull_requestイベントのみで実行される | E-01（on: [pull_request]） | ○ |
| C-02 | ubuntu-latestで実行、タイムアウト5分 | E-01（runs-on/timeout-minutes） | ○ |
| C-03 | ベースブランチをfetch --depth=1で取得 | E-01（git fetch --depth=1） | ○ |
| C-04 | OLD_FILESはdiff-filter=adで取得 | E-01（--diff-filter=ad） | ○ |
| C-05 | NEW_FILESはdiff-filter=dで取得 | E-01（--diff-filter=d） | ○ |
| C-06 | NEW_FILESが空の場合スキップ | E-01（if [ -z "$NEW_FILES" ]） | ○ |
| C-07 | gh APIで最新リリースURLを取得 | E-01（gh api /repos/crate-ci/typos/releases/latest） | ○ |
| C-08 | TLS 1.3でダウンロード、3回リトライ | E-01（--secure-protocol=TLSv1_3 --tries=3） | ○ |
| C-09 | x86_64-unknown-linux-musl版をダウンロード | E-01（test pattern in jq） | ○ |
| C-10 | --format jsonで実行しJSONL出力 | E-01（typos --format json） | ○ |
| C-11 | Pythonスクリプトで新旧比較 | E-01（python -c スクリプト） | ○ |
| C-12 | 6文字以下のタイポはCI失敗させない | E-01（if len(new["typo"]) > 6） | ○ |
| C-13 | ::warning形式でアノテーション出力 | E-01（print("::warning file=..."）） | ○ |
| C-14 | GH_TOKENにgithub.tokenを使用 | E-01（env: GH_TOKEN） | ○ |
| C-15 | permissionsは空 | E-01（permissions: {}） | ○ |
| C-16 | 偽陽性時にtypos設定ファイルに除外登録が可能 | **根拠なし**（リポジトリ内のtypos設定ファイルの存在を確認していない） | △ |

## 4) 不足情報（Unknown / Missing）
- C-16のtypos除外設定について、リポジトリ内に`_typos.toml`や`.typos.toml`等の設定ファイルが存在するかは未確認
  - 候補：`_typos.toml` / `.typos.toml` / `typos.toml`

## 5) リスクフラグ（レビュー観点）
- C-16: 0（低リスク）- typosツールの標準機能であり、運用上の一般的な対処方法として妥当

## 6) レビュアーチェックリスト（最小）
- [ ] typosツールの取得方法（GitHub API + wget）が正しく記載されているか確認
- [ ] 新旧比較ロジック（Pythonスクリプト）の動作が正確に記載されているか確認
- [ ] 6文字の閾値に関する記述が正しいか確認（ソースコードでは`> 6`なので7文字超でCI失敗）
