---
generated_at: 2026-02-05 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-print_sorted_stdlibs.jl バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **sysimg.jlとの関連性の記載**：直接的なコード参照はなくコメントに基づく推測

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/print_sorted_stdlibs.jl` （ソースコード全体、行1-123）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行23：No.22の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TOMLパッケージを使用して依存関係を解析 | E-01 (行4: using TOML, 行34: TOML.parsefile) | ○ |
| C-02 | --help/-hフラグで使用方法を表示 | E-01 (行14-16: check_flag) | ○ |
| C-03 | --exclude-jllsオプションに対応 | E-01 (行19: exclude_jlls) | ○ |
| C-04 | --exclude-sysimageオプションに対応 | E-01 (行20: exclude_sysimage) | ○ |
| C-05 | --only-sysimgオプションに対応 | E-01 (行21: only_sysimage) | ○ |
| C-06 | デフォルトstdlibディレクトリはusr/share/julia/stdlib/ | E-01 (行24: joinpath) | ○ |
| C-07 | vX.Yサブディレクトリの自動検出 | E-01 (行26-28: match r"v\d\.\d") | ○ |
| C-08 | Project.tomlからname/depsを読み込む | E-01 (行33-42: parsefile, name, deps) | ○ |
| C-09 | project_depth関数で再帰的にdepthを計算 | E-01 (行47-68: project_depth) | ○ |
| C-10 | 100イテレーションで収束しない場合エラー | E-01 (行57-58: depth > 100, error) | ○ |
| C-11 | depth順+アルファベット順でソート | E-01 (行72-79: project_isless, sort) | ○ |
| C-12 | JLLパッケージのフィルタリング | E-01 (行81-83: filter endswith _jll) | ○ |
| C-13 | --only-sysimgと--exclude-sysimage同時指定で警告 | E-01 (行85-88: println stderr Warning) | ○ |
| C-14 | Base.loaded_modulesでsysimageパッケージを判定 | E-01 (行91: loaded_modules_set) | ○ |
| C-15 | Julia配列リテラル形式で出力 | E-01 (行112-122: println stdlibs = [...]) | ○ |
| C-16 | depthごとにコメントを出力 | E-01 (行114-119: "No dependencies", "depth packages") | ○ |
| C-17 | 読み取り専用でファイル変更なし | E-01 (全体: writeやopen(..., "w")の不在) | ○ |
| C-18 | 出力はsysimg.jlに使用される | E-01 (行100, 102: コメント "pasted into sysimg.jl") | ○ |
| C-19 | check_flag関数がARGSから該当引数を除去 | E-01 (行6-12: popat! ARGS) | ○ |
| C-20 | No.21 new-stdlib.shの後に使用が推奨される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：new-stdlib.shとの連携についてはソースコード内に明示的な記述がない。バッチ一覧の説明と一般的な開発ワークフローからの推測である
  - 候補：開発者ガイドライン / CONTRIBUTING.md / new-stdlib.shの終了メッセージ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のユーティリティスクリプトであり、ソースコードが明確

## 6) レビュアーチェックリスト（最小）
- [ ] depth計算アルゴリズムの説明が実際のコードロジックと一致しているか
- [ ] フィルタリングオプションの動作説明が正確か
- [ ] 出力形式の例が実際の出力と一致しているか
