---
generated_at: 2026-02-05 10:20:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：25-doctest バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **doctestブロック数の見積もり**：具体的なカウントデータがない
  2. **メモリ使用量の見積もり**：実測値がない

## 2) 参照した情報（Evidence一覧）

- E-01: `doc/Makefile` （行19-21: doctest/linkcheckオプション、行61-65: htmlターゲット）
- E-02: `doc/make.jl` （行420: doctest判定、行325-347: Revise設定、行349-390: DocTestSetup）
- E-03: `AGENTS.md` （doctestに関する指示）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行26：No.25の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | doctest=trueオプションで検証実行 | E-01 (行20), E-02 (行420) | ○ |
| C-02 | doctest=fixで自動修正可能 | E-01 (行21), E-02 (行420: :fix) | ○ |
| C-03 | doctest=onlyで検証のみ | E-02 (行420: :only) | ○ |
| C-04 | revise=trueでRevise.jlを使用可能 | E-02 (行325-329), E-03 | ○ |
| C-05 | Reviseでbase/stdlibの変更を反映 | E-02 (行332-346: track Base, Compiler, stdlibs) | ○ |
| C-06 | 各stdlibにDocTestSetupを設定 | E-02 (行349-358) | ○ |
| C-07 | SparseArraysはLinearAlgebraも含むsetup | E-02 (行361-366) | ○ |
| C-08 | UUIDsはRandomも含むsetup | E-02 (行367-372) | ○ |
| C-09 | PkgはPkg.Artifactsも含むsetup | E-02 (行373-378) | ○ |
| C-10 | Baseは空のsetup | E-02 (行379-384: :(;;)) | ○ |
| C-11 | makedocsのdoctestパラメータで制御 | E-02 (行420) | ○ |
| C-12 | 最大15分かかる可能性がある | E-03 (doctestの記述) | ○ |
| C-13 | タイムアウト前に強制終了してはならない | E-03 (doctestの記述) | ○ |
| C-14 | make -C doc doctest=true revise=trueで実行 | E-03 (実行コマンド例) | ○ |
| C-15 | juliaupバイナリでも実行可能 | E-03 (JULIA_EXECUTABLEオプション) | ○ |
| C-16 | HTML生成と同じmake.jlを共有 | E-01, E-02 | ○ |
| C-17 | jldoctests.mdにベストプラクティスが記載 | E-03 (jldoctests.md参照の記述) | ○ |
| C-18 | 数百件のdoctestブロック | **根拠なし** | △ |
| C-19 | メモリ使用量は数GB | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：doctestブロックの正確な数はソースコードを網羅的にカウントしないと確認できない
  - 候補：grep -c "jldoctest" によるカウント / Documenterのログ出力
- C-19について：メモリ使用量は実測データがなく推定値
  - 候補：CIログ / プロファイリング結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - doctestの仕組み自体はDocumenter.jlの確立された機能であり、設計書の記載内容は主にソースコードとAGENTS.mdに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] doctest=true/fix/onlyの各モードの動作説明が正確か
- [ ] DocTestSetupの設定内容が最新のmake.jlと一致しているか
- [ ] Reviseモードの使用手順がAGENTS.mdと一致しているか
