---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：27-test バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **処理時間の見積もり**：実測データがない

## 2) 参照した情報（Evidence一覧）

- E-01: `Makefile` （行740-761: test/test-%/test-revise-%ターゲット）
- E-02: `test/Makefile` （行1-51: テスト実行設定）
- E-03: `AGENTS.md` （テスト関連の指示）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行28：No.27の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | make testでデフォルトテスト実行 | E-01 (行740-742) | ○ |
| C-02 | check-whitespaceに依存 | E-01 (行741: check-whitespace) | ○ |
| C-03 | test/Makefileのdefaultターゲット呼び出し | E-01 (行742), E-02 (行36-37: default:) | ○ |
| C-04 | test-%パターンで個別テスト実行 | E-01 (行755-758) | ○ |
| C-05 | sysimageが100秒以内再ビルドでヒント表示 | E-01 (行756-757: 100秒チェック, WARNCOLOR) | ○ |
| C-06 | test-revise-%でReviseモードテスト | E-01 (行760-761) | ○ |
| C-07 | revise-*ターゲットは--reviseフラグ付き | E-02 (行49-51: --revise) | ○ |
| C-08 | runtests.jlを呼び出し | E-02 (行41-42: runtests.jl) | ○ |
| C-09 | テスト実行オプション --check-bounds=yes | E-02 (行33) | ○ |
| C-10 | テスト実行オプション --startup-file=no | E-02 (行33) | ○ |
| C-11 | テスト実行オプション --depwarn=error | E-02 (行33) | ○ |
| C-12 | --buildroot引数を渡す | E-02 (行34) | ○ |
| C-13 | テストグループにunicode/strings等 | E-02 (行19: TESTGROUPS) | ○ |
| C-14 | JULIA_TEST_FAILFASTで即座に停止可能 | E-03 | ○ |
| C-15 | テスト変更時にtest-revise-*が推奨される | E-03 | ○ |
| C-16 | 新規テストは既存ファイルに追加推奨 | E-03 | ○ |
| C-17 | test/ディレクトリ内のjlファイルがテスト対象 | E-02 (行20-25: TESTS定義) | ○ |
| C-18 | testallとは異なりsysimage検証なし | E-01 (行740-742 vs 744-749) | ○ |
| C-19 | test実行はファイルを変更しない | E-01, E-02 (テスト実行フロー) | ○ |
| C-20 | 個別テスト実行時間は数秒から数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：テスト実行時間はテストの内容に依存し、実測データがない
  - 候補：CIログ / 開発者の経験知

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Makefileのターゲット定義が明確で追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] test/test-%/test-revise-%の各ターゲットの動作が正確に記載されているか
- [ ] テストグループ一覧が最新のtest/Makefileと一致しているか
- [ ] Reviseモードの使用手順がAGENTS.mdと一致しているか
