---
generated_at: 2026-02-05 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-fixup-rpath.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/fixup-rpath.sh` （ソースコード全体、行1-34）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行29：No.28の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数が3つ必要 | E-01 (行6-10: $# -ne 3) | ○ |
| C-02 | 第1引数はpatchelfパス | E-01 (行12: patchelf="$1") | ○ |
| C-03 | 第2引数は処理対象ディレクトリ | E-01 (行13: executable_dir="$2") | ○ |
| C-04 | 第3引数はビルドlibdir | E-01 (行14: build_libdir="$3") | ○ |
| C-05 | findで実行可能ファイルを走査 | E-01 (行16: find -type f -perm -111) | ○ |
| C-06 | patchelf --print-rpathでRPATH取得 | E-01 (行18: --print-rpath) | ○ |
| C-07 | grep -FでRPATH内のbuild_libdir存在チェック | E-01 (行21: grep -F) | ○ |
| C-08 | build_libdirが含まれない場合スキップ | E-01 (行21-23: continue) | ○ |
| C-09 | tr/grepでbuild_libdirをRPATHから除去 | E-01 (行26: tr, grep -vF) | ○ |
| C-10 | 末尾コロンを除去 | E-01 (行28: ${new_rpath%?}) | ○ |
| C-11 | 変更ログを出力 | E-01 (行30: echo "Setting RPATH") | ○ |
| C-12 | patchelf --set-rpathで新RPATHを設定 | E-01 (行33: --set-rpath) | ○ |
| C-13 | 引数不足時はUsage表示してexit 1 | E-01 (行7-10) | ○ |
| C-14 | RPATHはコロン区切り | E-01 (行26: tr : \\n) | ○ |
| C-15 | インプレースでバイナリを修正 | E-01 (行33: 同じファイルに対してset-rpath) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 短いシェルスクリプトで全処理が明確に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] RPATH除去ロジック（tr/grep）の説明が正確か
- [ ] patchelfの操作がインプレースであることの記載が正確か
