---
generated_at: 2026-02-05 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-fixup-libgfortran.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/fixup-libgfortran.sh` （ソースコード全体、行1-162）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行30：No.29の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FC環境変数のデフォルトはgfortran | E-01 (行5: FC=${FC:-gfortran}) | ○ |
| C-02 | PATCHELF環境変数のデフォルトはpatchelf | E-01 (行6: PATCHELF=${PATCHELF:-patchelf}) | ○ |
| C-03 | --verbose/-vでデバッグメッセージ有効化 | E-01 (行9-13: debug関数) | ○ |
| C-04 | private_libdir未指定でUsage表示してexit 1 | E-01 (行16-19) | ○ |
| C-05 | uname -sでプラットフォーム検出 | E-01 (行21: uname -s) | ○ |
| C-06 | Linuxの場合SHLIB_EXTはso | E-01 (行23: SHLIB_EXT="so") | ○ |
| C-07 | macOSの場合SHLIB_EXTはdylib | E-01 (行25: SHLIB_EXT="dylib") | ○ |
| C-08 | 不明なプラットフォームはLinuxと仮定して警告 | E-01 (行27-29: WARNING) | ○ |
| C-09 | find_shlib関数でLinuxはpatchelf --print-needed | E-01 (行38-39) | ○ |
| C-10 | find_shlib関数でmacOSはotool -L | E-01 (行41) | ○ |
| C-11 | @rpathや相対パスの場合FCに問い合わせ | E-01 (行53-54: find_shlib_dir, FC -print-file-name) | ○ |
| C-12 | lapack/blas/openblasからlibgfortran検出 | E-01 (行61-62: for lib in lapack blas openblas) | ○ |
| C-13 | libgfortranからlibgcc_s/libquadmath検出 | E-01 (行80-81: LIBGCC_PATH, LIBQUADMATH_PATH) | ○ |
| C-14 | uniquify関数で重複排除 | E-01 (行96-98) | ○ |
| C-15 | SONAMEファイルをprivate_libdirにコピー | E-01 (行106-117: cp -v) | ○ |
| C-16 | chmod 755で権限設定 | E-01 (行110: chmod 755) | ○ |
| C-17 | macOSでinstall_name_tool -idで@rpath変更 | E-01 (行113: install_name_tool -id) | ○ |
| C-18 | 対象ライブラリにlibopenblas/libcholmod/liblapack含む | E-01 (行151: for lib in) | ○ |
| C-19 | macOSでinstall_name_tool -changeでリンケージ修正 | E-01 (行138-140: change_linkage, -change) | ○ |
| C-20 | LinuxでRPATHを$ORIGINに設定 | E-01 (行142: --set-rpath \$ORIGIN) | ○ |
| C-21 | ファイル不存在時はスキップ | E-01 (行129-132: ! -f, return) | ○ |
| C-22 | chmod 755でリンケージ修正前に権限変更 | E-01 (行158: chmod 755) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが詳細で全処理ロジックが明確に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] Linux/macOSの両プラットフォームでの動作が正しく記載されているか
- [ ] ライブラリ依存関係の検出順序が正確か
- [ ] change_linkage関数の動作がプラットフォーム別に正しく説明されているか
