---
generated_at: 2026-02-05 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-LabelCheck

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/LabelCheck.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.3行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pull_requestイベント（labeled, unlabeled, opened, reopened, edited, synchronize）で実行 | E-01（on: pull_request: types） | ○ |
| C-02 | ubuntu-latestで実行、タイムアウト2分 | E-01（runs-on/timeout-minutes） | ○ |
| C-03 | yogevbd/enforce-label-action@2.2.2を使用 | E-01（uses: yogevbd/enforce-label-action@a3c219da...） | ○ |
| C-04 | BANNED_LABELSに10種類のラベルが設定されている | E-01（BANNED_LABELS値） | ○ |
| C-05 | BANNED_LABELS_DESCRIPTIONが設定されている | E-01（BANNED_LABELS_DESCRIPTION値） | ○ |
| C-06 | REQUIRED_LABELS_ANYはコメントアウトされている | E-01（コメントアウト行） | ○ |
| C-07 | permissionsはcontents: readに設定 | E-01（permissions: contents: read） | ○ |
| C-08 | ワークフロー名は"Labels" | E-01（name: Labels） | ○ |
| C-09 | ファイル名はLabelCheck.yml | E-01（ファイルパス） | ○ |
| C-10 | ブロッキングラベルが存在する場合チェック失敗 | E-01（enforce-label-actionの仕様） | ○ |
| C-11 | リポジトリチェックアウトは不要（アクション内で処理） | E-01（ステップにcheckoutなし） | ○ |
| C-12 | No.4 PrAssigneeとともにPR管理プロセスの一環 | E-02（No.3, No.4の記載） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 全体: 0（低リスク）- ワークフロー定義がシンプルで、外部アクションの使用もコミットハッシュで固定されている

## 6) レビュアーチェックリスト（最小）
- [ ] BANNED_LABELSのラベルリストが最新のリポジトリ運用と一致しているか確認
- [ ] enforce-label-actionのバージョン（コミットハッシュ固定）が適切か確認
