---
generated_at: 2026-02-05 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-fixup-libstdc++.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/fixup-libstdc++.sh` （ソースコード全体、行1-39）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （行31：No.30の定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数が2つ必要（libdir, private_libdir） | E-01 (行6-9: $# -ne 2) | ○ |
| C-02 | 第1引数はlibdir | E-01 (行11: libdir="$1") | ○ |
| C-03 | 第2引数はprivate_libdir | E-01 (行12: private_libdir="$2") | ○ |
| C-04 | libjulia-internal.soの存在確認 | E-01 (行14: -f libjulia-internal.so) | ○ |
| C-05 | libjulia-internal-debug.soへのフォールバック | E-01 (行15: -f libjulia-internal-debug.so) | ○ |
| C-06 | 両方存在しない場合exit 2 | E-01 (行16-18: ERROR, exit 2) | ○ |
| C-07 | lddでlibstdc++.soを検出 | E-01 (行23: ldd, grep libstdc++) | ○ |
| C-08 | find_shlib関数でlddのパース | E-01 (行20-25: find_shlib) | ○ |
| C-09 | cut -d' ' -f3でフルパス取得 | E-01 (行23: cut -d' ' -f3) | ○ |
| C-10 | basenameでファイル名取得 | E-01 (行33: basename) | ○ |
| C-11 | dirnameでディレクトリ取得 | E-01 (行34: dirname) | ○ |
| C-12 | private_libdirに未存在の場合のみコピー | E-01 (行36: ! -f private_libdir/LIBSTD_NAME) | ○ |
| C-13 | ソースファイル存在確認 | E-01 (行36: -f LIBSTD_DIR/LIBSTD_NAME) | ○ |
| C-14 | cp -vでコピー | E-01 (行37: cp -v) | ○ |
| C-15 | chmod 755で権限設定 | E-01 (行38: chmod 755) | ○ |
| C-16 | libjulia-internal.soを優先しdebug版はフォールバック | E-01 (行28-32: if/elif) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 短いスクリプトで全処理が明確。冪等性も確保されている

## 6) レビュアーチェックリスト（最小）
- [ ] libjulia-internal.soとdebug版の優先順位が正しく記載されているか
- [ ] lddによるlibstdc++検出の説明が正確か
- [ ] コピーの冪等性（既存ファイルのスキップ）が正しく説明されているか
