---
generated_at: 2026-02-05 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-install.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒未満）**：推定値であり明示的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `contrib/install.sh`（スクリプト本体、35行）
- E-02: `Make.inc`（行397-398: INSTALL_F/INSTALL_M定義）
- E-03: `Makefile`（installターゲットでのINSTALL_F/INSTALL_M使用箇所）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧、行33）
- E-05: `contrib/README.md`（install.shの説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 第1引数がパーミッション値である | E-01（行7: PERMS=$1） | ○ |
| C-02 | 最後の引数がコピー先となる | E-01（行11-15: while $# -gt 1 ... DEST=$1） | ○ |
| C-03 | cp -aでメタデータ保持コピーを行う | E-01（行18: cp -a $SRC $DEST） | ○ |
| C-04 | コピー先がディレクトリの場合ファイル名を自動解決する | E-01（行20-21: -d チェック + basename） | ○ |
| C-05 | シンボリックリンクの場合chmodをスキップする | E-01（行30-32: ! -L チェック） | ○ |
| C-06 | 常にexit 0を返す | E-01（行35: exit 0） | ○ |
| C-07 | INSTALL_Fはパーミッション644で定義される | E-02（行397: INSTALL_F := .../install.sh 644） | ○ |
| C-08 | INSTALL_Mはパーミッション755で定義される | E-02（行398: INSTALL_M := .../install.sh 755） | ○ |
| C-09 | ビルドシステム全体で広く使用される | E-03（Makefile内で多数のINSTALL_F/INSTALL_M使用） | ○ |
| C-10 | バイナリのインストールに使用される | E-03（行359: INSTALL_M $(JULIA_EXECUTABLE_...)） | ○ |
| C-11 | manページのインストールに使用される | E-03（行467: INSTALL_F $(build_man1dir)/julia.1） | ○ |
| C-12 | カテゴリはユーティリティである | E-04（バッチ一覧.csv: カテゴリ=ユーティリティ） | ○ |
| C-13 | installコマンドに類似した機能を提供する | E-05（README.md: Installation script with different permissions） | ○ |
| C-14 | シンボリックリンクスキップはシステムライブラリへの安全対策 | E-01（行27-29: コメントに記載） | ○ |
| C-15 | ログ出力を行わない | E-01（スクリプト全体にecho等の出力命令なし） | ○ |
| C-16 | 1回の呼出あたり1秒未満で完了する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: パフォーマンス要件は推定値。スクリプトの性質（単純なファイルコピー）から妥当な推定だが、大量ファイルの場合は異なる可能性あり。
  - 候補：ビルドログ / ベンチマーク結果 / CI実行ログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトは非常にシンプルで、ソースコードとの整合性が高い
- 1: 中リスク - exit 0固定のためエラー検出不可という設計上の注意点を正しく記載しているか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] cp -aのメタデータ保持動作がプラットフォーム間で一致するか確認
- [ ] シンボリックリンクスキップの挙動がソースコードのコメントと一致しているか
- [ ] exit 0固定によるエラー非検出の影響範囲が正しく記載されているか
- [ ] INSTALL_F/INSTALL_Mの定義がMake.incの実際の値と一致しているか
