---
generated_at: 2026-02-05 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：34-build-stats

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **3回計測の目的（キャッシュウォームアップ）**：推定であり明示的な設計意図の記述なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Makefile`（行774-798: LLVM_SIZE定義およびbuild-statsターゲット）
- E-02: `Makefile`（行774-778: USE_SYSTEM_LLVMによるllvm-sizeパス切替え）
- E-03: `Makefile`（行780-781: USE_BINARYBUILDER_LLVMによるllvm-toolsインストール条件）
- E-04: `Makefile`（行784-788: メインバイナリのllvm-size実行）
- E-05: `Makefile`（行789-793: macOS/Linux判定によるLLVMライブラリパス切替え）
- E-06: `Makefile`（行794-797: 起動速度計測の3回実行）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧、行35）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-size -Aでセクション別バイナリサイズを表示する | E-04（行784: llvm-size -A） | ○ |
| C-02 | sys.$(SHLIB_EXT)が対象に含まれる | E-04（行784: sys.$(SHLIB_EXT)） | ○ |
| C-03 | libjulia.$(SHLIB_EXT)が対象に含まれる | E-04（行785: libjulia.$(SHLIB_EXT)） | ○ |
| C-04 | libjulia-internal.$(SHLIB_EXT)が対象に含まれる | E-04（行786: libjulia-internal.$(SHLIB_EXT)） | ○ |
| C-05 | libjulia-codegen.$(SHLIB_EXT)が対象に含まれる | E-04（行787: libjulia-codegen.$(SHLIB_EXT)） | ○ |
| C-06 | julia実行ファイルが対象に含まれる | E-04（行788: julia$(EXE)） | ○ |
| C-07 | macOSではlibLLVM.dylib、その他ではLLVM_SHARED_LIB_NAME.soを使用 | E-05（行789-793: ifeq $(OS),Darwin条件分岐） | ○ |
| C-08 | USE_BINARYBUILDER_LLVM=1の場合llvm-toolsをインストール | E-03（行780-781: ifeq条件とmake -C deps install-llvm-tools） | ○ |
| C-09 | USE_SYSTEM_LLVM=1の場合システムのllvm-sizeを使用 | E-02（行774-778: ifeq条件分岐） | ○ |
| C-10 | 起動速度計測を3回実行する | E-06（行795-797: time julia -e '' を3回） | ○ |
| C-11 | julia -e ''で空コマンドを実行して計測する | E-06（行795: time julia -e ''） | ○ |
| C-12 | カラー出力でヘッダを表示する | E-01（行783: printf $(JULCOLOR)... $(ENDCOLOR)） | ○ |
| C-13 | 読み取り専用でファイルシステムに変更を加えない | E-01（ターゲット全体を確認、出力コマンドのみ） | ○ |
| C-14 | カテゴリはビルドである | E-07（バッチ一覧.csv: カテゴリ=ビルド） | ○ |
| C-15 | $(call spawn,...)でコマンドをラップしている | E-04, E-05, E-06（各コマンドにspawnラッパー使用） | ○ |
| C-16 | $(call cygpath_w,...)でWindowsパス変換をしている | E-04（行784-788: cygpath_wの使用） | ○ |
| C-17 | make build-statsで手動実行される | E-01（行779: build-stats:ターゲット定義） | ○ |
| C-18 | 3回計測はキャッシュウォームアップのためである | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: 3回計測の目的についてソースコード内にコメント等の明示的な記述がない。一般的なベンチマーク慣行からの推定。
  - 候補：開発者コミュニケーション / コミットメッセージ / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Makefileのターゲット定義は明確であり、ソースコードとの整合性が高い
- 0: 低リスク - 読み取り専用処理のため副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] llvm-size対象の6〜7バイナリが全て正しく列挙されているか
- [ ] macOS/Linux条件分岐のLLVMライブラリパスが正確か
- [ ] USE_BINARYBUILDER_LLVM/USE_SYSTEM_LLVMの条件分岐が正しく記載されているか
- [ ] 3回計測の目的の記述が妥当か（推定であることを認識した上で確認）
