---
generated_at: 2026-02-05 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-PrAssignee

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/PrAssignee.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.4行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pull_request_target (opened, reopened, ready_for_review)で実行 | E-01（on: pull_request_target: types） | ○ |
| C-02 | ドラフトPRはスキップ | E-01（if: draft != true） | ○ |
| C-03 | PRのソースコードをチェックアウトしない | E-01（セキュリティコメント、checkoutステップなし） | ○ |
| C-04 | actions/github-script@v8.0.0を使用 | E-01（uses: actions/github-script@ed5974...） | ○ |
| C-05 | リトライ5回、指数バックオフ | E-01（retries: 5） | ○ |
| C-06 | 404はリトライ対象外 | E-01（retry-exempt-status-codes: 404） | ○ |
| C-07 | push/maintain/admin権限でコラボレーター判定 | E-01（relevantPerms配列） | ○ |
| C-08 | DilumAluthgeBot、dependabotをコラボレーターに追加 | E-01（allCollaboratorsFlattened.push） | ○ |
| C-09 | 既存アサイニーがある場合スキップ | E-01（if oldPrAssignees.length >= 1） | ○ |
| C-10 | RUNNER_DEBUGモードの判定ロジック | E-01（RUNNER_DEBUG処理） | ○ |
| C-11 | JuliaLang/pr-assignment/users.txtからの候補取得 | E-01（github.rest.repos.getContent） | ○ |
| C-12 | 正規表現/^@([a-zA-Z0-9\-]+)/で候補抽出 | E-01（regex定義） | ○ |
| C-13 | Math.random()でランダム選出 | E-01（Math.floor(Math.random()*...）） | ○ |
| C-14 | addAssigneesでアサイン | E-01（github.rest.issues.addAssignees） | ○ |
| C-15 | 設定結果の検証（pulls.get） | E-01（github.rest.pulls.get） | ○ |
| C-16 | 失敗時にエラースロー | E-01（throw new Error） | ○ |
| C-17 | PRラベル付与機能はコメントアウト | E-01（コメントアウトされたaddLabels） | ○ |
| C-18 | permissionsはpull-requests: write | E-01（permissions: pull-requests: write） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 全体: 0（低リスク）- pull_request_targetイベントのセキュリティ注意事項がワークフロー内にコメントで明記されている

## 6) レビュアーチェックリスト（最小）
- [ ] pull_request_targetイベントのセキュリティリスクが適切に説明されているか確認
- [ ] コラボレーター判定ロジックが正確に記載されているか確認
- [ ] users.txt取得とパース処理が正確に記載されているか確認
