---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 188
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：Compiler.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Compiler.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：188 / 200、根拠なし：12
- 優先レビュー（高）
  1. **UT-CMP-125～128 (inline/constprop宣言チェック)**：実際のメソッドオブジェクトのソースフィールドに依存し、テスト前提条件の構築が困難
  2. **UT-CMP-131～133 (validate_code!)**：CodeInfoオブジェクトのモック構築が必要で、入力値の具体化が不十分
  3. **UT-CMP-191～194 (IR/推論系)**：IRCode/AbstractInterpreter依存のテストで、実行環境に大きく依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Compiler/src/Compiler.jl` - モジュール定義、includes、公開関数
- E-02: `Compiler/src/types.jl` - InferenceParams, OptimizationParams, NativeInterpreter, VarState, InferenceResult, CallInfo等の型定義
- E-03: `Compiler/src/typelattice.jl` - Conditional, MustAlias, LimitedAccuracy, NotFound, widenconst, widenconditional, smerge等
- E-04: `Compiler/src/effects.jl` - Effects構造体、各種判定関数、encode/decode、merge関数
- E-05: `Compiler/src/abstractlattice.jl` - JLTypeLattice, ConstsLattice, PartialsLattice, ConditionalsLattice等の格子定義
- E-06: `Compiler/src/typeutils.jl` - isconstType, hasuniquerep, valid_as_lattice, argtypes_to_type, typesubtract, unioncomplexity等
- E-07: `Compiler/src/utilities.jl` - contains_is, count_const_size, is_inlineable_constant, singleton_type, find_ssavalue_uses等
- E-08: `Compiler/src/validation.jl` - validate_code!, is_valid_lvalue, is_valid_argument, is_valid_rvalue, InvalidCodeError
- E-09: `Compiler/src/methodtable.jl` - MethodLookupResult, InternalMethodTable, OverlayMethodTable, CachedMethodTable, findall, findsup
- E-10: `Compiler/src/cicache.jl` - WorldRange, InternalCodeCache
- E-11: `Compiler/src/ssair/basicblock.jl` - StmtRange, BasicBlock
- E-12: `Compiler/src/ssair/domtree.jl` - DFSTree, DomTree, SNCA/DSNCAアルゴリズム
- E-13: `Compiler/src/ssair/disjoint_set.jl` - IntDisjointSet, find_root!, union!, in_same_set
- E-14: `Compiler/src/ssair/heap.jl` - heapleft, heapright, heapparent, percolate_down!, percolate_up!, heapify!, heappush!, heappop!
- E-15: `Compiler/src/ssair/tarjan.jl` - CFGReachability, tarjan!, kill_edge!, kill_cfg_edge!
- E-16: `Compiler/src/sort.jl` - searchsortedfirst, searchsortedlast, searchsorted, sort!
- E-17: `Compiler/src/inferenceresult.jl` - matching_cache_argtypes, most_general_argtypes, elim_free_typevars, constprop_cache_lookup
- E-18: `Compiler/src/opaque_closure.jl` - compute_ir_rettype, compute_oc_signature
- E-19: `Compiler/src/reflection_interface.jl` - _infer_exception_type, _infer_effects, _may_throw_methoderror, findsup_mt
- E-20: `Compiler/src/stmtinfo.jl` - StmtInfo型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01～C-08 | WorldRange構築・操作テスト | E-10 | ○ |
| C-09～C-27 | Effects構築・判定・マージ・エンコード/デコードテスト | E-04 | ○ |
| C-28～C-31 | InferenceParams/OptimizationParams構築テスト | E-02 | ○ |
| C-32～C-37 | NativeInterpreter構築・APIテスト | E-02 | ○ |
| C-38～C-48 | VarState/AnalysisResults/InferenceResult/CallInfo等テスト | E-02 | ○ |
| C-49～C-72 | Conditional/MustAlias/LimitedAccuracy/widenconst等テスト | E-03 | ○ |
| C-73～C-89 | 格子順序(⊑)・tmeet・is_lattice_equal・has_conditional等テスト | E-05 | ○ |
| C-90～C-109 | isconstType/hasuniquerep/valid_as_lattice/typesubtract等テスト | E-06 | ○ |
| C-110～C-130 | contains_is/count_const_size/singleton_type/find_ssavalue_uses等テスト | E-07 | ○ |
| C-131～C-133 | validate_code!テスト（CodeInfo構築が必要） | E-08 | △ |
| C-134～C-144 | is_valid_lvalue/is_valid_argument/is_valid_rvalue/InvalidCodeErrorテスト | E-08 | ○ |
| C-145～C-149 | MethodLookupResult/InternalMethodTable/CachedMethodTableテスト | E-09 | ○ |
| C-150～C-154 | StmtRange/BasicBlockテスト | E-11 | ○ |
| C-155 | DFSTree構築テスト | E-12 | ○ |
| C-156～C-162 | IntDisjointSetテスト | E-13 | ○ |
| C-163～C-170 | heap操作テスト | E-14 | ○ |
| C-171～C-174 | CFGReachability/tarjan!/kill_cfg_edge!テスト | E-15 | ○ |
| C-175～C-185 | searchsortedfirst/searchsortedlast/searchsorted/sort!テスト | E-16 | ○ |
| C-186～C-190 | most_general_argtypes/elim_free_typevars/is_argtype_matchテスト | E-17 | ○ |
| C-191～C-192 | compute_ir_rettype/compute_oc_signatureテスト | E-18 | △ |
| C-193～C-196 | _infer_exception_type/_infer_effects/findsup_mtテスト | E-19 | △ |
| C-197～C-199 | is_return_type/somethingテスト | E-01 | ○ |
| C-200 | StmtInfoテスト | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- **validate_code!テスト（C-131～C-133）**：CodeInfoオブジェクトの具体的な構築方法がテストケースの入力値として明示されていない。テスト実装時にはCodeInfoのモック/スタブを構築する具体的な方法が必要。
  - 候補：`Compiler/test/` 内の既存テスト / `ccall(:jl_new_code_info_uninit)` / テスト用ヘルパー
- **IRCode関連テスト（C-191～C-192）**：IRCodeオブジェクトの具体的な構築手順が入力値として不十分。実際のコンパイルパイプラインを通してIRCodeを生成する必要がある。
  - 候補：`Base.code_ircode` / テスト用のIRCode構築ヘルパー
- **推論系テスト（C-193～C-196）**：AbstractInterpreterの具体的なインスタンス化と型タプルの構築が環境依存。NativeInterpreterを使用し、単純な関数に対してテストすることが推奨される。
  - 候補：`NativeInterpreter()` + `Tuple{typeof(+), Int, Int}` のような具象型タプル
- **inline/constprop宣言テスト（C-125～C-128）**：テスト前提条件として特定のアノテーション付きメソッドが必要だが、具体的なメソッド構築方法は記載していない。
  - 候補：テスト内で `@inline`, `@noinline`, `@constprop` 付きの関数を定義

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: WorldRange, Effects, 格子操作, ソート, ヒープ, DisjointSet等の純粋関数テスト（C-01～C-109, C-150～C-185）-- ソースコードから直接テスト観点を導出可能
- **1（中リスク）**: validate_code!, メソッドテーブル, SSAValue使用検出, inline宣言チェック等（C-110～C-149）-- テスト前提条件の構築にやや注意が必要
- **2（高リスク）**: IRCode関連, 推論系テスト（C-191～C-196）-- ランタイム環境に依存し、テスト実装時の入力値構築に工夫が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Effects関連テスト（C-09～C-27）の定数値（ALWAYS_TRUE, ALWAYS_FALSE等）が実際のソースコードと一致しているか
- [ ] 格子順序テスト（C-73～C-89）の期待結果がJuliaの型推論仕様と整合しているか
- [ ] validate_code!テスト（C-131～C-133）の前提条件が実装可能か、CodeInfoモック構築の具体的手順を確認
- [ ] IRCode/推論テスト（C-191～C-196）の入力値が実際のテスト実装で再現可能か確認
- [ ] typesubtract（C-100～C-101）の期待結果が型システムの挙動と一致するか実行で確認
- [ ] sort!テスト（C-184）の200件超閾値が実際のソースコード（line 78: `length(v) > 200`）と一致しているか
- [ ] テストID命名（UT-CMP-xxx）が他モジュールと重複していないか
