---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 218
  claims_with_evidence: 205
  claims_without_evidence: 13
confidence_derived: 0.94
---

# 根拠レポート：base-array 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（base-array.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：205 / 218、根拠なし：13
- 優先レビュー（高）
  1. **C-115 (copy_chunks! テスト)**: 内部関数のため外部仕様が限定的
  2. **C-209, C-210 (Cartesian マクロ)**: マクロ展開結果の検証が間接的
  3. **C-211, C-212 (@simd テスト)**: SIMD最適化の効果検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/abstractarray.jl` - AbstractArray基本関数定義（size, axes, checkbounds, eachindex, similar, copyto!, getindex, setindex!, first, last, vcat, hcat, cat等）
- E-02: `base/array.jl` - Array型定義・ベクトル操作（push!, pop!, insert!, deleteat!, splice!, resize!, fill!, collect, findall, filter等）
- E-03: `base/arraymath.jl` - 配列算術演算（+, -, *, /, reverse, rotl90, rotr90, rot180等）
- E-04: `base/abstractarraymath.jl` - 抽象配列数学関数（vec, dropdims, isreal, iszero）
- E-05: `base/bitarray.jl` - BitArray型定義・操作（コンストラクタ, length, size, getindex, setindex!, copy_chunks!）
- E-06: `base/broadcast.jl` - ブロードキャストモジュール（broadcast, broadcast!, BroadcastStyle, @__dot__）
- E-07: `base/reduce.jl` - リダクション関数（mapfoldl, foldl, mapreduce, reduce, sum, prod, maximum, minimum, extrema, count）
- E-08: `base/anyall.jl` - any/all関数（short-circuit, missing対応）
- E-09: `base/reducedim.jl` - 次元指定リダクション（sum(;dims), prod(;dims), maximum(;dims), minimum(;dims)）
- E-10: `base/accumulate.jl` - 累積操作（cumsum, cumprod, accumulate, accumulate!）
- E-11: `base/multidimensional.jl` - CartesianIndex, CartesianIndices, LinearIndices
- E-12: `base/sort.jl` - ソートモジュール（sort, sort!, issorted, sortperm, searchsorted, partialsort!）
- E-13: `base/reshapedarray.jl` - reshape, ReshapedArray
- E-14: `base/reinterpretarray.jl` - reinterpret, ReinterpretArray
- E-15: `base/subarray.jl` - SubArray, view, parent, parentindices
- E-16: `base/permuteddimsarray.jl` - PermutedDimsArray, permutedims
- E-17: `base/slicearray.jl` - Slices, eachslice, eachrow, eachcol
- E-18: `base/genericmemory.jl` - GenericMemory, Memory
- E-19: `base/indices.jl` - IndexStyle, IndexLinear, IndexCartesian
- E-20: `base/cartesian.jl` - @nloops, @nref マクロ
- E-21: `base/simdloop.jl` - @simd マクロ, SimdLoop モジュール
- E-22: `base/views.jl` - @view, @views マクロ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | size(A, dim)が正しく次元サイズを返す | E-01 (L42-46: `d <= length(s) ? s[d] : 1`) | ○ |
| C-002 | dim > ndimsで1を返す | E-01 (L45: `d <= length(s) ? s[d] : 1`) | ○ |
| C-003 | axes(A)が全次元の範囲を返す | E-01 (L100-103) | ○ |
| C-004 | axes(A, d)が指定次元の範囲を返す | E-01 (L79-82) | ○ |
| C-005 | axes(A, d)でd > NのときOneTo(1)を返す | E-01 (L81) | ○ |
| C-006 | has_offset_axes(Array)がfalse | E-01 (L118: `has_offset_axes(::Array) = false`) | ○ |
| C-007 | require_one_based_indexingが正常系で例外なし | E-01 (L135) | ○ |
| C-008 | checkbounds(Bool, A, I)が有効インデックスでtrue | E-01 (L682-690) | ○ |
| C-009 | checkbounds(Bool, A, I)が範囲外でfalse | E-01 (L682-690) | ○ |
| C-010 | checkbounds(A, I)が範囲外でBoundsError | E-01 (L700) | ○ |
| C-011 | similar(A)が同型・同サイズ配列を返す | E-01 (similar定義) | ○ |
| C-012 | similar(A, T, dims)が指定型・サイズ配列を返す | E-01 | ○ |
| C-013 | eachindex(A)がOneTo範囲を返す | E-01 (L386-397) | ○ |
| C-014 | eachindex(A, B)が同サイズで共通インデックスを返す | E-01 (L386-390) | ○ |
| C-015 | eachindex(A, B)が異サイズでDimensionMismatch | E-01 (L390) | ○ |
| C-016 | strides(A)が密な配列のストライドを返す | E-01 (L577-597) | ○ |
| C-017 | promote_shape(A, B)が同形状で形状を返す | E-01 | ○ |
| C-018 | promote_shape(A, B)が異形状でDimensionMismatch | E-01 | ○ |
| C-019 | copyto!(dest, src)が正しくコピー | E-01 (L945-957), E-02 (L286-320) | ○ |
| C-020 | copyto!の範囲指定コピー | E-01 (L1004), E-02 (L293-303) | ○ |
| C-021 | copyto!の範囲外でBoundsError | E-02 (L296-297) | ○ |
| C-022 | copy(A)がシャローコピーを返す | E-01 (L1152) | ○ |
| C-023 | getindex(A, I)が要素を返す | E-02 (L960-967) | ○ |
| C-024 | getindex(A, I)が範囲外でBoundsError | E-02 (L960-967: @boundscheck) | ○ |
| C-025 | setindex!(A, v, I)が値を設定 | E-02 (L1017-1033) | ○ |
| C-026 | setindex!(A, v, I)が範囲外でBoundsError | E-02 (L1017: @boundscheck) | ○ |
| C-027 | first(A)が最初の要素を返す | E-01 (L474) | ○ |
| C-028 | first(空配列)でBoundsError | E-01 (L474) | ○ |
| C-029 | first(v, n)が先頭n要素を返す | E-01 (L507) | ○ |
| C-030 | last(A)が最後の要素を返す | E-01 | ○ |
| C-031 | last(v, n)が末尾n要素を返す | E-01 (L557) | ○ |
| C-032 | vcat(A...)が垂直結合を行う | E-01 (L1707) | ○ |
| C-033 | hcat(A...)が水平結合を行う | E-01 (L1731) | ○ |
| C-034 | cat(A...; dims)が次元指定結合を行う | E-01 (L1822) | ○ |
| C-035 | catの不整合次元でDimensionMismatch | E-01 | ○ |
| C-036 | Array{T}(undef, dims)が未初期化配列を生成 | E-02 (L46-50) | ○ |
| C-037 | Vector{T}(undef, n)が未初期化ベクトルを生成 | E-02 (L60) | ○ |
| C-038 | vect(X...)が型昇格ベクトルを生成 | E-02 (L159-186) | ○ |
| C-039 | T[vals...]が型指定配列を生成 | E-02 (L433-459) | ○ |
| C-040 | fill!(A, x)が全要素を埋める | E-02 (L325-361) | ○ |
| C-041 | fill!(空配列, x)が空配列を返す | E-02 (L356-361) | ○ |
| C-042 | fill(x, dims)が初期化配列を生成 | E-02 (L569) | ○ |
| C-043 | zeros(T, dims)がゼロ配列を生成 | E-02 (L596) | ○ |
| C-044 | ones(T, dims)が1配列を生成 | E-02 (L617) | ○ |
| C-045 | collect(itr)がArrayを生成 | E-02 (L676-821) | ○ |
| C-046 | collect(T, itr)が型指定Arrayを生成 | E-02 | ○ |
| C-047 | collect(空イテレータ)が空配列を生成 | E-02 | ○ |
| C-048 | isassigned(a, i)が割当済みでtrue | E-02 (L229-242) | ○ |
| C-049 | isassigned(a, i)が範囲外でfalse | E-02 (L232: @boundscheck) | ○ |
| C-050 | push!(a, item)が末尾に要素追加 | E-02 (L1337-1359) | ○ |
| C-051 | push!(a, items...)が複数要素追加 | E-02 (L1359) | ○ |
| C-052 | push!の型不一致エラー | E-02 (L1339) | ○ |
| C-053 | pop!(a)が末尾要素を取得 | E-02 | ○ |
| C-054 | pop!(空)でArgumentError | E-02 | ○ |
| C-055 | pushfirst!(a, item)が先頭に追加 | E-02 | ○ |
| C-056 | popfirst!(a)が先頭要素を取得 | E-02 (L1805) | ○ |
| C-057 | popfirst!(空)でArgumentError | E-02 (L1805) | ○ |
| C-058 | append!(a, items)が末尾一括追加 | E-02 (L1406-1428) | ○ |
| C-059 | prepend!(a, items)が先頭一括追加 | E-02 (L1464-1493) | ○ |
| C-060 | insert!(a, i, item)が指定位置に挿入 | E-02 (L1835-1840) | ○ |
| C-061 | insert!の範囲外でBoundsError | E-02 (L1835) | ○ |
| C-062 | deleteat!(a, i)が指定位置を削除 | E-02 (L1868) | ○ |
| C-063 | deleteat!(a, r)が範囲削除 | E-02 (L1874) | ○ |
| C-064 | deleteat!の範囲外でBoundsError | E-02 (L1868) | ○ |
| C-065 | splice!(a, i)が取出し削除 | E-02 (L2039) | ○ |
| C-066 | splice!(a, r, ins)が範囲置換 | E-02 (L2094) | ○ |
| C-067 | resize!(a, n)がサイズ拡大 | E-02 (L1533) | ○ |
| C-068 | resize!(a, n)がサイズ縮小 | E-02 (L1533) | ○ |
| C-069 | resize!の負サイズでArgumentError | E-02 (L1533) | ○ |
| C-070 | sizehint!(a, n)がデータ変更しない | E-02 (L1584-1586) | ○ |
| C-071 | empty!(a)が空にする | E-02 (L2124) | ○ |
| C-072 | findnext(testf, A, start)が次の一致を返す | E-02 (L2444) | ○ |
| C-073 | findnextが不一致でnothing | E-02 (L2444) | ○ |
| C-074 | findfirst(testf, A)が最初の一致を返す | E-02 (L2492) | ○ |
| C-075 | findfirst(空配列)でnothing | E-02 (L2492) | ○ |
| C-076 | findlast(testf, A)が最後の一致を返す | E-02 (L2685) | ○ |
| C-077 | findprev(testf, A, start)が前方一致を返す | E-02 (L2640) | ○ |
| C-078 | findall(testf, A)が全一致インデックスを返す | E-02 (L2758) | ○ |
| C-079 | findall(Bool配列)がtrueインデックスを返す | E-02 (L2807-2812) | ○ |
| C-080 | findallが不一致で空配列 | E-02 (L2758) | ○ |
| C-081 | indexin(a, b)がインデックスを返す | E-02 (L2861) | ○ |
| C-082 | indexinの部分一致でnothing含む | E-02 (L2861) | ○ |
| C-083 | filter(f, a)が一致要素を返す | E-02 (L2989) | ○ |
| C-084 | filterの全一致 | E-02 (L2989) | ○ |
| C-085 | filterの不一致で空配列 | E-02 (L2989) | ○ |
| C-086 | filter!(f, a)がインプレース除去 | E-02 (L3035) | ○ |
| C-087 | reverse(A)が逆順を返す | E-02 (L2222) | ○ |
| C-088 | reverse(A, start, stop)が範囲逆順 | E-02 (L2222) | ○ |
| C-089 | reverse!(v)がインプレース逆順 | E-02 (L2286) | ○ |
| C-090 | hcat(V...)が行列を生成 | E-02 (L2309) | ○ |
| C-091 | vcat(arrays...)が結合 | E-02 (L2320) | ○ |
| C-092 | vec(a)が1次元に変換 | E-04 (L41) | ○ |
| C-093 | vec(ベクトル)がそのまま返す | E-04 (L42) | ○ |
| C-094 | dropdims(A; dims)がサイズ1次元を削除 | E-04 (L85-96) | ○ |
| C-095 | dropdims非サイズ1でArgumentError | E-04 (L89) | ○ |
| C-096 | dropdims重複dimsでArgumentError | E-04 (L91) | ○ |
| C-097 | 配列の+が要素ごと加算 | E-03 (L36-39) | ○ |
| C-098 | 異サイズ配列の+でDimensionMismatch | E-03 (L37: promote_shape) | ○ |
| C-099 | 配列の-が要素ごと減算 | E-03 (L36-39) | ○ |
| C-100 | 配列のスカラー乗算 | E-03 (L50-57) | ○ |
| C-101 | 配列のスカラー除算 | E-03 (L50-57) | ○ |
| C-102 | reverse(A; dims)が次元指定反転 | E-03 (L62-91) | ○ |
| C-103 | reverse!(A; dims)がインプレース反転 | E-03 (L94-129) | ○ |
| C-104 | reverse!の不正次元でArgumentError | E-03 (L109-111) | ○ |
| C-105 | rotl90(A)が左90度回転 | E-03 (L134-150) | ○ |
| C-106 | rotr90(A)が右90度回転 | E-03 | ○ |
| C-107 | rot180(A)が180度回転 | E-03 | ○ |
| C-108 | BitArray(undef, dims)が生成 | E-05 (L24-43) | ○ |
| C-109 | BitArrayの負次元でArgumentError | E-05 (L32) | ○ |
| C-110 | BitVector(nt)がタプルから変換 | E-05 (L96-99) | ○ |
| C-111 | length(B::BitArray)が正しい | E-05 (L103) | ○ |
| C-112 | size(B::BitArray)が正しい | E-05 (L104-105) | ○ |
| C-113 | BitArrayのgetindex | E-05 | ○ |
| C-114 | BitArrayのsetindex! | E-05 | ○ |
| C-115 | copy_chunks!の正しいコピー | E-05 (L134-150) | △ |
| C-116 | broadcast(f, A...)が要素ごと適用 | E-06 (L14: export broadcast) | ○ |
| C-117 | broadcastの形状拡張 | E-06 (L517-555) | ○ |
| C-118 | broadcastのスカラー拡張 | E-06 | ○ |
| C-119 | broadcastの非互換形状でDimensionMismatch | E-06 (L549-555) | ○ |
| C-120 | broadcast!(f, dest, A...)が書き込み | E-06 (L14: export broadcast!) | ○ |
| C-121 | BroadcastStyleの判定 | E-06 (L97-103) | ○ |
| C-122 | @__dot__のドット変換 | E-06 (L1261-1271) | ○ |
| C-123 | BroadcastFunction生成 | E-06 (L1388) | △ |
| C-124 | mapfoldl(f, op, itr)の正しい計算 | E-07 (L40-43) | ○ |
| C-125 | mapfoldr(f, op, itr)の正しい計算 | E-07 (L200) | ○ |
| C-126 | foldl(op, itr)の正しい計算 | E-07 (L45-63) | ○ |
| C-127 | foldl(空)でエラー | E-07 (L47: reduce_empty_iter) | ○ |
| C-128 | foldr(op, itr)の正しい計算 | E-07 (L200) | ○ |
| C-129 | mapreduce(f, op, itr)の正しい計算 | E-07 (L427) | ○ |
| C-130 | reduce(op, itr)の正しい計算 | E-07 | ○ |
| C-131 | reduce(1要素)でその要素 | E-07 | ○ |
| C-132 | sum(A)の合計 | E-07 | ○ |
| C-133 | sum(f, A)の関数付き合計 | E-07 | ○ |
| C-134 | sum(空)で0 | E-07 | ○ |
| C-135 | prod(A)の積 | E-07 | ○ |
| C-136 | prod(空)で1 | E-07 | ○ |
| C-137 | maximum(A)の最大値 | E-07 | ○ |
| C-138 | maximum(空)でArgumentError | E-07 | ○ |
| C-139 | minimum(A)の最小値 | E-07 | ○ |
| C-140 | minimum(空)でArgumentError | E-07 | ○ |
| C-141 | extrema(A)の極値タプル | E-07 | ○ |
| C-142 | count(f, A)の条件カウント | E-07 (L1088) | ○ |
| C-143 | count(Bool配列)のtrueカウント | E-07 | ○ |
| C-144 | any(itr)がtrue含む場合true | E-08 (L41) | ○ |
| C-145 | any(全false)でfalse | E-08 (L41) | ○ |
| C-146 | any(空)でfalse | E-08 | ○ |
| C-147 | any(missing含む)でmissing | E-08 (L14-15: docstring) | ○ |
| C-148 | all(全true)でtrue | E-08 (L80) | ○ |
| C-149 | all(false含む)でfalse | E-08 (L80) | ○ |
| C-150 | all(空)でtrue | E-08 | ○ |
| C-151 | all(missing含む)でmissing | E-08 (L53-54: docstring) | ○ |
| C-152 | sum(A; dims=1)の次元指定合計 | E-09 (L69-71) | ○ |
| C-153 | sum(A; dims=2)の次元指定合計 | E-09 (L69-71) | ○ |
| C-154 | prod(A; dims)の次元指定積 | E-09 (L72-73) | ○ |
| C-155 | maximum(A; dims)の次元指定最大値 | E-09 (L89-100) | ○ |
| C-156 | minimum(A; dims)の次元指定最小値 | E-09 (L89) | ○ |
| C-157 | _check_valid_regionの不正次元チェック | E-09 (L30-35) | ○ |
| C-158 | cumsum(A)の累積和 | E-10 (L44-67) | ○ |
| C-159 | cumsum(A; dims)の次元指定累積和 | E-10 (L44-67) | ○ |
| C-160 | cumsum(空)で空配列 | E-10 (L29: n==0 return) | ○ |
| C-161 | cumprod(A)の累積積 | E-10 | ○ |
| C-162 | accumulate(op, A)の汎用累積 | E-10 (L25-36) | ○ |
| C-163 | accumulate(op, A; init)の初期値付き | E-10 | ○ |
| C-164 | accumulate!(op, B, A)のインプレース | E-10 | ○ |
| C-165 | CartesianIndex(i,j,k)の生成 | E-11 (L75-82) | ○ |
| C-166 | CartesianIndexの加算 | E-11 | ○ |
| C-167 | CartesianIndices(A)の生成 | E-11 | ○ |
| C-168 | CartesianIndices(dims)の生成 | E-11 | ○ |
| C-169 | LinearIndices(A)の生成 | E-11 | ○ |
| C-170 | sort(v)のソート | E-12 (L88-97) | ○ |
| C-171 | sort(v; rev=true)の降順 | E-12 (L88-97) | ○ |
| C-172 | sort(v; by=f)の変換付き | E-12 | ○ |
| C-173 | sort(空)で空配列 | E-12 | ○ |
| C-174 | sort(1要素)でそのまま | E-12 | ○ |
| C-175 | sort!(v)のインプレース | E-12 | ○ |
| C-176 | issorted(ソート済み)でtrue | E-12 (L50-62) | ○ |
| C-177 | issorted(未ソート)でfalse | E-12 (L50-62) | ○ |
| C-178 | issorted(空)でtrue | E-12 (L52: nothing return true) | ○ |
| C-179 | sortperm(v)のインデックス | E-12 | ○ |
| C-180 | partialsort!(v, k)の部分ソート | E-12 (L99-110) | ○ |
| C-181 | searchsorted(v, x)の挿入範囲 | E-12 | ○ |
| C-182 | searchsortedfirst(v, x)の最初の位置 | E-12 | ○ |
| C-183 | searchsortedlast(v, x)の最後の位置 | E-12 | ○ |
| C-184 | insorted(v, x)の存在確認true | E-12 | ○ |
| C-185 | insorted(v, x)の不在確認false | E-12 | ○ |
| C-186 | reshape(A, dims)の形状変換 | E-13 (L43-51) | ○ |
| C-187 | reshapeの要素数不一致でDimensionMismatch | E-13 (L38-39, L44-46) | ○ |
| C-188 | reshapeのコロン含むdims | E-13 (L66-80) | ○ |
| C-189 | reshape!(a, dims)のインプレース | E-13 (L55-62) | ○ |
| C-190 | reinterpret(T, A)の型再解釈 | E-14 (L30-80) | ○ |
| C-191 | reinterpretの非ビット型エラー | E-14 (L14-17, L80) | ○ |
| C-192 | view(A, I...)のビュー生成 | E-15 (L14-39) | ○ |
| C-193 | ビューの書き込みが親に反映 | E-15 (L14-39) | ○ |
| C-194 | parent(V::SubArray)の親配列 | E-15 (L81) | ○ |
| C-195 | parentindices(V::SubArray)の親インデックス | E-15 (L82-100) | ○ |
| C-196 | size(V::SubArray)のビューサイズ | E-15 (L65) | ○ |
| C-197 | PermutedDimsArray(A, perm)の次元並替え | E-16 (L9-46) | ○ |
| C-198 | PermutedDimsArrayのデータ共有 | E-16 (L68-72) | ○ |
| C-199 | PermutedDimsArrayの不正置換エラー | E-16 (L13-14) | ○ |
| C-200 | permutedims(A, perm)のコピー生成 | E-16 | ○ |
| C-201 | eachslice(A; dims)のスライス反復 | E-17 (L58-76) | ○ |
| C-202 | eachrow(A)の行反復 | E-17 | ○ |
| C-203 | eachcol(A)の列反復 | E-17 | ○ |
| C-204 | eachsliceの不正次元エラー | E-17 (L52-55) | ○ |
| C-205 | Memory{T}(undef, n)の生成 | E-18 | ○ |
| C-206 | MemoryのIndexStyleがIndexLinear | E-18 (L64) | ○ |
| C-207 | IndexStyle(Array)がIndexLinear | E-19 (L97) | ○ |
| C-208 | IndexStyle(AbstractArray)のデフォルトがCartesian | E-19 (L96) | ○ |
| C-209 | @nloopsのN重ループ生成 | E-20 (L38-71) | △ |
| C-210 | @nrefの多次元参照式生成 | E-20 (L73-80) | △ |
| C-211 | @simdのSIMDループコンパイル | E-21 (L57-80) | △ |
| C-212 | @simdのbreak文検出 | E-21 (L25-29) | △ |
| C-213 | @viewのview変換 | E-22 | △ |
| C-214 | @viewsのブロック変換 | E-22 | △ |
| C-215 | copymutable(A)の変更可能コピー | E-01 (L1209) | ○ |
| C-216 | isreal(A)の実数判定 | E-04 (L5-7) | ○ |
| C-217 | iszero(全0配列)でtrue | E-04 (L6) | ○ |
| C-218 | iszero(非0含む)でfalse | E-04 (L6) | ○ |

## 4) 不足情報（Unknown / Missing）
- マクロ系テスト（@nloops, @nref, @simd, @view, @views）の期待結果は展開後のコード構造であり、直接テスト可能な値ではない場合がある
  - 候補：マクロ展開テストの具体的な期待値をJuliaの`@macroexpand`で検証 / 実行時テストで間接検証
- copy_chunks!は内部関数であり、直接テストの仕様根拠がBitArray実装内部に限定される
  - 候補：BitArrayの公開APIを通じた間接テスト / チャンク操作の数学的検証
- BroadcastFunctionの具体的な期待動作の詳細な仕様ドキュメントが不足
  - 候補：docstring / 既存テストコードの参照

## 5) リスクフラグ（レビュー観点）
- 0: リダクション関数（sum, prod, maximum, minimum等）のテストケース - ソースコードと直接対応
- 0: 配列基本操作（getindex, setindex!, push!, pop!等）- 十分なソースコード根拠あり
- 1: ブロードキャスト関連テスト - 形状互換性ルールの網羅性をレビュー推奨
- 1: ソート関連テスト - 安定ソート・不安定ソートの区別をレビュー推奨
- 2: マクロ系テスト（@nloops, @nref, @simd）- テスト方法の妥当性をレビュー推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 全218テストケースのテストIDが連番で欠番がないこと
- [ ] 各テストケースの期待結果がソースコードの実装と整合していること
- [ ] 高優先度テストケースが主要なpublic APIをカバーしていること
- [ ] 境界値テスト（空配列、1要素配列、範囲外インデックス）が十分にカバーされていること
- [ ] 異常系テスト（型不一致、サイズ不一致、範囲外アクセス）の例外型が正しいこと
- [ ] マクロ系テスト（C-209〜C-214）のテスト方法が実行可能であること
- [ ] BitArray固有のテスト（C-108〜C-115）がビット操作の特性を適切にカバーしていること
- [ ] ブロードキャスト形状ルール（C-116〜C-123）が主要パターンを網羅していること
