---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 244
  claims_with_evidence: 237
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：base-collections 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（base-collections.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：237 / 244、根拠なし：7
- 優先レビュー（高）
  1. **HAMT insert!/path テスト (C-166〜C-169)**：HAMT内部操作は直接テストが困難なため、PersistentDict経由のテスト設計を推奨
  2. **IntrusiveLinkedList テスト (C-180〜C-188)**：テスト対象の型Tに`.next`と`.queue`フィールドを持つ具象型が必要、テスト用のスタブ型定義が前提
  3. **WeakKeyDict GC挙動テスト (C-156〜C-163)**：GCによるキー回収のタイミングは非決定的で、テストの安定性に注意が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/pair.jl` - Pair型の定義と操作（iterate, ==, isless, reverse, hash, convert, getindex, length, first, last, promote_rule）
- E-02: `base/dict.jl` - Dict, ImmutableDict, PersistentDict の定義と全操作
- E-03: `base/abstractdict.jl` - AbstractDict のインターフェース（keys, values, pairs, merge!, mergewith!, in, ==, isequal, hash, copy!, map!, filter, keytype, valtype）
- E-04: `base/set.jl` - Set の定義と操作（push!, pop!, delete!, in, in!, unique, unique!, allunique, allequal, replace, replace!）
- E-05: `base/abstractset.jl` - AbstractSet のインターフェース（union, intersect, setdiff, symdiff, issubset, issetequal, isdisjoint, hasfastin, filter）
- E-06: `base/iddict.jl` - IdDict の定義と操作（===ベースのキー比較）
- E-07: `base/idset.jl` - IdSet の定義と操作（===ベースの要素判定）
- E-08: `base/bitset.jl` - BitSet の定義と操作（push!, pop!, delete!, union!, intersect!, setdiff!, symdiff!, ==, issubset, first, last, length, copy）
- E-09: `base/weakkeydict.jl` - WeakKeyDict の定義と操作（setindex!, getindex, haskey, delete!, empty!, nothingキーの拒否）
- E-10: `base/hamt.jl` - HAMT（Hash Array Mapped Trie）の定義と操作（path, insert!, length, iterate, isempty）
- E-11: `base/ordering.jl` - Order モジュール（ForwardOrdering, ReverseOrdering, By, Lt, Perm, lt, ord, reverse）
- E-12: `base/linked_list.jl` - IntrusiveLinkedList と LinkedList の定義と操作（push!, pushfirst!, popfirst!, list_append!!, list_deletefirst!, length, isempty）
- E-13: `base/combinatorics.jl` - 組み合わせ関数（factorial, isperm, invperm, permute!, invpermute!, nextprod, swapcols!, swaprows!）
- E-14: `base/generator.jl` - Generator 型の定義と操作（iterate, length, size, isempty, last, IteratorSize, IteratorEltype）
- E-15: `base/iterators.jl` - Iterators モジュール（enumerate, zip, take, drop, takewhile, dropwhile, cycle, repeated, product, flatten, flatmap, partition, Stateful, only, countfrom, rest, peel, Reverse, Filter, Accumulate, nth, findeach）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-010 | Pair型の基本操作（構築、iterate、==、isless、reverse、hash、convert、getindex、length） | E-01 | ○ |
| C-011〜C-044 | Dict型の全操作（構築、setindex!、getindex、get、get!、haskey、delete!、pop!、empty!、length、isempty、iterate、getkey、sizehint!、filter!、copy、rehash!） | E-02 | ○ |
| C-045〜C-049 | ImmutableDict型の操作（構築、getindex、haskey、isempty） | E-02 | ○ |
| C-050〜C-053 | PersistentDict型の操作（構築、追加、削除、getindex） | E-02 | ○ |
| C-054〜C-072 | AbstractDictインターフェース（keys、values、pairs、merge!、mergewith!、keytype、valtype、filter、isequal、==、hash、copy!、in、map!） | E-03 | ○ |
| C-073〜C-101 | Set型の全操作（構築、in、push!、pop!、delete!、empty!、length、isempty、in!、unique、unique!、allunique、allequal、replace!、replace） | E-04 | ○ |
| C-102〜C-118 | AbstractSetインターフェース（union、intersect、setdiff、symdiff、issubset、issetequal、isdisjoint、hasfastin、filter）| E-05 | ○ |
| C-119〜C-127 | IdDict型の全操作（構築、setindex!、getindex、get、pop!、delete!、empty!、iterate） | E-06 | ○ |
| C-128〜C-134 | IdSet型の全操作（構築、push!、in、pop!、delete!、empty!） | E-07 | ○ |
| C-135〜C-155 | BitSet型の全操作（構築、push!、in、pop!、delete!、empty!、union!、intersect!、setdiff!、symdiff!、==、issubset、length、first/last、union!(range)、copy） | E-08 | ○ |
| C-156〜C-163 | WeakKeyDict型の全操作（構築、setindex!、getindex、haskey、delete!、empty!） | E-09 | ○ |
| C-164〜C-171 | HAMT型の操作（構築、path、insert!、length、iterate、isempty） | E-10 | △ |
| C-172〜C-179 | Orderモジュール（ForwardOrdering、ReverseOrdering、By、Lt、Perm、ord、reverse） | E-11 | ○ |
| C-180〜C-189 | IntrusiveLinkedList / LinkedList操作（push!、pushfirst!、popfirst!、isempty、length、list_append!!、list_deletefirst!） | E-12 | △ |
| C-190〜C-203 | 組み合わせ関数（factorial、isperm、invperm、permute!、invpermute!、nextprod） | E-13 | ○ |
| C-204〜C-209 | Generator型の操作（構築、iterate、length、isempty、last、IteratorSize） | E-14 | ○ |
| C-210〜C-244 | Iteratorsモジュール（enumerate、zip、take、drop、takewhile、dropwhile、cycle、repeated、product、flatten、flatmap、partition、Stateful、only、countfrom、rest、peel、Reverse、Filter、Accumulate、nth、findeach） | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- **HAMT内部操作のテスト可能性**: `path`と`insert!`はモジュール内部関数（非エクスポート）であり、直接的な単体テストの設計が難しい。PersistentDict経由での間接テストが現実的。
  - 候補：PersistentDictの公開APIを用いた統合テスト / HAMTモジュールの内部テスト用ヘルパー
- **IntrusiveLinkedListのテスト前提型**: テスト実行には`.next`と`.queue`フィールドを持つ具象型（例：Task）が必要。テスト用のモック型定義が前提。
  - 候補：テストファイル内でのスタブ型定義 / LinkedListアダプタの利用
- **WeakKeyDictのGC依存テスト**: キーのガベージコレクション後の挙動テストは、GCタイミングに依存するため非決定的。
  - 候補：GC.gc()の明示的呼び出し / _cleanup_locked関数の直接テスト
- **swapcols!/swaprows!のテストケース不足**: combinatorics.jlの行列操作関数（swapcols!、swaprows!、permutecols!!、permutecols!、permuterows!、invpermutecols!、invpermuterows!）の個別テストケースが含まれていない。
  - 候補：これらは配列操作モジュール（base-array）のスコープに含まれる可能性がある
- **Iterators.pairsの各種特殊化**: IndexLinear/IndexCartesian版のpairs、Tuple/NamedTuple版のpairsの個別テストケースが限定的。
  - 候補：各特殊化パターンのテスト追加
- **Iterators.IterableStatePairsの直接テスト**: 内部型であり、AbstractString.pairsを通じて間接的にのみテスト可能。
  - 候補：AbstractStringのpairs経由テスト
- **Dict.rehash!の異常系**: rehash中のメモリ不足等の異常系テストが含まれていない。
  - 候補：メモリ制約環境でのテスト（実用的でない可能性あり）

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: HAMT内部操作テスト - 内部API変更時にテストの妥当性が失われる可能性
- **1（中リスク）**: IntrusiveLinkedListテスト - テスト用スタブ型の設計によってカバレッジが変動
- **1（中リスク）**: WeakKeyDict GC挙動テスト - テストの安定性がGCの実装に依存
- **0（低リスク）**: Dict/Set/BitSetの基本操作 - ソースコードから直接対応が確認でき、信頼性が高い
- **0（低リスク）**: Iteratorsモジュール - 公開APIが明確でテスト設計が直截的

## 6) レビュアーチェックリスト（最小）
- [ ] HAMT関連テストケース（C-164〜C-171）がPersistentDict経由で実行可能か確認
- [ ] IntrusiveLinkedListテスト（C-180〜C-188）に必要なスタブ型が適切に定義されているか確認
- [ ] WeakKeyDictテスト（C-156〜C-163）のGC依存テストの安定性を確認
- [ ] combinatorics.jlの行列操作関数（swapcols!等）のテストが別モジュール（base-array）でカバーされているか確認
- [ ] 各テストケースの優先度（高/中/低）が実際のビジネスリスクと整合しているか確認
- [ ] テストIDの連番（UT-COL-001〜UT-COL-244）に欠番がないか確認
- [ ] 境界値テスト（空コレクション、1要素、最大値等）の網羅性を確認
