---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 250
  claims_with_evidence: 243
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：base-concurrency 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（base-concurrency.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：243 / 250、根拠なし：7
- 優先レビュー（高）
  1. **UT-CON-242 (threadcall)**: do_threadcallの内部動作の検証はCCコール依存で、実行環境でのテストが必要
  2. **UT-CON-240/241 (Partr sift_up/sift_down)**: ヒープ操作の内部実装であり、直接的な単体テストが困難
  3. **UT-CON-053 (enq_work sticky)**: スレッドスケジューリングの詳細動作は実行環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/task.jl` - タスク管理、スケジューリング、待機関数の実装（1275行）
- E-02: `base/channels.jl` - Channel構造体、put!/take!/fetch/close等の実装（731行）
- E-03: `base/lock.jl` - ReentrantLock、Semaphore、Event、OncePerProcess/Thread/Task、Lockable（992行）
- E-04: `base/condition.jl` - GenericCondition、wait/notify、Condition（205行）
- E-05: `base/locks-mt.jl` - SpinLock、PaddedSpinLock（111行）
- E-06: `base/threadingconstructs.jl` - threadid/nthreads/threadpool/threadpoolsize、@threads、@spawn（544行）
- E-07: `base/asyncevent.jl` - AsyncCondition、Timer、sleep、timedwait（433行）
- E-08: `base/atomics.jl` - Atomic{T}、atomic_cas!/xchg!/add!/sub!/and!/or!/xor!/nand!/max!/min!、atomic_fence（357行）
- E-09: `base/scopedvalues.jl` - ScopedValue、LazyScopedValue、with/@with、Scope、ScopedThunk（349行）
- E-10: `base/partr.jl` - taskheap、multiq_insert/deletemin/check_empty、cong、rand_uniform_max_int32（248行）
- E-11: `base/asyncmap.jl` - asyncmap/asyncmap!、AsyncCollector、AsyncGenerator（406行）
- E-12: `base/threads_overloads.jl` - Threads.foreach（67行）
- E-13: `base/threadcall.jl` - @threadcall、do_threadcall（108行）
- E-14: `base/threads.jl` - Threadsモジュール定義（14行）

## 3) Claims と根拠の対応（レビューの主戦場）

### task.jl 関連 (UT-CON-001 - UT-CON-054, UT-CON-244 - UT-CON-250)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CapturedException(ex, bt_raw) でprocessed_btが最大100行に制限される | E-01 (行17: `bt_lines = process_backtrace(stacktrace(bt_raw))[1:min(100, end)]`) | ○ |
| C-02 | CompositeException()で空のexceptionsが生成される | E-01 (行48: `CompositeException() = new(Any[])`) | ○ |
| C-03 | Task.stateが:runnable/:done/:failedのSymbolで返される | E-01 (行152-178: getpropertyの実装) | ○ |
| C-04 | Task.scopeへのアクセスでエラーが発生する | E-01 (行172-174: `error("""Querying a Task's scope field is disallowed.""")`) | ○ |
| C-05 | istaskdone/istaskstarted/istaskfailedの判定ロジック | E-01 (行209,226,253) | ○ |
| C-06 | _wait(current_task())でConcurrencyViolationError | E-01 (行306: `Core.throw(ConcurrencyViolationError("deadlock detected"))`) | ○ |
| C-07 | wait(t; throw=true)で失敗タスクにTaskFailedException | E-01 (行360-366) | ○ |
| C-08 | fetch(t)でwait後にresult返却 | E-01 (行553-556) | ○ |
| C-09 | waitany/waitallの動作仕様 | E-01 (行370-537) | ○ |
| C-10 | task_local_storage動的スコープの値復元 | E-01 (行292-302: try/finally) | ○ |
| C-11 | schedule(t)で非runnableタスクにエラー | E-01 (行955: `error("schedule: Task not runnable")`) | ○ |
| C-12 | yield(current_task())でConcurrencyViolationError | E-01 (行1090: `throw(ConcurrencyViolationError("Cannot yield to currently running task!"))`) | ○ |
| C-13 | IntrusiveLinkedListSynchronizedの各操作 | E-01 (行897-946) | ○ |
| C-14 | record_running_time!/maybe_record_enqueued!の動作 | E-01 (行1259-1274) | ○ |

### channels.jl 関連 (UT-CON-055 - UT-CON-088)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Channel{T}(sz)で負サイズにArgumentError | E-02 (行44: `throw(ArgumentError("Channel size must be either 0, a positive integer or Inf"))`) | ○ |
| C-16 | Channel(Inf)でtypemax(Int)に変換 | E-02 (行55: `sz = (sz == Inf ? typemax(Int) : convert(Int, sz))`) | ○ |
| C-17 | put!で型変換が行われる | E-02 (行397: `v = convert(T, v)`) | ○ |
| C-18 | 閉じたチャネルへのput!でInvalidStateException | E-02 (行182-190: check_channel_state) | ○ |
| C-19 | fetch_unbufferedでErrorException | E-02 (行494: `throw(ErrorException("`fetch` is not supported on an unbuffered Channel."))`) | ○ |
| C-20 | isbuffered(c)の判定 | E-02 (行180: `c.sz_max==0 ? false : true`) | ○ |
| C-21 | isfull(c)の判定式 | E-02 (行639: `n_avail(c) >= c.sz_max`) | ○ |
| C-22 | bind(c, task)の動作 | E-02 (行329-334: close_chnl_on_taskdone) | ○ |
| C-23 | Channel iterateの動作 | E-02 (行705-728) | ○ |

### lock.jl 関連 (UT-CON-089 - UT-CON-126)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | ReentrantLock()で未ロック状態 | E-03 (行85: `new(nothing, 0x0000_0000, 0x00, ThreadSynchronizer())`) | ○ |
| C-25 | trylock再入でreentrancy_cnt増加 | E-03 (行167-168) | ○ |
| C-26 | unlock未ロックでエラー | E-03 (行270-271: `error(rl.reentrancy_cnt == 0x0000_0000 ? "unlock count must match lock count" : "unlock from wrong thread")`) | ○ |
| C-27 | Semaphore(0)でArgumentError | E-03 (行509: `sem_size > 0 ? new(...) : throw(ArgumentError(...))`) | ○ |
| C-28 | release未取得でエラー | E-03 (行604: `error("release count must match acquire count")`) | ○ |
| C-29 | Event動作(notify/wait/reset) | E-03 (行633-686) | ○ |
| C-30 | OncePerProcess初回実行/キャッシュ/エラー | E-03 (行729-776) | ○ |
| C-31 | OncePerThread動作 | E-03 (行842-947) | ○ |
| C-32 | OncePerTask動作 | E-03 (行980-991) | ○ |
| C-33 | Lockable値アクセス(assert_havelock) | E-03 (行431: `getindex(l::Lockable) = (assert_havelock(l.lock); l.value)`) | ○ |

### condition.jl 関連 (UT-CON-127 - UT-CON-137)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | GenericCondition wait/notifyの動作 | E-04 (行136-170) | ○ |
| C-35 | Condition(AlwaysLockedST)のlock/unlockでArgumentError | E-04 (行201-204) | ○ |
| C-36 | AlwaysLockedSTのislocked常にtrue | E-04 (行52: `islocked(::AlwaysLockedST) = true`) | ○ |

### locks-mt.jl 関連 (UT-CON-138 - UT-CON-146)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | SpinLockの基本操作 | E-05 (行41-110) | ○ |
| C-38 | SpinLock unlockエラー | E-05 (行100-101: `error("unlock count must match lock count")`) | ○ |
| C-39 | PaddedSpinLockの構造 | E-05 (行60-70) | ○ |

### threadingconstructs.jl 関連 (UT-CON-147 - UT-CON-165)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | threadid()がccallでInt返却 | E-06 (行36) | ○ |
| C-41 | threadpoolsize(:foreign)でエラー | E-06 (行140: `error("Threadpool size of ':foreign' is indeterminant")`) | ○ |
| C-42 | _tpid_to_sym/_sym_to_tpidの変換テーブル | E-06 (行68-89) | ○ |
| C-43 | threadpooltids(:invalid)でエラー | E-06 (行159: `error("invalid threadpool specified")`) | ○ |

### asyncevent.jl 関連 (UT-CON-166 - UT-CON-184)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Timer負timeout/intervalでArgumentError | E-07 (行118-119) | ○ |
| C-45 | sleep負秒数でArgumentError | E-07 (行320: `sec >= 0 || throw(ArgumentError(...))`) | ○ |
| C-46 | timedwait pollint < 1msでArgumentError | E-07 (行415: `pollint >= 1e-3 || throw(ArgumentError(...))`) | ○ |
| C-47 | 閉じたTimer/AsyncConditionのwaitでEOFError | E-07 (行203: `_trywait(t) || throw(EOFError())`) | ○ |

### atomics.jl 関連 (UT-CON-185 - UT-CON-200)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Atomic{T}()でzero(T)初期化 | E-08 (行43: `Atomic{T}() where {T} = new(zero(T))`) | ○ |
| C-49 | 各atomic操作の実装 | E-08 (行304-315) | ○ |
| C-50 | Atomic()がAtomic{Int}()と等価 | E-08 (行47: `Atomic() = Atomic{Int}()`) | ○ |

### asyncmap.jl 関連 (UT-CON-201 - UT-CON-210)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | asyncmapの基本動作 | E-11 (行76-78) | ○ |
| C-52 | verify_ntasksで負の値にArgumentError | E-11 (行117-119) | ○ |
| C-53 | verify_batch_sizeで0以下にArgumentError | E-11 (行107-108) | ○ |

### scopedvalues.jl 関連 (UT-CON-214 - UT-CON-230)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | ScopedValue(x)でhasdefault=true | E-09 (行98: `ScopedValue(val::T) where T = new{T}(true, val)`) | ○ |
| C-55 | 未設定ScopedValueへのアクセスでKeyError | E-09 (行222: `maybe === nothing && throw(KeyError(val))`) | ○ |
| C-56 | with動的スコープの動作 | E-09 (行323-325) | ○ |
| C-57 | ScopedThunkのスコープキャプチャ | E-09 (行343: `new{F}(f, Core.current_scope())`) | ○ |

### partr.jl 関連 (UT-CON-231 - UT-CON-241)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | taskheap初期化値 | E-10 (行13: `taskheap() = new(SpinLock(), Vector{Task}(undef, 256), zero(Int32), typemax(UInt16))`) | ○ |
| C-59 | cong(0)でUInt32(0) | E-10 (行28: `iszero(max) ? UInt32(0) : ...`) | ○ |
| C-60 | rand_uniform_max_int32(1)で0 | E-10 (行64: `if max == UInt32(1) return UInt32(0), seed end`) | ○ |
| C-61 | multiq_insert/deletemin/check_emptyの動作 | E-10 (行140-245) | ○ |
| C-62 | multiq_sift_up/downの内部動作(直接テスト困難) | E-10 (行79-108) | △ |

### threadcall.jl/threads_overloads.jl 関連 (UT-CON-242 - UT-CON-243, UT-CON-211 - UT-CON-213)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | do_threadcallで非isbitsにArgumentError | E-13 (行73: `isbitstype(T) || throw(ArgumentError(...))`) | ○ |
| C-64 | do_threadcallのC関数呼び出し結果(実行環境依存) | E-13 (行58-107) | △ |
| C-65 | Threads.foreachの動作 | E-12 (行41-63) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ヒープ操作の直接単体テスト**: `multiq_sift_up`/`multiq_sift_down`は内部関数であり、公開APIを通じた間接テストが推奨される。直接テストする場合はtaskheap構造体の手動構築が必要。
  - 候補：Partrモジュールの統合テスト / ベンチマークテスト / 既存テストファイル参照
- **threadcall C関数呼び出し**: do_threadcallはC関数ポインタを直接操作するため、テスト環境での安全な呼び出しが必要。
  - 候補：テスト用C関数の準備 / @threadcallマクロ経由でのテスト
- **マルチスレッド環境依存テスト**: 一部のテストケース（特にスケジューリング関連）は、複数スレッドが利用可能な環境でのみ完全にテスト可能。
  - 候補：`julia -t 4`での実行 / CI環境設定
- **Timer/AsyncConditionのlibuv依存**: Timer/AsyncConditionはlibuv eventloopに依存するため、イベントループが動作している環境が前提。
  - 候補：統合テストとしての実施
- **enq_workのスレッドスティッキー動作**: GC.in_finalizer()やスレッド割り当ての詳細動作は実行コンテキスト依存。
  - 候補：マルチスレッド統合テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UT-CON-001〜012 (例外構造体の生成・表示): 純粋なデータ構造のテストであり、外部依存なし
- **0: 低リスク** - UT-CON-055〜088 (Channel操作): 十分にドキュメントされた公開API
- **0: 低リスク** - UT-CON-089〜126 (ロック・同期プリミティブ): コード上の根拠が明確
- **0: 低リスク** - UT-CON-185〜200 (Atomic操作): 明確な仕様と実装
- **0: 低リスク** - UT-CON-214〜230 (ScopedValues): 明確なスコープセマンティクス
- **1: 中リスク** - UT-CON-038〜041 (waitany/waitall): 複数タスクの並行動作テストは非決定的要素あり
- **1: 中リスク** - UT-CON-166〜184 (AsyncCondition/Timer): libuv依存のタイミングテスト
- **1: 中リスク** - UT-CON-231〜241 (Partr): 内部スケジューラの動作テスト
- **2: 高リスク** - UT-CON-240〜241 (sift_up/sift_down): 内部関数への直接テストが困難
- **2: 高リスク** - UT-CON-242 (threadcall): C関数呼び出し環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] 全14ファイルの主要な公開関数がカバーされているか確認
- [ ] テスト観点（正常系・異常系・境界値）のバランスが適切か確認
- [ ] Channel操作（put!/take!/fetch/close）の正常系・異常系が網羅されているか
- [ ] ReentrantLock/SpinLockのロック・アンロック・再入テストが含まれているか
- [ ] ScopedValueのwithスコープ内外での値変化テストが含まれているか
- [ ] Atomic操作の全バリエーション（cas/xchg/add/sub/and/or/xor/nand/max/min）が含まれているか
- [ ] マルチスレッド環境でのみ検証可能なテストケースが明示されているか
- [ ] 優先度（高/中/低）が適切に設定されているか（金額・認証は該当なし、データ整合性・並行安全性を高として設定）
