---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 186
  claims_without_evidence: 14
confidence_derived: 0.93
---

# 根拠レポート: base-core 単体テストケース一覧

## 概要

本レポートは `base-core` モジュール（Julia言語のコア型システム・基本機能群）に対する単体テストケース一覧（200件）の根拠を示すものである。

### 対象ファイル一覧（24ファイル）

| ファイル | テストケース数 | カバレッジ |
|----------|---------------|-----------|
| base/essentials.jl | 21 | 高 |
| base/Enums.jl | 5 | 中 |
| base/tuple.jl | 13 | 高 |
| base/namedtuple.jl | 11 | 高 |
| base/ntuple.jl | 4 | 中 |
| base/some.jl | 7 | 高 |
| base/missing.jl | 10 | 高 |
| base/traits.jl | 3 | 中 |
| base/operators.jl | 10 | 高 |
| base/expr.jl | 5 | 中 |
| base/meta.jl | 13 | 高 |
| base/deepcopy.jl | 10 | 高 |
| base/refvalue.jl | 6 | 高 |
| base/summarysize.jl | 6 | 中 |
| base/opaque_closure.jl | 2 | 低 |
| base/reflection.jl | 12 | 高 |
| base/runtime_internals.jl | 9 | 中 |
| base/coreir.jl | 2 | 低 |
| base/optimized_generics.jl | 2 | 低 |
| base/multinverses.jl | 16 | 高 |
| base/Base_compiler.jl | 8 | 中 |
| base/baseext.jl | 6 | 中 |
| base/boot.jl | 10 | 中 |
| base/Base.jl | 0 | - |

**注**: Base.jl は他ファイルのincludeとモジュール初期化のみを行うエントリポイントであるため、独自のテストケースは生成していない。

## 根拠詳細

### essentials.jl (UT-BCR-001 ~ UT-BCR-011, UT-BCR-169 ~ UT-BCR-175, UT-BCR-190 ~ UT-BCR-194, UT-BCR-200)

**根拠**: ソースコード内の関数定義を直接確認。

- `convert(::Type{T}, x)`: 行3付近に定義。型変換の基本メカニズム。UT-BCR-001~003, UT-BCR-200はconvertの正常系・異常系・恒等変換をカバー。
- `oftype(x, y)`: ソースコード内に `oftype(x, y) = convert(typeof(x), y)` として定義。UT-BCR-004が対応。
- `cconvert`, `unsafe_convert`: FFI用の変換関数。UT-BCR-005~006が対応。
- `typejoin`: 型結合関数。UT-BCR-007~008が正常系と境界値をカバー。
- `promote_type`: 型昇格。UT-BCR-009が対応。
- `isdispatchtuple`: UT-BCR-010~011が具象型/抽象型を判定。
- `ifelse`: UT-BCR-169~170。条件分岐のブランチレス版。
- `sizeof`: UT-BCR-171~172。型とインスタンスのサイズ取得。
- `typemin`/`typemax`: UT-BCR-173~175。数値型の境界値。
- `isbitstype`/`ismutable`/`isimmutable`: UT-BCR-190~194。型特性判定関数。

### Enums.jl (UT-BCR-012 ~ UT-BCR-016)

**根拠**: `@enum` マクロの定義とEnum型関連ユーティリティをソースコードから確認。

- `@enum`: マクロ定義を確認。基本定義（UT-BCR-012）、値指定（UT-BCR-013）、重複値エラー（UT-BCR-014）をカバー。
- `instances(Enum)`: UT-BCR-015。列挙値の全取得。
- `Symbol(::Enum)`: UT-BCR-016。列挙値のシンボル変換。

### tuple.jl (UT-BCR-017 ~ UT-BCR-027, UT-BCR-179 ~ UT-BCR-181, UT-BCR-199)

**根拠**: Tupleに対する各種操作のメソッド定義をソースコードから確認。

- `getindex`: UT-BCR-017~018。正常系と境界外アクセス。
- `iterate`: UT-BCR-019~020。通常タプルと空タプル。
- `length`: UT-BCR-021~022。通常タプルと空タプル。
- `==`/`<`: UT-BCR-023~025。等値比較と順序比較。
- `map`: UT-BCR-026。タプルへのmap適用。
- `reverse`: UT-BCR-027。タプルの逆転。
- `first`/`last`: UT-BCR-179~180。先頭・末尾要素取得。
- `eltype`: UT-BCR-181。要素型。
- `hash`: UT-BCR-199。ハッシュ一貫性。

### namedtuple.jl (UT-BCR-028 ~ UT-BCR-036, UT-BCR-186 ~ UT-BCR-188)

**根拠**: NamedTupleの構造体定義と各メソッドをソースコードから確認。

- コンストラクタ: UT-BCR-028, UT-BCR-036（空NamedTuple）。
- `getindex`/`keys`/`values`: UT-BCR-029~031。
- `merge`: UT-BCR-032~033。通常マージとキー重複。
- `haskey`: UT-BCR-034~035。
- `pairs`: UT-BCR-186。
- `get`: UT-BCR-187~188。デフォルト値付き取得。

### ntuple.jl (UT-BCR-037 ~ UT-BCR-040)

**根拠**: `ntuple` 関数の定義をソースコードから確認。Int版とVal版の両方をカバー。

### some.jl (UT-BCR-041 ~ UT-BCR-047)

**根拠**: Some型、something関数、coalesce関数、isnothing関数の定義をソースコードから確認。

- `Some(x)`: UT-BCR-041。構築。
- `something`: UT-BCR-042~044。正常系、全nothing、Some(nothing)。
- `coalesce`: UT-BCR-045。missing版のsomething。
- `isnothing`: UT-BCR-046~047。

### missing.jl (UT-BCR-048 ~ UT-BCR-054, UT-BCR-176 ~ UT-BCR-178)

**根拠**: Missing型と関連関数の定義をソースコードから確認。

- `ismissing`: UT-BCR-048~049。
- 算術伝播: UT-BCR-050。`+(::Missing, ::Number)` の定義確認。
- 比較伝播: UT-BCR-051。`==(::Missing, ::Any)` の定義確認。
- `isequal`: UT-BCR-052。Missingの同一性比較。
- `skipmissing`: UT-BCR-053。イテレータ生成。
- `nonmissingtype`: UT-BCR-054。型操作。
- `string(missing)`: UT-BCR-176。
- `convert`: UT-BCR-177~178。

### traits.jl (UT-BCR-055 ~ UT-BCR-057)

**根拠**: IteratorSize、IteratorEltype、OrderStyleの定義をソースコードから確認。トレイト値のディスパッチパターンをカバー。

### operators.jl (UT-BCR-058 ~ UT-BCR-067, UT-BCR-182 ~ UT-BCR-185)

**根拠**: 各演算子・関数合成の定義をソースコードから確認。

- `|>`/`∘`: UT-BCR-058~059。パイプと合成。
- `!`: UT-BCR-060。関数否定。
- `splat`: UT-BCR-061。引数展開。
- `Fix1`/`Fix2`: UT-BCR-062~063。部分適用。
- `Returns`: UT-BCR-064。定数関数。
- `xor`/`nand`/`nor`: UT-BCR-065~067。論理演算。
- `in`: UT-BCR-182~183。包含判定。
- `<:`: UT-BCR-184~185。サブタイプ関係。

### expr.jl (UT-BCR-068 ~ UT-BCR-072)

**根拠**: Expr構築、copy、gensym、macroexpandの定義をソースコードから確認。

### meta.jl (UT-BCR-073 ~ UT-BCR-085)

**根拠**: Metaモジュール内の各関数定義をソースコードから確認。

- `isexpr`: UT-BCR-073~075。3つのオーバーロード。
- `quot`: UT-BCR-076。QuoteNode生成。
- `isidentifier`/`isoperator`/`isunaryoperator`/`isbinaryoperator`: UT-BCR-077~081。
- `parse`: UT-BCR-082~083。正常系とエラー系。
- `lower`: UT-BCR-084。低レベル化。
- `show_sexpr`: UT-BCR-085。

### deepcopy.jl (UT-BCR-086 ~ UT-BCR-094, UT-BCR-189)

**根拠**: deepcopy関数と各型特殊化の定義をソースコードから確認。

- bitstype: UT-BCR-086。行33の`isbitstype(typeof(x)) && return x`に対応。
- Array: UT-BCR-087~088。行128~136のArray特殊化に対応。
- Dict: UT-BCR-089。行149~164のDict特殊化に対応。
- String: UT-BCR-090。行52~59のString特殊化に対応。
- Symbol: UT-BCR-091。行37~38のSymbol等の恒等コピーに対応。
- 循環参照: UT-BCR-092。stackdictによる循環参照追跡機構に対応。
- Tuple: UT-BCR-093。行39~40のTuple特殊化に対応。
- Module: UT-BCR-094。行41のerror呼び出しに対応。
- AbstractLock: UT-BCR-189。行166~173のLock特殊化に対応。

### refvalue.jl (UT-BCR-095 ~ UT-BCR-100)

**根拠**: RefValue構造体と各メソッドの定義をソースコードから確認。

- コンストラクタ: UT-BCR-095。行5~9の定義に対応。
- `getindex`/`setindex!`: UT-BCR-096~097。行59~60に対応。
- `isassigned`: UT-BCR-098~099。行36に対応。docstringの例も確認。
- `unsafe_convert`: UT-BCR-100。行38~54に対応。

### summarysize.jl (UT-BCR-101 ~ UT-BCR-106)

**根拠**: summarysize関数とSummarySize構造体の定義をソースコードから確認。docstring内の例をテストケースに反映。

- 基本サイズ: UT-BCR-101。docstring行32の例に対応。
- Ref(rand(100)): UT-BCR-102。docstring行35の例に対応。
- count=true: UT-BCR-103。docstring行41の例に対応。
- 文字列: UT-BCR-104。行129~133のString特殊化に対応。
- 重複排除: UT-BCR-105。seen辞書メカニズムに対応。
- Symbol: UT-BCR-106。行126の`(::SummarySize)(obj::Symbol) = 0`に対応。

### opaque_closure.jl (UT-BCR-107 ~ UT-BCR-108)

**根拠**: @opaqueマクロの2つの形式（型指定なし・型指定あり）をソースコードから確認。行20~38。

### reflection.jl (UT-BCR-109 ~ UT-BCR-119, UT-BCR-195)

**根拠**: リフレクション関数群の定義をソースコードから確認。

- `code_lowered`: UT-BCR-109。
- `code_typed`: UT-BCR-110。
- `which`: UT-BCR-111~112。正常系とMethodError。
- `hasmethod`: UT-BCR-113~114。
- `nameof`/`parentmodule`: UT-BCR-115~116。
- `return_types`/`infer_return_type`: UT-BCR-117~118。
- `code_ircode`: UT-BCR-119。
- `isambiguous`: UT-BCR-195。

### runtime_internals.jl (UT-BCR-120 ~ UT-BCR-128)

**根拠**: モジュールリフレクション関数群の定義をソースコードから確認。

- `parentmodule(::Module)`: UT-BCR-120~121。行21。
- `fullname`: UT-BCR-122~123。行66~77。
- `names`: UT-BCR-124~125。行91~120。
- `isexported`/`ispublic`: UT-BCR-126~127。行146, 177。
- `moduleroot`: UT-BCR-128。行32~40。

### coreir.jl (UT-BCR-129 ~ UT-BCR-130)

**根拠**: Core.PartialStruct コンストラクタの定義を確認。行50~73。通常コンストラクタとレガシーコンストラクタの2形式。

### optimized_generics.jl (UT-BCR-131 ~ UT-BCR-132)

**根拠**: OptimizedGenerics.KeyValue モジュール内のset/getインターフェース定義を確認。行36~55。これらは実装ではなくインターフェース定義のみであるため、テストは存在確認にとどまる。

### multinverses.jl (UT-BCR-133 ~ UT-BCR-144, UT-BCR-196 ~ UT-BCR-198)

**根拠**: MultiplicativeInversesモジュールの全定義をソースコードから確認。

- `SignedMultiplicativeInverse`: UT-BCR-133~134。行53~89のコンストラクタ。
- `UnsignedMultiplicativeInverse`: UT-BCR-135~136。行98~134のコンストラクタ。
- `div`: UT-BCR-137~138, UT-BCR-141~142, UT-BCR-196~197。行137~146の除算実装。
- `rem`/`divrem`: UT-BCR-139~140。行148~154。
- `mod`: UT-BCR-143, UT-BCR-198。行156~161。
- `multiplicativeinverse`: UT-BCR-144。行163~164のファクトリ関数。

### Base_compiler.jl (UT-BCR-145 ~ UT-BCR-152)

**根拠**: Baseモジュールの初期化コードとプロパティアクセス関数の定義をソースコードから確認。

- `include`: UT-BCR-145。行15~29のinclude定義。
- `getproperty`/`setproperty!`: UT-BCR-146~148。行50~55の定義。
- `convert(::Type{Any}, x)`: UT-BCR-149。行135。
- `swapproperty!`/`replaceproperty!`/`modifyproperty!`: UT-BCR-150~152。行89~104。

### baseext.jl (UT-BCR-153 ~ UT-BCR-158)

**根拠**: VecElementコンストラクタとArray/Vector/Matrixコンストラクタの定義をソースコードから確認。

- `VecElement{T}(arg)`: UT-BCR-153。行17。
- `Vector{T}(undef, m)`: UT-BCR-154。行23。
- `Matrix{T}(undef, m, n)`: UT-BCR-155。行24。
- `Array{T,N}(nothing, d...)`: UT-BCR-156。行42。
- `Array{T,N}(missing, d...)`: UT-BCR-157。行43。
- `Vector()`: UT-BCR-158。行38。

### boot.jl (UT-BCR-159 ~ UT-BCR-168)

**根拠**: Core型定義と基本操作のコメントアウトされた定義をソースコードから確認。これらはC実装へのインターフェースであり、ソースコードのコメント（行5~99）およびexport宣言（行207~244）から関数の存在を確認。

- `typeof`/`isa`/`===`/`throw`: UT-BCR-159~164。export宣言行237~240。
- `nfields`/`fieldtype`/`getfield`/`isdefined`: UT-BCR-165~168。export宣言行231~232。

## 根拠なしのケース

以下14件は、ソースコード中に明示的な関数定義が見つからないか、C実装のラッパーであるため、ソースコードからの直接的なエビデンスが限定的である。

| テストID | 理由 |
|----------|------|
| UT-BCR-009 | promote_typeはessentials.jlから参照されるが主定義はpromotion.jl（別モジュール） |
| UT-BCR-055 | IteratorSizeのデフォルト実装は他ファイルに分散 |
| UT-BCR-056 | IteratorEltypeのデフォルト実装は他ファイルに分散 |
| UT-BCR-057 | OrderStyleの具体的な実装確認が限定的 |
| UT-BCR-107 | @opaqueマクロの実行時挙動はコンパイラ内部に依存 |
| UT-BCR-108 | 型指定付き@opaqueの実行時挙動はコンパイラ内部に依存 |
| UT-BCR-131 | OptimizedGenerics.KeyValue.setはインターフェースのみ |
| UT-BCR-132 | OptimizedGenerics.KeyValue.getはインターフェースのみ |
| UT-BCR-145 | include関数のテストはファイルシステム依存 |
| UT-BCR-159 | typeof はC実装（boot.jlにコメントのみ） |
| UT-BCR-160 | isa はC実装（boot.jlにコメントのみ） |
| UT-BCR-162 | === はC実装（boot.jlにコメントのみ） |
| UT-BCR-164 | throw はC実装（boot.jlにコメントのみ） |
| UT-BCR-195 | isambiguousの具体的な曖昧メソッドペアの生成が困難 |

## テスト観点カバレッジ

| テスト観点 | 件数 | 割合 |
|-----------|------|------|
| 正常系 | 155 | 77.5% |
| 異常系 | 18 | 9.0% |
| 境界値 | 21 | 10.5% |
| 状態・条件 | 6 | 3.0% |

## 優先度分布

| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 62 | 31.0% |
| 中 | 115 | 57.5% |
| 低 | 23 | 11.5% |

## 信頼度算出根拠

- 総クレーム数: 200
- エビデンスありクレーム数: 186（ソースコードの該当行を直接確認できたもの）
- エビデンスなしクレーム数: 14（C実装ラッパーまたはインターフェースのみの定義）
- 信頼度: 186 / 200 = **0.93**

## 改善提案

1. **opaque_closure.jl のカバレッジ向上**: コンパイラ内部への依存が大きく、単体テストが困難な領域。統合テストでの検証が推奨される。
2. **boot.jl のC実装テスト**: Core型の基本操作はC実装であるため、Julia側の単体テストでは振る舞い検証のみとなる。ランタイムレベルのテストが別途必要。
3. **optimized_generics.jl**: インターフェースのみの定義であり、実装を提供するモジュールでのテストが推奨される。
4. **境界値テストの拡充**: 特にmultinverses.jlにおけるInt型の最大値・最小値付近の挙動テストを追加すべき。
