---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 175
  claims_with_evidence: 168
  claims_without_evidence: 7
confidence_derived: 0.96
---

# 根拠レポート：base-infra 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：168 / 175、根拠なし：7
- 優先レビュー（高）
  1. **UT-INF-157 (init_depot_path)**: 初期化関数の内部動作はccallに依存しており、期待結果の正確性は環境依存
  2. **UT-INF-158 (init_load_path)**: 初期化関数の内部動作はccallに依存しており、期待結果の正確性は環境依存
  3. **UT-INF-156 (exit)**: exit関数はプロセス終了を伴うため、テスト実行方法の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/version.jl` - VersionNumber, VersionBound, VersionRange, VersionSpec, semver_spec 等の定義
- E-02: `base/uuid.jl` - UUID構造体と関連メソッドの定義
- E-03: `base/pkgid.jl` - PkgId構造体と binpack/binunpack の定義
- E-04: `base/error.jl` - error関数, ExponentialBackOff, retry, systemerror, @assert, ExceptionStack の定義
- E-05: `base/stacktraces.jl` - StackFrame, StackTrace の定義
- E-06: `base/gcutils.jl` - GCモジュール, WeakRef, finalizer の定義
- E-07: `base/timing.jl` - GC_Num, GC_Diff, format_bytes, time_print, @time, @timed 等の定義
- E-08: `base/regex.jl` - Regex, RegexMatch, eachmatch, SubstitutionString 等の定義
- E-09: `base/util.jl` - printstyled, with_output_color, securezero!, prompt, _crc32c, julia_cmd 等の定義
- E-10: `base/initdefs.jl` - DEPOT_PATH, LOAD_PATH, exit, isinteractive, init_depot_path, init_load_path の定義
- E-11: `base/module.jl` - eval_import_path, check_macro_rename, _eval_import, _eval_using の定義
- E-12: `base/logging/logging.jl` - CoreLogging, AbstractLogger, LogLevel, NullLogger の定義
- E-13: `base/options.jl` - JLOptions 構造体の定義

## 3) Claims と根拠の対応（レビューの主戦場）

### VersionNumber (base/version.jl) - UT-INF-001〜044

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VersionNumber(1,2,3)が正しく生成される | E-01: L49-83 内部コンストラクタ、L84-89 外部コンストラクタ | ○ |
| C-02 | minor/patchのデフォルト値が0 | E-01: L84 `minor::Integer = 0, patch::Integer = 0` | ○ |
| C-03 | pre-release付きバージョン生成 | E-01: L56-70 pre-release検証ロジック | ○ |
| C-04 | 不正pre-releaseでArgumentError | E-01: L65-68 正規表現検証、throw(ArgumentError(...)) | ○ |
| C-05 | 文字列パース | E-01: L148-152 parse関数、L154 VersionNumber(v::AbstractString) | ○ |
| C-06 | v接頭辞対応 | E-01: L114-124 VERSION_REGEX内の `v?` パターン | ○ |
| C-07 | pre-release文字列パース | E-01: L132-146 tryparse内のprerl処理 | ○ |
| C-08 | build情報パース | E-01: L144 build処理 | ○ |
| C-09 | 不正文字列でArgumentError | E-01: L148-152 parse関数のnothing検出 | ○ |
| C-10 | tryparse正常系 | E-01: L132-146 tryparse実装 | ○ |
| C-11 | 無限大記号 | E-01: L133 `v == "∞" && return typemax(VersionNumber)` | ○ |
| C-12 | tryparse異常系 | E-01: L135 `m === nothing && return nothing` | ○ |
| C-13 | ==比較（等しい） | E-01: L193-200 ==関数 | ○ |
| C-14 | ==比較（異なる） | E-01: L193-200 各フィールド比較 | ○ |
| C-15 | isless major比較 | E-01: L204-221 isless実装 L205-206 | ○ |
| C-16 | isless minor比較 | E-01: L207-208 | ○ |
| C-17 | pre-release < release | E-01: L211 `!isempty(a.prerelease) && isempty(b.prerelease)` | ○ |
| C-18 | isless同一バージョン | E-01: L204-221 最後にreturn false | ○ |
| C-19 | thispatch | E-01: L235 | ○ |
| C-20 | thisminor | E-01: L236 | ○ |
| C-21 | thismajor | E-01: L237 | ○ |
| C-22 | nextpatch | E-01: L239 | ○ |
| C-23 | nextminor | E-01: L240 | ○ |
| C-24 | nextmajor | E-01: L241 | ○ |
| C-25 | hashの一貫性 | E-01: L223-230 hash実装 | ○ |
| C-26 | split_idents | E-01: L126-130 | ○ |
| C-27 | VersionBound 1要素 | E-01: L289 | ○ |
| C-28 | VersionBound 2要素 | E-01: L290 | ○ |
| C-29 | VersionBound 3要素 | E-01: L291 | ○ |
| C-30 | VersionBound 4要素超過 | E-01: L287 | ○ |
| C-31 | VersionBound ワイルドカード | E-01: L367 `s == "*" && return VersionBound()` | ○ |
| C-32 | VersionBound 不正文字列 | E-01: L388 `error(...)` | ○ |
| C-33 | VersionRange単一 | E-01: L406-408 | ○ |
| C-34 | VersionRangeハイフン | E-01: L413-422 | ○ |
| C-35 | VersionRange in範囲内 | E-01: L452 `Base.in(v::VersionNumber, r::VersionRange)` | ○ |
| C-36 | VersionRange in範囲外 | E-01: L452 | ○ |
| C-37 | VersionSpec in | E-01: L508-513 | ○ |
| C-38 | VersionSpec intersect | E-01: L555-564 | ○ |
| C-39 | VersionSpec union | E-01: L568-574 | ○ |
| C-40 | semver_specキャレット | E-01: L611-633, L635-669 semver_interval | ○ |
| C-41 | semver_specチルダ | E-01: L635-669 vertyp === :tilde分岐 | ○ |
| C-42 | semver_spec不等号 | E-01: L672-702 inequality_interval | ○ |
| C-43 | semver_specハイフン | E-01: L704-736 hyphen_interval | ○ |
| C-44 | semver_spec不正文字列 | E-01: L623-628 `error(...)` | ○ |

### UUID (base/uuid.jl) - UT-INF-045〜057

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | UUID(UInt128) | E-02: L8-10 | ○ |
| C-46 | UUID(NTuple{2,UInt64}) | E-02: L12 | ○ |
| C-47 | UUID(NTuple{4,UInt32}) | E-02: L13-14 | ○ |
| C-48 | UUID文字列パース | E-02: L50-78 tryparse、L83-86 parse | ○ |
| C-49 | UUID不正文字列 | E-02: L82 throw_malformed_uuid | ○ |
| C-50 | tryparse長さチェック | E-02: L52 `ncodeunits(s) != 36 && return nothing` | ○ |
| C-51 | tryparse正常系 | E-02: L50-78 | ○ |
| C-52 | tryparseハイフン位置 | E-02: L57,62,67,72 codeunit確認 | ○ |
| C-53 | convert NTuple{2} | E-02: L16-21 | ○ |
| C-54 | convert NTuple{4} | E-02: L23-30 | ○ |
| C-55 | string(uuid) | E-02: L91-109 | ○ |
| C-56 | isless | E-02: L114 | ○ |
| C-57 | hash一貫性 | E-02: L34-37 | ○ |

### PkgId (base/pkgid.jl) - UT-INF-058〜066

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | PkgId(uuid,name)コンストラクタ | E-03: L3-9 | ○ |
| C-59 | PkgId(name)コンストラクタ | E-03: L10 | ○ |
| C-60 | ゼロUUIDのnullify | E-03: L7 `UInt128(u) == 0 ? nothing : u` | ○ |
| C-61 | ==等価 | E-03: L17 | ○ |
| C-62 | ==非等価 | E-03: L17 | ○ |
| C-63 | hash一貫性 | E-03: L19-24 | ○ |
| C-64 | binpack | E-03: L29-36 | ○ |
| C-65 | binunpack | E-03: L38-45 | ○ |
| C-66 | ラウンドトリップ | E-03: L29-45 binpack/binunpack相互参照 | ○ |

### error.jl - UT-INF-067〜082

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | error(msg) | E-04: L47-57 | ○ |
| C-68 | error(msg...) | E-04: L47-57 string(s...) | ○ |
| C-69 | error()空メッセージ | E-04: L49 `s === () -> ErrorException("")` | ○ |
| C-70 | ExponentialBackOffデフォルト | E-04: L273-274 | ○ |
| C-71 | ExponentialBackOff負値 | E-04: L261 `all(x->x>=0, ...)` | ○ |
| C-72 | iterate回数 | E-04: L275-281 | ○ |
| C-73 | iterate初期遅延 | E-04: L275 `state=(ebo.n, min(ebo.first_delay, ebo.max_delay))` | ○ |
| C-74 | iterate n=0 | E-04: L276 `state[1] < 1 && return nothing` | ○ |
| C-75 | length | E-04: L282 | ○ |
| C-76 | retry正常実行 | E-04: L305-322 try-catch内でreturn | ○ |
| C-77 | retryリトライ成功 | E-04: L305-322 ループ内で再試行 | ○ |
| C-78 | retry全失敗 | E-04: L305-322 ループ終了後rethrow | ○ |
| C-79 | retry checkコールバック | E-04: L313-316 check関数の呼び出し | ○ |
| C-80 | systemerror true | E-04: L187 | ○ |
| C-81 | systemerror false | E-04: L187 `b ? ... : nothing` | ○ |
| C-82 | current_exceptions | E-04: L162-172 | ○ |

### StackTraces (base/stacktraces.jl) - UT-INF-083〜085

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | StackFrame基本コンストラクタ | E-05: L69-70 | ○ |
| C-84 | StackFrame == | E-05: L88-90 | ○ |
| C-85 | StackFrame hash | E-05: L92-99 | ○ |

### GC/gcutils (base/gcutils.jl) - UT-INF-086〜095

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | GC.gc(true) | E-06: L133-134 ccall | ○ |
| C-87 | GC.gc(false) | E-06: L133-134 GC_INCREMENTAL | ○ |
| C-88 | GC.enable | E-06: L146 | ○ |
| C-89 | GC.enable_logging | E-06: L271-273 | ○ |
| C-90 | GC.logging_enabled | E-06: L280-282 | ○ |
| C-91 | GC.safepoint | E-06: L264 | ○ |
| C-92 | WeakRef生成 | E-06: L6-31 docstring | ○ |
| C-93 | WeakRef == | E-06: L34 | ○ |
| C-94 | finalizerミュータブル | E-06: L84-88 | ○ |
| C-95 | finalizerイミュータブル拒否 | E-06: L39-43 _check_mutable | ○ |

### timing.jl - UT-INF-096〜106, 167〜172

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | gc_num() | E-07: L77 | ○ |
| C-97 | GC_Diff(new,old) | E-07: L95-108 | ○ |
| C-98 | gc_alloc_count | E-07: L110-112 | ○ |
| C-99 | gc_total_bytes | E-07: L92-93 | ○ |
| C-100 | format_bytes バイナリ 1024 | E-07: L241-250 | ○ |
| C-101 | format_bytes KiB | E-07: L241-250 | ○ |
| C-102 | format_bytes 10進 | E-07: L241-250 binary=false | ○ |
| C-103 | format_bytes 0 | E-07: L201 `value == 0` | ○ |
| C-104 | format_bytes 1 | E-07: L201 `value == 1`, L246 単数形 | ○ |
| C-105 | prettyprint_getunits | E-07: L200-208 | ○ |
| C-106 | prettyprint_getunits 0 | E-07: L201 | ○ |
| C-167 | gc_live_bytes | E-07: L141-144 | ○ |
| C-168 | jit_total_bytes | E-07: L193-195 | ○ |
| C-169 | gc_time_ns | E-07: L131 | ○ |
| C-170 | time_print秒フォーマット | E-07: L252-303 | ○ |
| C-171 | time_print GC比率 | E-07: L274-279 | ○ |
| C-172 | time_printアロケーション | E-07: L265-273 | ○ |

### Regex (base/regex.jl) - UT-INF-107〜143

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | Regex基本コンストラクタ | E-08: L68 | ○ |
| C-108 | Regexフラグ付き | E-08: L48-67 | ○ |
| C-109 | Regex複数フラグ | E-08: L48-67 forループ | ○ |
| C-110 | Regex不正フラグ | E-08: L63 throw(ArgumentError) | ○ |
| C-111 | RegexASCIIモード | E-08: L52-57 f=='a'分岐 | ○ |
| C-112 | occursinマッチ成功 | E-08: L306-309 | ○ |
| C-113 | occursinマッチ失敗 | E-08: L306-309 | ○ |
| C-114 | matchキャプチャ | E-08: L430-449 | ○ |
| C-115 | match nothing | E-08: L435-437 `if !matched ... return nothing` | ○ |
| C-116 | matchオフセット | E-08: L430 `match(re,str,idx)` | ○ |
| C-117 | getindex整数 | E-08: L286 | ○ |
| C-118 | getindex名前 | E-08: L287-291 | ○ |
| C-119 | getindex存在しない名前 | E-08: L289 `error(...)` | ○ |
| C-120 | haskey整数 | E-08: L293 | ○ |
| C-121 | haskey名前存在 | E-08: L294-297 | ○ |
| C-122 | haskey名前不在 | E-08: L296 `idx > 0` | ○ |
| C-123 | keys | E-08: L260-266 | ○ |
| C-124 | iterate | E-08: L299 | ○ |
| C-125 | length | E-08: L300 | ○ |
| C-126 | startswith成功 | E-08: L338-341 | ○ |
| C-127 | startswith失敗 | E-08: L338-341 PCRE.ANCHORED | ○ |
| C-128 | endswith成功 | E-08: L370-373 | ○ |
| C-129 | endswith失敗 | E-08: L370-373 PCRE.ENDANCHORED | ○ |
| C-130 | chopprefix成功 | E-08: L380-384 | ○ |
| C-131 | chopprefix失敗 | E-08: L382 `m === nothing && return SubString(s)` | ○ |
| C-132 | chopsuffix成功 | E-08: L386-391 | ○ |
| C-133 | chopsuffix失敗 | E-08: L388 | ○ |
| C-134 | eachmatchイテレーション | E-08: L804-805 | ○ |
| C-135 | eachmatchオーバーラップ | E-08: L759-762 itr.overlap分岐 | ○ |
| C-136 | countマッチ数 | E-08: L568-580 | ○ |
| C-137 | countオーバーラップ | E-08: L575 overlap分岐 | ○ |
| C-138 | Regex == | E-08: L809-811 | ○ |
| C-139 | Regex !=  | E-08: L809-811 | ○ |
| C-140 | Regex連結 | E-08: L851-870 | ○ |
| C-141 | Regex+文字列連結 | E-08: L851-870, L876 wrap_string | ○ |
| C-142 | Regex繰り返し | E-08: L924 | ○ |
| C-143 | SubstitutionString | E-08: L600-602 | ○ |

### util.jl - UT-INF-144〜154

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | printstyled色付き | E-09: L141-144 | ○ |
| C-145 | printstyled太字 | E-09: L141 bold引数 | ○ |
| C-146 | with_output_color色無効 | E-09: L81-82 `if !iscolor; print(io, str)` | ○ |
| C-147 | securezero! | E-09: L271 | ○ |
| C-148 | promptデフォルト値 | E-09: L407-413 | ○ |
| C-149 | promptEOF | E-09: L411 `isempty(uinput) && return nothing` | ○ |
| C-150 | _crc32c文字列 | E-09: L518-520 | ○ |
| C-151 | _crc32c配列 | E-09: L514-516 | ○ |
| C-152 | _crc32c負値 | E-09: L523 `nb < 0 && throw(ArgumentError(...))` | ○ |
| C-153 | isdebugbuild | E-09: L740-742 | ○ |
| C-154 | julia_exename | E-09: L254-260 | ○ |

### initdefs.jl, module.jl, logging.jl, options.jl - UT-INF-155〜175

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | isinteractive | E-10: L40 | ○ |
| C-156 | exit | E-10: L28-29 | ○ |
| C-157 | init_depot_path | E-10: DEPOT_PATH定義あるが、init関数の詳細動作は環境依存 | △ |
| C-158 | init_load_path | E-10: LOAD_PATH定義あるが、init関数の詳細動作は環境依存 | △ |
| C-159 | eval_import_path Core | E-11: L31-32 `v === :Core -> m = Core` | ○ |
| C-160 | eval_import_path Base | E-11: L33-34 `v === :Base -> m = Base` | ○ |
| C-161 | eval_import_path空パス | E-11: L13 `isempty(path.args) && error(...)` | ○ |
| C-162 | check_macro_rename マクロ->非マクロ | E-11: L71-72 | ○ |
| C-163 | check_macro_rename 非マクロ->マクロ | E-11: L74-76 | ○ |
| C-164 | NullLogger | E-12: L100 | ○ |
| C-165 | catch_exceptionsデフォルト | E-12: L72 | ○ |
| C-166 | LogLevel比較 | E-12: LogLevelの定義（isless実装参照） | △ |
| C-173 | JLOptions | E-13: 構造体定義 | ○ |
| C-174 | julia_cmd | E-09: L171-252 | ○ |
| C-175 | GC.gc_active_impl | E-06: L290-292 | ○ |

## 4) 不足情報（Unknown / Missing）
- **init_depot_path / init_load_path (C-157, C-158)**: 初期化関数の正確な振る舞いは `initdefs.jl` 内の実装を参照する必要があるが、環境変数に依存するため完全な期待結果の検証が困難
  - 候補：実行環境でのテスト / モック環境の構築 / 統合テストとして検証
- **LogLevel比較 (C-166)**: LogLevelの演算子オーバーロードは `logging.jl` 内で定義されているが、isless等の具体的な実装行の特定が不完全
  - 候補：`logging.jl` の完全読み込み / LogLevel型定義の詳細確認
- **exit (C-156)**: プロセス終了関数のため、単体テストでの検証方法に制約がある
  - 候補：サブプロセスでの実行 / シグナルハンドリングを用いた検証
- **retry全失敗 (C-78)**: retryのループ終了後のrethrow動作はソースコードで確認済みだが、テスト内での遅延処理が実行時間に影響する
  - 候補：短い遅延でのテスト / モック遅延の使用
- **init_depot_path / init_load_path の期待結果**: 環境変数の設定値に依存し、テスト環境での値は予測不能
  - 候補：テスト環境でのENV変数制御
- **gc_live_bytes / jit_total_bytes の具体値**: ランタイム状態に依存するため具体値の予測不能
  - 候補：型と符号のみの検証
- **LogLevel内部値**: Debug, Info, Warn, Errorの内部数値表現を直接確認していない
  - 候補：`logging.jl` の LogLevel 値定義の完全確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: VersionNumber, UUID, PkgId, StackFrame - 純粋なデータ構造で外部依存なし、ソースコードから直接検証可能
- **0 (低リスク)**: Regex, RegexMatch - PCRE依存だが入出力のインターフェースはソースコードで明確
- **0 (低リスク)**: ExponentialBackOff, format_bytes, prettyprint_getunits - 純粋関数でテスト容易
- **1 (中リスク)**: GCモジュール (gc, enable, safepoint等) - ccallによるランタイム呼び出しで副作用あり
- **1 (中リスク)**: timing関連 (gc_num, gc_live_bytes等) - ランタイム状態依存
- **1 (中リスク)**: init_depot_path, init_load_path - 環境変数依存
- **2 (高リスク)**: exit関数 - プロセス終了を伴うためテスト実行方法に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] VersionNumberのpre-release/buildバリデーションの異常系テストケースが十分か確認
- [ ] UUIDのtryparseにおけるハイフン位置チェック(9,14,19,24)のエッジケースが網羅されているか確認
- [ ] ExponentialBackOffのmax_delay上限クランプ動作のテストが必要か検討
- [ ] GCモジュールのenable/disableの状態復元テストが必要か検討
- [ ] semver_spec関数の全パターン（キャレット/チルダ/不等号/ハイフン）の境界値テストが十分か確認
- [ ] Regex連結時の互換性チェック（異なるオプション間の連結制約）テストの妥当性確認
- [ ] retry関数のcheckコールバックの2要素返却パターン（state更新）のテスト追加を検討
