---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 250
  claims_with_evidence: 237
  claims_without_evidence: 13
confidence_derived: 0.95
---

# 根拠レポート: base-io モジュール 単体テストケース一覧

## 1. 概要

本レポートは、Julia言語 base-io モジュール（グループ5）の単体テストケース一覧（base-io.csv）の生成根拠を記述する。

### 対象モジュール
- **モジュール名**: base-io
- **対象ファイル数**: 13ファイル
- **生成テストケース数**: 250件
- **信頼度**: 0.95

### 対象ファイル一覧

| No | ファイル | 主要な機能 | テストケース数 |
|----|---------|-----------|--------------|
| 1 | base/io.jl | IO抽象型、読み書き関数、AbstractPipe | 36 |
| 2 | base/iobuffer.jl | GenericIOBuffer/IOBuffer実装 | 42 |
| 3 | base/iostream.jl | IOStream（ファイルIO） | 11 |
| 4 | base/stream.jl | LibuvStream、PipeEndpoint | 5 |
| 5 | base/coreio.jl | DevNull、print/println、stdin/stdout/stderr | 7 |
| 6 | base/secretbuffer.jl | SecretBuffer（セキュアバッファ） | 38 |
| 7 | base/parse.jl | 文字列→数値パース関数 | 45 |
| 8 | base/toml_parser.jl | TOMLパーサー | 24 |
| 9 | base/multimedia.jl | MIME型、Display機構 | 16 |
| 10 | base/errorshow.jl | エラー表示関数 | 5 |
| 11 | base/methodshow.jl | メソッド表示関数 | 3 |
| 12 | base/show.jl | show関数群 | 0（注1） |
| 13 | base/range.jl | Range型とRange操作 | 18 |

**注1**: show.jl は非常に大きなファイル（2000行超）であり、多数のshow関連メソッドを含む。show関数の基本的なテストは他のファイルのテストケースに含まれているが、show.jl固有の詳細なテストケースは本レポートでは省略した。これは信頼度低下の主な要因である。

## 2. 根拠の詳細

### 2.1 base/io.jl (UT-BIO-001 〜 UT-BIO-036)

**根拠**: ソースコード `base/io.jl` を直接解析し、以下の関数・型を特定した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-001〜003 | IO型のデフォルト実装（lock, unlock, reseteof）の定義を確認 | io.jl 33-45行目 |
| UT-BIO-004〜005 | isreadable/iswritableのデフォルト実装を確認 | io.jl 176, 199行目 |
| UT-BIO-006〜007 | isreadonlyの定義を確認 | io.jl 806行目 |
| UT-BIO-008〜010 | open_flags関数の条件分岐を網羅 | io.jl 378-408行目 |
| UT-BIO-011〜014 | write/readのデフォルト実装とエラー処理を確認 | io.jl 259-325行目 |
| UT-BIO-015〜019 | 各型に対するwrite実装を確認 | io.jl 830-849行目 |
| UT-BIO-020〜023 | read/peekの実装を確認 | io.jl 360-368, 919-993行目 |
| UT-BIO-024〜032 | readuntil/readline/readlines/copyuntil/copylineの実装を確認 | io.jl 538-726行目 |
| UT-BIO-033〜034 | write(io, Symbol)/write(to, from)を確認 | io.jl 894-905行目 |
| UT-BIO-035 | AbstractPipeの委譲メカニズムを確認 | io.jl 438-496行目 |
| UT-BIO-036 | ntoh/hton/ltoh/htolのエンディアン変換を確認 | io.jl 730-785行目 |

### 2.2 base/iobuffer.jl (UT-BIO-037 〜 UT-BIO-078)

**根拠**: ソースコード `base/iobuffer.jl` を直接解析。GenericIOBuffer構造体と各メソッドの実装を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-037〜041 | IOBufferコンストラクタのバリエーションとエラーチェックを確認 | iobuffer.jl 230-270, 110-130行目 |
| UT-BIO-042〜048 | read/peek/writeの各種実装とエラー処理を確認 | iobuffer.jl 349-461行目 |
| UT-BIO-049〜054 | seek/seekend/skipの実装と境界処理を確認 | iobuffer.jl 475-524行目 |
| UT-BIO-055〜058 | position/bytesavailable/eofの実装を確認 | iobuffer.jl 464-691行目 |
| UT-BIO-059〜061 | isopen/close/closewriteの実装を確認 | iobuffer.jl 693-711行目 |
| UT-BIO-062〜063 | take!の実装とリセット動作を確認 | iobuffer.jl 731-786行目 |
| UT-BIO-064〜068 | truncate/ensureroom の実装とエラー条件を確認 | iobuffer.jl 558-659行目 |
| UT-BIO-069〜071 | mark/unmark/reset/ismarked/filesizeの実装を確認 | iobuffer.jl（markインターフェース） |
| UT-BIO-072〜075 | copy/show/PipeBufferの実装を確認 | iobuffer.jl 272-343行目 |
| UT-BIO-076〜078 | MultiByteBitNumberType読み込みとcompact!を確認 | iobuffer.jl 380-689行目 |

### 2.3 base/iostream.jl (UT-BIO-079 〜 UT-BIO-089)

**根拠**: ソースコード `base/iostream.jl` を直接解析。IOStream構造体とccallベースの各メソッドを確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-079〜080 | IOStreamコンストラクタとshowを確認 | iostream.jl 13-35行目 |
| UT-BIO-081〜089 | isopen/close/flush/seek/seekend/truncate/iswritable/isreadable/fdの実装を確認 | iostream.jl 74-196行目 |

### 2.4 base/stream.jl (UT-BIO-090 〜 UT-BIO-094)

**根拠**: ソースコード `base/stream.jl` を直接解析。LibuvStream抽象型、ステータス定数、PipeEndpoint型を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-090〜091 | LibuvStreamのbytesavailable/eofを確認 | stream.jl 102-115行目 |
| UT-BIO-092〜093 | uv_status_stringの各ステータス値マッピングを確認 | stream.jl 129-167行目 |
| UT-BIO-094 | PipeEndpointコンストラクタを確認 | stream.jl 169-200行目 |

### 2.5 base/coreio.jl (UT-BIO-095 〜 UT-BIO-101)

**根拠**: ソースコード `base/coreio.jl` を直接解析。DevNull型、print/println関数を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-095〜099 | DevNull型の各メソッド（write/read/eof/isopen/isreadable/iswritable/bytesavailable）を確認 | coreio.jl 15-36行目 |
| UT-BIO-100〜101 | print/printlnのstdout版を確認 | coreio.jl 3-9行目 |

### 2.6 base/secretbuffer.jl (UT-BIO-102 〜 UT-BIO-139)

**根拠**: ソースコード `base/secretbuffer.jl` を全行解析（233行）。SecretBuffer型の全メソッドを網羅した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-102〜105 | コンストラクタ群を確認 | secretbuffer.jl 31-63行目 |
| UT-BIO-106 | SecretBuffer!の安全な初期化を確認 | secretbuffer.jl 71-80行目 |
| UT-BIO-107〜108 | unsafe_SecretBuffer!のNULLチェックを確認 | secretbuffer.jl 82-100行目 |
| UT-BIO-109〜125 | IOメソッド（write/read/peek/seek/seekend/skip/eof/isempty/bytesavailable/position）を確認 | secretbuffer.jl 133-188行目 |
| UT-BIO-126 | showの内容隠蔽を確認 | secretbuffer.jl 103行目 |
| UT-BIO-127〜129 | ==/hashの定時間比較と固定ハッシュを確認 | secretbuffer.jl 106-118行目 |
| UT-BIO-130〜131 | copy/copy!を確認 | secretbuffer.jl 120-131行目 |
| UT-BIO-132〜136 | shred!/final_shred!/isshreddedを確認 | secretbuffer.jl 190-232行目 |
| UT-BIO-137〜138 | cconvert(Cstring)とnulチェックを確認 | secretbuffer.jl 155-167行目 |
| UT-BIO-139 | write(io, SecretBuffer)を確認 | secretbuffer.jl 147-153行目 |

### 2.7 base/parse.jl (UT-BIO-140 〜 UT-BIO-184)

**根拠**: ソースコード `base/parse.jl` を全行解析（401行）。parse/tryparse関数の全バリエーションを確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-140〜154 | parse/tryparse_internal(::Type{Integer})の正常系・異常系・境界値を確認 | parse.jl 41-183行目 |
| UT-BIO-155〜157 | parse(::Type{T}, ::AbstractChar)を確認 | parse.jl 41-49行目 |
| UT-BIO-158〜162 | tryparse(::Type{Integer})と境界値を確認 | parse.jl 248-258行目 |
| UT-BIO-163〜169 | tryparse_internal(::Type{Bool})の全分岐を確認 | parse.jl 185-233行目 |
| UT-BIO-170〜174 | tryparse(::Type{Float64/Float32/Float16})を確認 | parse.jl 262-306行目 |
| UT-BIO-175〜180 | tryparse_internal(::Type{Complex})の全分岐を確認 | parse.jl 310-365行目 |
| UT-BIO-181 | parse(Union{})のエラーを確認 | parse.jl 39行目 |
| UT-BIO-182〜184 | check_valid_baseの境界値を確認 | parse.jl 235-240行目 |

### 2.8 base/multimedia.jl (UT-BIO-185 〜 UT-BIO-200)

**根拠**: ソースコード `base/multimedia.jl` を解析。MIME型、AbstractDisplay、TextDisplay、Displayスタック機構を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-185〜187 | MIME型のコンストラクタ・マクロ・showを確認 | multimedia.jl 32-51行目 |
| UT-BIO-188〜189 | showableの実装を確認 | multimedia.jl 76-77行目 |
| UT-BIO-190〜192 | istextmimeの実装と特別登録MIMEを確認 | multimedia.jl 195-206行目 |
| UT-BIO-193 | reprの実装を確認 | multimedia.jl 159-178行目 |
| UT-BIO-194〜197 | TextDisplayの実装を確認 | multimedia.jl 251-266行目 |
| UT-BIO-198〜200 | pushdisplay/popdisplayの実装を確認 | multimedia.jl 281-301行目 |

### 2.9 base/toml_parser.jl (UT-BIO-201 〜 UT-BIO-224)

**根拠**: ソースコード `base/toml_parser.jl` を解析。TOMLパーサーのParser型、parse/tryparse関数、各値型のパース関数を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-201〜214 | 各TOML値型（文字列、数値、ブール、配列、テーブル、日時）のパースを確認 | toml_parser.jl の各parse_*関数 |
| UT-BIO-215〜216 | エラー条件（不正TOML、重複キー）を確認 | toml_parser.jl のErrorType定義 |
| UT-BIO-217〜218 | tryparseの正常・異常系を確認 | toml_parser.jl のtryparse実装 |
| UT-BIO-219〜224 | 境界値・特殊値（空文字列、エスケープ、負数、inf/nan）を確認 | toml_parser.jl の各パース関数 |

### 2.10 base/errorshow.jl (UT-BIO-225 〜 UT-BIO-229)

**根拠**: ソースコード `base/errorshow.jl` を解析。showerror関数の各例外型に対する表示メソッドを確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-225 | showerror(io, ex)のデフォルト実装を確認 | errorshow.jl 30行目 |
| UT-BIO-226 | showerror(io, ::BoundsError)を確認 | errorshow.jl 55-76行目 |
| UT-BIO-227 | showerror(io, ::TypeError)を確認 | errorshow.jl 78-100行目 |
| UT-BIO-228 | SystemErrorの表示を確認 | errorshow.jl（SystemError表示） |
| UT-BIO-229 | show_indexの各型表示を確認 | errorshow.jl 32-36行目 |

### 2.11 base/methodshow.jl (UT-BIO-230 〜 UT-BIO-232)

**根拠**: ソースコード `base/methodshow.jl` を解析。メソッド表示関連の補助関数を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-230 | strip_gensymの実装を確認 | methodshow.jl 6-11行目 |
| UT-BIO-231 | method_argnamesの実装を確認 | methodshow.jl 49-53行目 |
| UT-BIO-232 | kwarg_declの実装を確認 | methodshow.jl 80-100行目 |

### 2.12 base/range.jl (UT-BIO-233 〜 UT-BIO-250)

**根拠**: ソースコード `base/range.jl` を解析。UnitRange, StepRange, LinRange, LogRange, OneTo, range関数の定義を確認した。

| テストID | 根拠 | エビデンス |
|---------|------|-----------|
| UT-BIO-233〜234 | UnitRangeコンストラクタを確認 | range.jl のUnitRange定義 |
| UT-BIO-235〜236 | StepRangeコンストラクタとステップ0エラーを確認 | range.jl のStepRange定義 |
| UT-BIO-237〜239 | LinRangeコンストラクタと境界値を確認 | range.jl のLinRange定義 |
| UT-BIO-240〜242 | OneToコンストラクタと境界値を確認 | range.jl のOneTo定義 |
| UT-BIO-243〜244 | colon演算子（:）の動作を確認 | range.jl のcolon定義 |
| UT-BIO-245〜246 | range関数のバリエーションを確認 | range.jl のrange定義 |
| UT-BIO-247〜248 | LogRangeの正常系・異常系を確認 | range.jl のLogRange定義 |
| UT-BIO-249〜250 | Rangeの基本プロパティ（length/first/last/step/getindex）を確認 | range.jl の各関数定義 |

## 3. テスト観点カバレッジ

| テスト観点 | テストケース数 | 割合 |
|-----------|--------------|------|
| 正常系 | 177 | 70.8% |
| 異常系 | 49 | 19.6% |
| 境界値 | 24 | 9.6% |

## 4. 優先度分布

| 優先度 | テストケース数 | 割合 |
|-------|--------------|------|
| 高 | 102 | 40.8% |
| 中 | 126 | 50.4% |
| 低 | 22 | 8.8% |

## 5. 根拠なしの項目

以下の13件は、ソースコードの直接的な行番号参照が困難だが、ファイル内の関連する機能から推論したテストケースである。

1. **UT-BIO-035**: AbstractPipeの委譲テストは、具体的なPipe実装が必要であり、io.jlの定義のみからの推論
2. **UT-BIO-069〜070**: mark/unmark/resetのIOBufferでの具体的な実装箇所が分散しており、複合的な推論
3. **UT-BIO-078**: compact!は内部メソッドであり、直接テストの妥当性は推論
4. **UT-BIO-091**: LibuvStreamのeof動作はランタイム依存のため、テスト条件は推論
5. **UT-BIO-094**: PipeEndpointの初期化はccall依存であり、テスト条件は推論
6. **UT-BIO-209**: 複数行文字列のTOMLパースは仕様からの推論
7. **UT-BIO-213**: 日時パースの期待結果は実装のDates型依存のため推論
8. **UT-BIO-220**: エスケープシーケンスの期待結果はTOML仕様からの推論
9. **UT-BIO-223**: 16進・8進・2進整数のTOMLパースはTOML仕様からの推論
10. **UT-BIO-224**: inf/nanのTOMLパースはTOML仕様からの推論
11. **UT-BIO-247〜248**: LogRangeの動作はJulia 1.10以降の機能であり、実装詳細は推論
12. show.jl固有のテストケースが含まれていない点（ファイルサイズが大きく完全な解析が困難）

## 6. 制限事項

1. **show.jl**: 2000行を超える大規模ファイルのため、完全な解析が行えていない。show関連の基本テストは他ファイルのテストケースでカバーされているが、show.jl固有の詳細な表示ロジック（数値表示、配列表示、型表示等）のテストケースは含まれていない。
2. **ランタイム依存テスト**: stream.jl のLibuvStream関連テストは、libuv ランタイムに依存するため、テスト実行環境に制約がある。
3. **ccall依存コード**: iostream.jl および stream.jl のccallベースの関数は、C言語ランタイムとの連携が必要であり、純粋な単体テストでのカバレッジに限界がある。

## 7. 推奨事項

1. show.jl に対して別途詳細なテストケースを追加することを推奨
2. LibuvStream関連テストは統合テストレベルでのカバレッジを推奨
3. SecretBufferのセキュリティ関連テスト（タイミング攻撃耐性等）は専用のセキュリティテストとして実施を推奨
