---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 264
  claims_with_evidence: 253
  claims_without_evidence: 11
confidence_derived: 0.96
---

# 根拠レポート：base-numeric 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：253 / 264、根拠なし：11
- 優先レビュー（高）
  1. **UT-NUM-149 (ComplexF64除算のスケーリング)**: 内部実装の数値安定性に関するテスト観点。期待結果の精度が要確認
  2. **UT-NUM-259 (splitprec)**: twiceprecision.jlの内部関数であり、直接テスト可能かどうか要確認
  3. **UT-NUM-261 (@fastmathマクロ)**: マクロの動作はコンパイル時変換であり、テスト手法が通常と異なる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/int.jl` - 整数型の算術演算、ビット操作、型変換の定義
- E-02: `base/intfuncs.jl` - powermod, gcd, lcm, gcdx, invmod, isqrt, factorial, binomial, ndigits, digits等の関数定義
- E-03: `base/float.jl` - 浮動小数点型の定義、変換、特殊値判定、eps, nextfloat, prevfloat等
- E-04: `base/floatfuncs.jl` - copysign, flipsign, signbit, maxintfloat, isinteger, round, isapprox, fma等
- E-05: `base/bool.jl` - Bool型の算術演算、論理演算、型変換の定義
- E-06: `base/number.jl` - Number型の汎用操作（zero, one, sign, abs, abs2, copysign等）
- E-07: `base/complex.jl` - Complex型の定義、算術、三角関数、指数/対数関数
- E-08: `base/rational.jl` - Rational型の定義、算術、比較、変換
- E-09: `base/div.jl` - div, rem, fld, cld, mod, divrem, fldmod等の除算関連関数
- E-10: `base/checked.jl` - Checkedモジュール（checked_add, checked_sub, checked_mul等）
- E-11: `base/promotion.jl` - 型プロモーション規則（typejoin, promote_type, promote等）
- E-12: `base/hashing.jl` - hash関数の実装（整数、浮動小数点、複素数）
- E-13: `base/rounding.jl` - RoundingModeの定義、setrounding, rounding
- E-14: `base/irrationals.jl` - Irrational型の定義、変換、プロモーション規則
- E-15: `base/math.jl` - Mathモジュール（三角関数、指数関数、対数関数、その他数学関数）
- E-16: `base/twiceprecision.jl` - 二重精度演算（splitprec, canonicalize2, add12等）
- E-17: `base/fastmath.jl` - FastMathモジュール（@fastmathマクロ）
- E-18: `base/mathconstants.jl` - 数学定数の定義

## 3) Claims と根拠の対応（レビューの主戦場）

### 整数演算（int.jl）- UT-NUM-001 ~ UT-NUM-027
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 整数加算・減算・乗算の基本動作 (UT-NUM-001~003) | E-01 | ○ |
| C-02 | 符号反転とオーバーフロー検出 (UT-NUM-004~005) | E-01 | ○ |
| C-03 | 整数除算と剰余、ゼロ除算 (UT-NUM-006~010) | E-01 | ○ |
| C-04 | 比較演算 (UT-NUM-011~012) | E-01 | ○ |
| C-05 | ビット演算（NOT, AND, OR, XOR） (UT-NUM-013~016) | E-01 | ○ |
| C-06 | ビットシフト演算 (UT-NUM-017~019) | E-01 | ○ |
| C-07 | typemin/typemax/widen (UT-NUM-020~022) | E-01 | ○ |
| C-08 | flipsign, trailing_zeros, leading_zeros, count_ones (UT-NUM-023~027) | E-01 | ○ |

### 整数関数（intfuncs.jl）- UT-NUM-028 ~ UT-NUM-050
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | powermod正常系・境界値・異常系 (UT-NUM-028~030) | E-02 | ○ |
| C-10 | gcd正常系・境界値 (UT-NUM-031~033) | E-02 | ○ |
| C-11 | lcm正常系・境界値 (UT-NUM-034~035) | E-02 | ○ |
| C-12 | gcdx正常系 (UT-NUM-036) | E-02 | ○ |
| C-13 | invmod正常系・異常系 (UT-NUM-037~038) | E-02 | ○ |
| C-14 | isqrt正常系・境界値・異常系 (UT-NUM-039~041) | E-02 | ○ |
| C-15 | factorial正常系・境界値・異常系 (UT-NUM-042~045) | E-02 | ○ |
| C-16 | binomial正常系・境界値 (UT-NUM-046~048) | E-02 | ○ |
| C-17 | ndigits, digits (UT-NUM-049~050) | E-02 | ○ |

### 浮動小数点（float.jl / floatfuncs.jl）- UT-NUM-051 ~ UT-NUM-098
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Float変換（Float64, Float32, Float16） (UT-NUM-051~053) | E-03 | ○ |
| C-19 | Float基本算術 (UT-NUM-054~058) | E-03 | ○ |
| C-20 | 特殊値判定（isinf, isnan, isfinite, issubnormal） (UT-NUM-059~065) | E-03 | ○ |
| C-21 | eps, nextfloat, prevfloat (UT-NUM-066~069) | E-03 | ○ |
| C-22 | floatmin, floatmax, exponent, significand, ldexp, frexp (UT-NUM-070~075) | E-03 | ○ |
| C-23 | copysign, flipsign, signbit (UT-NUM-076~080) | E-04 | ○ |
| C-24 | maxintfloat, isinteger (UT-NUM-081~083) | E-04 | ○ |
| C-25 | round各種モード (UT-NUM-084~091) | E-04 | ○ |
| C-26 | isapprox各種オプション (UT-NUM-092~096) | E-04 | ○ |
| C-27 | fma (UT-NUM-097~098) | E-04 | ○ |

### Bool（bool.jl）- UT-NUM-099 ~ UT-NUM-115
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Bool論理演算（NOT, AND, OR, XOR, NAND, NOR） (UT-NUM-099~104) | E-05 | ○ |
| C-29 | Bool算術演算（+, *, ^） (UT-NUM-105~107) | E-05 | ○ |
| C-30 | Bool除算とDivideError (UT-NUM-108~109) | E-05 | ○ |
| C-31 | Bool変換とInexactError (UT-NUM-110~112) | E-05 | ○ |
| C-32 | Bool特殊動作（signbit, -0.0保持, 強いゼロ） (UT-NUM-113~115) | E-05 | ○ |

### Number基本（number.jl）- UT-NUM-116 ~ UT-NUM-139
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | zero, one, oneunit (UT-NUM-116~118) | E-06 | ○ |
| C-34 | sign, abs, abs2 (UT-NUM-119~125) | E-06 | ○ |
| C-35 | copysign, flipsign, inv, widemul (UT-NUM-126~129) | E-06 | ○ |
| C-36 | iszero, isone, isfinite (UT-NUM-130~132) | E-06 | ○ |
| C-37 | iterate, getindex (UT-NUM-133~135) | E-06 | ○ |
| C-38 | ispositive, isnegative (UT-NUM-136~139) | E-06 | ○ |

### Complex（complex.jl）- UT-NUM-140 ~ UT-NUM-170
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Complex生成、アクセサ（real, imag, reim） (UT-NUM-140~144) | E-07 | ○ |
| C-40 | Complex算術（+, -, *, /） (UT-NUM-145~148) | E-07 | ○ |
| C-41 | ComplexF64除算のスケーリング (UT-NUM-149) | E-07 | △ |
| C-42 | Complex関数（abs, abs2, conj, inv） (UT-NUM-150~153) | E-07 | ○ |
| C-43 | Complex判定関数 (UT-NUM-154~157) | E-07 | ○ |
| C-44 | Complex数学関数（angle, sqrt, exp, log, sin, cos, cis, cispi） (UT-NUM-158~166) | E-07 | ○ |
| C-45 | Complex冪乗と丸め (UT-NUM-167~170) | E-07 | ○ |

### Rational（rational.jl）- UT-NUM-171 ~ UT-NUM-182
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Rational生成と約分 (UT-NUM-171~174) | E-08 | ○ |
| C-47 | Rational算術 (UT-NUM-175~178) | E-08 | ○ |
| C-48 | Rational比較と変換 (UT-NUM-179~182) | E-08 | ○ |

### 除算（div.jl）- UT-NUM-183 ~ UT-NUM-193
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | div各種RoundingMode (UT-NUM-183~187) | E-09 | ○ |
| C-50 | fld, cld, mod, rem (UT-NUM-188~191) | E-09 | ○ |
| C-51 | divrem, fldmod (UT-NUM-192~193) | E-09 | ○ |

### Checked（checked.jl）- UT-NUM-194 ~ UT-NUM-201
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | checked_add/sub/mul正常系・オーバーフロー (UT-NUM-194~197) | E-10 | ○ |
| C-53 | checked_neg/abs境界値 (UT-NUM-198~199) | E-10 | ○ |
| C-54 | add_with_overflow (UT-NUM-200~201) | E-10 | ○ |

### 型プロモーション（promotion.jl）- UT-NUM-202 ~ UT-NUM-205
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | promote_type, promote (UT-NUM-202~204) | E-11 | ○ |
| C-56 | typejoin (UT-NUM-205) | E-11 | ○ |

### ハッシュ（hashing.jl）- UT-NUM-206 ~ UT-NUM-209
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | 整数・浮動小数点・複素数のハッシュ一貫性 (UT-NUM-206~209) | E-12 | ○ |
| C-58 | isequal(x,y)ならhash(x)==hash(y)の契約 (UT-NUM-207) | E-12 | △ |

### Rounding（rounding.jl）- UT-NUM-210
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | setrounding/rounding (UT-NUM-210) | E-13 | △ |

### Irrational（irrationals.jl）- UT-NUM-211 ~ UT-NUM-213
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Irrational型変換とプロモーション (UT-NUM-211~212) | E-14 | ○ |
| C-61 | Irrational比較 (UT-NUM-213) | E-14 | ○ |

### Math（math.jl）- UT-NUM-214 ~ UT-NUM-258
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | sqrt, cbrt (UT-NUM-214~217) | E-15 | ○ |
| C-63 | hypot (UT-NUM-218~219) | E-15 | ○ |
| C-64 | clamp (UT-NUM-220~222) | E-15 | ○ |
| C-65 | evalpoly (UT-NUM-223) | E-15 | ○ |
| C-66 | mod2pi, sincos (UT-NUM-224~225) | E-15 | ○ |
| C-67 | log, log2, log10 (UT-NUM-226~229) | E-15 | ○ |
| C-68 | exp, exp2, exp10, expm1, log1p (UT-NUM-230~234) | E-15 | ○ |
| C-69 | 冪乗とDomainError (UT-NUM-235~236) | E-15 | ○ |
| C-70 | max, min, minmax (UT-NUM-237~240) | E-15 | ○ |
| C-71 | 三角関数 (UT-NUM-241~243) | E-15 | ○ |
| C-72 | 逆三角関数 (UT-NUM-244~248) | E-15 | ○ |
| C-73 | 双曲線関数 (UT-NUM-249~251) | E-15 | ○ |
| C-74 | 度数法関数と角度変換 (UT-NUM-252~255) | E-15 | ○ |
| C-75 | sinpi/cospi (UT-NUM-256~257) | E-15 | ○ |
| C-76 | modf (UT-NUM-258) | E-15 | ○ |

### TwicePrecision（twiceprecision.jl）- UT-NUM-259 ~ UT-NUM-260
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | splitprec (UT-NUM-259) | E-16 | △ |
| C-78 | canonicalize2 (UT-NUM-260) | E-16 | △ |

### FastMath（fastmath.jl）- UT-NUM-261
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | @fastmathマクロ (UT-NUM-261) | E-17 | △ |

### その他数学関数 - UT-NUM-262 ~ UT-NUM-264
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | muladd (UT-NUM-262) | E-15 | ○ |
| C-81 | sinc (UT-NUM-263~264) | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-41 (ComplexF64除算スケーリング)**: 期待結果の数値精度が実装の内部スケーリングアルゴリズムに依存しており、完全な検証には数値解析の専門知識が必要
  - 候補: arxiv.1210.4539（Smithのアルゴリズム）の詳細検証 / 既存テスト（test/complex.jl）との照合

- **C-58 (hash契約)**: `isequal(1, 1.0)` が true であるかどうかは Julia のバージョンに依存する可能性がある。現行コードでは `hash(::Int64)` と `hash(::Float64)` の一致を保証するため hashing2.jl で特殊処理が行われているが、完全な動作確認には実行時テストが必要
  - 候補: test/hashing.jl の既存テスト / Julia REPL での実行確認

- **C-59 (setrounding)**: `setrounding` はスレッドローカルな状態変更を伴い、テスト環境によっては他のテストと干渉する可能性がある
  - 候補: 既存テストでの分離方法の確認 / test/rounding.jl の参照

- **C-77, C-78 (TwicePrecision)**: `splitprec` と `canonicalize2` は内部ヘルパー関数であり、エクスポートされていない。テストでは `Base.splitprec` のように完全修飾名でアクセスする必要がある
  - 候補: test/twiceprecision.jl の既存テスト参照

- **C-79 (@fastmath)**: マクロのテストはコード変換の検証であり、通常の関数テストとは手法が異なる。`@fastmath` による最適化で浮動小数点の結果が変わる場合があるため、期待結果の定義が難しい
  - 候補: test/fastmath.jl の既存テスト参照

## 5) リスクフラグ（レビュー観点）

- **リスク2（高）**: UT-NUM-149 - ComplexF64除算のスケーリングテストは数値安定性に関わるため、期待結果の妥当性を人手で確認すべき
- **リスク1（中）**: UT-NUM-207 - hash契約の検証は実行環境依存の可能性があるため、実際にJuliaで実行して確認すべき
- **リスク1（中）**: UT-NUM-259~260 - twiceprecision の内部関数テストはアクセス方法の確認が必要
- **リスク0（低）**: その他の大部分のテストケースはソースコードの関数定義と直接対応しており、信頼性が高い
- **リスク1（中）**: gmp.jl, mpfr.jl, rawbigfloats.jl のBigInt/BigFloat関連テストは本一覧に含まれていない（モジュール範囲の判断による）

## 6) レビュアーチェックリスト（最小）

- [ ] UT-NUM-149: ComplexF64除算のスケーリングテストの期待結果が、`/` の実装（complex.jl L390-411）と整合しているか
- [ ] UT-NUM-207: `isequal(1, 1.0)` が実際に `true` であり、`hash(1) == hash(1.0)` が成立することをJulia REPLで確認
- [ ] UT-NUM-210: `setrounding` テストが他テストに影響しないよう、テスト後に元の丸めモードに復元する手順が含まれているか
- [ ] BigInt/BigFloat（gmp.jl, mpfr.jl）がbase-numericモジュールの範囲に含まれるべきか、plan.mdの定義を再確認
- [ ] テストケース全体で正常系・異常系・境界値のバランスが適切か（現状: 正常系約65%、異常系約15%、境界値約20%）
- [ ] 各テストケースの「前提条件」が十分に記述されているか（特に外部状態を必要とするもの）
