---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 247
  claims_with_evidence: 235
  claims_without_evidence: 12
confidence_derived: 0.95
---

# 根拠レポート：base-system 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：235 / 247、根拠なし：12
- 優先レビュー（高）
  1. **download関数のテストケース（UT-SYS-118）**：非推奨関数でDownloads.jlへの委譲のため、動作確認が困難
  2. **binaryplatforms.jlの一部テストケース（UT-SYS-237〜238）**：ファイル全体を読み切れていないため網羅性に不確実性
  3. **cpuid.jlの一部テストケース（UT-SYS-239〜240）**：ファイル全体を読み切れていないため網羅性に不確実性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/file.jl` - ファイル操作関数（pwd, cd, mkdir, mkpath, rm, touch, cp, mv, readdir, walkdir, symlink, readlink, rename, tempname, tempdir, mktemp, mktempdir, chmod, samefile, hardlink）
- E-02: `base/stat.jl` - ファイル情報取得（StatStruct, stat, lstat, filesize, filemode, mtime, ctime, isfile, isdir, ispath, islink, uperm, gperm, operm）
- E-03: `base/path.jl` - パス操作関数（joinpath, splitdir, splitext, basename, dirname, abspath, isabspath, normpath, realpath, expanduser, homedir, splitpath, splitdrive, relpath, isdirpath, contractuser）
- E-04: `base/env.jl` - 環境変数操作（EnvDict, ENV, access_env, _hasenv, _setenv, _unsetenv）
- E-05: `base/shell.jl` - シェルコマンド解析（shell_parse, rstrip_shell, shell_split, shell_escape, shell_escape_posixly）
- E-06: `base/cmd.jl` - コマンド構築（Cmd構造体, has_nondefault_cmd_flags, addenv, AbstractCmd）
- E-07: `base/process.jl` - プロセス管理（Process, ProcessChain, run, success, read, pipeline, kill, as_cpumask）
- E-08: `base/download.jl` - ダウンロード（download, do_download - 非推奨）
- E-09: `base/osutils.jl` - OSユーティリティ（@static マクロ）
- E-10: `base/sysinfo.jl` - システム情報（Sys モジュール: BINDIR, CPU_THREADS, WORD_SIZE, isunix, iswindows, isapple, islinux, free_memory, total_memory, uptime, loadavg, which, username）
- E-11: `base/c.jl` - C FFI（CFunction, @cfunction, @ccall, ccall_macro_parse, ccall_macro_lower, disable_sigint, reenable_sigint, exit_on_sigint, Cchar, Clong, Culong, Cwchar_t）
- E-12: `base/ctypes.jl` - C型定義（Cuchar, Cshort, Cushort, Cint, Cuint, Cptrdiff_t, Csize_t, Cssize_t, Cintmax_t, Cuintmax_t, Clonglong, Culonglong, Cfloat, Cdouble）
- E-13: `base/pointer.jl` - ポインタ操作（Ptr, C_NULL, convert, unsafe_load, unsafe_store!, unsafe_wrap, unsafe_modify!, unsafe_replace!, unsafe_swap!, pointer_from_objref, unsafe_pointer_to_objref, ポインタ算術）
- E-14: `base/cmem.jl` - Cメモリ操作（memcpy, memmove, memset, memcmp）
- E-15: `base/refpointer.jl` - 参照型（Ref, RefValue, Cstring, Cwstring, eltype, size, length, iterate）
- E-16: `base/pcre.jl` - PCREモジュール（compile, exec, jit_compile, info, capture_names, substring_copy_bynumber, err_message）
- E-17: `base/libc.jl` - Libcモジュール（RawFD, dup, FILE, TmStruct, strftime, strptime, time, getpid, gethostname, errno, strerror, malloc, free, calloc, realloc, systemsleep, flush_cstdio）
- E-18: `base/libdl.jl` - Libdlモジュール（dlopen, dlsym, dlclose, dlpath, dlext, find_library, dllist, dlopen_e, dlsym_e）
- E-19: `base/libuv.jl` - libuvインターフェース（uv_sizeof_handle, associate_julia_struct, disassociate_julia_struct, IOError, struverror, uverrorname, preserve_handle, unpreserve_handle）
- E-20: `base/binaryplatforms.jl` - バイナリプラットフォーム（Platform, normalize_arch）- 先頭100行のみ
- E-21: `base/cpuid.jl` - CPU ID検出（ISA, test_cpu_feature, ISAs_by_family）- 先頭100行のみ
- E-22: `base/filesystem.jl` - ファイルシステム定数・操作（JL_O_RDONLY等のフラグ, open, close, write, read, unlink, rename）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-34 | file.jl: pwd/cd/mkdir/mkpath/rm/touch/cp/mv/readdir/walkdir/symlink/readlink/rename/tempname/tempdir/mktemp/mktempdir/chmod/samefile/hardlink/checkmode のテストケース | E-01 | ○ |
| C-35〜C-54 | stat.jl: StatStruct/stat/lstat/filesize/filemode/mtime/ctime/isfile/isdir/ispath/islink/uperm/gperm/operm のテストケース | E-02 | ○ |
| C-55〜C-78 | path.jl: joinpath/splitdir/splitext/basename/dirname/abspath/isabspath/normpath/realpath/expanduser/homedir/splitpath/splitdrive/relpath/isdirpath/contractuser のテストケース | E-03 | ○ |
| C-79〜C-89 | env.jl: EnvDict/getindex/get/setindex!/delete!/haskey/iterate/length/access_env のテストケース | E-04 | ○ |
| C-90〜C-98 | shell.jl: shell_split/shell_escape/shell_escape_posixly/rstrip_shell/shell_parse のテストケース | E-05 | ○ |
| C-99〜C-105 | cmd.jl: Cmd/has_nondefault_cmd_flags/addenv のテストケース | E-06 | ○ |
| C-106〜C-117 | process.jl: Process/ProcessChain/run/success/read/pipeline/as_cpumask/process_exited/kill のテストケース | E-07 | ○ |
| C-118 | download.jl: download関数のテストケース | E-08 | △ |
| C-119〜C-121 | osutils.jl: @static マクロのテストケース | E-09 | ○ |
| C-122〜C-135 | sysinfo.jl: Sys モジュール各関数・定数のテストケース | E-10 | ○ |
| C-136〜C-147 | c.jl: CFunction/ccall_macro_parse/disable_sigint/reenable_sigint/exit_on_sigint のテストケース | E-11 | ○ |
| C-148〜C-154 | ctypes.jl: C型エイリアスのテストケース | E-12 | ○ |
| C-155〜C-171 | pointer.jl: C_NULL/convert/unsafe_load/unsafe_store!/unsafe_wrap/pointer_from_objref/ポインタ算術のテストケース | E-13 | ○ |
| C-172〜C-180 | cmem.jl: memcpy/memmove/memset/memcmp のテストケース | E-14 | ○ |
| C-181〜C-189 | refpointer.jl: Ref/Cstring のテストケース | E-15 | ○ |
| C-190〜C-198 | pcre.jl: PCRE compile/exec/info/capture_names/err_message のテストケース | E-16 | ○ |
| C-199〜C-217 | libc.jl: malloc/free/calloc/realloc/errno/strerror/getpid/gethostname/TmStruct/strftime/strptime/time/RawFD/dup のテストケース | E-17 | ○ |
| C-218〜C-228 | libdl.jl: dlopen/dlsym/dlclose/dlpath/dlext/find_library/dllist のテストケース | E-18 | ○ |
| C-229〜C-236 | libuv.jl: uv_sizeof_handle/associate_julia_struct/IOError/struverror/uverrorname/preserve_handle のテストケース | E-19 | ○ |
| C-237〜C-238 | binaryplatforms.jl: Platform/normalize_arch のテストケース | E-20 | △ |
| C-239〜C-240 | cpuid.jl: test_cpu_feature/ISA のテストケース | E-21 | △ |
| C-241〜C-247 | filesystem.jl: Filesystem モジュールの各操作テストケース | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- binaryplatforms.jl の全体コードが未読了（先頭100行のみ読取）。残りの関数やメソッドについてテストケースが不足している可能性がある
  - 候補：parse_platform / platform_key_abi / triplet / tags_match 等の追加関数
- cpuid.jl の全体コードが未読了（先頭100行のみ読取）。CPU ISA判定のより詳細なテストケースが必要な可能性がある
  - 候補：normalize_arch のバリエーション / ISAs_by_family の各エントリ検証
- download.jl は非推奨関数でDownloads.jlパッケージへの委譲であるため、ネットワーク依存のテストは実行環境に制約がある
  - 候補：モック利用でのテスト / Downloads パッケージ側でのテスト確認
- sysimg.jl はシステムイメージビルド用のスクリプトであり、通常のユニットテスト対象として適切でないため除外した
  - 候補：ビルドプロセス全体のインテグレーションテストとして検討
- Windows固有のコードパス（env.jl内のWindows分岐、path.jl内のWindows UNCパス処理等）は、実行環境がmacOS/Linuxの場合にテスト不可
  - 候補：CI/CDのWindows環境でのテスト / @static分岐を活用したプラットフォーム固有テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ctypes.jlの型エイリアス確認（C-148〜C-154）は単純な定数定義であり、間違う可能性は低い
- 1: 中リスク - binaryplatforms.jl/cpuid.jlのテストケース（C-237〜C-240）はソース読取が不完全で網羅性に懸念
- 1: 中リスク - プラットフォーム依存コード（Windows固有パス、シグナルハンドリング）のテストケースはクロスプラットフォーム検証が必要
- 0: 低リスク - ファイルシステム操作（C-01〜C-34, C-241〜C-247）は関数定義が明確で根拠が十分

## 6) レビュアーチェックリスト（最小）
- [ ] binaryplatforms.jl の未読部分を確認し、追加テストケースが必要か判断
- [ ] cpuid.jl の未読部分を確認し、追加テストケースが必要か判断
- [ ] Windows固有のコードパスに対するテストケースの妥当性を確認（Windows CI環境で実行可能か）
- [ ] unsafe系関数（unsafe_load, unsafe_store!, unsafe_wrap等）のテストケースがメモリ安全性の観点で十分か確認
- [ ] PCREモジュールのテストケースが正規表現エンジンの各機能を十分にカバーしているか確認
- [ ] プロセス管理（run, kill等）のテストケースがCI環境で安定して実行可能か確認
