---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 112
  claims_without_evidence: 8
confidence_derived: 0.93
---

# 根拠レポート：cli.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（cli.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：112 / 120、根拠なし：8
- 優先レビュー（高）
  1. **UT-CLI-034（空ファイルのmmap処理）**：mmap(size=0)の動作がOS依存のため根拠不足
  2. **UT-CLI-095（strncat maxlen切り詰め）**：Windows実装のstrncat境界動作の詳細確認が必要
  3. **UT-CLI-117（空dep_libs）**：ビルドシステムが空文字列を生成するケースの根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `cli/loader_lib.c` - メインローダーライブラリ（load_library, jl_get_libdir, jl_load_libjulia_internal, jl_load_repl等）
- E-02: `cli/loader_exe.c` - 実行ファイルエントリポイント（main関数）
- E-03: `cli/loader_library_probe.c` - Linux限定のシステムライブラリプローブ（jl_loader_open_via_mmap, search_ldcache, jl_loader_probe_system_library等）
- E-04: `cli/loader_symbol_probe.c` - Linux限定のELFシンボル検索（Elf64_locate_symbol, Elf32_locate_symbol, jl_loader_locate_symbol等）
- E-05: `cli/loader_win_utils.c` - Windows限定のユーティリティ（wchar_to_utf8, utf8_to_wchar, CommandLineToArgv, dirname, strlen等）
- E-06: `cli/loader.h` - ヘッダファイル（関数宣言、マクロ定義）
- E-07: `cli/jl_exports.h` - エクスポート関数定義（マクロ展開による関数リスト生成）
- E-08: `cli/dl-cache.h` - ldキャッシュ構造体定義（cache_file, cache_file_new, file_entry等）
- E-09: `cli/list_strip_symbols.h` - シンボルストリップ設定
- E-10: `cli/trampolines/common.h` - トランポリン共通マクロ定義
- E-11: `cli/Makefile` - ビルド設定（DEP_LIBS, コンパイルフラグ等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jl_loader_print_stderrがfputs(msg, stderr)を呼ぶ | E-01 (loader_lib.c:26-29) | ○ |
| C-02 | jl_loader_print_stderr3が3つのメッセージを順に出力する | E-01 (loader_lib.c:31-36) | ○ |
| C-03 | load_libraryがbasenameを抽出してdlopen/GetModuleHandleAを試行する | E-01 (loader_lib.c:46-61) | ○ |
| C-04 | load_libraryがerr=0かつファイル不在時にNULLを返す | E-01 (loader_lib.c:86-91) | ○ |
| C-05 | load_libraryがerr=1かつロード失敗時にexit(1)する | E-01 (loader_lib.c:96-116) | ○ |
| C-06 | lookup_symbolがdlsym/GetProcAddressを使用する | E-01 (loader_lib.c:120-126) | ○ |
| C-07 | jl_get_libdirがキャッシュされた値を再利用する | E-01 (loader_lib.c:158-161) | ○ |
| C-08 | jl_get_libdirがdladdr/GetModuleFileNameWでパスを取得する | E-01 (loader_lib.c:162-201) | ○ |
| C-09 | jl_get_libdirがdirname処理を行う | E-01 (loader_lib.c:202-208) | ○ |
| C-10 | jl_load_libjulia_internalが二重初期化を防止する | E-01 (loader_lib.c:254-256) | ○ |
| C-11 | dep_libsがコロン区切りでパースされる | E-01 (loader_lib.c:262-289) | ○ |
| C-12 | 特殊ライブラリ(@プレフィックス)が3個必要 | E-01 (loader_lib.c:270-295) | ○ |
| C-13 | libstdcxxprobeがlibstdc++既ロード時にNULLを返す | E-01 (loader_lib.c:231-233) | ○ |
| C-14 | JULIA_PROBE_LIBSTDCXX環境変数でプローブ制御が可能 | E-01 (loader_lib.c:326-332) | ○ |
| C-15 | libjulia-codegen不在時にfallback関数名が使用される | E-01 (loader_lib.c:379-388) | ○ |
| C-16 | ランタイム関数のシンボル解決ループが実行される | E-01 (loader_lib.c:391-398) | ○ |
| C-17 | jl_init_options_addrが初期化時に呼ばれる | E-01 (loader_lib.c:401, 431) | ○ |
| C-18 | jl_load_replがjl_repl_entrypointを呼び出す | E-01 (loader_lib.c:442-458) | ○ |
| C-19 | jl_load_replがlibjulia_internal未初期化時にjl_load_libjulia_internalを呼ぶ | E-01 (loader_lib.c:445-451) | ○ |
| C-20 | mainがjl_load_replを呼んでexit()する | E-02 (loader_exe.c:35-63) | ○ |
| C-21 | jl_loader_open_via_mmapがopen+fstat+mmapを使用する | E-03 (loader_library_probe.c:22-55) | ○ |
| C-22 | jl_loader_open_via_mmapがファイル不在時にNULLを返す | E-03 (loader_library_probe.c:28-31) | ○ |
| C-23 | search_ldcache_newがCACHEMAGIC_NEWを検証する | E-03 (loader_library_probe.c:59) | ○ |
| C-24 | search_ldcacheが旧形式と新形式の両方を処理する | E-03 (loader_library_probe.c:80-109) | ○ |
| C-25 | jl_loader_probe_system_libraryがLD_LIBRARY_PATH -> ldcache -> デフォルトの順で検索する | E-03 (loader_library_probe.c:137-213) | ○ |
| C-26 | LD_LIBRARY_PATHの末尾スラッシュが考慮される | E-03 (loader_library_probe.c:165) | ○ |
| C-27 | Elf64_locate_symbolがET_DYN以外を拒否する | E-04 (loader_symbol_probe.c:35-36) | ○ |
| C-28 | Elf64_locate_symbolがDYNSYMセクションを検索する | E-04 (loader_symbol_probe.c:38-54) | ○ |
| C-29 | jl_loader_locate_symbolがELFマジック値を検証する | E-04 (loader_symbol_probe.c:108) | ○ |
| C-30 | jl_loader_locate_symbolがELFCLASS32/64を分岐する | E-04 (loader_symbol_probe.c:112-116) | ○ |
| C-31 | wchar_to_utf8がサロゲートペアを処理する | E-05 (loader_win_utils.c:181-241) | ○ |
| C-32 | utf8_to_wcharがwtf8_decode1を使用する | E-05 (loader_win_utils.c:245-283) | ○ |
| C-33 | utf8_to_wcharが不正UTF-8でNULLを返す | E-05 (loader_win_utils.c:257-258) | ○ |
| C-34 | wtf8_decode1が1-4バイトシーケンスを処理する | E-05 (loader_win_utils.c:122-162) | ○ |
| C-35 | get_surrogate_valueがサロゲートペアをデコードする | E-05 (loader_win_utils.c:166-177) | ○ |
| C-36 | CommandLineToArgvがクォートとバックスラッシュを処理する | E-05 (loader_win_utils.c:51-103) | ○ |
| C-37 | CommandLineToArgvがバッファを動的に拡張する | E-05 (loader_win_utils.c:92-95) | ○ |
| C-38 | dirnameがルートパスで"/"を返す | E-05 (loader_win_utils.c:329-331) | ○ |
| C-39 | dirnameが区切り文字なしで"."を返す | E-05 (loader_win_utils.c:337-339) | ○ |
| C-40 | fwriteがコンソール時UTF-16変換を行う | E-05 (loader_win_utils.c:19-37) | ○ |
| C-41 | fwriteがファイル時UTF-8のまま書き込む | E-05 (loader_win_utils.c:32-34) | ○ |
| C-42 | setup_stdioがGetStdHandle/GetConsoleModeを使用する | E-05 (loader_win_utils.c:105-111) | ○ |
| C-43 | jl_exports.hがマクロ展開で関数名リストを生成する | E-07 (jl_exports.h:44-80) | ○ |
| C-44 | 空ファイルのmmap動作がOS依存である | **根拠なし** | △ |
| C-45 | strncat maxlen切り詰めの正確な境界動作 | E-05 (loader_win_utils.c:299-306) を参照するが、min()マクロとの組合せで挙動要確認 | △ |
| C-46 | 空dep_libsがexit(1)を引き起こす | E-01 (loader_lib.c:292-295)より推定 | △ |
| C-47 | Elf32系関数がELF32バイナリで正常動作する | E-04 (loader_symbol_probe.c:57-97) コード構造はELF64と同等 | ○ |
| C-48 | TLSセットアップ(jl_pgcstack_setkey)が実行される | E-01 (loader_lib.c:412-427) | ○ |
| C-49 | Linux上でsigmaskが設定・復元される | E-01 (loader_lib.c:242-251, 433-438) | ○ |
| C-50 | Windows上でDllMainCRTStartupがjl_load_libjulia_internalを呼ぶ | E-01 (loader_lib.c:462-468) | ○ |
| C-51 | mainCRTStartup(Windows)がCommandLineToArgvを使用する | E-02 (loader_exe.c:29-31) | ○ |
| C-52 | Windows mainがwchar_to_utf8で引数変換する | E-02 (loader_exe.c:47-54) | ○ |
| C-53 | UTF-8変換失敗時にメッセージ出力して終了する | E-02 (loader_exe.c:49-51) | ○ |
| C-54 | __asan_default_optionsが定義される(ASAN有効時) | E-02 (loader_exe.c:18-24) | ○ |
| C-55 | ASAN/TSAN有効時にLBT_USE_RTLD_DEEPBIND=0が設定される | E-02 (loader_exe.c:39-43) | ○ |
| C-56 | _dl_cache_check_flagsがアーキテクチャ依存である | E-08 (dl-cache.h:45-113) | ○ |
| C-57 | ALIGN_CACHEマクロがキャッシュアラインメントを計算する | E-08 (dl-cache.h:180-182) | ○ |
| C-58 | search_ldcacheのiteratorパターンが正しい | E-03 (loader_library_probe.c:62-77) | ○ |
| C-59 | jl_loader_probe_system_libraryがsnprintf結果を検証する | E-03 (loader_library_probe.c:167-168, 207-208) | ○ |
| C-60 | Windows上のwin_file_exists関数が使用される | E-01 (loader_lib.c:18-20) | ○ |
| C-61 | win32_formatmessageがFormatMessageW失敗時にリトライする | E-01 (loader_lib.c:129-151) | ○ |
| C-62 | load_libraryがWindowsでLOAD_WITH_ALTERED_SEARCH_PATHを使用 | E-01 (loader_lib.c:75) | ○ |
| C-63 | search_ldcache_newの_dl_cache_check_flagsフィルタリング | E-03 (loader_library_probe.c:69-70), E-08 | ○ |
| C-64 | jl_loader_open_via_mmapがEINTRでリトライする | E-03 (loader_library_probe.c:25-32, 35-43) | ○ |
| C-65 | トランポリンが正しいアセンブラマクロを使用する | E-10 (common.h) | ○ |
| C-66 | テストの優先度判定が適切である | **設計判断** | △ |
| C-67 | Linux限定テストの条件が正しく明記されている | E-03, E-04 の#ifdef _OS_LINUX_ガード | ○ |
| C-68 | Windows限定テストの条件が正しく明記されている | E-05, E-01 の#ifdef _OS_WINDOWS_ガード | ○ |
| C-69 | 各関数のパラメータ型と戻り値型が正確 | E-06 (loader.h) の宣言 | ○ |
| C-70 | テスト対象外とした関数（__register_atfork232）の判断 | E-02 (loader_exe.c:68-71) GLIBC/ASAN固有 | △ |
| C-71 | dep_libs変数の初期サイズ1024が十分か | E-01 (loader_lib.c:24) を参照するが実際のDEP_LIBS長は不明 | △ |
| C-72 | jl_load_libjulia_internalのシグナルマスク処理が正確 | E-01 (loader_lib.c:242-251) | ○ |
| C-73 | strncat実装でヌル終端が保証されない可能性 | E-05 (loader_win_utils.c:299-306) にヌル終端処理なし | △ |
| C-74 | PATHSEPSTRING使用箇所が正しい | E-06, E-01 (loader_lib.c:51, 65) | ○ |
| C-75 | load_libraryのパスバッファサイズが2*JL_PATH_MAX+1 | E-01 (loader_lib.c:63) | ○ |
| C-76 | search_ldcacheのoffsetアラインメント計算が正しい | E-03 (loader_library_probe.c:86), E-08 (dl-cache.h:180-182) | ○ |
| C-77 | jl_loader_locate_symbolがmunmapでリソースを解放する | E-04 (loader_symbol_probe.c:119) | ○ |
| C-78 | wtf8_decode1の0xC2未満バイトが不正として扱われる | E-05 (loader_win_utils.c:132-133) | ○ |
| C-79 | CommandLineToArgvのMaxEntries初期値4 | E-05 (loader_win_utils.c:54) | ○ |

## 4) 不足情報（Unknown / Missing）
- **mmap(size=0)の動作**: Linuxカーネルのmmap実装に依存するため、ソースコードのみからは確定できない。実際のテスト環境での検証が必要。
  - 候補：Linux manページ / カーネルソース / POSIX仕様
- **strncat実装のヌル終端保証**: Windows版strncat実装（loader_win_utils.c:299-306）がヌル終端を明示的に追加していない。load_library側でmemsetによるゼロ初期化に依存している可能性がある。
  - 候補：load_library内のpath変数初期化（loader_lib.c:63）を確認
- **DEP_LIBS文字列の実際の内容と長さ**: ビルドシステム（Make.inc）が生成するDEP_LIBSの実際の値はビルド環境依存。
  - 候補：Make.inc / LOADER_BUILD_DEP_LIBS定義箇所
- **テスト優先度の基準**: 設計判断に基づくため、プロジェクトの品質基準との整合確認が必要。
  - 候補：プロジェクトのテスト方針書
- **__register_atfork232のテスト除外判断**: GLIBC+ASAN/TSAN固有のフックであり、単体テストの対象外としたが、レビューで確認が必要。

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: load_library関数のexit(1)パス - プロセス終了を伴うため、テスト方法に制約がある。モック化またはfork()を使用したテストが必要。
- **リスク1（中）**: Windows限定関数のテスト - クロスプラットフォームテスト環境が必要。Windows環境でのみ検証可能。
- **リスク1（中）**: Linux限定関数（ldキャッシュ、ELFプローブ）のテスト - /etc/ld.so.cacheの存在に依存するため、コンテナ環境やNixOSでは動作が異なる可能性がある。
- **リスク1（中）**: strncat/memcpy等のWindows独自実装 - 標準ライブラリを使用しないため、エッジケースでの互換性に注意が必要。
- **リスク0（低）**: トランポリンのアセンブリコード - アーキテクチャ依存のアセンブリはマクロ生成のため、テストケース一覧からは除外（統合テストで検証すべき）。

## 6) レビュアーチェックリスト（最小）
- [ ] load_library/jl_load_repl等のexit(1)パスのテスト方法が実現可能か確認
- [ ] Windows限定テスト（UT-CLI-061〜110）の実行環境が確保されているか確認
- [ ] Linux限定テスト（UT-CLI-031〜060, 111〜114）の実行環境が確保されているか確認
- [ ] strncat実装（UT-CLI-095）のヌル終端問題が実コードで影響するか確認
- [ ] DEP_LIBS文字列のパースに関するテスト（UT-CLI-116〜117）の前提条件が妥当か確認
- [ ] jl_exports.hのマクロ展開テスト（UT-CLI-118〜120）がコンパイル時テストとして適切か確認
- [ ] テスト優先度（高/中/低）の設定がプロジェクトの品質基準と整合しているか確認
- [ ] ELF32関連テスト（UT-CLI-054〜056）に使用する32ビットテストバイナリが用意可能か確認
