---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 260
  claims_with_evidence: 252
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：src-flisp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（src-flisp.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：252 / 260、根拠なし：8
- 優先レビュー（高）
  1. **equal_lispvalue / hash_lispvalue テスト（C-157〜C-163）**：equal.c の実装詳細が大きなファイルであり、一部の内部動作の根拠が推定に基づく
  2. **GC関連テスト（C-022）**：GCトリガーの境界条件が実行時環境依存
  3. **fl_table_foldl変更検出テスト（C-154）**：EnumerationError発生条件の実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/flisp/flisp.c` - コアインタープリタ実装（symbol, cons, GC, 例外処理）
- E-02: `src/flisp/flisp.h` - ヘッダファイル（型定義、マクロ、関数宣言）
- E-03: `src/flisp/builtins.c` - 組み込み関数（eq?, atom?, car, cdr, compare等）
- E-04: `src/flisp/iostream.c` - IO ストリーム関数（file, buffer, read, write等）
- E-05: `src/flisp/string.c` - 文字列操作関数（string?, string.count, string.sub等）
- E-06: `src/flisp/table.c` - ハッシュテーブル関数（table, put!, get, del!等）
- E-07: `src/flisp/read.c` - S式リーダー（tokenizer, parser）
- E-08: `src/flisp/print.c` - S式プリンター（print, pretty-print）
- E-09: `src/flisp/equal.c` - 等価比較・ハッシュ関数
- E-10: `src/flisp/equalhash.c` - 等価ハッシュテーブル実装
- E-11: `src/flisp/cvalues.c` - C言語値型システム（cvalue, cprim）
- E-12: `src/flisp/types.c` - 型テーブル管理（get_type, define_opaque_type）
- E-13: `src/flisp/julia_extensions.c` - Julia固有の拡張関数（ID文字判定、正規化等）
- E-14: `src/flisp/flmain.c` - メインエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）

### flisp.c（例外処理・シンボル・メモリ管理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | fl_raiseが例外を正しく発生させる | E-01 (L138-153) | ○ |
| C-002 | fl_raiseがreadstateをアンワインドする | E-01 (L141-145) | ○ |
| C-003 | throwing_frameが初回のみ設定される | E-01 (L146-147) | ○ |
| C-004 | lerrorfがフォーマット付きエラーメッセージを生成する | E-01 (L162-172) | ○ |
| C-005 | lerrorが静的メッセージでエラーを生成する | E-01 (L174-180) | ○ |
| C-006 | type_errorがTypeErrorをraiseする | E-01 (L182-185) | ○ |
| C-007 | bounds_errorがBoundsErrorをraiseする | E-01 (L187-190) | ○ |
| C-008 | fl_is_keyword_nameがコロン先頭キーワードを認識する | E-01 (L210-213) | ○ |
| C-009 | fl_is_keyword_nameがコロン末尾キーワードを認識する | E-01 (L212) | ○ |
| C-010 | fl_is_keyword_nameが非キーワードを拒否する | E-01 (L212) | ○ |
| C-011 | fl_is_keyword_nameがコロン1文字を拒否する | E-01 (L212: len>1条件) | ○ |
| C-012 | fl_is_keyword_nameが空文字列を拒否する | E-01 (L212: len>1条件) | ○ |
| C-013 | symbolが新規シンボルを作成する | E-01 (L258-264) | ○ |
| C-014 | symbolが既存シンボルを再利用する | E-01 (L260-263: symtab_lookup) | ○ |
| C-015 | fl_gensymが一意のgensymを生成する | E-01 (L266-283) | ○ |
| C-016 | fl_gensymが異なるIDを割り当てる | E-01 (L277: gensym_ctr++) | ○ |
| C-017 | fl_isgensymがgensymをtrue判定する | E-01 (L285-288) | ○ |
| C-018 | fl_isgensymが通常シンボルをfalse判定する | E-01 (L285-288) | ○ |
| C-019 | symbol_nameが通常シンボルの名前を返す | E-01 (L296-310) | ○ |
| C-020 | symbol_nameがgensym名を生成する | E-01 (L299-305) | ○ |
| C-021 | mk_consがcons cellを割り当てる | E-01 (L320-340) | ○ |
| C-022 | mk_consがヒープ不足時にGCを発生させる | E-01 (L334-336) | △ |
| C-023 | alloc_vectorがサイズ0で空ベクタを返す | E-01 (L391) | ○ |
| C-024 | alloc_vectorが指定サイズで割り当てる | E-01 (L389-399) | ○ |
| C-025 | alloc_vectorがinit=0で初期化しない | E-01 (L395-398) | ○ |
| C-026 | fl_consがcons pairを構築する | E-02 (fl_cons宣言) | ○ |
| C-027 | fl_savestateが状態を保存する | E-01 (L121-128) | ○ |
| C-028 | fl_restorestateが状態を復元する | E-01 (L130-136) | ○ |

### builtins.c（組み込み関数）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-029 | fl_eqpが同一オブジェクトでTを返す | E-03 | ○ |
| C-030 | fl_eqpが異なるオブジェクトでFを返す | E-03 | ○ |
| C-031 | fl_eqpが引数数チェックを行う | E-03 | ○ |
| C-032 | fl_atompがfixnumでTを返す | E-03 | ○ |
| C-033 | fl_atompがconsでFを返す | E-03 | ○ |
| C-034 | fl_notがFに対してTを返す | E-03 | ○ |
| C-035 | fl_notが真値に対してFを返す | E-03 | ○ |
| C-036 | fl_nullpがNILでTを返す | E-03 | ○ |
| C-037 | fl_nullpが非NILでFを返す | E-03 | ○ |
| C-038 | fl_pairpがconsでTを返す | E-03 | ○ |
| C-039 | fl_symbolpがシンボルでTを返す | E-03 | ○ |
| C-040 | fl_numberpがfixnumでTを返す | E-03 | ○ |
| C-041 | fl_fixnumpがfixnumでTを返す | E-03 | ○ |
| C-042 | fl_fixnumpが非fixnumでFを返す | E-03 | ○ |
| C-043 | fl_carがcons pairのcarを返す | E-03 | ○ |
| C-044 | fl_carが非consで型エラーを発生させる | E-03 | ○ |
| C-045 | fl_cdrがcons pairのcdrを返す | E-03 | ○ |
| C-046 | fl_cdrが非consで型エラーを発生させる | E-03 | ○ |
| C-047 | fl_setcarがcarを更新する | E-03 | ○ |
| C-048 | fl_setcdrがcdrを更新する | E-03 | ○ |
| C-049 | fl_compareが同値で0を返す | E-03 | ○ |
| C-050 | fl_compareが小<大で負を返す | E-03 | ○ |
| C-051 | fl_compareが大>小で正を返す | E-03 | ○ |

### iostream.c（IOストリーム）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-052 | fl_isiostream がiostreamを判定する | E-04 (L40-43) | ○ |
| C-053 | fl_isiostream が非iostreamを拒否する | E-04 (L40-43) | ○ |
| C-054 | fl_iostreampがTを返す | E-04 (L45-49) | ○ |
| C-055 | fl_iostreampが引数チェックする | E-04 (L47) | ○ |
| C-056 | fl_eof_objectがFL_EOFを返す | E-04 (L51-56) | ○ |
| C-057 | fl_eof_objectpがEOFでTを返す | E-04 (L58-62) | ○ |
| C-058 | fl_eof_objectpが非EOFでFを返す | E-04 (L58-62) | ○ |
| C-059 | fl_bufferがメモリストリームを作成する | E-04 (L98-107) | ○ |
| C-060 | fl_bufferが引数チェックする | E-04 (L100) | ○ |
| C-061 | fl_fileが読み取りモードで開く | E-04 (L76-96) | ○ |
| C-062 | fl_fileがデフォルト読み取りモードになる | E-04 (L88) | ○ |
| C-063 | fl_fileが存在しないファイルでIOErrorを発生させる | E-04 (L92-93) | ○ |
| C-064 | fl_fileが引数なしでエラーを発生させる | E-04 (L78-79) | ○ |
| C-065 | fl_iogetcがUTF-8文字を読み取る | E-04 (L130-142) | ○ |
| C-066 | fl_iogetcがEOFでFL_EOFを返す | E-04 (L136-138) | ○ |
| C-067 | fl_iogetcが不正UTF-8でIOErrorを発生させる | E-04 (L139-140) | ○ |
| C-068 | fl_iopeekc が位置を変えずに文字を返す | E-04 (L144-155) | ○ |
| C-069 | fl_ioputcがwcharを書き込む | E-04 (L157-165) | ○ |
| C-070 | fl_ioputcが非wcharで型エラーを発生させる | E-04 (L161-162) | ○ |
| C-071 | fl_ioflushがフラッシュ成功でTを返す | E-04 (L167-174) | ○ |
| C-072 | fl_iocloseがストリームを閉じる | E-04 (L176-182) | ○ |
| C-073 | fl_ioeofがEOF状態でTを返す | E-04 (L192-197) | ○ |
| C-074 | fl_ioeofが非EOF状態でFを返す | E-04 (L192-197) | ○ |
| C-075 | fl_ioseekがシーク成功でTを返す | E-04 (L222-231) | ○ |
| C-076 | fl_ioseekがシーク失敗でFを返す | E-04 (L228-229) | ○ |
| C-077 | fl_ioposが位置を返す | E-04 (L244-252) | ○ |
| C-078 | fl_iolinenoが行番号を返す | E-04 (L199-204) | ○ |
| C-079 | fl_iosetlinenoが行番号を設定する | E-04 (L206-213) | ○ |
| C-080 | fl_iocolnoが列番号を返す | E-04 (L215-220) | ○ |
| C-081 | fl_readがS式を読み取る | E-04 (L109-128) | ○ |
| C-082 | fl_readがデフォルトストリームから読む | E-04 (L115-117) | ○ |
| C-083 | fl_readがEOFでFL_EOFを返す | E-04 (L125-126) | ○ |
| C-084 | fl_writeが値をストリームに書き込む | E-04 (L254-265) | ○ |
| C-085 | fl_writeがデフォルト出力ストリームに書き込む | E-04 (L261-262) | ○ |
| C-086 | fl_iowriteがバイナリデータを書き込む | E-04 (L311-332) | ○ |
| C-087 | fl_iowriteがwcharをUTF-8として書き込む | E-04 (L316-321) | ○ |
| C-088 | fl_iowriteがwcharオフセットでエラーを発生させる | E-04 (L317-319) | ○ |
| C-089 | fl_ioreadが型指定データを読み取る | E-04 (L267-294) | ○ |
| C-090 | fl_ioreadがEOFでFL_EOFを返す | E-04 (L290-292) | ○ |
| C-091 | fl_ioreaduntilがデリミタまで読み取る | E-04 (L346-371) | ○ |
| C-092 | fl_ioreaduntilがEOFでFL_EOFを返す | E-04 (L368-369) | ○ |
| C-093 | fl_iocopyがストリーム間コピーする | E-04 (L382-393) | ○ |
| C-094 | fl_iocopyがバイト数指定でコピーする | E-04 (L388-390) | ○ |
| C-095 | fl_iotostringがメモリストリームを文字列に変換する | E-04 (L416-423) | ○ |
| C-096 | fl_iotostringが非メモリストリームでArgErrorを発生させる | E-04 (L420-421) | ○ |
| C-097 | stream_to_stringがローカルバッファから変換する | E-04 (L395-414) | ○ |
| C-098 | stream_to_stringが外部バッファから変換する | E-04 (L407-413) | ○ |

### string.c（文字列操作）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-099 | fl_stringpが文字列でTを返す | E-05 (L28-32) | ○ |
| C-100 | fl_stringpが非文字列でFを返す | E-05 (L28-32) | ○ |
| C-101 | fl_string_countがASCII文字数を返す | E-05 (L34-57) | ○ |
| C-102 | fl_string_countがUTF-8文字数を返す | E-05 (L56: u8_charnum) | ○ |
| C-103 | fl_string_countが開始位置で部分カウントする | E-05 (L43-46) | ○ |
| C-104 | fl_string_countが範囲指定でカウントする | E-05 (L47-53) | ○ |
| C-105 | fl_string_countが範囲外でbounds_errorを発生させる | E-05 (L45-46) | ○ |
| C-106 | fl_string_countがstop<=startで0を返す | E-05 (L51-52) | ○ |
| C-107 | fl_string_countが空文字列で0を返す | E-05 (L56) | ○ |
| C-108 | fl_string_countが非文字列で型エラーを発生させる | E-05 (L39-40) | ○ |
| C-109 | fl_string_subが部分文字列を抽出する | E-05 (L84-108) | ○ |
| C-110 | fl_string_subが末尾まで抽出する | E-05 (L99-101) | ○ |
| C-111 | fl_string_subがi2<=i1で空文字列を返す | E-05 (L102-103) | ○ |
| C-112 | fl_string_subが範囲外でbounds_errorを発生させる | E-05 (L92-93) | ○ |
| C-113 | fl_string_charが指定位置の文字を返す | E-05 (L110-122) | ○ |
| C-114 | fl_string_charが範囲外でbounds_errorを発生させる | E-05 (L116-117) | ○ |
| C-115 | fl_string_findが部分文字列位置を返す | E-05 (L132-180) | ○ |
| C-116 | fl_string_findがwchar位置を返す | E-05 (L148-153) | ○ |
| C-117 | fl_string_findが不一致でFを返す | E-05 (L179) | ○ |
| C-118 | fl_string_findが開始位置指定で検索する | E-05 (L136-137) | ○ |
| C-119 | fl_string_findが空検索で開始位置を返す | E-05 (L170-171) | ○ |
| C-120 | fl_string_incが次のUTF-8位置を返す | E-05 (L182-198) | ○ |
| C-121 | fl_string_incがカウント指定で進む | E-05 (L190-191) | ○ |
| C-122 | fl_string_incが範囲外でbounds_errorを発生させる | E-05 (L193-194) | ○ |
| C-123 | fl_string_decが前のUTF-8位置を返す | E-05 (L200-219) | ○ |
| C-124 | fl_string_decが位置0でbounds_errorを発生させる | E-05 (L214-215) | ○ |
| C-125 | fl_string_decが範囲外でbounds_errorを発生させる | E-05 (L211-212) | ○ |
| C-126 | fl_numbertostringが10進変換する | E-05 (L229-252) | ○ |
| C-127 | fl_numbertostringが16進変換する | E-05 (L245-246) | ○ |
| C-128 | fl_numbertostringが負数を変換する | E-05 (L240-243) | ○ |
| C-129 | fl_numbertostringが非整数で型エラーを発生させる | E-05 (L237) | ○ |
| C-130 | fl_numbertostringが範囲外基数でArgErrorを発生させる | E-05 (L224-226) | ○ |
| C-131 | fl_stringtonumberが10進変換する | E-05 (L254-266) | ○ |
| C-132 | fl_stringtonumberが16進変換する | E-05 (L261-262) | ○ |
| C-133 | fl_stringtonumberが変換不能でFを返す | E-05 (L263-264) | ○ |
| C-134 | fl_string_isutf8が有効UTF-8でTを返す | E-05 (L268-274) | ○ |
| C-135 | fl_string_isutf8が無効UTF-8でFを返す | E-05 (L273) | ○ |
| C-136 | fl_stringが文字列をそのまま返す | E-05 (L64-65) | ○ |
| C-137 | fl_stringが複数引数を連結する | E-05 (L62-82) | ○ |

### table.c（ハッシュテーブル）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | fl_tableがペアからテーブルを作成する | E-06 (L82-112) | ○ |
| C-139 | fl_tableが奇数引数でArgErrorを発生させる | E-06 (L85-86) | ○ |
| C-140 | fl_tableが空テーブルを作成する | E-06 (L84) | ○ |
| C-141 | fl_tablepがテーブルでTを返す | E-06 (L69-73) | ○ |
| C-142 | fl_tablepが非テーブルでFを返す | E-06 (L69-73) | ○ |
| C-143 | fl_table_putがキーバリューを追加する | E-06 (L115-128) | ○ |
| C-144 | fl_table_putが既存キーを上書きする | E-06 (L120) | ○ |
| C-145 | fl_table_putが非テーブルで型エラーを発生させる | E-06 (L118) | ○ |
| C-146 | fl_table_getが値を返す | E-06 (L136-148) | ○ |
| C-147 | fl_table_getがデフォルト値を返す | E-06 (L143-144) | ○ |
| C-148 | fl_table_getがKeyErrorを発生させる | E-06 (L145) | ○ |
| C-149 | fl_table_hasが存在キーでTを返す | E-06 (L151-156) | ○ |
| C-150 | fl_table_hasが非存在キーでFを返す | E-06 (L151-156) | ○ |
| C-151 | fl_table_delがキーを削除する | E-06 (L159-166) | ○ |
| C-152 | fl_table_delが非存在キーでKeyErrorを発生させる | E-06 (L163-164) | ○ |
| C-153 | fl_table_foldlが全エントリに関数を適用する | E-06 (L168-193) | ○ |
| C-154 | fl_table_foldlがテーブル変更を検出する | E-06 (L186-187) | △ |
| C-155 | relocate_htableがポインタを再配置する | E-06 (L51-62) | ○ |
| C-156 | free_htableがメモリを解放する | E-06 (L44-49) | ○ |

### equal.c / equalhash.c（等価比較・ハッシュ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-157 | equal_lispvalueが同一fixnumを等しいと判定する | E-09 | △ |
| C-158 | equal_lispvalueが異なるfixnumを等しくないと判定する | E-09 | △ |
| C-159 | equal_lispvalueが同一構造リストを等しいと判定する | E-09 | △ |
| C-160 | equal_lispvalueが同一文字列を等しいと判定する | E-09 | △ |
| C-161 | equal_lispvalueが異なる型を等しくないと判定する | E-09 | △ |
| C-162 | hash_lispvalueが同一値で同一ハッシュを返す | E-09 | ○ |
| C-163 | hash_lispvalueが等しいリストで同一ハッシュを返す | E-09 | ○ |

### read.c（S式リーダー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-164 | isnumtok_baseが10進整数を認識する | E-07 (L32-106) | ○ |
| C-165 | isnumtok_baseが16進整数を認識する | E-07 (L99-105) | ○ |
| C-166 | isnumtok_baseが浮動小数点を認識する | E-07 (L41-53) | ○ |
| C-167 | isnumtok_baseが科学表記を認識する | E-07 (L41) | ○ |
| C-168 | isnumtok_baseが+NaNを認識する | E-07 (L73-76) | ○ |
| C-169 | isnumtok_baseが-Infを認識する | E-07 (L87-89) | ○ |
| C-170 | isnumtok_baseが負整数を認識する | E-07 (L91-97) | ○ |
| C-171 | isnumtok_baseが空文字列を拒否する | E-07 (L38-39) | ○ |
| C-172 | isnumtok_baseが非数値を拒否する | E-07 (L99-105) | ○ |
| C-173 | isnumtok_baseがfloat末尾fを認識する | E-07 (L48-53) | ○ |
| C-174 | strtoull_0b0oが0bプレフィックスの2進を解析する | E-07 (L21-30) | ○ |
| C-175 | strtoull_0b0oが0oプレフィックスの8進を解析する | E-07 (L25) | ○ |
| C-176 | symcharが英字をシンボル文字と判定する | E-07 (L14-18) | ○ |
| C-177 | symcharが括弧をシンボル文字でないと判定する | E-07 (L16) | ○ |
| C-178 | symcharが空白をシンボル文字でないと判定する | E-07 (L16) | ○ |
| C-179 | symcharがセミコロンをシンボル文字でないと判定する | E-07 (L16) | ○ |
| C-180 | fl_read_sexprがリストを読み込む | E-07 (L712-730) | ○ |
| C-181 | fl_read_sexprがドットペアを読み込む | E-07 (L576-585) | ○ |
| C-182 | fl_read_sexprがベクタを読み込む | E-07 (L669-670) | ○ |
| C-183 | fl_read_sexprがquoteを読み込む | E-07 (L619-621) | ○ |
| C-184 | fl_read_sexprがbackquoteを読み込む | E-07 (L617-618) | ○ |
| C-185 | fl_read_sexprが文字列を読み込む | E-07 (L706-707) | ○ |
| C-186 | fl_read_sexprが文字定数を読み込む | E-07 (L248-283) | ○ |
| C-187 | fl_read_sexprが名前付き文字を読み込む | E-07 (L276: spacesym) | ○ |
| C-188 | fl_read_sexprがブール値を読み込む | E-07 (L644-648) | ○ |
| C-189 | fl_read_sexprが2進リテラルを読み込む | E-07 (L363) | ○ |
| C-190 | fl_read_sexprが16進リテラルを読み込む | E-07 (L366) | ○ |
| C-191 | fl_read_sexprが不正閉じ括弧でParseErrorを発生させる | E-07 (L603) | ○ |
| C-192 | fl_read_sexprが不完全入力でParseErrorを発生させる | E-07 (L560-561) | ○ |
| C-193 | fl_read_sexprがコメントを無視する | E-07 (L139-147) | ○ |
| C-194 | fl_read_sexprがブロックコメントを無視する | E-07 (L312-341) | ○ |
| C-195 | fl_read_sexprがバックリファレンスを解決する | E-07 (L687-700) | ○ |

### print.c（S式プリンター）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-196 | fl_printがfixnumを出力する | E-08 (L384-390) | ○ |
| C-197 | fl_printがシンボルを出力する | E-08 (L391-401) | ○ |
| C-198 | fl_printがリストを出力する | E-08 (L487-488) | ○ |
| C-199 | fl_printがベクタを出力する | E-08 (L455-483) | ○ |
| C-200 | fl_printが文字列を出力する | E-08 (L494-526) | ○ |
| C-201 | fl_printがブール値を出力する | E-08 (L403-413) | ○ |
| C-202 | fl_printがNILを出力する | E-08 (L409-411) | ○ |
| C-203 | fl_printがドットペアを出力する | E-08 (L286-289) | ○ |
| C-204 | fl_printが循環構造を出力する | E-08 (L346-370) | ○ |
| C-205 | fl_printがエスケープシンボルを出力する | E-08 (L102-143) | ○ |
| C-206 | print_traverseがリストをトラバースする | E-08 (L51-100) | ○ |
| C-207 | print_traverseが共有構造を検出する | E-08 (L56-59) | ○ |
| C-208 | tinypが短シンボルをtiny判定する | E-08 (L156-163) | ○ |
| C-209 | tinypがfixnumをtiny判定する | E-08 (L161) | ○ |
| C-210 | smallpが小consをsmall判定する | E-08 (L165-183) | ○ |

### cvalues.c（C値型システム）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-211 | cvalueが指定型で作成される | E-11 | ○ |
| C-212 | cvalue_stringが文字列を作成する | E-11 | ○ |
| C-213 | cvalue_stringが空文字列を作成する | E-11 | ○ |
| C-214 | fl_isstringが文字列を判定する | E-11 | ○ |
| C-215 | fl_isstringが非文字列を判定する | E-11 | ○ |
| C-216 | fl_isnumberがfixnumを判定する | E-11 | ○ |
| C-217 | fl_isnumberがdoubleを判定する | E-11 | ○ |
| C-218 | mk_doubleがdouble cvalueを作成する | E-11 | ○ |
| C-219 | mk_floatがfloat cvalueを作成する | E-11 | ○ |
| C-220 | mk_wcharがwchar cvalueを作成する | E-11 | ○ |

### types.c（型テーブル管理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-221 | get_typeがシンボル型を取得する | E-12 (L3-57) | ○ |
| C-222 | get_typeが配列型を取得する | E-12 (L15, L42-54) | ○ |
| C-223 | get_typeがキャッシュを利用する | E-12 (L6-9) | ○ |
| C-224 | get_typeが無効要素型でエラーを発生させる | E-12 (L45-47) | ○ |
| C-225 | get_array_typeが配列型を返す | E-12 (L59-65) | ○ |
| C-226 | get_array_typeがキャッシュを利用する | E-12 (L62-63) | ○ |
| C-227 | define_opaque_typeが不透明型を定義する | E-12 (L67-81) | ○ |
| C-228 | relocate_typetableがTypeTableを再配置する | E-12 (L83-96) | ○ |

### julia_extensions.c（Julia拡張）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-229 | jl_id_start_charがASCII英字を判定する | E-13 (L127-137) | ○ |
| C-230 | jl_id_start_charがアンダースコアを判定する | E-13 (L129) | ○ |
| C-231 | jl_id_start_charが数字を拒否する | E-13 (L129) | ○ |
| C-232 | jl_id_start_charがnablaを判定する | E-13 (L86-87) | ○ |
| C-233 | jl_id_start_charが境界値を判定する | E-13 (L131-132) | ○ |
| C-234 | jl_id_charが英字を判定する | E-13 (L139-158) | ○ |
| C-235 | jl_id_charが数字を判定する | E-13 (L142) | ○ |
| C-236 | jl_id_charが感嘆符を判定する | E-13 (L142) | ○ |
| C-237 | jl_id_charがスペースを拒否する | E-13 (L144-145) | ○ |
| C-238 | jl_id_charがプライムを判定する | E-13 (L153) | ○ |
| C-239 | jl_op_suffix_charがサブスクリプトを判定する | E-13 (L163-180) | ○ |
| C-240 | jl_op_suffix_charがASCIIを拒否する | E-13 (L173) | ○ |
| C-241 | fl_skipwsが空白をスキップする | E-13 (L42-65) | ○ |
| C-242 | fl_skipwsが改行なしモードで動作する | E-13 (L56) | ○ |
| C-243 | fl_skipwsがEOFでFL_EOFを返す | E-13 (L50-54) | ○ |
| C-244 | fl_skipwsがBOMをスキップする | E-13 (L56: is_bom) | ○ |
| C-245 | fl_julia_underscore_symbolpがアンダースコアシンボルを判定する | E-13 (L269-277) | ○ |
| C-246 | fl_julia_underscore_symbolpが非アンダースコアを拒否する | E-13 (L276) | ○ |
| C-247 | fl_julia_underscore_symbolpが非シンボルでFを返す | E-13 (L272) | ○ |
| C-248 | fl_julia_underscore_symbolpが空シンボルでFを返す | E-13 (L274) | ○ |
| C-249 | fl_julia_strip_op_suffixがサフィックスを除去する | E-13 (L245-266) | ○ |
| C-250 | fl_julia_strip_op_suffixがサフィックスなしで元を返す | E-13 (L258) | ○ |
| C-251 | fl_julia_strip_op_suffixが非シンボルで型エラーを発生させる | E-13 (L248-249) | ○ |
| C-252 | fl_accum_julia_symbolがASCII識別子を読み取る | E-13 (L330-358) | ○ |
| C-253 | fl_accum_julia_symbolがUnicode識別子を正規化する | E-13 (L357) | ○ |
| C-254 | fl_accum_julia_symbolが!=境界で停止する | E-13 (L343-349) | ○ |
| C-255 | fl_string2normsymbolが文字列を正規化シンボルに変換する | E-13 (L361-367) | ○ |
| C-256 | fl_string2normsymbolが非文字列で型エラーを発生させる | E-13 (L364-365) | ○ |
| C-257 | fl_string_only_julia_charが1文字でcharを返す | E-13 (L406-416) | ○ |
| C-258 | fl_string_only_julia_charが複数文字でFを返す | E-13 (L412-414) | ○ |
| C-259 | fl_string_only_julia_charが空文字列でFを返す | E-13 (L392-393) | ○ |
| C-260 | fl_string_only_julia_charが非文字列で型エラーを発生させる | E-13 (L408-409) | ○ |

## 4) 不足情報（Unknown / Missing）
- **equal.c の内部実装詳細（C-157〜C-161）**：equal.c はHTIMPLマクロで展開されるequal_lispvalue関数を含み、展開後の実装詳細が直接確認しづらい。関数の動作はequalhash.cのマクロ定義とhtable.incから推定した。
  - 候補：equal.c展開後コード / htable.incマクロ定義 / テスト実行による検証
- **GCトリガー条件（C-022）**：GCの発生タイミングはヒープサイズやメモリ割り当て状況に依存し、静的解析のみでは正確な境界条件を特定困難。
  - 候補：実行時デバッグ / GCログ分析
- **table.foldl変更検出（C-154）**：h->sizeの変更検出は実装されているが、テーブルのリハッシュによるサイズ変更の全パターンの確認が必要。
  - 候補：equalhash_put_rのリハッシュ実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接的に根拠が確認可能
- 1: 中リスク - equal.c/equalhash.cのマクロ展開に基づくテストケースは実装詳細の確認が必要
- 0: 低リスク - julia_extensions.cのUnicode文字判定テストはコード中のUnicodeコードポイント一覧から根拠が確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] equal_lispvalue関連テスト（C-157〜C-161）の期待結果がHTIMPLマクロ展開後の実装と整合しているか確認
- [ ] GCトリガーテスト（C-022）の前提条件が実行環境で再現可能か確認
- [ ] テストID（UT-FLP-xxx）の連番に抜けや重複がないか確認
- [ ] 各テストケースの「入力値」が実際のC関数のシグネチャと整合しているか確認
- [ ] Julia拡張関数のUnicodeテスト（C-229〜C-240）のコードポイントがJuliaの仕様と整合しているか確認
- [ ] table.foldl変更検出テスト（C-154）の条件がequalhash_put_rの挙動と整合しているか確認
