---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 188
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：src-runtime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（src-runtime.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：188 / 200、根拠なし：12
- 優先レビュー（高）
  1. **UT-SRT-008 (jl_eval_string 文字列式)**: エスケープ処理が複雑で入力値の正確性に根拠不足
  2. **UT-SRT-171 (jl_new_task スタックサイズ0)**: デフォルトスタックサイズの正確な値はビルド設定依存
  3. **UT-SRT-182 (jl_init_stack_limits)**: プラットフォーム依存の動作で全環境での検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/jlapi.c` - Julia C API実装（初期化、評価、呼び出し、Boxing/Unboxing）
- E-02: `src/julia.h` - Julia公開ヘッダー（型定義、マクロ、データ構造）
- E-03: `src/builtins.c` - 組込み関数実装（egal、object_id、比較）
- E-04: `src/rtutils.c` - ランタイムユーティリティ（例外、文字列、エラー）
- E-05: `src/array.c` - 配列コンストラクタとプリミティブ
- E-06: `src/genericmemory.c` - GenericMemoryコンストラクタとプリミティブ
- E-07: `src/symbol.c` - シンボルテーブル実装
- E-08: `src/simplevector.c` - SimpleVector (SVec)実装
- E-09: `src/module.c` - モジュールとトップレベルバインディング
- E-10: `src/gc-common.c` - GC共通実装（コールバック、ファイナライザ、メトリクス）
- E-11: `src/jltypes.c` - 型システム（Union、UnionAll、TypeVar）
- E-12: `src/subtype.c` - サブタイプ判定アルゴリズム
- E-13: `src/gf.c` - ジェネリック関数ディスパッチ
- E-14: `src/datatype.c` - DataType定義と操作
- E-15: `src/threading.c` - スレッディング実装
- E-16: `src/task.c` - タスク（コルーチン）実装
- E-17: `src/iddict.c` - IDDictハッシュテーブル実装
- E-18: `src/init.c` - システム初期化
- E-19: `src/dlload.c` - 動的ライブラリロード
- E-20: `src/safepoint.c` - セーフポイント機構
- E-21: `src/jl_exported_funcs.inc` - エクスポート関数一覧
- E-22: `src/julia_internal.h` - 内部ヘッダー（内部関数宣言）
- E-23: `src/builtin_proto.h` - 組込み関数プロトタイプ

## 3) Claims と根拠の対応（レビューの主戦場）

### 初期化・API (UT-SRT-001 - UT-SRT-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jl_is_initialized はjl_main_module!=NULLで1を返す | E-01 (L39-42) | ○ |
| C-02 | jl_is_initialized はjl_main_module==NULLで0を返す | E-01 (L39-42) | ○ |
| C-03 | jl_initでランタイムが初期化される | E-01 (L136-139) | ○ |
| C-04 | jl_initの二重呼び出しは安全 | E-01 (L108-109: if jl_is_initialized return) | ○ |
| C-05 | jl_init_with_image_fileでシステムイメージ指定初期化 | E-01 (L105-121) | ○ |
| C-06 | 不正image_pathのエラーハンドリング | E-01 (L105-121) | △ |
| C-07 | jl_eval_stringで式を評価 | E-01 (L153-171) | ○ |
| C-08 | jl_eval_stringで文字列式を評価 | E-01 (L153-171) | △ |
| C-09 | 構文エラーでNULL返却 | E-01 (L166-170: JL_CATCH→NULL) | ○ |
| C-10 | 実行時エラーでNULL返却 | E-01 (L166-170) | ○ |
| C-11 | jl_exception_occurredで例外取得 | E-01 (L191-194) | ○ |
| C-12 | jl_exception_clearで例外クリア | E-01 (L200-203) | ○ |
| C-13 | jl_typename_strでDataType名を返す | E-01 (L211-216) | ○ |
| C-14 | jl_typename_strで非DataTypeにNULL | E-01 (L213: if !jl_is_datatype return NULL) | ○ |
| C-15 | jl_callで関数呼び出し | E-01 (L290-313) | ○ |
| C-16 | jl_call0-jl_call4の各バリエーション | E-01 (L323-484) | ○ |
| C-17 | jl_get_fieldでフィールド取得 | E-01 (L493-) | ○ |
| C-18 | jl_string_ptrでCポインタ取得 | E-01 (L277-280) | ○ |
| C-19 | jl_array_eltypeで要素型取得 | E-01 (L235-238) | ○ |
| C-20 | jl_array_rankで次元数取得 | E-01 (L248-251) | ○ |
| C-21 | jl_current_exceptionで例外取得 | E-01 (L179-183) | ○ |
| C-22 | jl_current_exceptionで例外なし時nothing | E-01 (L182) | ○ |

### シンボル (UT-SRT-035 - UT-SRT-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | jl_symbolでシンボル作成 | E-07 (L79-100) | ○ |
| C-24 | 同じ文字列で同一シンボルが返る（インターン） | E-07 (L79-100: symtab_lookup) | ○ |
| C-25 | _jl_symbolでMAX_SYM_LEN超過時エラー | E-07 (L84-86) | ○ |
| C-26 | hash_symbolの一貫性 | E-07 (L23-28) | ○ |

### SimpleVector (UT-SRT-041 - UT-SRT-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | jl_alloc_svecでゼロ初期化SVec作成 | E-08 (L84-90) | ○ |
| C-28 | n=0でjl_emptysvec返却 | E-08 (L86) | ○ |
| C-29 | jl_svec1/svec2/svec3で固定長SVec | E-08 (L37-71) | ○ |
| C-30 | jl_svec_copyでSVecコピー | E-08 (L92-98) | ○ |

### 配列 (UT-SRT-049 - UT-SRT-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | jl_alloc_array_1d/2d/3d/ndで配列作成 | E-05 (L147-167) | ○ |
| C-32 | jl_array_validate_dimsで次元バリデーション | E-05 (L21-33) | ○ |
| C-33 | オーバーフロー検出 | E-05 (L27-29: __builtin_mul_overflow) | ○ |
| C-34 | jl_array_grow_endで配列拡張 | E-05 (L191-) | ○ |
| C-35 | jl_array_to_stringで配列→文字列変換 | E-05 (L127-145) | ○ |
| C-36 | 空配列→jl_an_empty_string | E-05 (L130-135) | ○ |
| C-37 | jl_ptr_to_array_1dでポインタから配列作成 | E-05 (L95-106) | ○ |
| C-38 | 次元不一致でArgumentError | E-05 (L98-99) | ○ |

### GenericMemory (UT-SRT-068 - UT-SRT-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | jl_alloc_genericmemoryでMemory確保 | E-06 (L75-100) | ○ |
| C-40 | nel=0でinstanceシングルトン返却 | E-06 (L92-93) | ○ |
| C-41 | オーバーフロー時ArgumentError | E-06 (L65-66) | ○ |

### 組込み比較 (UT-SRT-072 - UT-SRT-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | jl_egalの同一オブジェクト比較 | E-03 (L56-167: egal実装) | ○ |
| C-43 | jl_egalの同値整数比較 | E-03 (bits_equal) | ○ |
| C-44 | jl_egalの異型比較 | E-03 (L173-174: dtag比較) | ○ |
| C-45 | jl_object_idの一意性・一貫性 | E-03, E-21 | ○ |
| C-46 | compare_svecの長さチェック | E-03 (L91-92) | ○ |

### 例外・エラー (UT-SRT-083 - UT-SRT-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | jl_errorでErrorExceptionスロー | E-04 (L35-44) | ○ |
| C-48 | jl_errorfでフォーマットエラー | E-04 (L73-80) | ○ |
| C-49 | jl_exceptionfでカスタム例外 | E-04 (L82-90) | ○ |
| C-50 | jl_too_few_args/jl_too_many_args | E-04 (L102-110) | ○ |
| C-51 | jl_type_errorでTypeError | E-04 (L136-141) | ○ |
| C-52 | jl_undefined_var_errorでUndefVarError | E-04 (L143-168) | ○ |
| C-53 | jl_bounds_errorでBoundsError | E-04 (L190-194) | ○ |

### DataType (UT-SRT-096 - UT-SRT-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | jl_new_datatypeでDataType作成 | E-14 (L99-) | ○ |
| C-55 | jl_new_abstracttypeで抽象型作成 | E-14 (L101-104) | ○ |
| C-56 | jl_new_typename_inでTypeName作成 | E-14 (L70-97) | ○ |
| C-57 | jl_field_indexでフィールド検索 | E-14, E-21 | ○ |
| C-58 | jl_get_nth_field/jl_set_nth_field | E-14, E-21 | ○ |

### モジュール (UT-SRT-112 - UT-SRT-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | jl_new_moduleでモジュール作成 | E-09, E-21 | ○ |
| C-60 | jl_set_const/jl_set_global/jl_get_global | E-09, E-21 | ○ |
| C-61 | jl_boundpでバインディング存在チェック | E-09, E-21 | ○ |
| C-62 | jl_module_name/jl_module_parent | E-09, E-21 | ○ |

### GC (UT-SRT-124 - UT-SRT-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | jl_gc_enable/jl_gc_is_enabled | E-10, E-21 | ○ |
| C-64 | jl_gc_collectで手動GC | E-10, E-21 | ○ |
| C-65 | GCコールバック登録/解除 | E-10 (L37-118) | ○ |
| C-66 | schedule_finalizationでファイナライザスケジュール | E-10 (L160-167) | ○ |
| C-67 | run_finalizerのエラーハンドリング | E-10 (L169-189) | ○ |
| C-68 | memory_block_usable_size | E-10 (L137-149) | ○ |

### 型システム (UT-SRT-138 - UT-SRT-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | jl_apply_type/jl_apply_tuple_type | E-11, E-21 | ○ |
| C-70 | jl_type_union | E-11, E-21 | ○ |
| C-71 | jl_type_unionall/jl_new_typevar | E-11, E-21 | ○ |
| C-72 | jl_subtypeのサブタイプ判定 | E-12, E-21 | ○ |
| C-73 | jl_types_equal | E-12, E-21 | ○ |
| C-74 | jl_type_intersection | E-12, E-21 | ○ |
| C-75 | jl_isa | E-12, E-21 | ○ |

### ジェネリック関数 (UT-SRT-158 - UT-SRT-164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | jl_get_world_counter | E-13 (L31-37) | ○ |
| C-77 | jl_apply_genericでディスパッチ | E-13, E-21 | ○ |
| C-78 | メソッド未発見時MethodError | E-13 | ○ |

### スレッディング・タスク (UT-SRT-165 - UT-SRT-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | jl_get_ptls_states | E-15 (L56-60) | ○ |
| C-80 | jl_set_safe_restore | E-15 (L79-92) | ○ |
| C-81 | jl_new_taskでタスク作成 | E-16, E-21 | ○ |
| C-82 | jl_new_taskのデフォルトスタックサイズ | E-16 (L98-100: MINSTKSZ) | △ |
| C-83 | jl_is_task_started | E-16, E-21 | ○ |

### IDDict (UT-SRT-175 - UT-SRT-180)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | jl_idtable_rehash | E-17 (L13-30) | ○ |
| C-85 | jl_eqtable_get/put/pop | E-17, E-21 | ○ |

### 初期化・動的ロード・セーフポイント (UT-SRT-181 - UT-SRT-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | jl_atexit_hook | E-18, E-21 | ○ |
| C-87 | jl_init_stack_limits | E-18 (L53-80) | △ |
| C-88 | jl_dlopen/jl_dlsym/jl_dlclose | E-19, E-21 | ○ |
| C-89 | jl_dlopen不正パスの挙動 | E-19 | △ |
| C-90 | セーフポイント有効化/無効化 | E-20 (L50-70) | ○ |
| C-91 | セーフポイント重複有効化カウント | E-20 (L54: enable_cnt++) | ○ |
| C-92 | jl_cstr_to_string/jl_pchar_to_string | E-04, E-21 | ○ |
| C-93 | Boxing/Unboxing (int64, float64) | E-01, E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SRT-006, C-06**: `jl_init_with_image_file`に不正パスを渡した場合の具体的なエラー挙動はソースコードから直接確認できない（内部関数`jl_resolve_sysimg_location`に依存）
  - 候補：`src/init.c` / `src/staticdata.c` の内部実装確認
- **UT-SRT-008, C-08**: 文字列評価のエスケープ処理が複雑で、テストケースの入力値表現が正確かどうかの検証が困難
  - 候補：実機テストでの検証
- **UT-SRT-171, C-82**: デフォルトスタックサイズは`MINSTKSZ`マクロで定義されるがプラットフォーム依存
  - 候補：`src/task.c` L97-100 の`MINSTKSZ`定義確認
- **UT-SRT-182, C-87**: `jl_init_stack_limits`はOS依存の実装が多く、全プラットフォームでの動作検証が困難
  - 候補：`src/init.c` のプラットフォーム別実装確認
- **UT-SRT-184, C-89**: `jl_dlopen`で存在しないライブラリを開こうとした場合のNULL返却はOS依存
  - 候補：`src/dlload.c` のプラットフォーム別エラーハンドリング確認

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: src-runtimeはC/C++のランタイムコードであり、単体テストの実行にはランタイム初期化が前提。テストハーネスの構築コストが高い。
- **リスク0 (低)**: テストID命名は`SRT`（src-runtime）で一貫。他モジュールとの衝突なし。
- **リスク1 (中)**: 一部の関数（`jl_safepoint_enable/disable`、`jl_init_stack_limits`）はOSレベルの操作を伴い、テスト環境による差異が発生する可能性がある。
- **リスク0 (低)**: Boxing/Unboxing関数群はマクロ展開で実装されている場合があり、テスト対象ファイルが実際と異なる可能性がある（`src/jlapi.c`と記載しているが、実体は`src/runtime_intrinsics.c`等の可能性）。

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがエクスポート関数一覧（`jl_exported_funcs.inc`）の主要関数をカバーしているか
- [ ] 各テストケースの前提条件が現実的に構築可能か
- [ ] 異常系テストケースで期待されるエラー型が正しいか（ソースコードの`jl_throw`呼び出しと一致するか）
- [ ] 境界値テストケースが適切な境界を選択しているか（MAXINTVAL、MAX_SYM_LEN等）
- [ ] Boxing/Unboxing関数の対象ファイルが正確か（マクロ展開による実体確認）
- [ ] プラットフォーム依存テストケース（dlload, safepoint, stack_limits）に注記が適切か
- [ ] GCコールバック関連テストの登録/解除ペアが網羅されているか
- [ ] 153ファイル中、主要な公開API関数をカバーする20ファイルから200ケースを抽出した妥当性
