---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 228
  claims_with_evidence: 224
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：src-support 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：224 / 228、根拠なし：4
- 優先レビュー（高）
  1. **C-045 (u8_strwidth CJK幅)**: utf8proc_charwidthの戻り値が実際にCJK文字で2を返すかはutf8procライブラリの実装に依存
  2. **C-192 (sleep_ms ゼロスリープ)**: ms=0の場合の即座復帰は実装で確認できるが、タイミングの検証は環境依存
  3. **C-210 (libsupport_init)**: 初期化の副作用（rlimit変更、locale設定等）はOS環境に依存
  4. **C-200 (jl_strtod_c 先頭空白)**: Windows専用コードパスの動作は実行環境に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/support/utf8.c` - UTF-8操作関数の実装
- E-02: `src/support/utf8.h` - UTF-8操作関数の宣言
- E-03: `src/support/htable.c` - ハッシュテーブル共通関数の実装
- E-04: `src/support/htable.h` - ハッシュテーブル構造体・マクロ定義
- E-05: `src/support/htable.inc` - ハッシュテーブル操作マクロテンプレート
- E-06: `src/support/ptrhash.c` - ポインタハッシュテーブルの実装
- E-07: `src/support/ptrhash.h` - ポインタハッシュテーブルの宣言
- E-08: `src/support/arraylist.c` - 動的配列の実装
- E-09: `src/support/arraylist.h` - 動的配列の宣言
- E-10: `src/support/bitvector.c` - ビットベクトルの実装
- E-11: `src/support/bitvector.h` - ビットベクトルの宣言
- E-12: `src/support/hashing.c` - ハッシュ関数の実装（int32hash, int64hash, memhash等）
- E-13: `src/support/hashing.h` - ハッシュ関数の宣言
- E-14: `src/support/MurmurHash3.c` - MurmurHash3アルゴリズムの実装
- E-15: `src/support/MurmurHash3.h` - MurmurHash3の宣言
- E-16: `src/support/int2str.c` - 整数→文字列変換の実装
- E-17: `src/support/operators.c` - 数値型変換・比較演算子の実装
- E-18: `src/support/utils.h` - ユーティリティ関数の宣言
- E-19: `src/support/ios.c` - IOストリームの実装
- E-20: `src/support/ios.h` - IOストリームの宣言
- E-21: `src/support/timefuncs.c` - 時刻関数の実装
- E-22: `src/support/timefuncs.h` - 時刻関数の宣言
- E-23: `src/support/strtod.c` - 文字列→浮動小数点変換の実装
- E-24: `src/support/strtod.h` - strtod関数の宣言
- E-25: `src/support/rle.c` - RLEエンコーディングの実装
- E-26: `src/support/rle.h` - RLEエンコーディングの宣言
- E-27: `src/support/libsupportinit.c` - ライブラリ初期化の実装
- E-28: `src/support/libsupport.h` - ライブラリ初期化の宣言
- E-29: `src/support/dtypes.h` - 型定義・ユーティリティインライン関数
- E-30: `src/support/platform.h` - プラットフォーム検出マクロ

## 3) Claims と根拠の対応（レビューの主戦場）

### UTF-8関数 (utf8.c / utf8.h)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | u8_seqlenがASCIで1を返す | E-01 (trailingBytesForUTF8テーブルとseqlen実装) | ○ |
| C-002 | u8_seqlenが2バイトシーケンスで2を返す | E-01 (trailingBytesForUTF8[0xC3]=1, +1=2) | ○ |
| C-003 | u8_seqlenが3バイトシーケンスで3を返す | E-01 (trailingBytesForUTF8[0xE3]=2, +1=3) | ○ |
| C-004 | u8_seqlenが4バイトシーケンスで4を返す | E-01 (trailingBytesForUTF8[0xF0]=3, +1=4) | ○ |
| C-005〜C-013 | u8_charlenの各コードポイント範囲の戻り値 | E-01 (条件分岐: <0x80→1, <0x800→2, <0x10000→3, <0x110000→4, else→0) | ○ |
| C-014〜C-017 | u8_toucsの正常系・境界値 | E-01 (u8_toucs実装: sz==0||srcsz==0→return 0) | ○ |
| C-018〜C-020 | u8_toutf8の正常系・異常系 | E-01 (u8_toutf8実装: 無効コードポイントで置換文字) | ○ |
| C-021〜C-024 | u8_wc_toutf8の各範囲 | E-01 (u8_wc_toutf8実装) | ○ |
| C-025〜C-030 | u8_offset/u8_charnumの正常系・境界値 | E-01 (実装確認済み) | ○ |
| C-031〜C-036 | u8_nextchar/u8_inc/u8_decの動作 | E-01 (実装確認済み) | ○ |
| C-037〜C-043 | u8_isvalidの各パターン | E-01 (検証ロジック: 0xc2-0xf4範囲チェック、サロゲート検出、オーバーロング検出) | ○ |
| C-044〜C-046 | u8_strwidthの正常系・境界値 | E-01 (utf8proc_charwidth呼び出し) | ○ |
| C-045 | CJK文字の幅が2として計算される | E-01 | △ |
| C-047〜C-052 | octal_digit/hex_digitの判定 | E-01 (明確な条件分岐) | ○ |
| C-053〜C-056 | read_escape_control_charの変換 | E-01 (if-else文による変換テーブル) | ○ |
| C-057〜C-060 | u8_read_escape_sequenceのエスケープ解析 | E-01 (8進/16進/Unicode解析ロジック) | ○ |
| C-061〜C-063 | u8_escape_wcharのエスケープ出力 | E-01 (snprintfによるフォーマット出力) | ○ |
| C-064〜C-067 | u8_memchr/u8_memrchrの検索 | E-01 (線形探索実装) | ○ |

### ハッシュテーブル (htable.c / ptrhash.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-068〜C-074 | htable_new/free/resetの動作 | E-03, E-04 (実装確認: size<=HT_N_INLINE/2→インライン, else→ヒープ) | ○ |
| C-075〜C-084 | ptrhash_put/get/has/remove/adjoinの動作 | E-05, E-06 (HTIMPL展開による関数生成) | ○ |

### 動的配列 (arraylist.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-085〜C-097 | arraylist/small_arraylistの全操作 | E-08, E-09 (実装: size<=AL_N_INLINE→インライン, pop→len==0でNULL) | ○ |

### ビットベクトル (bitvector.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-098〜C-109 | bitvector_new/set/get/nwords/resizeの動作 | E-10, E-11 (ビット操作: b[n>>5] |= (1<<(n&31))) | ○ |

### ハッシュ関数 (hashing.c / MurmurHash3.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110〜C-122 | int32hash/int64hash/memhash等の一貫性・分散 | E-12, E-13 (決定論的ハッシュ関数実装) | ○ |
| C-220〜C-224 | MurmurHash3の一貫性・分散 | E-14, E-15 (決定論的MurmurHash3実装) | ○ |

### 整数変換 (int2str.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123〜C-131 | uint2str/isdigit_baseの動作 | E-16, E-18 (実装: 余り演算による桁変換) | ○ |

### 数値型変換 (operators.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132〜C-145 | conv_to_double/int64/uint64, cmp_same_lt/eq, cmp_lt/eqの動作 | E-17, E-18 (switch-caseによる型別変換、NaN比較ロジック) | ○ |

### IOストリーム (ios.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146〜C-188 | ios_mem/write/read/seek/pos/skip/eof/putc/getc/peekc等の全操作 | E-19, E-20 (メモリストリーム・ファイルストリーム実装) | ○ |

### 時刻関数 (timefuncs.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-189〜C-191 | jl_gettimeofday/jl_clock_nowの動作 | E-21, E-22 (gettimeofday呼び出し) | ○ |
| C-192 | sleep_msのゼロスリープ | E-21 (ms==0→return) | △ |

### 文字列→浮動小数点変換 (strtod.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-193〜C-199 | jl_strtod_cの各パターン | E-23, E-24 (strtod_lまたはカスタム解析実装) | ○ |
| C-200 | 先頭空白スキップ | E-23 (Windowsパス: while(isspace...)) | △ |
| C-201 | jl_strtof_cの動作 | E-23 (jl_strtod_cのfloatキャスト) | ○ |

### RLEエンコーディング (rle.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-202〜C-209 | rle_iter_init/increment, rle_index_to_reference/reference_to_indexの動作 | E-25, E-26 (RLEテーブル走査実装) | ○ |

### ライブラリ初期化 (libsupportinit.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-210 | libsupport_initの初期化 | E-27, E-28 (ios_init_stdstreams呼び出し) | △ |
| C-211 | 二重呼び出しの冪等性 | E-27 (isInitializedフラグチェック) | ○ |

### 型定義・ユーティリティ (dtypes.h)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-212〜C-219 | next_power_of_two, calloc_s, malloc_sの動作 | E-29 (インライン関数実装) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-045**: utf8proc_charwidthの戻り値はutf8procライブラリの外部依存のため、CJK文字に対する幅2の返却は外部ライブラリの仕様に依存する
  - 候補：utf8proc.hのドキュメント / Unicode Standard Annex #11 (East Asian Width)
- **C-192**: sleep_msのms=0で即座に戻る動作はOS依存。Windows:Sleep(0)の動作、POSIX:select(timeout=0)の動作
  - 候補：各OSのAPIドキュメント
- **C-200**: jl_strtod_cの先頭空白スキップはWindows専用コードパスにのみ存在。Unix環境ではstrtod_lの仕様に依存
  - 候補：POSIX strtod_lドキュメント
- **C-210**: libsupport_initのrlimit変更・locale設定はOS環境に依存し、テスト環境で完全に検証できない可能性がある
  - 候補：OS別の動作確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: UTF-8変換関数群 - 実装が明確で、入出力が決定論的
- **0 (低リスク)**: ハッシュテーブル/動的配列/ビットベクトル - 標準的なデータ構造で実装が明確
- **0 (低リスク)**: ハッシュ関数群 - 決定論的アルゴリズムで一貫性検証が容易
- **1 (中リスク)**: IOストリーム関数 - ファイルI/O関連のテストは環境依存要素がある
- **1 (中リスク)**: strtod関数 - プラットフォーム間でコードパスが異なる（strtod_l vs カスタム実装）
- **0 (低リスク)**: RLEエンコーディング - 純粋な計算処理で環境依存なし

## 6) レビュアーチェックリスト（最小）
- [ ] UTF-8関数のテストケースがU+0000〜U+10FFFFの全範囲境界を網羅しているか確認
- [ ] u8_isvalidのテストケースが全ての不正UTF-8パターン（オーバーロング、サロゲート、範囲外）を検証しているか確認
- [ ] ハッシュテーブルのテーブル拡張テストが十分な数のエントリで検証されているか確認
- [ ] IOストリームのファイルI/Oテスト（ios_file）が環境に依存しない形で設計されているか確認
- [ ] jl_strtod_cのWindows/Unix両方のコードパスのテストケースが存在するか確認
- [ ] conv_to_double/uint64のエッジケース（INT64_MIN、大きなuint64値）のテストが十分か確認
- [ ] bitvector_setのワード境界（ビット0、31、32、63）のテストが網羅されているか確認
- [ ] strptime.cはWindows専用ファイルのためテスト対象外としているが、これが適切か確認
