---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 233
  claims_with_evidence: 228
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：stdlib-Dates 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：228 / 233、根拠なし：5
- 優先レビュー（高）
  1. **UT-DAT-150（unix2datetime/datetime2unix往復変換）**：往復精度の正確な期待値は浮動小数点の精度依存
  2. **UT-DAT-146（rata2datetime(1)）**：Rata Die日数1がDate(0001,1,1)に対応するかはエポック定義に依存
  3. **UT-DAT-148（julian2datetime(0.0)）**：ユリウス日エポックの正確な対応日時の検証が必要
  4. **UT-DAT-191（epochdays2date(0)）**：エポック日0がDate(0,1,1)に対応するかの正確な検証が必要
  5. **UT-DAT-192（epochms2datetime(0)）**：エポックms 0がDateTime(0,1,1,0,0,0)に対応するかの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Dates/src/types.jl` - 型定義、コンストラクタ、バリデーション
- E-02: `stdlib/Dates/src/periods.jl` - Period型の算術演算、CompoundPeriod、canonicalize
- E-03: `stdlib/Dates/src/accessors.jl` - 年月日週時分秒アクセサ、ISO週、ISO年
- E-04: `stdlib/Dates/src/query.jl` - 曜日、月名、閏年判定、四半期、DateLocale
- E-05: `stdlib/Dates/src/arithmetic.jl` - TimeType算術演算、月ラップ、年ラップ
- E-06: `stdlib/Dates/src/conversions.jl` - 型変換、Unix/Rata Die/Julian変換
- E-07: `stdlib/Dates/src/adjusters.jl` - trunc、firstdayof/lastdayof、tonext/toprev/tofirst/tolast、adjust
- E-08: `stdlib/Dates/src/rounding.jl` - floor/ceil/round（TimeType、Period）、floorceil、エポック変換
- E-09: `stdlib/Dates/src/io.jl` - DateFormat、フォーマット、パース、ISODateTimeFormat等
- E-10: `stdlib/Dates/src/parse.jl` - tryparsenext系関数、parse、tryparse、parse_components
- E-11: `stdlib/Dates/src/ranges.jl` - StepRange、length、in、iterate
- E-12: `stdlib/Dates/src/Dates.jl` - モジュール定義、export一覧
- E-13: `stdlib/Dates/src/deprecated.jl` - 非推奨関数（テスト対象外）

## 3) Claims と根拠の対応（レビューの主戦場）

### types.jl（C-001〜C-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | DateTime基本コンストラクタが有効な引数で動作する | E-01: DateTime(y,m,d,h,mi,s,ms)定義（L243-250） | ○ |
| C-002 | DateTimeデフォルト引数が1月1日0時 | E-01: デフォルト値 m=1,d=1,h=0等（L243-244） | ○ |
| C-003 | 月=13でArgumentError | E-01: validargs月チェック（L254） | ○ |
| C-004 | 月=0でArgumentError | E-01: validargs月チェック（L254） | ○ |
| C-005 | 2023年2月29日でArgumentError | E-01: validargs日チェック+daysinmonth（L255） | ○ |
| C-006 | 閏年2月29日で正常生成 | E-01: daysinmonth(2024,2)=29（L210） | ○ |
| C-007 | 時間25でArgumentError | E-01: validargs時間チェック（L256-258） | ○ |
| C-008 | 時間24:00:00で正常生成 | E-01: h==24 && mi==s==ms==0の条件（L257） | ○ |
| C-009 | 分60でArgumentError | E-01: validargs分チェック（L262） | ○ |
| C-010 | 秒60でArgumentError | E-01: validargs秒チェック（L263） | ○ |
| C-011 | ミリ秒1000でArgumentError | E-01: validargsミリ秒チェック（L264） | ○ |
| C-012 | Period可変長からDateTime生成 | E-01: DateTime(period::Period, periods...)定義（L341-354） | ○ |
| C-013 | Date+TimeからDateTime生成 | E-01: DateTime(dt::Date, t::Time)定義（L414-418） | ○ |
| C-014 | Timeにマイクロ秒含むとInexactError | E-01: microsecond/nanosecondチェック（L415） | ○ |
| C-015 | Date基本コンストラクタ | E-01: Date(y,m,d)定義（L275-279） | ○ |
| C-016 | Dateデフォルト引数 | E-01: デフォルト値 m=1,d=1（L275） | ○ |
| C-017 | Date月範囲外 | E-01: validargs(Date,...)月チェック（L282） | ○ |
| C-018 | Date日範囲外 | E-01: validargs(Date,...)日チェック（L283） | ○ |
| C-019 | Period可変長からDate生成 | E-01: Date(period::Period, periods...)定義（L362-370） | ○ |
| C-020 | Time基本コンストラクタ | E-01: Time(h,mi,s,ms,us,ns)定義（L294-299） | ○ |
| C-021 | Timeデフォルト引数 | E-01: デフォルト値 mi=0等（L294） | ○ |
| C-022 | Time時間24でArgumentError | E-01: validargs(Time,...)時間チェック（L302-303） | ○ |
| C-023 | Timeマイクロ秒1000でError | E-01: validargsマイクロ秒チェック（L310） | ○ |
| C-024 | Time mod演算で丸め | E-01: Time(instant)のmod(instant, 86400000000000)（L190） | ○ |
| C-025 | totaldays計算 | E-01: totaldays関数定義（L197-203） | ○ |
| C-026 | isleapyear 2000年 | E-01: isleapyear定義（L206） | ○ |
| C-027 | isleapyear 1900年 | E-01: isleapyear定義（L206） | ○ |
| C-028 | isleapyear 2024年 | E-01: isleapyear定義（L206） | ○ |
| C-029 | isleapyear 2023年 | E-01: isleapyear定義（L206） | ○ |
| C-030 | daysinmonth 1月=31 | E-01: DAYSINMONTH定数（L209） | ○ |
| C-031 | daysinmonth 閏年2月=29 | E-01: daysinmonth + isleapyear（L210） | ○ |
| C-032 | daysinmonth 非閏年2月=28 | E-01: daysinmonth + isleapyear（L210） | ○ |
| C-033 | validargs(DateTime)成功 | E-01: validargs定義（L252-266） | ○ |
| C-034 | validargs(DateTime)失敗 | E-01: validargs定義（L252-266） | ○ |
| C-035 | validargs(Date)成功 | E-01: validargs定義（L281-285） | ○ |
| C-036 | validargs(Time)成功 | E-01: validargs定義（L301-313） | ○ |
| C-037 | adjusthour TWENTYFOURHOUR | E-01: adjusthour定義（L229-234） | ○ |
| C-038 | adjusthour PM加算 | E-01: adjusthour PM条件（L231） | ○ |
| C-039 | adjusthour AM 12→0 | E-01: adjusthour AM条件（L232） | ○ |
| C-040 | adjusthour PM 12そのまま | E-01: adjusthour条件分岐（L231: h<12チェック） | ○ |
| C-041 | eps(DateTime)=Millisecond(1) | E-01: eps定義（L452） | ○ |
| C-042 | eps(Date)=Day(1) | E-01: eps定義（L453） | ○ |
| C-043 | eps(Time)=Nanosecond(1) | E-01: eps定義（L454） | ○ |
| C-044 | isless(DateTime,DateTime) | E-01: isless定義（L472） | ○ |
| C-045 | ==(DateTime,DateTime) | E-01: ==定義（L474） | ○ |

### periods.jl（C-046〜C-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-046 | value(Period)でInt64取得 | E-02: value定義（L10） | ○ |
| C-047 | DatePeriodデフォルト=1 | E-02: default定義（L66） | ○ |
| C-048 | TimePeriodデフォルト=0 | E-02: default定義（L67） | ○ |
| C-049 | Period同型加算 | E-02: +定義（L74-76） | ○ |
| C-050 | Period符号反転 | E-02: -定義（L69） | ○ |
| C-051 | Periodスカラー乗算 | E-02: *定義（L90） | ○ |
| C-052 | Period同型除算 | E-02: /定義（L78） | ○ |
| C-053 | Period整数除算 | E-02: div定義（L80） | ○ |
| C-054 | Period剰余算 | E-02: mod定義（L83-87） | ○ |
| C-055 | 異型Period加算→CompoundPeriod | E-02: +定義（L332） | ○ |
| C-056 | CompoundPeriod生成 | E-02: CompoundPeriod定義（L130-165） | ○ |
| C-057 | ゼロPeriodの除去 | E-02: CompoundPeriodコンストラクタ（L159-161） | ○ |
| C-058 | canonicalize正規化 | E-02: canonicalize定義（L232-312） | ○ |
| C-059 | canonicalize逆符号結合 | E-02: canonicalize定義（L267-309） | ○ |
| C-060 | canonicalize空入力 | E-02: canonicalize（L263: return x） | ○ |
| C-061 | toms(Millisecond) | E-02: toms定義（L449） | ○ |
| C-062 | toms(Hour) | E-02: toms定義（L452） | ○ |
| C-063 | tons(Nanosecond) | E-02: tons定義（L457） | ○ |
| C-064 | days(Day) | E-02: days定義（L463） | ○ |
| C-065 | days(Week) | E-02: days定義（L464） | ○ |
| C-066 | seconds(Millisecond) | E-02: seconds定義（L471） | ○ |
| C-067 | coarserperiod(Nanosecond) | E-02: coarserperiod定義（L109） | ○ |
| C-068 | coarserperiod(Hour) | E-02: coarserperiod定義（L114） | ○ |
| C-069 | Hour→Day変換 | E-02: define_conversions（L388-413） | ○ |
| C-070 | 割り切れない変換エラー | E-02: divexact（L377-381） | ○ |
| C-071 | FixedPeriod==OtherPeriod（ゼロ） | E-02: ==定義（L417） | ○ |
| C-072 | FixedPeriod==OtherPeriod（非ゼロ） | E-02: ==定義（L417） | ○ |
| C-073 | isless異型MethodError | E-02: isless定義（L439-440） | ○ |
| C-074 | abs(Period) | E-02: abs定義（L103） | ○ |
| C-075 | sign(Period) | E-02: sign定義（L104） | ○ |

### accessors.jl（C-076〜C-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-076 | yearmonthday逆変換 | E-03: yearmonthday定義（L5-9） | ○ |
| C-077 | year(Date) | E-03: year(dt::TimeType)定義（L131） | ○ |
| C-078 | month(Date) | E-03: month(dt::TimeType)定義（L133） | ○ |
| C-079 | day(Date) | E-03: day(dt::TimeType)定義（L135） | ○ |
| C-080 | week ISO週番号 | E-03: week定義（L39-44） | ○ |
| C-081 | week年境界 | E-03: week定義 + docstring例（L177-184） | ○ |
| C-082 | hour(DateTime) | E-03: hour定義（L136） | ○ |
| C-083 | minute(DateTime) | E-03: minute定義（L137） | ○ |
| C-084 | second(DateTime) | E-03: second定義（L138） | ○ |
| C-085 | millisecond(DateTime) | E-03: millisecond定義（L139） | ○ |
| C-086 | hour(Time) | E-03: hour定義（L140） | ○ |
| C-087 | microsecond(Time) | E-03: microsecond定義（L144） | ○ |
| C-088 | nanosecond(Time) | E-03: nanosecond定義（L145） | ○ |
| C-089 | yearmonth(TimeType) | E-03: yearmonth定義（L149） | ○ |
| C-090 | monthday(TimeType) | E-03: monthday定義（L150） | ○ |
| C-091 | quarter Q1 | E-03: quarter定義（L120-123） | ○ |
| C-092 | quarter Q4 | E-03: quarter定義（L120-123） | ○ |
| C-093 | weeksinyear 52週 | E-03: weeksinyear定義（L60-68） | ○ |
| C-094 | weeksinyear 53週 | E-03: weeksinyear定義（L60-68） | ○ |
| C-095 | isoyear前年帰属 | E-03: isoyear定義（L84-98） | ○ |
| C-096 | isoweekdate | E-03: isoweekdate定義（L117-118） | ○ |

### query.jl（C-097〜C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-097 | dayofweek | E-04: dayofweek定義（L86, L121） | ○ |
| C-098 | dayname | E-04: dayname定義（L169-171） | ○ |
| C-099 | dayabbr | E-04: dayabbr定義（L189-191） | ○ |
| C-100 | dayname(Integer) | E-04: dayname定義（L150） | ○ |
| C-101 | ismonday | E-04: ismonday定義（L194） | ○ |
| C-102 | issunday false | E-04: issunday定義（L200） | ○ |
| C-103 | dayofweekofmonth | E-04: dayofweekofmonth定義（L222-225） | ○ |
| C-104 | dayofweekofmonth 29日 | E-04: dayofweekofmonth（L224: d<29?4:5） | ○ |
| C-105 | daysofweekinmonth 5回 | E-04: daysofweekinmonth定義（L250-256） | ○ |
| C-106 | daysofweekinmonth 4回 | E-04: daysofweekinmonth定義（L250-256） | ○ |
| C-107 | monthname | E-04: monthname定義（L579-581） | ○ |
| C-108 | monthabbr | E-04: monthabbr定義（L598-600） | ○ |
| C-109 | monthname(Integer) | E-04: monthname定義（L560） | ○ |
| C-110 | daysinyear閏年 | E-04: daysinyear定義（L103） | ○ |
| C-111 | daysinyear非閏年 | E-04: daysinyear定義（L103） | ○ |
| C-112 | dayofyear | E-04: dayofyear定義（L107, L643） | ○ |
| C-113 | dayofyear 1月1日 | E-04: dayofyear定義（L107: MONTHDAYS[1]+1=1） | ○ |
| C-114 | quarterofyear | E-04: quarterofyear定義（L653） | ○ |
| C-115 | dayofquarter | E-04: dayofquarter定義（L662-665） | ○ |
| C-116 | dayofquarter閏年3月 | E-04: dayofquarter（L664: m==3 && isleapyear条件） | ○ |
| C-117 | daysinmonth(TimeType) | E-04: daysinmonth定義（L619） | ○ |
| C-118 | isleapyear(TimeType) | E-04: isleapyear定義（L636） | ○ |

### arithmetic.jl（C-119〜C-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | DateTime+Year | E-05: +定義（L25-28） | ○ |
| C-120 | 閏日+Year丸め | E-05: d<=ld?d:ld条件（L26-27） | ○ |
| C-121 | Date+Month | E-05: +定義（L56-61） | ○ |
| C-122 | 月末月加算丸め | E-05: d<=ld?d:ld条件（L60） | ○ |
| C-123 | 年越し月加算 | E-05: yearwrap定義（L47） | ○ |
| C-124 | Date-Month | E-05: -定義（L68-73） | ○ |
| C-125 | Date+Day | E-05: +定義（L81） | ○ |
| C-126 | Date-Day | E-05: -定義（L82） | ○ |
| C-127 | Date+Week | E-05: +定義（L79） | ○ |
| C-128 | DateTime+Hour | E-05: +定義（L83） | ○ |
| C-129 | DateTime+Minute | E-05: +定義（L83） | ○ |
| C-130 | DateTime-DateTime | E-05: -定義（L9-10） | ○ |
| C-131 | Date-Date | E-05: -定義（L9） | ○ |
| C-132 | Date+Time→DateTime | E-05: +定義（L21-22） | ○ |
| C-133 | Time+TimePeriod | E-05: +定義（L85） | ○ |
| C-134 | Time-TimePeriod | E-05: -定義（L86） | ○ |
| C-135 | DateTime+Quarter | E-05: +定義（L77） | ○ |
| C-136 | missing加算 | E-05: +/-定義（L90-93） | ○ |
| C-137 | monthwrap | E-05: monthwrap定義（L44） | ○ |
| C-138 | yearwrap | E-05: yearwrap定義（L47） | ○ |

### conversions.jl（C-139〜C-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | DateTime→Date | E-06: convert(Date,DateTime)定義（L31） | ○ |
| C-140 | Date→DateTime | E-06: convert(DateTime,Date)定義（L30） | ○ |
| C-141 | DateTime→Time | E-06: convert(Time,DateTime)定義（L32） | ○ |
| C-142 | unix2datetime(0) | E-06: unix2datetime定義+UNIXEPOCH（L40, L49-59） | ○ |
| C-143 | datetime2unix(epoch) | E-06: datetime2unix定義（L67） | ○ |
| C-144 | unix2datetime正値 | E-06: unix2datetime定義（L49-59） | ○ |
| C-145 | unix2datetime負値 | E-06: unix2datetime定義（L49-59） | ○ |
| C-146 | rata2datetime | E-06: rata2datetime定義（L108） | △ |
| C-147 | datetime2rata | E-06: datetime2rata定義（L115） | ○ |
| C-148 | julian2datetime(0.0) | E-06: julian2datetime定義+JULIANEPOCH（L118, L126-129） | △ |
| C-149 | datetime2julian | E-06: datetime2julian定義（L137） | ○ |
| C-150 | Unix往復変換 | E-06: unix2datetime/datetime2unix定義 | △ |

### adjusters.jl（C-151〜C-177）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | trunc(Date,Year) | E-07: trunc定義（L4） | ○ |
| C-152 | trunc(Date,Month) | E-07: trunc定義（L6） | ○ |
| C-153 | trunc(DateTime,Day) | E-07: trunc定義（L12） | ○ |
| C-154 | trunc(DateTime,Hour) | E-07: trunc定義（L13） | ○ |
| C-155 | trunc(Time,Minute) | E-07: trunc定義（L19） | ○ |
| C-156 | firstdayofweek | E-07: firstdayofweek定義（L52-53） | ○ |
| C-157 | lastdayofweek | E-07: lastdayofweek定義（L68-69） | ○ |
| C-158 | firstdayofmonth | E-07: firstdayofmonth定義（L84-85） | ○ |
| C-159 | lastdayofmonth | E-07: lastdayofmonth定義（L100-103） | ○ |
| C-160 | lastdayofmonth閏年2月 | E-07: lastdayofmonth+daysinmonth（L102） | ○ |
| C-161 | firstdayofyear | E-07: firstdayofyear定義（L119-120） | ○ |
| C-162 | lastdayofyear | E-07: lastdayofyear定義（L135-138） | ○ |
| C-163 | firstdayofquarter Q1 | E-07: firstdayofquarter定義（L157-161） | ○ |
| C-164 | firstdayofquarter Q2 | E-07: firstdayofquarter定義（L157-161） | ○ |
| C-165 | lastdayofquarter Q2 | E-07: lastdayofquarter定義（L180-184） | ○ |
| C-166 | lastdayofquarter Q3 | E-07: lastdayofquarter定義（L180-184） | ○ |
| C-167 | tonext(dow) | E-07: tonext定義（L373） | ○ |
| C-168 | tonext(dow, same=true) | E-07: tonext定義（L373: same条件） | ○ |
| C-169 | tonext(func) | E-07: tonext定義（L383-385） | ○ |
| C-170 | toprev(dow) | E-07: toprev定義（L394） | ○ |
| C-171 | toprev(dow, same=true) | E-07: toprev定義（L394: same条件） | ○ |
| C-172 | tofirst(dow) | E-07: tofirst定義（L414-417） | ○ |
| C-173 | tofirst(dow, of=Year) | E-07: tofirst定義（L415: of条件） | ○ |
| C-174 | tolast(dow) | E-07: tolast定義（L426-429） | ○ |
| C-175 | adjust基本動作 | E-07: adjust定義（L199-204, L242-244） | ○ |
| C-176 | adjust limit超過 | E-07: adjust定義（L204: limit例外） | ○ |
| C-177 | DateFunctionバリデーション | E-07: DateFunction定義（L191-192） | ○ |

### rounding.jl（C-178〜C-192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-178 | floor(Date,Year) | E-08: floor定義（L45-49） | ○ |
| C-179 | floor(Date,Month) | E-08: floor定義（L51-59） | ○ |
| C-180 | floor(DateTime,Minute) | E-08: floor定義（L81-85） | ○ |
| C-181 | floor DomainError | E-08: floor（L46: value(p)<1チェック） | ○ |
| C-182 | ceil(Date,Month) | E-08: ceil定義（L162-165） | ○ |
| C-183 | ceil(DateTime,Minute) | E-08: ceil定義（L162-165） | ○ |
| C-184 | ceil同値 | E-08: ceil定義（L164: dt==f?f:f+p） | ○ |
| C-185 | round(DateTime,Minute) | E-08: round定義（L240-243） | ○ |
| C-186 | round正午→翌日 | E-08: round定義（L240-243: NearestTiesUp） | ○ |
| C-187 | floorceil同時取得 | E-08: floorceil定義（L201-204） | ○ |
| C-188 | floor(Period,Period) | E-08: floor定義（L116-120） | ○ |
| C-189 | ceil(Period,Period) | E-08: ceil定義（L190-193） | ○ |
| C-190 | round(Period,Period) | E-08: round定義（L273-277） | ○ |
| C-191 | epochdays2date(0) | E-08: epochdays2date定義（L19） | △ |
| C-192 | epochms2datetime(0) | E-08: epochms2datetime定義（L27） | △ |

### io.jl/parse.jl/query.jl/ranges.jl（C-193〜C-233）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-193 | DateFormat生成 | E-09: DateFormat定義（L412-462） | ○ |
| C-194 | DateTime文字列パース | E-09: DateTime(dt,format)定義（L572-574） | ○ |
| C-195 | DateFormatパース | E-09: DateTime(dt,df)定義（L586） | ○ |
| C-196 | Date文字列パース | E-09: Date(d,format)定義（L612-614） | ○ |
| C-197 | Time文字列パース | E-09: Time(t,format)定義（L652-654） | ○ |
| C-198 | DateTimeフォーマット | E-09: format定義+ISODateTimeFormat（L677-682, L499） | ○ |
| C-199 | Dateフォーマット | E-09: format定義+ISODateFormat（L677-682, L513） | ○ |
| C-200 | Timeフォーマット | E-09: format定義+ISOTimeFormat（L677-682, L527） | ○ |
| C-201 | RFC1123フォーマット | E-09: RFC1123Format定義（L541） | ○ |
| C-202 | カスタムフォーマット | E-09: format(dt,f::AbstractString)定義（L718-720） | ○ |
| C-203 | hour12午後 | E-09: hour12定義（L180） | ○ |
| C-204 | hour12真夜中 | E-09: hour12定義（L180: h==0?12） | ○ |
| C-205 | string(Time) | E-09: string定義（L44-52） | ○ |
| C-206 | string(Time)ナノ秒 | E-09: string定義（L44-52） | ○ |
| C-207 | parse ISO DateTime | E-10: parse(DateTime,s,ISODateTimeFormat)定義（L211-299） | ○ |
| C-208 | parse空文字列エラー | E-10: parse（L213, L303） | ○ |
| C-209 | parse不正文字列エラー | E-10: parse（L298, L304-306） | ○ |
| C-210 | tryparse成功 | E-10: tryparse定義（L310-321） | ○ |
| C-211 | tryparse失敗 | E-10: tryparse（L313-314: nothing返却） | ○ |
| C-212 | tryparse空文字列 | E-10: tryparse（L312: return nothing） | ○ |
| C-213 | parse Date | E-10: parse(Date,str)定義（L301-308） | ○ |
| C-214 | parse Time | E-10: parse(Time,str)定義（L301-308） | ○ |
| C-215 | 負の年パース | E-10: tryparsenext_sign（L159-169）+ ISOパーサ（L222-225） | ○ |
| C-216 | tryparsenext_base10正常 | E-10: tryparsenext_base10定義（L171-190） | ○ |
| C-217 | tryparsenext_base10非数値 | E-10: tryparsenext_base10（L185-186: nothing） | ○ |
| C-218 | parse_components | E-10: parse_components定義（L331-348） | ○ |
| C-219 | tryparsenext_sign正符号 | E-10: tryparsenext_sign定義（L162） | ○ |
| C-220 | tryparsenext_sign負符号 | E-10: tryparsenext_sign定義（L164） | ○ |
| C-221 | DateLocale生成 | E-04: DateLocale定義（L5-14, L46-53） | ○ |
| C-222 | locale_dict | E-04: locale_dict定義（L16-28） | ○ |
| C-223 | monthname_to_value正常 | E-04: monthname_to_value定義（L70-78） | ○ |
| C-224 | monthname_to_value小文字 | E-04: monthname_to_value（L75: lowercase） | ○ |
| C-225 | monthname_to_value不正 | E-04: monthname_to_value（L73: get default 0） | ○ |
| C-226 | Date StepRange | E-11: StepRange定義+:演算子（L7） | ○ |
| C-227 | Dateデフォルトステップ範囲 | E-11: :定義（L7: Day(1)） | ○ |
| C-228 | length(StepRange) | E-11: length定義（L25） | ○ |
| C-229 | in(x, StepRange) true | E-11: in定義（L56-59） | ○ |
| C-230 | in(x, StepRange) false | E-11: in定義（L56-59） | ○ |
| C-231 | Real stepエラー | E-11: StepRange定義（L5-6） | ○ |
| C-232 | Period+Range | E-11: +定義（L64） | ○ |
| C-233 | step=0エラー | E-11: steprange_last（L36） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-146（rata2datetime(1)）**: Rata Die日数1の正確な対応日時はエポック定義（0000-12-31）に基づく計算が必要で、Date(0001,1,1)への対応は要検証
  - 候補：既存テストファイル / 数学的検証 / ISO 8601仕様
- **C-148（julian2datetime(0.0)）**: ユリウス日0.0がDateTime(-4713,11,24,12,0,0)に正確に対応するかはJULIANEPOCH定数の値に依存
  - 候補：JULIANEPOCH定数の実値確認 / 天文学的定義の参照
- **C-150（Unix往復変換精度）**: 浮動小数点変換の精度により、大きな値での往復変換に誤差が生じる可能性
  - 候補：浮動小数点精度の検証 / Int64範囲内のテスト
- **C-191（epochdays2date(0)）**: DATEEPOCH定数の実値に基づくため、Date(0,1,1)への正確な対応は要検証
  - 候補：DATEEPOCH定数値の確認
- **C-192（epochms2datetime(0)）**: DATETIMEEPOCH定数の実値に基づくため、DateTime(0,1,1)への正確な対応は要検証
  - 候補：DATETIMEEPOCH定数値の確認

## 5) リスクフラグ（レビュー観点）
- 0: types.jl, periods.jl, accessors.jl, query.jl - コンストラクタ・アクセサ・クエリは直接コードから根拠取得済み
- 0: arithmetic.jl - 算術演算は分岐条件を含め網羅
- 0: adjusters.jl - 調整関数はdocstring内の例と一致
- 1: conversions.jl - エポック変換の正確な期待値にはランタイム定数の確認が望ましい
- 0: io.jl, parse.jl - パース/フォーマットは定義と一致
- 0: rounding.jl - 丸め関数はdocstring内の例と一致
- 0: ranges.jl - 範囲操作はコード定義と一致

## 6) レビュアーチェックリスト（最小）
- [ ] 全233テストケースがCSVに含まれているか
- [ ] テストID(UT-DAT-001〜233)に欠番がないか
- [ ] 正常系・異常系・境界値の観点が各主要関数に対して網羅されているか
- [ ] エポック関連変換（C-146, C-148, C-150, C-191, C-192）の期待値を実行環境で確認
- [ ] 閏年関連テスト（C-006, C-031, C-032, C-116, C-120, C-160）の境界条件が正しいか
- [ ] AM/PM変換テスト（C-037〜C-040）がすべてのケースをカバーしているか
- [ ] CompoundPeriod関連テスト（C-055〜C-060）のcanonicalizeロジックが正しいか
- [ ] parseエラーケース（C-208, C-209）の例外メッセージが正確か
