---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 156
  claims_with_evidence: 148
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：stdlib-InteractiveUtils 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：148 / 156、根拠なし：8
- 優先レビュー（高）
  1. **clipboard関連テスト（UT-INU-074〜077）**：OS依存の動作でありテスト環境によって結果が異なる可能性
  2. **peakflops関連テスト（UT-INU-143〜144）**：LinearAlgebra stdlib依存であり実行環境によって動作が異なる
  3. **report_bug関数**：テストケース未生成（外部パッケージ依存・ネットワーク依存のため単体テスト不適）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` - モジュール定義、varinfo、versioninfo、type_close_enough、methodswith、subtypes、supertypes、peakflops、report_bug
- E-02: `stdlib/InteractiveUtils/src/clipboard.jl` - clipboard関数（macOS、Linux/FreeBSD、Windows、その他OS）
- E-03: `stdlib/InteractiveUtils/src/codeview.jl` - ArgInfo構造体、code_warntype、code_llvm、code_native、_dump_function、print_llvm、print_native、sys_arch_category等
- E-04: `stdlib/InteractiveUtils/src/editless.jl` - define_editor、editor_matches、editor、edit、less、EDITOR_CALLBACKS
- E-05: `stdlib/InteractiveUtils/src/macros.jl` - make_tuple_type、get_typeof、is_broadcasting_call/expr/assignment、recursive_dotcalls!、construct_callable、separate_kwargs、are_kwargs_valid、gen_call_with_extracted_types、@activate等
- E-06: `docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール分割とプロジェクト情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | varinfo()がMarkdown.MDを返す | E-01 (L46-86: 戻り値Markdown.MD) | ○ |
| C-02 | varinfoのRegexパターンフィルタ | E-01 (L53: occursin(pattern, string(v))) | ○ |
| C-03 | varinfo all=trueオプション | E-01 (L52: names(m2; all, imported)) | ○ |
| C-04 | varinfo imported=trueオプション | E-01 (L52: names(m2; all, imported)) | ○ |
| C-05 | varinfo recursive=trueオプション | E-01 (L58: recursive && ... push!(workqueue)) | ○ |
| C-06 | varinfo sortby=:size | E-01 (L72-81: sort!処理) | ○ |
| C-07 | varinfo sortby=:summary | E-01 (L76-77: sortby === :summary分岐) | ○ |
| C-08 | varinfo minsize | E-01 (L67: ssize >= minsize) | ○ |
| C-09 | varinfo sortby不正値でArgumentError | E-01 (L47: throw(ArgumentError(...))) | ○ |
| C-10 | varinfo(pat::Regex)ディスパッチ | E-01 (L87: varinfo(pat::Regex; kwargs...)) | ○ |
| C-11 | versioninfoデフォルト出力 | E-01 (L103-191: println出力処理) | ○ |
| C-12 | versioninfo verbose=true | E-01 (L132-165: verbose分岐) | ○ |
| C-13 | versioninfo IO指定 | E-01 (L103: function versioninfo(io::IO=stdout...)) | ○ |
| C-14 | type_close_enough同一型 | E-01 (L195: x == t && return true) | ○ |
| C-15 | type_close_enough DataTypeサブタイプ | E-01 (L197: x.name === t.name && x <: t) | ○ |
| C-16 | type_close_enough Union型 | E-01 (L198: isa(x, Union) && ...) | ○ |
| C-17 | type_close_enough不一致 | E-01 (L195-198: 条件不一致時のfalse) | ○ |
| C-18 | methodswith基本検索 | E-01 (L215-229: methodswith実装) | ○ |
| C-19 | methodswith関数指定 | E-01 (L215: methodswith(t, f, ...)) | ○ |
| C-20 | methodswithモジュール指定 | E-01 (L245: methodswith(t, m::Module; ...)) | ○ |
| C-21 | methodswith supertypes=true | E-01 (L220: supertypes ? ... ) | ○ |
| C-22 | methodswithマッチなし空配列 | E-01 (L216-228: pushの条件不成立) | ○ |
| C-23 | subtypes抽象型列挙 | E-01 (L256-282: _subtypes_in!実装) | ○ |
| C-24 | subtypes具象型で空 | E-01 (L258-260: !isabstracttype(x)でType[]) | ○ |
| C-25 | subtypesモジュール指定 | E-01 (L284: subtypes(m::Module, x::Type)) | ○ |
| C-26 | supertypesチェーン | E-01 (L320-325: supertypes再帰実装) | ○ |
| C-27 | supertypes(Any)で(Any,) | E-01 (L323: S === T ? (T,) : ...) | ○ |
| C-28 | supertypes終端Any | E-01 (L323: 再帰終端条件) | ○ |
| C-29 | ArgInfo関数構築 | E-03 (L28-35: ArgInfo constructor) | ○ |
| C-30 | ArgInfo Builtin拒否 | E-03 (L30: throw(ArgumentError(...))) | ○ |
| C-31 | ArgInfo OpaqueClosure | E-03 (L31-32: f isa Core.OpaqueClosure) | ○ |
| C-32 | ArgInfo型のみ構築 | E-03 (L39-42: ArgInfo(argtypes)) | ○ |
| C-33 | printstyled_ll出力 | E-03 (L45-48: printstyled_ll実装) | ○ |
| C-34 | warntype_type_printer used=true | E-03 (L52-64: 条件分岐) | ○ |
| C-35 | warntype_type_printer used=false | E-03 (L53: (show_type && used) || return nothing) | ○ |
| C-36 | warntype_type_printer不安定型強調 | E-03 (L59: type == Core.Box) | ○ |
| C-37 | code_warntype基本動作 | E-03 (L157-190: code_warntype実装) | ○ |
| C-38 | code_warntype optimize | E-03 (L160: optimize::Bool=false) | ○ |
| C-39 | code_warntype debuginfo | E-03 (L160: debuginfo::Symbol=:default) | ○ |
| C-40 | code_llvm基本動作 | E-03 (L326-335: code_llvm実装) | ○ |
| C-41 | code_llvm raw | E-03 (L328: raw::Bool=false) | ○ |
| C-42 | code_llvm dump_module | E-03 (L328: dump_module::Bool=false) | ○ |
| C-43 | code_llvm optimize=false | E-03 (L328: optimize::Bool=true) | ○ |
| C-44 | code_native基本動作 | E-03 (L354-367: code_native実装) | ○ |
| C-45 | code_native syntax=:att | E-03 (L355: syntax::Symbol=:intel) | ○ |
| C-46 | code_native binary | E-03 (L356: binary::Bool=false) | ○ |
| C-47 | code_native dump_module=false | E-03 (L355: dump_module::Bool=true) | ○ |
| C-48 | _dump_function debuginfo不正値 | E-03 (L237-238: throw(ArgumentError(...))) | ○ |
| C-49 | _dump_function syntax不正値 | E-03 (L241-242: throw(ArgumentError(...))) | ○ |
| C-50 | print_llvmカラー出力 | E-03 (L373-384: print_llvm実装) | ○ |
| C-51 | print_llvm_tokensトークン分類 | E-03 (L390-410: print_llvm_tokens実装) | ○ |
| C-52 | print_nativeカラー出力 | E-03 (L480-492: print_native実装) | ○ |
| C-53 | sys_arch_category x86 | E-03 (L495: Sys.ARCH === :x86_64) | ○ |
| C-54 | sys_arch_category arm | E-03 (L497: Sys.ARCH === :aarch64) | ○ |
| C-55 | define_editor登録 | E-04 (L92-115: define_editor実装) | ○ |
| C-56 | define_editor wait | E-04 (L102-103: if wait run(editor)) | ○ |
| C-57 | editor_matches文字列 | E-04 (L118: editor_matches(p::String, ...)) | ○ |
| C-58 | editor_matches Regex | E-04 (L117: editor_matches(p::Regex, ...)) | ○ |
| C-59 | editor_matches配列 | E-04 (L119: editor_matches(ps::AbstractArray, ...)) | ○ |
| C-60 | editor_matches不一致 | E-04 (L117-119: マッチ条件不成立) | ○ |
| C-61 | editor JULIA_EDITOR優先 | E-04 (L206-211: for var in [...]) | ○ |
| C-62 | editor VISUAL fallback | E-04 (L207: "VISUAL") | ○ |
| C-63 | editor EDITOR fallback | E-04 (L207: "EDITOR") | ○ |
| C-64 | editor空変数エラー | E-04 (L210: isempty(str) && error(...)) | ○ |
| C-65 | edit基本動作 | E-04 (L231-247: edit実装) | ○ |
| C-66 | edit .jlファイル解決 | E-04 (L233-235: endswith(path, ".jl")) | ○ |
| C-67 | edit関数引数 | E-04 (L263-269: edit(@nospecialize f)) | ○ |
| C-68 | edit Method引数 | E-04 (L270: edit(m::Method)) | ○ |
| C-69 | edit file=nothingエラー | E-04 (L274: edit(file::Nothing, ...)) | ○ |
| C-70 | edit Module引数 | E-04 (L275: edit(m::Module)) | ○ |
| C-71 | less基本動作 | E-04 (L305: less(file) = less(file, 1)) | ○ |
| C-72 | less行番号指定 | E-04 (L280-296: less実装) | ○ |
| C-73 | lessソースファイル不明 | E-04 (L315: less(file, line::Integer) = error(...)) | ○ |
| C-74 | clipboard(x)コピー | E-02 (L6-21/L64-71/L79-109: OS別clipboard実装) | △ |
| C-75 | clipboard()ペースト | E-02 (L23-31/L72-76/L111-142: OS別clipboard実装) | △ |
| C-76 | clipboard非文字列コピー | E-02 (L110: clipboard(x) = clipboard(sprint(print, x))) | ○ |
| C-77 | clipboardラウンドトリップ | E-02 (OS依存、実行環境に依存) | △ |
| C-78 | make_tuple_type基本 | E-05 (L15-36: make_tuple_type実装) | ○ |
| C-79 | make_tuple_type Vararg | E-05 (L20-21: Core.TypeofVararg判定) | ○ |
| C-80 | make_tuple_type複数Varargエラー | E-05 (L22: throw(ArgumentError(...))) | ○ |
| C-81 | make_tuple_type Vararg.N超過 | E-05 (L25: throw(ArgumentError(...))) | ○ |
| C-82 | make_tuple_type Vararg後型不整合 | E-05 (L30: throw(ArgumentError(...))) | ○ |
| C-83 | extract_where_parameters where式 | E-05 (L40-42: extract_where_parameters) | ○ |
| C-84 | extract_where_parameters非where | E-05 (L41: isexpr(ex, :where) || return ex, nothing) | ○ |
| C-85 | rewrap_where有効パラメータ | E-05 (L45-48: rewrap_where) | ○ |
| C-86 | rewrap_where nothing | E-05 (L46: isnothing(where_params) && return ex) | ○ |
| C-87 | get_typeof ::T 1引数 | E-05 (L59: isexpr(ex, :(::), 1)) | ○ |
| C-88 | get_typeof x::T 2引数 | E-05 (L60: isexpr(ex, :(::), 2)) | ○ |
| C-89 | get_typeof splat | E-05 (L61-63: isexpr(ex, :..., 1)) | ○ |
| C-90 | get_typeof一般変数 | E-05 (L66: :(Core.Typeof($ex))) | ○ |
| C-91 | is_broadcasting_call f.(x) | E-05 (L72: isexpr(ex, :.) && ...) | ○ |
| C-92 | is_broadcasting_call .+ | E-05 (L77: string(f)[1] == '.') | ○ |
| C-93 | is_broadcasting_call通常呼出 | E-05 (L69-79: 条件不成立) | ○ |
| C-94 | is_broadcasting_call非Expr | E-05 (L70: isa(ex, Expr) || return false) | ○ |
| C-95 | is_broadcasting_assignment .= | E-05 (L87: head[begin] == '.' && head[end] == '=') | ○ |
| C-96 | is_broadcasting_assignment通常代入 | E-05 (L82-88: 条件不成立) | ○ |
| C-97 | is_broadcasting_assignment .式 | E-05 (L84: isexpr(ex, :.) && return false) | ○ |
| C-98 | recursive_dotcalls!引数置換 | E-05 (L96-128: recursive_dotcalls!実装) | ○ |
| C-99 | recursive_dotcalls!再帰処理 | E-05 (L105-108: 再帰呼び出し) | ○ |
| C-100 | extract_farg型注釈付き | E-05 (L130-134: extract_farg) | ○ |
| C-101 | extract_farg型注釈なし | E-05 (L131: !isexpr(arg, ...) && return arg) | ○ |
| C-102 | construct_callableシングルトン | E-05 (L138: Base.issingletontype(func)) | ○ |
| C-103 | construct_callable非シングルトンエラー | E-05 (L142: throw(ArgumentError(...))) | ○ |
| C-104 | separate_kwargs分離 | E-05 (L146-161: separate_kwargs) | ○ |
| C-105 | separate_kwargs parameters | E-05 (L152-154: isexpr(ex, :parameters)) | ○ |
| C-106 | separate_kwargs kwなし | E-05 (L146-161: pushなしの場合) | ○ |
| C-107 | are_kwargs_valid有効 | E-05 (L163-174: are_kwargs_valid) | ○ |
| C-108 | are_kwargs_valid splat | E-05 (L165: isexpr(kwarg, :..., 1)) | ○ |
| C-109 | are_kwargs_valid Symbol | E-05 (L168: isa(kwarg, Symbol)) | ○ |
| C-110 | are_kwargs_valid不正 | E-05 (L171: return false) | ○ |
| C-111 | merge_namedtuple_typesマージ | E-05 (L213-230: merge_namedtuple_types) | ○ |
| C-112 | merge_namedtuple_types重複キー | E-05 (L222-224: i findfirst, types[i] = type) | ○ |
| C-113 | merge_namedtuple_types単一型 | E-05 (L215: isempty(nts) && return nt) | ○ |
| C-114 | typeof_nt NamedTuple | E-05 (L210: typeof_nt(nt::NamedTuple)) | ○ |
| C-115 | typeof_nt Pairs | E-05 (L211: typeof_nt(nt::Base.Pairs)) | ○ |
| C-116 | gen_call_with_extracted_types関数呼出 | E-05 (L386-534: 実装全体) | ○ |
| C-117 | gen_call_with_extracted_types代入右辺 | E-05 (L388-389: ex0.head === :(=)) | ○ |
| C-118 | gen_call_with_extracted_typesキーワード | E-05 (L462-470: kwcall処理) | ○ |
| C-119 | gen_call_with_extracted_types ref式 | E-05 (L506-509: ex0.head === :ref) | ○ |
| C-120 | gen_call_with_extracted_typesドット式 | E-05 (L421-454: isexpr(ex0, :.)) | ○ |
| C-121 | gen_call_with_extracted_typesブロードキャスト | E-05 (L407-419: is_broadcasting_expr) | ○ |
| C-122 | gen_call_with_extracted_typesブロードキャスト+source | E-05 (L456-461: error文) | ○ |
| C-123 | gen_call_with_extracted_typesマクロ式 | E-05 (L522-524: ex0.head === :macrocall) | ○ |
| C-124 | gen_call_with_extracted_types vcat | E-05 (L489-505: :vcat/:typed_vcat) | ○ |
| C-125 | gen_call_with_extracted_types hcat | E-05 (L511: :hcat => Base.hcat) | ○ |
| C-126 | gen_call_with_extracted_types adjoint | E-05 (L514: Symbol("'") => Base.adjoint) | ○ |
| C-127 | gen_call_with_extracted_types setproperty | E-05 (L482: lhs.head === :(.)) | ○ |
| C-128 | gen_call_with_extracted_types setindex | E-05 (L483-486: lhs.head === :ref) | ○ |
| C-129 | gen_call_with_extracted_types do式 | E-05 (L397-405: ex0.head === :do) | ○ |
| C-130 | gen_call_with_extracted_types解析不能 | E-05 (L528-533: error(...)) | ○ |
| C-131 | gen_call_with_extracted_types signature tuple | E-05 (L244-245: use_signature_tuple分岐) | ○ |
| C-132 | gen_call_with_extracted_types literal_pow | E-05 (L473-475: ex0.args[1] === :^) | ○ |
| C-133 | gen_call_with_extracted_types_and_kwargs | E-05 (L541-556: 実装) | ○ |
| C-134 | gen_call_with_extracted_types_and_kwargs余分引数 | E-05 (L552: error文) | ○ |
| C-135 | @activate Compiler | E-05 (L806-834: @activate実装) | ○ |
| C-136 | @activate with options | E-05 (L808-815: isexpr(what, :ref)) | ○ |
| C-137 | @activate未認識コンポーネント | E-05 (L825: error(...)) | ○ |
| C-138 | @activate非Symbol | E-05 (L820-821: error(...)) | ○ |
| C-139 | skip_type_check自由型変数 | E-05 (L38: Core.has_free_typevars(T)) | ○ |
| C-140 | skip_type_check具象型 | E-05 (L38: falseを返す) | ○ |
| C-141 | is_code_macro code_ | E-05 (L291: startswith(string(fcn), "code_")) | ○ |
| C-142 | is_code_macro非code_ | E-05 (L291: falseを返す) | ○ |
| C-143 | peakflops基本動作 | E-01 (L340-347: peakflops実装) | △ |
| C-144 | peakflopsサイズ指定 | E-01 (L340: n::Integer=4096) | △ |
| C-145 | reescape非Expr | E-05 (L51: isa(ex, Expr) || return f(ex)) | ○ |
| C-146 | reescape Expr | E-05 (L50-55: reescape実装) | ○ |
| C-147 | generate_namedtuple_type | E-05 (L200-208: generate_namedtuple_type) | ○ |
| C-148 | generate_merged_namedtuple_type | E-05 (L177-198: generate_merged_namedtuple_type) | ○ |
| C-149 | generate_merged_namedtuple_type splat | E-05 (L181-186: isexpr(ex, :..., 1)) | ○ |
| C-150 | print_llvm_operandカンマ境界 | E-03 (L422-427: カンママッチ) | ○ |
| C-151 | print_llvm_operand括弧 | E-03 (L440-445: 括弧マッチ) | ○ |
| C-152 | print_native_tokens x86 | E-03 (L511-571: x86トークン処理) | ○ |
| C-153 | print_native_tokens ARM | E-03 (L511-571: ARM分岐) | ○ |
| C-154 | print_native_tokens未サポート | E-03 (L504: print(io, line)) | ○ |
| C-155 | fixup_hygiene ##S# | E-05 (L276-289: fixup_hygiene_for_ref_temporary!) | ○ |
| C-156 | fixup_hygiene非対象 | E-05 (L287: startswith条件不成立) | ○ |

## 4) 不足情報（Unknown / Missing）
- **clipboard関数のOS別動作（C-74, C-75, C-77）**：各OS固有のクリップボードコマンド（pbcopy/pbpaste, xsel/xclip, Windows API）に依存しており、テスト環境で実際にクリップボードが利用可能かはランタイムに依存する。単体テストとしてはモック化が必要な可能性がある。
  - 候補：CI環境でのクリップボード利用可否確認 / OS判定によるテストスキップ / モックフレームワーク利用
- **peakflops関数（C-143, C-144）**：LinearAlgebra stdlibへの動的依存（Base.require_stdlib）があり、テスト環境でLinearAlgebraが利用可能でない場合の動作が不明。
  - 候補：LinearAlgebraのインストール確認 / 条件付きテスト実行
- **report_bug関数**：BugReportingパッケージへの外部依存とネットワーク通信を含むため、単体テストケースの生成対象外とした。
  - 候補：モック化テスト / 統合テストとして別途実施
- **clipboardcmd（Linux/FreeBSD）（C-74, C-75）**：xsel/xclip/wl-clipboardのインストール状態に依存するため、テスト環境への前提条件が必要。
  - 候補：テスト環境にxclipをインストール / which コマンドのモック化

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: clipboard関連テスト（UT-INU-074〜077）はOS・環境依存が強く、CIでは失敗する可能性がある。テスト実行時にOS判定やクリップボードコマンドの存在確認を前提条件とすべき。
- **リスク0（低）**: codeview関連テスト（UT-INU-037〜054）はコンパイラの内部実装に依存するため、Juliaバージョンアップ時に出力形式が変わる可能性がある。出力の厳密な文字列一致ではなく、構造的な検証が推奨。
- **リスク0（低）**: macros.jl内のExpr生成テスト（UT-INU-116〜134）は生成されるExprの構造を検証するが、Juliaの内部表現が変更された場合に影響を受ける可能性がある。
- **リスク1（中）**: peakflops（UT-INU-143〜144）はLinearAlgebra stdlibのロードが必要で、環境によってはタイムアウトや利用不可の可能性がある。

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがInteractiveUtils内の全publicエクスポート関数をカバーしているか確認
- [ ] clipboard関連テストのOS依存性が適切にハンドルされているか確認
- [ ] codeview関連テスト（code_warntype, code_llvm, code_native）の期待結果が実行環境非依存か確認
- [ ] マクロテスト（@which, @edit, @code_typed等）がExpr構造を正しく検証しているか確認
- [ ] report_bug関数がテスト対象外とされた理由が妥当か確認
- [ ] peakflops関数のLinearAlgebra依存がテスト環境で問題にならないか確認
- [ ] テストID（UT-INU-xxx）が一意で連番が正しいか確認
- [ ] 各テストケースの優先度（高/中/低）が適切に設定されているか確認
