---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 298
  claims_with_evidence: 290
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：stdlib-Markdown 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：290 / 298、根拠なし：8
- 優先レビュー（高）
  1. **ターミナル出力のAnnotatedString動作**: AnnotatedIOBuffer/AnnotatedStringのフェイス適用の詳細な期待結果が実行環境依存
  2. **bestmime関数の型判定テスト**: showableの判定対象となる具体的なオブジェクトが不明
  3. **styled言語コードブロック**: StyledStrings.styled関数の具体的な出力がランタイム依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Markdown/src/Markdown.jl` - モジュール定義、parse関数、マクロ定義
- E-02: `stdlib/Markdown/src/parse/parse.jl` - MD型定義、parseinline、_parse、parse(IO)
- E-03: `stdlib/Markdown/src/parse/config.jl` - Config型定義、@flavor、@breaking、@trigger マクロ
- E-04: `stdlib/Markdown/src/parse/util.jl` - skipwhitespace、blankline、startswith、withstream、eatindent、readuntil、parse_inline_wrapper
- E-05: `stdlib/Markdown/src/Common/Common.jl` - @flavor common定義
- E-06: `stdlib/Markdown/src/Common/block.jl` - Paragraph、Header、Code、Footnote、BlockQuote、Admonition、List、HorizontalRule、HTMLBlock型と対応するパーサー
- E-07: `stdlib/Markdown/src/Common/inline.jl` - Italic、Bold、Strikethrough、Code(inline)、Image、Link、Footnote(inline)、LineBreak、escapes、entity、autolink
- E-08: `stdlib/Markdown/src/Common/entities.jl` - HTMLエンティティ辞書
- E-09: `stdlib/Markdown/src/GitHub/GitHub.jl` - @flavor github定義、github_paragraph
- E-10: `stdlib/Markdown/src/GitHub/table.jl` - Table型、parserow、parsealign、rowlength!、colwidths、padding、padcells!、各レンダラ
- E-11: `stdlib/Markdown/src/IPython/IPython.jl` - LaTeX型、tex、blocktex
- E-12: `stdlib/Markdown/src/Julia/Julia.jl` - @flavor julia定義
- E-13: `stdlib/Markdown/src/Julia/interp.jl` - interp、interpinner、blockinterp、toexpr
- E-14: `stdlib/Markdown/src/render/html.jl` - html関数群、htmlinline関数群、htmlesc、withtag、encode_uri_component、show(text/html)
- E-15: `stdlib/Markdown/src/render/plain.jl` - plain関数群、plaininline関数群、show(text/markdown)
- E-16: `stdlib/Markdown/src/render/latex.jl` - latex関数群、latexinline関数群、latexesc、wrapblock、wrapinline、show(text/latex)
- E-17: `stdlib/Markdown/src/render/rst.jl` - rst関数群、rstinline関数群、rstescape、show(text/rst)
- E-18: `stdlib/Markdown/src/render/terminal/render.jl` - term関数群、terminline関数群、show(text/plain)
- E-19: `stdlib/Markdown/src/render/terminal/formatting.jl` - annotprint、with_output_annotations、wraplines、insert_hlines
- E-20: `stdlib/Markdown/src/render/rich.jl` - tohtml関数群、bestmime

## 3) Claims と根拠の対応（レビューの主戦場）

### パーサー（parse/）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | MD型のコンストラクタが正しく動作する（UT-MKD-001〜003） | E-02 | ○ |
| C-002 | MD型の配列メソッド委譲が正しく動作する（UT-MKD-004〜010） | E-02 | ○ |
| C-003 | MD型の==がHTML比較で動作する（UT-MKD-011〜012） | E-02 | ○ |
| C-004 | parse関数がIO/String/AbstractStringから正しくパースする（UT-MKD-013〜016） | E-01, E-02 | ○ |
| C-005 | parse_file関数がファイルからパースする（UT-MKD-017） | E-01 | ○ |
| C-006 | parseinline関数がインライン要素を正しくパースする（UT-MKD-018〜019） | E-02 | ○ |
| C-007 | _parse関数がブロックレベル要素を正しくパースする（UT-MKD-020〜021） | E-02 | ○ |
| C-008 | Config構築と関連関数が正しく動作する（UT-MKD-249〜253） | E-03 | ○ |
| C-009 | ユーティリティ関数群が正しく動作する（UT-MKD-254〜277） | E-04 | ○ |

### ブロック要素（Common/block.jl）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-010 | Paragraphがパースされる（UT-MKD-022〜024） | E-06 | ○ |
| C-011 | hashheaderがレベル1〜6をパースし、レベル7以上を拒否する（UT-MKD-025〜030） | E-06 | ○ |
| C-012 | setextheaderが=/-下線を正しくパースする（UT-MKD-031〜033） | E-06 | ○ |
| C-013 | fencedcodeがバッククォート/チルダフェンスを正しくパースする（UT-MKD-034〜038） | E-06 | ○ |
| C-014 | indentcodeが4スペース/タブインデントを正しくパースする（UT-MKD-039〜041） | E-06 | ○ |
| C-015 | footnoteが脚注を正しくパースする（UT-MKD-042〜044） | E-06 | ○ |
| C-016 | blockquoteが引用ブロックを正しくパースする（UT-MKD-045〜047） | E-06 | ○ |
| C-017 | admonitionが!!! 構文を正しくパースする（UT-MKD-048〜050） | E-06 | ○ |
| C-018 | listが箇条書き/番号付きリストを正しくパースする（UT-MKD-051〜058） | E-06 | ○ |
| C-019 | horizontalruleが水平線を正しくパースする（UT-MKD-059〜062） | E-06 | ○ |
| C-020 | HTMLブロックが各タイプを正しくパースする（UT-MKD-063〜067） | E-06 | ○ |
| C-021 | コンストラクタが正しく動作する（UT-MKD-292〜298） | E-06 | ○ |

### インライン要素（Common/inline.jl）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-022 | Italic/Bold/Strikethroughが正しくパースされる（UT-MKD-068〜075） | E-07 | ○ |
| C-023 | インラインCodeが奇数/偶数バッククォートで切り替わる（UT-MKD-076〜079） | E-07 | ○ |
| C-024 | Image/Link/Footnoteが正しくパースされる（UT-MKD-080〜089） | E-07 | ○ |
| C-025 | LineBreak/escapes/entityが正しくパースされる（UT-MKD-090〜098） | E-07 | ○ |
| C-026 | replace_escapes_and_entitiesが正しく動作する（UT-MKD-099〜100） | E-07 | ○ |
| C-027 | _is_link/_is_email/_is_mailtoが正しく判定する（UT-MKD-101〜107） | E-07 | ○ |
| C-028 | en_or_em_dashが正しく変換する（UT-MKD-108〜109） | E-07 | ○ |

### GitHub拡張（GitHub/）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-029 | Tableが正しくパースされる（UT-MKD-110〜112） | E-10 | ○ |
| C-030 | parserow/parsealign/rowlength!が正しく動作する（UT-MKD-113〜121） | E-10 | ○ |
| C-031 | colwidths/padding/padcells!が正しく動作する（UT-MKD-122〜127） | E-10 | ○ |
| C-032 | _dash/mapmapが正しく動作する（UT-MKD-128〜131） | E-10 | ○ |
| C-033 | github_paragraphが正しくパースする（UT-MKD-282〜283） | E-09 | ○ |

### IPython/Julia拡張
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-034 | LaTeXインライン/ブロックが正しくパースされる（UT-MKD-132〜134） | E-11 | ○ |
| C-035 | interp/interpinner/blockinterpが正しく動作する（UT-MKD-135〜139） | E-13 | ○ |
| C-036 | toexprが各MD要素をExprに変換する（UT-MKD-140〜142） | E-13 | ○ |

### HTMLレンダラ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-037 | ブロック要素がHTMLに正しく変換される（UT-MKD-143〜156） | E-14 | ○ |
| C-038 | インライン要素がHTMLに正しく変換される（UT-MKD-157〜164） | E-14 | ○ |
| C-039 | htmlesc/withtag/encode_uri_componentが正しく動作する（UT-MKD-165〜171） | E-14 | ○ |
| C-040 | MIME text/html出力が正しい（UT-MKD-172） | E-14 | ○ |

### プレーンテキストレンダラ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | ブロック要素がプレーンテキストに正しく変換される（UT-MKD-173〜183） | E-15 | ○ |
| C-042 | インライン要素がプレーンテキストに正しく変換される（UT-MKD-184〜190） | E-15 | ○ |
| C-043 | show/MIME出力が正しい（UT-MKD-191〜192） | E-15 | ○ |

### LaTeXレンダラ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-044 | ブロック要素がLaTeXに正しく変換される（UT-MKD-193〜199） | E-16 | ○ |
| C-045 | latexesc/latexinlineが正しく動作する（UT-MKD-200〜209） | E-16 | ○ |
| C-046 | MIME text/latex出力が正しい（UT-MKD-210） | E-16 | ○ |

### reSTレンダラ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-047 | ブロック/インライン要素がreSTに正しく変換される（UT-MKD-211〜222） | E-17 | ○ |

### ターミナルレンダラ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-048 | ブロック要素がターミナル形式に正しく変換される（UT-MKD-223〜231） | E-18 | ○ |
| C-049 | terminline関数でBold/Italic等がフェイス付きで出力される（UT-MKD-232〜236） | E-18 | △ |
| C-050 | MIME text/plain出力が正しい（UT-MKD-237） | E-18 | ○ |

### フォーマッティング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-051 | annotprint/wraplines/with_output_annotationsが正しく動作する（UT-MKD-238〜242） | E-19 | ○ |
| C-052 | insert_hlinesが正しく動作する（UT-MKD-243〜244） | E-19 | ○ |

### リッチ出力
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-053 | bestmime/tohtmlが正しく動作する（UT-MKD-245〜248） | E-20 | △ |

### モジュールレベル
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-054 | mdexpr/doc_str/catdocが正しく動作する（UT-MKD-278〜281） | E-01 | ○ |
| C-055 | テーブルの各レンダラ出力が正しい（UT-MKD-284〜288） | E-10 | ○ |
| C-056 | htmlinline文字列の空白処理が正しい（UT-MKD-289） | E-14 | ○ |
| C-057 | htmltight/percent_escapeが正しく動作する（UT-MKD-290〜291） | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- ターミナルレンダラのAnnotatedString/AnnotatedIOBufferのフェイス適用動作は、StyledStringsパッケージの実装に依存しており、具体的な出力文字列の期待値を確定させるにはランタイム実行が必要
  - 候補：StyledStrings.jl ドキュメント / JuliaSyntaxHighlighting.jl ドキュメント / 実行時のテスト出力
- bestmime関数のテストで使用する「表示可能/不可能な値」の具体例がソースコードからは直接特定できない
  - 候補：Base.showable のドキュメント / MIME表示に対応したカスタム型の定義
- entities.jlのエンティティ辞書は25000トークン超のため全量確認を実施していない
  - 候補：CommonMark仕様のエンティティ一覧との照合

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パーサー部分のテストケースはソースコードの条件分岐から直接導出しており信頼性が高い
- 0: 低リスク - レンダラ部分のテストケースは出力フォーマットの仕様が明確
- 1: 中リスク - ターミナルレンダラのフェイス適用テストはStyledStrings依存のため期待結果の精度に限界がある
- 1: 中リスク - tohtml/bestmimeのテストは外部型のshowable判定に依存するためモック化が必要な可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 全298件のテストケースが、ソースコード内の全public関数/メソッドをカバーしているか確認
- [ ] 各パーサー関数に対して正常系・異常系・境界値のテストが含まれているか確認
- [ ] HTMLレンダラのテストで、HTML特殊文字のエスケープが十分にカバーされているか確認
- [ ] テーブル関連のテストで、列数不一致・空テーブル等のエッジケースがカバーされているか確認
- [ ] ターミナルレンダラのテストで、AnnotatedString関連の期待結果が実行環境と整合しているか確認
- [ ] LaTeXレンダラのテストで、LaTeX特殊文字のエスケープが網羅されているか確認
- [ ] 各フレーバー（common/github/julia）固有の機能がテストされているか確認
- [ ] entities.jlの全エンティティ辞書がCommonMark仕様と整合しているか確認
