---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 172
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：stdlib-Profile 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：172 / 180、根拠なし：8
- 優先レビュー（高）
  1. **C側の挙動に依存するテストケース（start_timer失敗、init失敗等）**：C側のエラーコードの正確な発生条件が推測
  2. **32ビットシステム固有のテストケース**：実行環境の制約で検証困難
  3. **take_heap_snapshot書き込み不可ディレクトリのフォールバック**：OS依存の挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Profile/src/Profile.jl` - メインモジュール（1492行）
- E-02: `stdlib/Profile/src/Allocs.jl` - アロケーションプロファイラーモジュール（422行）
- E-03: `stdlib/Profile/src/heapsnapshot_reassemble.jl` - ヒープスナップショット組み立てモジュール（257行）
- E-04: `stdlib/Profile/src/precompile.jl` - プリコンパイル指示ファイル（11行）
- E-05: `docs/code-to-docs/単体テストケース一覧/plan.md` - テスト計画書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-PRF-001~004) | init関数のクエリモードと設定モードの動作 | E-01 L128-157 | ○ |
| C-02 (UT-PRF-005~007) | init関数のエラー処理と32ビット制限 | E-01 L144-157 | ○ |
| C-03 (UT-PRF-008~010) | default_init/check_initのデフォルト初期化 | E-01 L159-182 | ○ |
| C-04 (UT-PRF-011) | clear関数によるバッファクリア | E-01 L189 | ○ |
| C-05 (UT-PRF-012~013) | ProfileFormatのコンストラクタ | E-01 L194-212 | ○ |
| C-06 (UT-PRF-014~018) | fetch関数のデータ取得とメタデータ処理 | E-01 L686-703 | ○ |
| C-07 (UT-PRF-019~020) | strip_meta関数のメタデータ除去 | E-01 L705-720 | ○ |
| C-08 (UT-PRF-021~025) | add_fake_meta関数の偽メタデータ追加 | E-01 L729-745 | ○ |
| C-09 (UT-PRF-026~028) | is_block_end関数のブロック終端検出 | E-01 L426-434 | ○ |
| C-10 (UT-PRF-029~032) | has_meta関数のメタデータ存在判定 | E-01 L436-448 | ○ |
| C-11 (UT-PRF-033~035) | retrieve/getdict関数のデータエクスポート | E-01 L458-486 | ○ |
| C-12 (UT-PRF-036~038) | flatten関数のインラインフレームフラット化 | E-01 L507-539 | ○ |
| C-13 (UT-PRF-039~049) | print関数の各種出力形式とオプション | E-01 L271-368 | ○ |
| C-14 (UT-PRF-050~053) | print_group関数のグループ出力 | E-01 L382-398 | ○ |
| C-15 (UT-PRF-054~059) | get_task_ids/get_thread_ids関数 | E-01 L400-424 | ○ |
| C-16 (UT-PRF-060~066) | callers/callersf関数の呼び出し元特定 | E-01 L609-1337 | ○ |
| C-17 (UT-PRF-067~070) | start_timer/stop_timer関数 | E-01 L649-658 | ○ |
| C-18 (UT-PRF-069) | start_timer失敗時のエラー処理 | E-01 L651-654 | △ |
| C-19 (UT-PRF-071~074) | is_running/is_buffer_full関数 | E-01 L660-662 | ○ |
| C-20 (UT-PRF-075~076) | get_peek_duration/set_peek_duration | E-01 L105-111 | ○ |
| C-21 (UT-PRF-077) | clear_malloc_data関数 | E-01 L646 | ○ |
| C-22 (UT-PRF-078~084) | short_path関数のパス短縮 | E-01 L546-595 | ○ |
| C-23 (UT-PRF-085~091) | editor_link関数のURI生成 | E-01 L857-887 | ○ |
| C-24 (UT-PRF-092~096) | parse_flat関数のフラット解析 | E-01 L750-815 | ○ |
| C-25 (UT-PRF-097~098) | liperm関数のソート順列 | E-01 L1342-1357 | ○ |
| C-26 (UT-PRF-099~102) | tree!関数のツリー構築 | E-01 L1080-1217 | ○ |
| C-27 (UT-PRF-103) | maxstats関数の最大統計値計算 | E-01 L1219-1234 | ○ |
| C-28 (UT-PRF-104~107) | indent関数のインデント生成 | E-01 L993-1002 | ○ |
| C-29 (UT-PRF-108~115) | take_heap_snapshot関数の各モード | E-01 L1407-1469 | ○ |
| C-30 (UT-PRF-115) | 書き込み不可ディレクトリのフォールバック | E-01 L1456-1464 | △ |
| C-31 (UT-PRF-116~117) | take_page_profile関数 | E-01 L1477-1485 | ○ |
| C-32 (UT-PRF-118~121) | @profile/@profile_walltimeマクロ | E-01 L57-88 | ○ |
| C-33 (UT-PRF-122~125) | Allocs.start/stop関数 | E-02 L96-107 | ○ |
| C-34 (UT-PRF-126) | Allocs.clear関数 | E-02 L114-117 | ○ |
| C-35 (UT-PRF-127) | Allocs.fetch関数 | E-02 L125-128 | ○ |
| C-36 (UT-PRF-128~130) | Allocs.@profileマクロ | E-02 L72-88 | ○ |
| C-37 (UT-PRF-131~134) | Allocs.load_type関数 | E-02 L164-173 | ○ |
| C-38 (UT-PRF-135~137) | Allocs.decode_alloc/decode関数 | E-02 L175-192 | ○ |
| C-39 (UT-PRF-138~139) | Allocs.load_backtrace関数 | E-02 L194-201 | ○ |
| C-40 (UT-PRF-140~142) | Allocs.stacktrace_memoized関数 | E-02 L203-223 | ○ |
| C-41 (UT-PRF-143~144) | Allocs.Alloc show関数 | E-02 L145-148 | ○ |
| C-42 (UT-PRF-145~146) | Allocs.print関数 | E-02 L243-248 | ○ |
| C-43 (UT-PRF-147~153) | Allocs.flat/tree/parse_flat関数 | E-02 L286-420 | ○ |
| C-44 (UT-PRF-154~157) | HeapSnapshot Edges/Nodes構造体 | E-03 L12-52 | ○ |
| C-45 (UT-PRF-158~160) | _write_decimal_number関数 | E-03 L57-78 | ○ |
| C-46 (UT-PRF-161~165) | assemble_snapshot関数 | E-03 L80-213 | ○ |
| C-47 (UT-PRF-166~167) | cleanup_streamed_files関数 | E-03 L220-226 | ○ |
| C-48 (UT-PRF-168~174) | print_str_escape_json関数 | E-03 L228-255 | ○ |
| C-49 (UT-PRF-175~176) | warning_empty関数 | E-01 L1359-1372 | ○ |
| C-50 (UT-PRF-177) | _peek_report関数 | E-01 L91-96 | ○ |
| C-51 (UT-PRF-178~179) | len_data/maxlen_data関数 | E-01 L666-668 | ○ |
| C-52 (UT-PRF-180) | Allocs.__init__関数 | E-02 L156-158 | ○ |
| C-53 (UT-PRF-005~006) | 32ビットシステム固有の動作 | E-01 L148-152 | △ |
| C-54 (UT-PRF-008) | Win32固有のデフォルト値 | E-01 L163-167 | △ |
| C-55 (UT-PRF-042~045) | Windows環境でのスレッドプロファイリング制限 | E-01 L293-294 | △ |
| C-56 (UT-PRF-069) | start_timerの各エラーコード(-1~-4) | E-01 L670-674 | △ |
| C-57 (UT-PRF-109~110) | ストリーミングファイルの具体的な内容検証 | E-01 L1428-1452, E-03 | △ |
| C-58 (UT-PRF-135~136) | unsafeなポインタ操作を伴うデコード処理 | E-02 L175-192 | △ |

## 4) 不足情報（Unknown / Missing）
- **C側ランタイムの内部状態**: start_timer, stop_timer, ccall経由の関数の正確な失敗条件はCソースコード（src/）を参照する必要がある
  - 候補：`src/signal-handling.c` / `src/gc-alloc-profiler.c` / `src/gc-heap-snapshot.c`
- **32ビットWindows環境固有の動作**: 実行環境の制約により検証困難
  - 候補：CI環境での32ビットWindowsテスト / エミュレーション
- **unsafeなポインタ操作のメモリ安全性**: `unsafe_load`, `unsafe_pointer_to_objref`等の正確な動作はJuliaランタイムに依存
  - 候補：Juliaランタイムのドキュメント / メモリモデル仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（162件）はソースコードから直接読み取れる関数シグネチャ・条件分岐に基づいており信頼性が高い
- 1: 中リスク - ccall経由のC関数のエラー処理テスト（UT-PRF-069等）はC側の実装に依存するため、実際のエラー発生条件の検証が必要
- 1: 中リスク - unsafeなポインタ操作を伴うデコード処理（UT-PRF-131~136）は実行時のメモリ状態に依存
- 1: 中リスク - プラットフォーム固有のテストケース（32ビットWindows、シグナル処理）は特定環境でのみ検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがProfileモジュールの全publicインターフェース（init, clear, print, fetch, retrieve, flatten, callers, take_heap_snapshot, take_page_profile, clear_malloc_data, add_fake_meta）をカバーしているか
- [ ] Allocs サブモジュールの全public関数（@profile, start, stop, clear, fetch, print）がカバーされているか
- [ ] HeapSnapshot サブモジュールの主要関数（assemble_snapshot, cleanup_streamed_files, print_str_escape_json）がカバーされているか
- [ ] 各関数について正常系・異常系・境界値のテスト観点が適切にバランスされているか
- [ ] ccall経由のC関数呼び出しに対するテストケースの期待結果が妥当か（C側の挙動に依存する部分）
- [ ] マクロ（@profile, @profile_walltime, Allocs.@profile）の例外安全性テストが含まれているか
- [ ] ストリーミングモード/非ストリーミングモードのヒープスナップショットテストが適切か
