---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 192
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：stdlib-REPL 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：192 / 200、根拠なし：8
- 優先レビュー（高）
  1. **UT-RPL-017, UT-RPL-018（modules_to_be_loaded）**：lowered Exprの正確な構造はコンパイラ内部に依存し、テスト時の入力値の再現が困難
  2. **UT-RPL-035, UT-RPL-036（collect_qualified_access_warnings）**：公開/非公開の判定はBase.ispublicの挙動に依存し、テスト前提条件の構築が複雑
  3. **UT-RPL-051, UT-RPL-052（completions）**：REPLCompletions.completionsの戻り値は環境（ロード済みモジュール等）に強く依存
  4. **UT-RPL-133, UT-RPL-134（HistoryFile update!）**：履歴ファイルのバイナリフォーマットの詳細な検証が必要
  5. **UT-RPL-148（Pkg_promptf）**：実行環境のプロジェクト状態に依存する動的テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/REPL/src/REPL.jl` - メインREPLモジュール（softscope, ends_with_semicolon, has_ancestor, retrieve_modules, modules_to_be_loaded, LimitIO, REPLBackend, banner, contextual_prompt等）
- E-02: `stdlib/REPL/src/REPLCompletions.jl` - 補完エンジン（completions, bslash_completions, shell_completions, complete_path, complete_keyword!, complete_methods等）
- E-03: `stdlib/REPL/src/docview.jl` - ドキュメントビュー（helpmode, _helpmode, trimdocs, symbol_latex, matchinds, fuzzyscore, levenshtein, stripmd, docsearch, summarize, AccessibleBinding等）
- E-04: `stdlib/REPL/src/options.jl` - Optionsの定義（全フィールドとデフォルト値）
- E-05: `stdlib/REPL/src/SyntaxUtil.jl` - 構文ユーティリティ（CursorNode, seek_pos, find_parent, char_range, children_nt, find_delim）
- E-06: `stdlib/REPL/src/StylingPasses.jl` - スタイリングパス（StylingContext, merge_annotations, apply_styling_passes, SyntaxHighlightPass, RegionHighlightPass, EnclosingParenHighlightPass, find_enclosing_parens）
- E-07: `stdlib/REPL/src/History/histfile.jl` - 履歴ファイル（HistoryFile, HistEntry, update!, push!）
- E-08: `stdlib/REPL/src/History/History.jl` - 履歴モジュール定義
- E-09: `stdlib/REPL/src/Pkg_beforeload.jl` - Pkgプリロード（safe_realpath, find_project_file, projname, Pkg_promptf）
- E-10: `stdlib/REPL/src/TerminalMenus/RadioMenu.jl` - RadioMenu（コンストラクタ, pick, cancel, keypress）
- E-11: `stdlib/REPL/src/TerminalMenus/MultiSelectMenu.jl` - MultiSelectMenu（コンストラクタ, pick, cancel, keypress, header）
- E-12: `stdlib/REPL/src/TerminalMenus/config.jl` - Config, MultiSelectConfig（charset, cursor, arrows）
- E-13: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` - AbstractMenu（move_up!, move_down!, page_up!, page_down!, printmenu）
- E-14: `stdlib/REPL/src/TerminalMenus/Pager.jl` - Pager（コンストラクタ, header, pick, cancel）
- E-15: `stdlib/REPL/src/LineEdit.jl` - ラインエディタ（Prompt, MIState, PromptState, NamedCompletion, region, activate_region, input_string）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-RPL-001~005) | softscopeの各分岐テスト | E-01 (REPL.jl L157-173) | ○ |
| C-02 (UT-RPL-006~009) | ends_with_semicolonの判定テスト | E-01 (REPL.jl L1726-1733) | ○ |
| C-03 (UT-RPL-010~012) | has_ancestorのモジュール判定テスト | E-01 (REPL.jl L182-190) | ○ |
| C-04 (UT-RPL-013~016) | retrieve_modulesのモジュール取得テスト | E-01 (REPL.jl L192-210) | ○ |
| C-05 (UT-RPL-017~018) | modules_to_be_loadedのモジュール検出テスト | E-01 (REPL.jl L372-414) | △ |
| C-06 (UT-RPL-019~020) | REPLBackend/REPLBackendRefのコンストラクタ | E-01 (REPL.jl L118-140) | ○ |
| C-07 (UT-RPL-021~025) | LimitIOの書き込み制限テスト | E-01 (REPL.jl L478-521) | ○ |
| C-08 (UT-RPL-026~028) | beforecursor/to_regionの変換テスト | E-01 (REPL.jl L847-850) | ○ |
| C-09 (UT-RPL-029~030) | find_hist_fileのパス検索テスト | E-01 (REPL.jl L1141-1143) | ○ |
| C-10 (UT-RPL-031~032) | contextual_promptのプロンプト生成テスト | E-01 (REPL.jl L1236-1243) | ○ |
| C-11 (UT-RPL-033~034) | bannerの出力テスト | E-01 (REPL.jl L1735-1803) | ○ |
| C-12 (UT-RPL-035~036) | collect_qualified_access_warningsの警告収集テスト | E-01 (REPL.jl L281-297) | △ |
| C-13 (UT-RPL-037~038) | Numbered.repl_eval_counter/out_transformテスト | E-01 (REPL.jl L1842-1851) | ○ |
| C-14 (UT-RPL-039~041) | Optionsのコンストラクタテスト | E-04 (options.jl L5-66) | ○ |
| C-15 (UT-RPL-042~050) | completion_text/named_completion/completes_globalテスト | E-02 (REPLCompletions.jl L114-143) | ○ |
| C-16 (UT-RPL-051~053) | completions関数の基本動作テスト | E-02 (REPLCompletions.jl L999-1156) | △ |
| C-17 (UT-RPL-054~058) | bslash_completionsのLaTeX/絵文字補完テスト | E-02 (REPLCompletions.jl L859-887) | ○ |
| C-18 (UT-RPL-059~060) | shell_completionsのシェル補完テスト | E-02 (REPLCompletions.jl L1303-1342) | ○ |
| C-19 (UT-RPL-061~063) | complete_pathのパス補完テスト | E-02 (REPLCompletions.jl L437-491) | ○ |
| C-20 (UT-RPL-064~065) | complete_keyword!のキーワード補完テスト | E-02 (REPLCompletions.jl L304-306) | ○ |
| C-21 (UT-RPL-066~067) | complete_methodsのメソッド補完テスト | E-02 (REPLCompletions.jl L719-728) | ○ |
| C-22 (UT-RPL-068~069) | find_dict_matchesの辞書キー補完テスト | E-02 (REPLCompletions.jl L890-897) | ○ |
| C-23 (UT-RPL-070) | get_loading_candidatesのパッケージ候補テスト | E-02 (REPLCompletions.jl L942-956) | ○ |
| C-24 (UT-RPL-071~073) | do_string_escape/unescapeテスト | E-02 (REPLCompletions.jl L318-329) | ○ |
| C-25 (UT-RPL-074~076) | expr_has_errorのエラー式検出テスト | E-02 (REPLCompletions.jl L1165-1169) | ○ |
| C-26 (UT-RPL-077) | appendmacro!のマクロ補完テスト | E-02 (REPLCompletions.jl L144-153) | ○ |
| C-27 (UT-RPL-078~079) | field_completion_eligibleのフィールド補完テスト | E-02 (REPLCompletions.jl L267-276) | ○ |
| C-28 (UT-RPL-080~082) | joinpath_withsepのパス結合テスト | E-02 (REPLCompletions.jl L331-334) | ○ |
| C-29 (UT-RPL-083~086) | helpmode/_helpmodeのヘルプモードテスト | E-03 (docview.jl L23-77) | ○ |
| C-30 (UT-RPL-087~088) | trimdocsのドキュメント切り詰めテスト | E-03 (docview.jl L132-165) | ○ |
| C-31 (UT-RPL-089) | assume_julia_code!のコード言語推定テスト | E-03 (docview.jl L99-118) | ○ |
| C-32 (UT-RPL-090~091) | symbol_latexのLaTeX逆引きテスト | E-03 (docview.jl L498-510) | ○ |
| C-33 (UT-RPL-092~094) | matchindsのマッチングテスト | E-03 (docview.jl L704-724) | ○ |
| C-34 (UT-RPL-095~096) | fuzzyscoreのスコアリングテスト | E-03 (docview.jl L780-793) | ○ |
| C-35 (UT-RPL-097~099) | levenshteinの距離計算テスト | E-03 (docview.jl L802-818) | ○ |
| C-36 (UT-RPL-100~101) | stripmdのMarkdownストリップテスト | E-03 (docview.jl L977-998) | ○ |
| C-37 (UT-RPL-102~104) | docsearchのドキュメント検索テスト | E-03 (docview.jl L933-963) | ○ |
| C-38 (UT-RPL-105~107) | summarizeのサマリー生成テスト | E-03 (docview.jl L305-441) | ○ |
| C-39 (UT-RPL-108~109) | insert_internal_warningの警告挿入テスト | E-03 (docview.jl L193-207) | ○ |
| C-40 (UT-RPL-110~111) | AccessibleBindingの構築テスト | E-03 (docview.jl L452-461) | ○ |
| C-41 (UT-RPL-112~113) | seek_posのノード探索テスト | E-05 (SyntaxUtil.jl L77-85) | ○ |
| C-42 (UT-RPL-114~115) | find_parentの親ノード探索テスト | E-05 (SyntaxUtil.jl L87-93) | ○ |
| C-43 (UT-RPL-116~119) | char_range/children_nt/find_delimテスト | E-05 (SyntaxUtil.jl L71-107) | ○ |
| C-44 (UT-RPL-120~124) | StylingContext/merge_annotations/apply_styling_passesテスト | E-06 (StylingPasses.jl L16-54) | ○ |
| C-45 (UT-RPL-125~130) | 各StylingPassの適用テスト | E-06 (StylingPasses.jl L57-163) | ○ |
| C-46 (UT-RPL-131~140) | HistoryFile/HistEntryのCRUDテスト | E-07 (histfile.jl L16-288) | ○ |
| C-47 (UT-RPL-133~134) | HistoryFile update!の読み込みテスト（不正エントリ含む） | E-07 (histfile.jl L82-207) | △ |
| C-48 (UT-RPL-141~148) | Pkg_beforeloadの各関数テスト | E-09 (Pkg_beforeload.jl L11-122) | △ |
| C-49 (UT-RPL-149~157) | RadioMenuの構築・操作テスト | E-10 (RadioMenu.jl L22-108) | ○ |
| C-50 (UT-RPL-158~167) | MultiSelectMenuの構築・操作テスト | E-11 (MultiSelectMenu.jl L30-128) | ○ |
| C-51 (UT-RPL-168~173) | Config/MultiSelectConfigの設定テスト | E-12 (config.jl L5-100) | ○ |
| C-52 (UT-RPL-174~181) | AbstractMenuのカーソル移動テスト | E-13 (AbstractMenu.jl L263-304) | ○ |
| C-53 (UT-RPL-182~185) | Pagerの構築・操作テスト | E-14 (Pager.jl L3-42) | ○ |
| C-54 (UT-RPL-186~196) | LineEditの基本型・操作テスト | E-15 (LineEdit.jl L43-161) | ○ |
| C-55 (UT-RPL-197~199) | UndefVarError_REPL_hintテスト | E-01 (REPL.jl L20-33) | ○ |
| C-56 (UT-RPL-200) | LimitIOException showerrorテスト | E-01 (REPL.jl L489-491) | ○ |

## 4) 不足情報（Unknown / Missing）
- **modules_to_be_loaded（C-05）**：lowered Exprの正確な構造はJuliaコンパイラの内部表現に依存するため、テスト入力値の正確な再現にはMeta.lowerの実行が必要。テストケースの入力値は概要レベルの記載。
  - 候補：Juliaコンパイラのlowering仕様 / 実際のMeta.lower出力の検証
- **collect_qualified_access_warnings（C-12）**：公開/非公開シンボルの判定ロジックはBase.ispublicに依存し、テスト用のモジュール構築が必要。
  - 候補：テスト専用モジュールの作成 / Base.ispublicのmock
- **completions（C-16）**：戻り値は実行環境のロード済みモジュール・定義済みシンボルに依存。テスト環境によって結果が異なる。
  - 候補：固定テスト環境の構築 / 特定シンボルの存在を前提とした部分的検証
- **HistoryFile update!の不正データ処理（C-47）**：不正なバイト列を含むテストファイルの作成が必要。バイナリフォーマットの詳細な検証。
  - 候補：テスト用の不正履歴ファイル生成スクリプト
- **Pkg_beforeload（C-48）**：find_project_file, projname, Pkg_promptfは実行環境のプロジェクト構成に依存。テスト環境の事前準備が必要。
  - 候補：一時ディレクトリにテスト用Project.tomlを作成

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Options, Config, MultiSelectConfig, NamedCompletion等の純粋なデータ構造テスト（UT-RPL-039~041, UT-RPL-168~173）
- **0: 低リスク** - 純粋関数のテスト（softscope, ends_with_semicolon, has_ancestor, levenshtein, matchinds等）
- **1: 中リスク** - ファイルシステムに依存するテスト（complete_path, find_hist_file, HistoryFile - UT-RPL-029~030, UT-RPL-061~063, UT-RPL-131~140）
- **1: 中リスク** - REPLCompletions.completionsの包括テスト（環境依存 - UT-RPL-051~053）
- **2: 高リスク** - modules_to_be_loadedはlowered Exprに依存（Juliaバージョン間での互換性リスク - UT-RPL-017~018）
- **1: 中リスク** - Pkg_beforeloadの関数群はアクティブプロジェクト環境に依存（UT-RPL-144~148）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-RPL-017~018: modules_to_be_loadedのテスト入力値が現行Juliaバージョンのlowered表現と整合しているか確認
- [ ] UT-RPL-035~036: collect_qualified_access_warningsのテストで適切なテスト用モジュールが構築されるか確認
- [ ] UT-RPL-051~053: completionsテストの期待結果がテスト環境で再現可能か確認
- [ ] UT-RPL-133~134: HistoryFile update!の不正データテストで適切なテストファイルが生成されるか確認
- [ ] UT-RPL-144~148: Pkg_beforeloadテストで一時プロジェクト環境が正しくセットアップされるか確認
- [ ] 全体: テストケースの優先度付けが適切か（高: セキュリティ/データ整合性関連、中: 主要機能、低: ヘルパー/表示）
- [ ] 全体: テスト観点（正常系/異常系/境界値）が各関数について網羅されているか確認
- [ ] TerminalMenus: RadioMenu/MultiSelectMenuの対話的テストはsuppress_output=trueオプションで実施可能か確認
