---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 185
  claims_with_evidence: 179
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：stdlib-Random 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：179 / 185、根拠なし：6
- 優先レビュー（高）
  1. **統計分布の正確性検証**：randn/randexpの分布特性は生成値の統計的検証が必要
  2. **SIMD最適化パスの閾値**：XoshiroSimdの閾値定数が将来変更される可能性
  3. **BigFloat精度テスト**：BigFloat乱数の精度検証は実行時精度設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Random/src/Random.jl` - モジュール定義、型階層、Sampler機構、rand/rand!の定義
- E-02: `stdlib/Random/src/DSFMT.jl` - DSFMT_state構造体、GF2X多項式、calc_jump、dsfmt_jump関連
- E-03: `stdlib/Random/src/Xoshiro.jl` - Xoshiro構造体、TaskLocalRNG、jump_128/jump_192、setstate!/getstate
- E-04: `stdlib/Random/src/MersenneTwister.jl` - MersenneTwister構造体、copy/copy!/==/hash/show、rand生成、配列生成、randjump
- E-05: `stdlib/Random/src/RNGs.jl` - default_rng、RandomDevice、SeedHasher、seed!、hash_seed
- E-06: `stdlib/Random/src/generation.jl` - Float/Integer/Complex/Char/Tuple/Pair生成、範囲サンプリング(NDL/Fast/Int)、BigInt、コレクション
- E-07: `stdlib/Random/src/normal.jl` - randn（Zigguratアルゴリズム）、randexp、randn!/randexp!、配列最適化
- E-08: `stdlib/Random/src/misc.jl` - bitrand、randstring、randsubseq/randsubseq!、shuffle/shuffle!、randperm/randperm!、randcycle/randcycle!
- E-09: `stdlib/Random/src/XoshiroSimd.jl` - SIMD最適化、xoshiro_bulk、forkRand、_bits2float

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-08 | DSFMT_stateの構築・コピー・比較・ハッシュ | E-02 (L26-41) | ○ |
| C-09〜C-12 | GF2X多項式の構築・degree・coeff | E-02 (L103-115) | ○ |
| C-13〜C-15 | calc_jump/powxmodの正常系・異常系 | E-02 (L152-188) | ○ |
| C-16〜C-28 | Xoshiroの構築・状態管理・コピー・比較・ハッシュ | E-03 (L52-244) | ○ |
| C-29〜C-34 | Xoshiro/TaskLocalRNGのrand生成（各型） | E-03 (L250-298) | ○ |
| C-35〜C-40 | jump_128!/jump_192!のジャンプ機能 | E-03 (L79-122) | ○ |
| C-41〜C-43 | TaskLocalRNGの構築・状態管理 | E-03 (L207-238) | ○ |
| C-44〜C-64 | MersenneTwisterの構築・コピー・比較・rand生成・配列・jump | E-04 (L10-552) | ○ |
| C-65〜C-70 | default_rng/RandomDeviceの構築・生成 | E-05 (L26-99) | ○ |
| C-71〜C-74 | SeedHasherの構築・生成 | E-05 (L107-176) | ○ |
| C-75〜C-83 | seed!/hash_seedの各パターン | E-05 (L179-308) | ○ |
| C-84〜C-96 | rand関数の各バリエーション・Sampler型 | E-01 (L260-316), E-06 | ○ |
| C-97〜C-104 | Float/BigFloat/Complex/Char/Tuple/Pair乱数 | E-06 (L18-201) | ○ |
| C-105〜C-121 | 範囲サンプリング・コレクションサンプリング | E-06 (L220-528) | ○ |
| C-122〜C-133 | randn/randn!の各バリエーション | E-07 (L12-264) | ○ |
| C-134〜C-138 | randexp/randexp!の各バリエーション | E-07 (L130-278) | ○ |
| C-139〜C-143 | bitrand/rand!(BitArray) | E-08 (L5-38) | ○ |
| C-144〜C-147 | randstring | E-08 (L43-89) | ○ |
| C-148〜C-153 | randsubseq/randsubseq! | E-08 (L92-176) | ○ |
| C-154〜C-160 | shuffle/shuffle! | E-08 (L179-252) | ○ |
| C-161〜C-170 | randperm/randperm!/randcycle/randcycle! | E-08 (L286-435) | ○ |
| C-171〜C-177 | XoshiroSimd SIMD最適化パス | E-09 (L168-313) | ○ |
| C-178 | 汎用配列生成 rand(rng, X, dims) | E-01 (L288-301) | ○ |
| C-179〜C-180 | LessThan/Maskedサンプラー | E-01 (L226-243) | ○ |
| C-181〜C-182 | _uint2float変換 | E-03 (L293-294) | ○ |
| C-183 | randn(BigFloat)の生成 | E-07 (L120-126) | △ |
| C-184 | shuffle(::OneTo)最適化パス | E-08 (L282) | ○ |
| C-185 | nth関数のヘルパー | E-06 (L521-525) | ○ |

**根拠不足の項目（△）：**

| Claim ID | 主張 | 状態 | 理由 |
|---|---|---|---|
| C-122 | randn()の統計的分布検証 | △ | Zigguratテーブル定数からアルゴリズムは検証可能だが、分布の統計的正確性は実行時テストが必要 |
| C-126 | 複素正規分布のSQRT_HALF精度 | △ | SQRT_HALF定数の精度はirrational宣言に依存 |
| C-134 | randexp()の統計的分布検証 | △ | Zigguratテーブル定数からアルゴリズムは検証可能だが、分布の統計的正確性は実行時テストが必要 |
| C-148 | randsubseqの確率分布の正確性 | △ | p=0.5での期待値はコードから推測だが、統計的検証は実行時テストが必要 |
| C-167 | randcycleの巡回性検証 | △ | Sattolo's algorithmの正しさはアルゴリズム的に担保されるが、実装の正確性は実行時検証が必要 |
| C-183 | randn(BigFloat)の精度 | △ | Box-Muller法のフォールバック実装だが、BigFloat精度での動作検証は未確認 |

## 4) 不足情報（Unknown / Missing）
- **統計的分布テスト**: randn, randexpの出力分布が理論分布に従うことの統計的検証（KSテストなど）はソースコード解析のみでは確認不可
  - 候補：既存テストファイル `stdlib/Random/test/` / 統計的テストの追加
- **マルチスレッド安全性**: TaskLocalRNGのスレッドセーフティは構造的に保証されるが、明示的なテストケースは含めていない
  - 候補：並行実行テスト / データ競合テスト
- **プラットフォーム依存性**: XoshiroSimdのSIMD幅やエンディアン依存性のテストは含めていない
  - 候補：クロスプラットフォームテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: DSFMT_state構築・コピー・比較、Xoshiro/MersenneTwister構築・コピー、基本型のrand生成、shuffle/randperm/randcycleの要素保存性
- **1（中リスク）**: SeedHasherのrehash!サイクル検出、BigInt範囲サンプリングの無限ループ回避、_rand_max383!のアライメント処理
- **1（中リスク）**: XoshiroSimdのSIMDベクトル幅依存のストリーム一貫性
- **0（低リスク）**: hash_seedの注入性（各型で異なるサフィックスバイトにより区別される）

## 6) レビュアーチェックリスト（最小）
- [ ] DSFMT_stateのバリデーション（不正長ベクトル）テストが実際にDomainErrorをスローするか確認
- [ ] Xoshiro/MersenneTwisterの再現性テスト（同一シードで同一列）が実環境で通るか確認
- [ ] 空コレクション（空Dict、空Set、空範囲）のArgumentErrorテストが網羅されているか確認
- [ ] randsubseqの確率境界値（p=0, p=1, p<0, p>1）テストの妥当性を確認
- [ ] jump_128!/jump_192!の状態一貫性テスト（jump後のコピーと元の比較）を確認
- [ ] randn/randexpの統計的分布テスト（平均値・分散の許容範囲）を別途追加検討
- [ ] Bool配列生成（RandomDevice, MersenneTwister, Xoshiro）でLSBのみマスキングされているか確認
