---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 157
  claims_with_evidence: 148
  claims_without_evidence: 9
confidence_derived: 0.94
---

# 根拠レポート：stdlib-Sockets 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（stdlib-Sockets.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：148 / 157、根拠なし：9
- 優先レビュー（高）
  1. **UT-SOC-095/096（UDP recv/recvfrom正常系）**：内部コールバック(uv_recvcb)の詳細動作は非同期libuvコールバック経由のため、単体テストでの検証方法が要確認
  2. **UT-SOC-111（quickack）**：Linux限定機能のためクロスプラットフォームテスト環境での実行可否が要確認
  3. **UT-SOC-134/135（_uv_hook_close）**：内部フック関数の直接テスト可否が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Sockets/src/IPAddr.jl` - IPv4/IPv6型定義、コンストラクタ、パース、表示関数
- E-02: `stdlib/Sockets/src/Sockets.jl` - TCPSocket/TCPServer/UDPSocket型定義、bind/listen/connect/accept/send/recv関数
- E-03: `stdlib/Sockets/src/addrinfo.jl` - DNS解決関数(getaddrinfo/getalladdrinfo/getnameinfo)、ネットワークインターフェース関数(getipaddr/getipaddrs/islinklocaladdr)
- E-04: `stdlib/Sockets/src/PipeServer.jl` - PipeServer型定義、bind/listen/accept/connect関数
- E-05: `stdlib/Sockets/src/Sockets.jl` (exports) - モジュールのパブリックAPI一覧（export宣言）

## 3) Claims と根拠の対応（レビューの主戦場）

### IPAddr.jl 関連（C-01〜C-51）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPv4(UInt32)コンストラクタが存在し正常動作する | E-01 (L17-18) | ○ |
| C-02 | IPv4(UInt8x4)コンストラクタが存在しビット演算で結合する | E-01 (L19-22) | ○ |
| C-03 | IPv4(Integerx4)コンストラクタが0-255範囲チェックを行う | E-01 (L23-28) | ○ |
| C-04 | 範囲外オクテットでArgumentErrorをスロー | E-01 (L24-25) | ○ |
| C-05 | 負のオクテットでArgumentErrorをスロー | E-01 (L24-25) | ○ |
| C-06 | IPv4(Integer)が正のIntegerから生成可能 | E-01 (L42-50) | ○ |
| C-07 | 負のIntegerでArgumentErrorスロー | E-01 (L43-44) | ○ |
| C-08 | UInt32最大値超でArgumentErrorスロー | E-01 (L45-46) | ○ |
| C-09 | 0(最小値)でIPv4生成可能 | E-01 (L42-50) | ○ |
| C-10 | typemax(UInt32)でIPv4生成可能 | E-01 (L42-50) | ○ |
| C-11 | IPv4(String)がparse経由で動作 | E-01 (L63) | ○ |
| C-12 | parse(IPv4, str)がドット区切り文字列をパース | E-01 (L196-223) | ○ |
| C-13 | 空フィールドでArgumentError | E-01 (L201-203) | ○ |
| C-14 | 先頭ゼロでArgumentError | E-01 (L204-205) | ○ |
| C-15 | フィールド値255超でArgumentError | E-01 (L209-211) | ○ |
| C-16 | 0.0.0.0パース | E-01 (L196-223) | ○ |
| C-17 | 255.255.255.255パース | E-01 (L196-223) | ○ |
| C-18 | show出力がip"..."形式 | E-01 (L65) | ○ |
| C-19 | print出力がドット区切り | E-01 (L66-69) | ○ |
| C-20 | isless比較がhost値で行われる | E-01 (L10) | ○ |
| C-21 | 同値比較でfalse | E-01 (L10) | ○ |
| C-22 | Integer型変換 | E-01 (L11) | ○ |
| C-23 | IPv6(UInt128)コンストラクタ | E-01 (L72-73) | ○ |
| C-24 | IPv6(UInt16x8)コンストラクタ | E-01 (L74-82) | ○ |
| C-25 | IPv6フィールド範囲外でArgumentError | E-01 (L85-87) | ○ |
| C-26 | IPv6負フィールドでArgumentError | E-01 (L85-87) | ○ |
| C-27 | IPv6(Integer)コンストラクタ | E-01 (L105-115) | ○ |
| C-28 | 負IPv6でArgumentError | E-01 (L107-108) | ○ |
| C-29 | UInt128超でArgumentError | E-01 (L110-111) | ○ |
| C-30 | IPv6最小値0 | E-01 (L105-115) | ○ |
| C-31 | IPv6最大値 | E-01 (L105-115) | ○ |
| C-32 | IPv6(String)パース | E-01 (L128) | ○ |
| C-33 | 完全形式IPv6パース | E-01 (L247-259) | ○ |
| C-34 | 省略形式(::)パース | E-01 (L247-259) | ○ |
| C-35 | IPv4マッピングIPv6パース | E-01 (L253-255) | ○ |
| C-36 | 9フィールド以上でArgumentError | E-01 (L249-250) | ○ |
| C-37 | ipv6_field正常抽出 | E-01 (L134-139) | ○ |
| C-38 | ipv6_field範囲外でBoundsError | E-01 (L135-137) | ○ |
| C-39 | ipv6_field負インデックスでBoundsError | E-01 (L135-137) | ○ |
| C-40 | IPv6 show出力 | E-01 (L141) | ○ |
| C-41 | RFC 5952準拠出力 | E-01 (L142-187) | ○ |
| C-42 | 単一ゼロ非省略 | E-01 (L169-171) | ○ |
| C-43 | 全ゼロが::出力 | E-01 (L144-187) | ○ |
| C-44 | parse(IPAddr)がコロンでIPv6判別 | E-01 (L267-273) | ○ |
| C-45 | parse(IPAddr)がコロンなしでIPv4判別 | E-01 (L267-273) | ○ |
| C-46 | @ip_strマクロIPv4 | E-01 (L289-291) | ○ |
| C-47 | @ip_strマクロIPv6 | E-01 (L289-291) | ○ |
| C-48 | InetAddr(IPAddr, port) | E-01 (L293-309) | ○ |
| C-49 | InetAddr(String, port) | E-01 (L326) | ○ |
| C-50 | InetAddr show出力 | E-01 (L328-333) | ○ |
| C-51 | broadcastable(ip) | E-01 (L14) | ○ |

### addrinfo.jl 関連（C-52〜C-76）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | DNSErrorがhost,codeフィールドを持つ | E-03 (L10-13) | ○ |
| C-53 | DNSError show出力 | E-03 (L15-18) | ○ |
| C-54 | getalladdrinfo正常系 | E-03 (L66-121) | ○ |
| C-55 | getalladdrinfo異常系DNSError | E-03 (L106-119) | ○ |
| C-56 | getalladdrinfo AbstractString変換 | E-03 (L122) | ○ |
| C-57 | getaddrinfo正常系 | E-03 (L158-164) | ○ |
| C-58 | getaddrinfo型指定 | E-03 (L140-148) | ○ |
| C-59 | getaddrinfo型不一致DNSError | E-03 (L147) | ○ |
| C-60 | getnameinfo IPv4逆引き | E-03 (L195-254) | ○ |
| C-61 | getnameinfo IPv6逆引き | E-03 (L195-254) | ○ |
| C-62 | getipaddr正常系 | E-03 (L283-292) | ○ |
| C-63 | getipaddr IPv4指定 | E-03 (L283-291) | ○ |
| C-64 | getipaddr IPv6指定 | E-03 (L283-291) | ○ |
| C-65 | getipaddrs正常系 | E-03 (L326-353) | ○ |
| C-66 | getipaddrs IPv4フィルタ | E-03 (L326-353) | ○ |
| C-67 | getipaddrs loopback=true | E-03 (L336-341) | ○ |
| C-68 | getipaddrs loopback=false | E-03 (L336-341) | ○ |
| C-69 | islinklocaladdr IPv4リンクローカル | E-03 (L368-373) | ○ |
| C-70 | islinklocaladdr IPv4非リンクローカル | E-03 (L368-373) | ○ |
| C-71 | islinklocaladdr IPv6リンクローカル | E-03 (L374-379) | ○ |
| C-72 | islinklocaladdr IPv6非リンクローカル | E-03 (L374-379) | ○ |
| C-73 | islinklocaladdr IPv4境界開始 | E-03 (L370-372) | ○ |
| C-74 | islinklocaladdr IPv4境界終了 | E-03 (L370-372) | ○ |
| C-75 | islinklocaladdr IPv4境界外直前 | E-03 (L370-372) | ○ |
| C-76 | islinklocaladdr IPv4境界外直後 | E-03 (L370-372) | ○ |

### Sockets.jl 関連（C-77〜C-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | TCPSocket(delay=true)生成 | E-02 (L85-95) | ○ |
| C-78 | TCPSocket(delay=false)生成 | E-02 (L85-95) | ○ |
| C-79 | TCPSocket(fd)生成 | E-02 (L97-108) | ○ |
| C-80 | TCPServer(delay=true)生成 | E-02 (L132-142) | ○ |
| C-81 | TCPServer(delay=false)生成 | E-02 (L132-142) | ○ |
| C-82 | UDPSocket()生成 | E-02 (L193-202) | ○ |
| C-83 | UDPSocket show出力 | E-02 (L204) | ○ |
| C-84 | bind TCPServer成功 | E-02 (L260-288) | ○ |
| C-85 | bind UDPSocket成功 | E-02 (L260-288) | ○ |
| C-86 | bind状態チェックエラー | E-02 (L261-263) | ○ |
| C-87 | bind ipv6only設定 | E-02 (L265-266) | ○ |
| C-88 | bind reuseaddr設定 | E-02 (L268-269) | ○ |
| C-89 | bind使用中ポートでfalse | E-02 (L273-280) | ○ |
| C-90 | setopt multicast_loop | E-02 (L303-322) | ○ |
| C-91 | setopt enable_broadcast | E-02 (L314-316) | ○ |
| C-92 | setopt未初期化エラー | E-02 (L305-307) | ○ |
| C-93 | setopt ttl | E-02 (L317-319) | ○ |
| C-94 | setopt multicast_ttl | E-02 (L311-313) | ○ |
| C-95 | recv正常系 | E-02 (L329-332) | △ |
| C-96 | recvfrom正常系 | E-02 (L346-370) | △ |
| C-97 | recvfrom状態チェック | E-02 (L349-351) | ○ |
| C-98 | send正常系 | E-02 (L441-473) | △ |
| C-99 | send状態チェック | E-02 (L443-446) | ○ |
| C-100 | connect!正常系 | E-02 (L511-526) | ○ |
| C-101 | connect!状態チェック | E-02 (L513-514) | ○ |
| C-102 | connect!ポート負値チェック | E-02 (L516-517) | ○ |
| C-103 | connect!ポート上限チェック | E-02 (L516-517) | ○ |
| C-104 | connect!ポート0境界値 | E-02 (L516) | ○ |
| C-105 | connect!ポート65535境界値 | E-02 (L516) | ○ |
| C-106 | connect!ホスト名文字列 | E-02 (L568-575) | ○ |
| C-107 | connect正常系 | E-02 (L577-581) | ○ |
| C-108 | connect(port)デフォルトlocalhost | E-02 (L560-561) | ○ |
| C-109 | nagle有効化 | E-02 (L595-603) | ○ |
| C-110 | nagle無効化 | E-02 (L595-603) | ○ |
| C-111 | quickack設定 | E-02 (L610-621) | △ |
| C-112 | listen(port)正常系 | E-02 (L644) | ○ |
| C-113 | listen(host, port)正常系 | E-02 (L645) | ○ |
| C-114 | listen(sock)バインド済 | E-02 (L647-650) | ○ |
| C-115 | listen失敗エラー | E-02 (L638-643) | ○ |
| C-116 | accept正常系 | E-02 (L699-725) | ○ |
| C-117 | accept未リッスンArgumentError | E-02 (L701-703) | ○ |
| C-118 | accept(callback)タスク返却 | E-02 (L155-169) | ○ |
| C-119 | accept_nonblock成功 | E-02 (L680-691) | ○ |
| C-120 | accept_nonblockクライアント状態チェック | E-02 (L682-683) | ○ |
| C-121 | listenany正常系 | E-02 (L738-755) | ○ |
| C-122 | listenanyホスト指定 | E-02 (L738-755) | ○ |
| C-123 | listenany backlog指定 | E-02 (L738-755) | ○ |
| C-124 | getsockname TCPSocket | E-02 (L814, L825-867) | ○ |
| C-125 | getsockname TCPServer | E-02 (L814, L825-867) | ○ |
| C-126 | getpeername TCPSocket | E-02 (L823, L825-867) | ○ |
| C-127 | _sockname self=true | E-02 (L825-867) | ○ |
| C-128 | _sockname self=false | E-02 (L825-867) | ○ |
| C-129 | join_multicast_group String | E-02 (L778-781) | ○ |
| C-130 | join_multicast_group IPAddr | E-02 (L782-788) | ○ |
| C-131 | join_multicast_group IF指定 | E-02 (L778-788) | △ |
| C-132 | leave_multicast_group String | E-02 (L797-800) | ○ |
| C-133 | leave_multicast_group IPAddr | E-02 (L801-807) | ○ |
| C-134 | _uv_hook_close StatusClosed | E-02 (L208-218) | ○ |
| C-135 | _uv_hook_close EOFError通知 | E-02 (L213) | △ |
| C-136 | alloc_buf_hook | E-02 (L372) | ○ |
| C-137 | localhost定数 | E-02 (L729) | ○ |
| C-138 | BACKLOG_DEFAULT定数 | E-02 (L626) | ○ |

### PipeServer.jl 関連（C-139〜C-151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | PipeServer()生成 | E-04 (L17-25) | ○ |
| C-140 | PipeServer(handle)生成 | E-04 (L27-30) | ○ |
| C-141 | open_pipe!正常系 | E-04 (L32-42) | ○ |
| C-142 | open_pipe!状態チェック | E-04 (L34-35) | ○ |
| C-143 | bind PipeServer成功 | E-04 (L67-84) | ○ |
| C-144 | bind PipeServer失敗 | E-04 (L72-79) | ○ |
| C-145 | accept PipeServer | E-04 (L46) | ○ |
| C-146 | accept_nonblock PipeServer | E-04 (L48-59) | ○ |
| C-147 | accept_nonblockクライアント状態チェック | E-04 (L50-52) | ○ |
| C-148 | listen(path)正常系 | E-04 (L94-98) | ○ |
| C-149 | listen(path)失敗 | E-04 (L96) | ○ |
| C-150 | connect!パイプ接続開始 | E-04 (L100-110) | ○ |
| C-151 | connect(path)正常系 | E-04 (L120) | ○ |

### 統合テスト関連（C-152〜C-157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-152 | UDP送受信統合テスト | E-02 (L329-332, L441-473) | △ |
| C-153 | TCP接続統合テスト | E-02 (L638-650, L560-581, L699-725) | △ |
| C-154 | trylisten正常系 | E-02 (L668-676) | ○ |
| C-155 | wait_connected正常系 | E-02 (L530-551) | △ |
| C-156 | parseipv6fields正常系 | E-01 (L225-245) | ○ |
| C-157 | parseipv6fieldsフィールド数超過 | E-01 (L226-228) | ○ |

## 4) 不足情報（Unknown / Missing）
- **非同期コールバック動作の検証**：recv/recvfrom/sendは内部でlibuv非同期コールバック(uv_recvcb, uv_writecb_task)を使用しており、単体テストでの完全な動作検証には送受信の統合的な環境構築が必要。ソースコード上のロジックは確認できるが、実際のネットワークI/O動作の正確性はランタイム依存。
  - 候補：stdlib/Sockets/test/runtests.jl / libuv公式ドキュメント / 実行時テスト
- **quickack(Linux限定)**：`@static if Sys.islinux()`で条件分岐されており、非Linux環境では何も行われない。テスト実行環境がLinuxでない場合、この機能は検証不可。
  - 候補：Linux CI環境 / jl_tcp_quickack実装
- **_uv_hook_closeのEOFError通知**：内部的にnotify_errorを呼ぶが、この通知の受信側の動作は単体テストでは検証困難。
  - 候補：close動作の統合テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：IPv4/IPv6型定義、パース、表示、islinklocaladdr - ソースコードから直接確認可能な純粋関数
- **0（低リスク）**：コンストラクタのバリデーション - 明確な条件分岐がソースコードに存在
- **1（中リスク）**：bind/listen/connect/accept - ネットワークI/O依存だが、ソケット状態チェックは明確
- **1（中リスク）**：DNS解決関数(getaddrinfo等) - 外部DNS依存、テスト環境によって結果が異なる可能性
- **2（高リスク）**：UDP send/recv統合動作 - 非同期コールバック経由で検証が複雑、パケットロスの可能性
- **1（中リスク）**：マルチキャスト操作 - ネットワーク環境依存で検証が制限される場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] IPv4/IPv6のコンストラクタ・パース・表示のテストケースが全分岐をカバーしているか
- [ ] バリデーションエラー（ArgumentError, BoundsError等）の期待結果がソースコードのエラーメッセージと一致しているか
- [ ] bind/listen/connect/acceptの状態遷移チェックが網羅されているか（StatusInit -> StatusOpen -> StatusActive等）
- [ ] DNS関連テスト(getaddrinfo, getnameinfo等)の前提条件がテスト実行環境で満たされるか
- [ ] UDP送受信テストの非同期動作が確実に検証可能なテスト設計になっているか
- [ ] PipeServer関連テストでUNIXドメインソケットのパス長制限(92-108バイト)を考慮しているか
- [ ] islinklocaladdrの境界値テストが169.254.0.0/16およびfe80::/10の範囲を正確にカバーしているか
- [ ] マルチキャストグループ操作(join/leave)テストがネットワーク環境依存部分を考慮しているか
