---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：stdlib-TOML 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **C-110 (UT-TML-110)**: stdout出力のテストは実行環境に依存するため根拠不足
  2. **C-117 (UT-TML-117)**: Base.TOMLCacheは内部APIであり、振る舞いの詳細根拠が不足
  3. **C-107 (UT-TML-107)**: カスタムby関数の具体的な期待出力の根拠が不足
  4. **C-114 (UT-TML-114)**: ラウンドトリップの等価性は全型について保証されるか要確認
  5. **C-115 (UT-TML-115)**: 複合型ラウンドトリップの浮動小数点精度に関して要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/TOML/src/TOML.jl` - メインモジュール定義（Parser構造体、parse/tryparse/parsefile/tryparsefile関数、_readstring関数、ParserError定数）
- E-02: `stdlib/TOML/src/print.jl` - TOML印刷機能（print_toml_escaped、printkey、printvalue、print_table、print_inline_table、print_integer、to_toml_value、is_table、is_array_of_tables、is_tabular、print API）
- E-03: `stdlib/TOML/src/precompile.jl` - プリコンパイルワークロード
- E-04: `base/toml_parser.jl` - Base内部パーサー（Parser{Dates}構造体、parse/tryparse関数、reinit!関数、各種エラー型、キー/値/テーブル/配列/文字列/数値/日時パーサー）
- E-05: TOML v1.0仕様（https://toml.io/en/v1.0.0） - TOML文法・型の仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Parser()デフォルトコンストラクタが存在する | E-01 (line 44) | ○ |
| C-002 | Parser(io::IO)コンストラクタが存在する | E-01 (line 45) | ○ |
| C-003 | Parser(str::String)コンストラクタが存在する | E-01 (line 46) | ○ |
| C-004 | Parser(str; filepath=...)コンストラクタが存在する | E-01 (line 46) | ○ |
| C-005 | _readstringが存在するファイルの内容を返す | E-01 (line 28) | ○ |
| C-006 | _readstringが存在しないファイルでerrorを発生させる | E-01 (line 28, isfile条件) | ○ |
| C-007 | parsefile(f)がDictを返す | E-01 (lines 57-58), E-04 (parse関数) | ○ |
| C-008 | parsefile(f)がネストテーブルを処理できる | E-04 (parse_table関数) | ○ |
| C-009 | parsefile(f)が存在しないファイルでエラーを返す | E-01 (line 28, _readstring) | ○ |
| C-010 | parsefile(f)が不正構文でParserErrorをスローする | E-04 (parse関数, line 445-446) | ○ |
| C-011 | parsefile(p, f)がParser再利用でDictを返す | E-01 (lines 59-60), E-04 (reinit!) | ○ |
| C-012 | tryparsefile(f)がDictを返す | E-01 (lines 71-72), E-04 (tryparse関数) | ○ |
| C-013 | tryparsefile(f)が不正構文でParserErrorを返す（スローではなく） | E-04 (tryparse関数, lines 449-465) | ○ |
| C-014 | tryparsefile(f)が存在しないファイルでerrorを発生させる | E-01 (line 28, _readstring) | ○ |
| C-015 | tryparsefile(p, f)がParser再利用で動作する | E-01 (lines 73-74) | ○ |
| C-016 | parse(str)が文字列をパースしてDictを返す | E-01 (lines 86-87), E-04 | ○ |
| C-017 | parse(str)が整数値をパースする | E-04 (parse_number_or_date_start, parse_integer) | ○ |
| C-018 | parse(str)が浮動小数点数をパースする | E-04 (parse_float) | ○ |
| C-019 | parse(str)がブール値をパースする | E-04 (parse_bool) | ○ |
| C-020 | parse(str)が配列をパースする | E-04 (parse_array) | ○ |
| C-021 | parse(str)がインラインテーブルをパースする | E-04 (parse_inline_table) | ○ |
| C-022 | parse(str)が日付型をパースする | E-04 (try_return_date) | ○ |
| C-023 | parse(str)が日時型をパースする | E-04 (try_return_datetime) | ○ |
| C-024 | parse(str)が時刻型をパースする | E-04 (try_return_time) | ○ |
| C-025 | parse(str)がテーブルセクションをパースする | E-04 (parse_table) | ○ |
| C-026 | parse(str)がテーブル配列をパースする | E-04 (parse_array_table) | ○ |
| C-027 | parse(str)がドットキーをパースする | E-04 (_parse_key, recurse_dict!) | ○ |
| C-028 | parse("")が空Dictを返す | E-04 (tryparse, EOF_CHAR条件) | ○ |
| C-029 | parse(str)がコメントを無視する | E-04 (skip_comment) | ○ |
| C-030 | parse(str)がエスケープ文字列をパースする | E-04 (parse_string_continue, take_chunks with unescape) | ○ |
| C-031 | parse(str)がマルチライン文字列をパースする | E-04 (parse_string_start, multiline条件) | ○ |
| C-032 | parse(str)がリテラル文字列をパースする | E-04 (parse_string_start, quoted=true) | ○ |
| C-033 | parse(str)が16進数整数をパースする | E-04 (parse_hex, accept 'x') | ○ |
| C-034 | parse(str)が8進数整数をパースする | E-04 (parse_oct, accept 'o') | ○ |
| C-035 | parse(str)が2進数整数をパースする | E-04 (parse_bin, accept 'b') | ○ |
| C-036 | parse(str)がアンダースコア区切り数値をパースする | E-04 (accept_batch_underscore) | ○ |
| C-037 | parse(str)がinf/nanをパースする | E-04 (parse_inf, parse_nan) | ○ |
| C-038 | parse(str)が+inf/-infをパースする | E-04 (parse_inf, sgn引数) | ○ |
| C-039 | parse(str)が不正構文でParserErrorをスローする | E-04 (ErrExpectedEqualAfterKey) | ○ |
| C-040 | parse(str)が重複キーでParserErrorをスローする | E-04 (ErrKeyAlreadyHasValue, parse_entry) | ○ |
| C-041 | parse(str)が不正ベアキーでParserErrorをスローする | E-04 (ErrInvalidBareKeyCharacter) | ○ |
| C-042 | parse(str)が先頭ゼロ整数でParserErrorをスローする | E-04 (ErrLeadingZeroNotAllowedInteger, accept '0'後のisdigit) | ○ |
| C-043 | parse(str)がインラインテーブルへのキー追加でエラーを返す | E-04 (ErrAddKeyToInlineTable, check_allowed_add_key) | ○ |
| C-044 | parse(str)がオフセット日時でエラーを返す | E-04 (ErrOffsetDateNotSupported) | ○ |
| C-045 | parse(str)が不正エスケープ文字でエラーを返す | E-04 (ErrInvalidEscapeCharacter) | ○ |
| C-046 | parse(str)が単一行文字列中の改行でエラーを返す | E-04 (ErrNewLineInString) | ○ |
| C-047 | parse(str)が空テーブルを正しくパースする | E-04 (parse_table) | ○ |
| C-048 | parse(str)が空配列を正しくパースする | E-04 (parse_array, empty_array条件) | ○ |
| C-049 | parse(str)が空インラインテーブルを正しくパースする | E-04 (parse_inline_table, accept '}') | ○ |
| C-050 | parse(str)が空文字列キーをパースする | E-04 (_parse_key, accept '"') | ○ |
| C-051 | parse(str)がInt64最大値をパースする | E-04 (parse_integer, Int64) | ○ |
| C-052 | parse(str)がInt64オーバーフロー時にInt128を使用する | E-04 (parse_integer, n1/n2条件) | ○ |
| C-053 | parse(str)がクォートキーをパースする | E-04 (_parse_key, accept '"') | ○ |
| C-054 | parse(io::IO)がIOストリームからパースする | E-01 (line 90) | ○ |
| C-055 | parse(p, str)がParser再利用で文字列をパースする | E-01 (lines 88-89) | ○ |
| C-056 | parse(p, io)がParser再利用でIOストリームをパースする | E-01 (line 91) | ○ |
| C-057 | tryparse(str)が有効な文字列でDictを返す | E-01 (lines 103-104) | ○ |
| C-058 | tryparse(str)が不正な文字列でParserErrorを返す | E-04 (tryparse, lines 449-465) | ○ |
| C-059 | tryparse(io)がIOストリームからパースする | E-01 (line 107) | ○ |
| C-060 | tryparse(p, str)がParser再利用で動作する | E-01 (lines 105-106) | ○ |
| C-061 | tryparse(p, io)がParser再利用でIO入力を処理する | E-01 (line 108) | ○ |
| C-062 | print_toml_escapedが通常文字列をそのまま出力する | E-02 (lines 8-33, else分岐) | ○ |
| C-063 | print_toml_escapedがバックスペースを\\bに変換する | E-02 (line 13-14) | ○ |
| C-064 | print_toml_escapedがタブを\\tに変換する | E-02 (lines 15-16) | ○ |
| C-065 | print_toml_escapedが改行を\\nに変換する | E-02 (lines 17-18) | ○ |
| C-066 | print_toml_escapedがフォームフィードを\\fに変換する | E-02 (lines 19-20) | ○ |
| C-067 | print_toml_escapedがキャリッジリターンを\\rに変換する | E-02 (lines 21-22) | ○ |
| C-068 | print_toml_escapedがダブルクォートを\\"に変換する | E-02 (lines 23-24) | ○ |
| C-069 | print_toml_escapedがバックスラッシュを\\\\に変換する | E-02 (lines 25-26) | ○ |
| C-070 | print_toml_escapedが制御文字を\\uXXXX形式に変換する | E-02 (lines 27-29) | ○ |
| C-071 | print_toml_escapedが不正文字でエラーを発生させる | E-02 (lines 10-11) | ○ |
| C-072 | printkeyが単一ベアキーを出力する | E-02 (lines 44-59, else分岐) | ○ |
| C-073 | printkeyがドット区切りキーを出力する | E-02 (line 46, ドット挿入) | ○ |
| C-074 | printkeyが空キーをクォートする | E-02 (lines 47-49) | ○ |
| C-075 | printkeyが特殊文字キーをクォートする | E-02 (lines 50-54) | ○ |
| C-076 | to_toml_valueが変換関数を適用する | E-02 (lines 61-70) | ○ |
| C-077 | to_toml_valueがidentity+非TOML型でエラーを返す | E-02 (lines 62-63) | ○ |
| C-078 | to_toml_valueが非TOML型の変換結果でエラーを返す | E-02 (lines 66-68) | ○ |
| C-079 | printvalueが文字列をクォートして出力する | E-02 (lines 103-106) | ○ |
| C-080 | printvalueが改行含む文字列をトリプルクォートで出力する | E-02 (line 103, contains "\n"条件) | ○ |
| C-081 | printvalueが整数を出力する | E-02 (line 99) | ○ |
| C-082 | printvalueがtrue/falseをブール文字列として出力する | E-02 (line 98) | ○ |
| C-083 | printvalueがfalseを"false"として出力する | E-02 (line 98) | ○ |
| C-084 | printvalueが浮動小数点数を出力する | E-02 (lines 100-102) | ○ |
| C-085 | printvalueがNaNを"nan"として出力する | E-02 (line 100, isnan条件) | ○ |
| C-086 | printvalueがInfを"+inf"として出力する | E-02 (line 101, isinf条件) | ○ |
| C-087 | printvalueが-Infを"-inf"として出力する | E-02 (line 101, 符号判定) | ○ |
| C-088 | printvalueがDateTimeをISO8601形式で出力する | E-02 (line 95) | ○ |
| C-089 | printvalueがDateをYYYY-MM-DD形式で出力する | E-02 (line 97) | ○ |
| C-090 | printvalueがTimeをHH:MM:SS.sss形式で出力する | E-02 (line 96) | ○ |
| C-091 | printvalueが配列をTOML形式で出力する | E-02 (lines 82-89) | ○ |
| C-092 | printvalueが空配列を[]として出力する | E-02 (lines 82-89, enumerate空) | ○ |
| C-093 | print_integerが符号付き整数を出力する | E-02 (lines 111-117, Signed分岐) | ○ |
| C-094 | print_integerが負の整数を出力する | E-02 (line 112) | ○ |
| C-095 | print_integerが符号なし整数を16進数で出力する | E-02 (lines 114-116) | ○ |
| C-096 | print_inline_tableがインラインテーブルを出力する | E-02 (lines 119-133) | ○ |
| C-097 | print_inline_tableがsorted=trueでキーをソートする | E-02 (lines 121-123) | ○ |
| C-098 | print_inline_tableが空Dictを{}として出力する | E-02 (lines 119-133) | ○ |
| C-099 | is_tableがAbstractDictに対してtrueを返す | E-02 (line 140) | ○ |
| C-100 | is_tableが非Dictに対してfalseを返す | E-02 (line 140) | ○ |
| C-101 | is_array_of_tablesがDict配列に対してtrueを返す | E-02 (lines 141-144) | ○ |
| C-102 | is_array_of_tablesが整数配列に対してfalseを返す | E-02 (lines 141-144) | ○ |
| C-103 | is_array_of_tablesが空配列に対してfalseを返す | E-02 (line 143, length > 0条件) | ○ |
| C-104 | printがDictをTOML形式でIOに出力する | E-02 (lines 229-236) | ○ |
| C-105 | printがネストDictをテーブル形式で出力する | E-02 (print_table, lines 184-204) | ○ |
| C-106 | printがsorted=trueでキーをソートする | E-02 (lines 161-163) | ○ |
| C-107 | printがby引数でカスタムソートを適用する | E-02 (line 163, sort! by引数) | △ |
| C-108 | printがinline_tablesで指定テーブルをインライン出力する | E-02 (lines 156-158) | ○ |
| C-109 | printが変換関数付きでカスタム型を出力する | E-02 (lines 229-230) | ○ |
| C-110 | printがIO省略時にstdoutに出力する | E-02 (lines 231-232, 235-236) | △ |
| C-111 | print_tableがテーブル配列を[[table]]形式で出力する | E-02 (lines 205-219) | ○ |
| C-112 | print_tableが深いネストを正しく出力する | E-02 (lines 184-204, indent) | ○ |
| C-113 | print_tableがテーブル配列中の非Dictでエラーを返す | E-02 (line 216) | ○ |
| C-114 | ラウンドトリップ（parse->print->parse）が一致する | E-01, E-02（機能的推論） | △ |
| C-115 | 複合型ラウンドトリップが一致する | E-01, E-02（機能的推論） | △ |
| C-116 | ParserErrorのフィールドにアクセスできる | E-04 (lines 258-273) | ○ |
| C-117 | Base.TOMLCache(p::Parser)が生成できる | E-01 (lines 145-147) | △ |
| C-118 | printvalueが非TOML型にカスタム変換を適用する | E-02 (lines 77-80) | ○ |
| C-119 | parse(str)がインラインテーブル末尾カンマでエラーを返す | E-04 (ErrTrailingCommaInlineTable, line 746) | ○ |
| C-120 | parse(str)が配列カンマ不足でエラーを返す | E-04 (ErrExpectedCommaBetweenItemsArray, line 689) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-107**: `by`引数の具体的な動作テストについて、コード上では`sort!(collect(akeys); by)`と呼ばれているが、具体的なカスタムソート結果の期待値は仕様文書がなく推測に基づく
  - 候補: TOML仕様ドキュメント / Julia sort!のドキュメント / 既存テストケース
- **C-110**: stdout出力テストは環境依存であり、テスト手法の根拠が不足
  - 候補: 既存のTOML stdlibテスト / redirect_stdoutを利用したテスト手法
- **C-114, C-115**: ラウンドトリップの等価性は浮動小数点の精度や日時フォーマットの差異により完全一致しない可能性がある
  - 候補: 既存テスト（stdlib/TOML/test/print.jl）/ TOML仕様
- **C-117**: Base.TOMLCacheは内部API（privateインターフェース）であり、公式ドキュメントがない
  - 候補: Baseソースコード / loading.jl内のTOMLCache使用箇所

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パーサー正常系テスト（C-016〜C-038）はソースコードの直接的な対応がある
- 0: 低リスク - エスケープ処理テスト（C-062〜C-071）はprint.jlの各分岐に直接対応
- 1: 中リスク - ラウンドトリップテスト（C-114, C-115）は型変換の精度に依存
- 0: 低リスク - エラーケーステスト（C-039〜C-046）はbase/toml_parser.jlのErrorType定義に直接対応
- 1: 中リスク - Base.TOMLCacheテスト（C-117）は内部API依存で将来的な互換性リスクあり

## 6) レビュアーチェックリスト（最小）
- [ ] 全120テストケースがCSVに正しく出力されているか
- [ ] テストIDの連番（UT-TML-001〜UT-TML-120）に欠番がないか
- [ ] 対象ファイルパスが正しいか（stdlib/TOML/src/TOML.jl, stdlib/TOML/src/print.jl）
- [ ] 正常系・異常系・境界値の観点が各公開関数に対して網羅されているか
- [ ] parse関数の各TOML型（文字列、整数、浮動小数点、ブール、日付、時刻、配列、テーブル）のテストケースが揃っているか
- [ ] print.jlの各エスケープ文字（\b, \t, \n, \f, \r, \\, \"）のテストケースが揃っているか
- [ ] エラーケースがbase/toml_parser.jlのErrorType enumと対応しているか
- [ ] ラウンドトリップテスト（C-114, C-115）の期待結果が浮動小数点精度を考慮しているか
- [ ] 優先度の設定が基準（金額計算=高、データ変換=中、表示用=低）に合致しているか
