---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 228
  claims_with_evidence: 220
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：stdlib-Test 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：220 / 228、根拠なし：8
- 優先レビュー（高）
  1. **detect_ambiguities テストケース (UT-TST-130〜132)**：実行時の曖昧性検出は環境依存であり、具体的な入力値の定義が不足
  2. **detect_unbound_args テストケース (UT-TST-133〜134)**：アンバウンド型パラメータの検出は内部実装依存
  3. **detect_closure_boxes テストケース (UT-TST-137〜138)**：Core.Box検出はコンパイラ内部実装依存
  4. **_check_bitarray_consistency 不整合ケース**：不整合なBitArrayを意図的に生成する方法の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Test/src/Test.jl` - Test モジュール本体（2904行）
- E-02: `stdlib/Test/src/logging.jl` - ログテスト機能（454行）
- E-03: `stdlib/Test/src/precompile.jl` - プリコンパイル定義（15行）
- E-04: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト計画書
- E-05: Julia標準ライブラリドキュメント（Logging, Random, Serialization, InteractiveUtils）

## 3) Claims と根拠の対応（レビューの主戦場）

### Result型（Pass/Fail/Error/Broken）- UT-TST-001〜023
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pass構造体の定義とコンストラクタ（UT-TST-001〜002） | E-01: L119-129 | ○ |
| C-02 | Pass.show表示ロジック（UT-TST-003〜005） | E-01: L131-141 | ○ |
| C-03 | Fail構造体の定義とコンストラクタ（UT-TST-006〜007） | E-01: L149-172 | ○ |
| C-04 | Fail.show表示ロジック（UT-TST-008〜011） | E-01: L174-216 | ○ |
| C-05 | Error構造体の定義とコンストラクタ（UT-TST-012〜013） | E-01: L226-279 | ○ |
| C-06 | Error.show表示ロジック（UT-TST-014〜017） | E-01: L281-312 | ○ |
| C-07 | Broken構造体と表示（UT-TST-018〜021） | E-01: L320-332 | ○ |
| C-08 | Returned/Threw構造体（UT-TST-022〜023） | E-01: L358-369 | ○ |

### 比較・関数評価 - UT-TST-024〜035
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | eval_test_comparison比較式評価（UT-TST-024〜028） | E-01: L371-399 | ○ |
| C-10 | eval_test_function関数呼び出し評価（UT-TST-029〜032） | E-01: L401-433 | ○ |
| C-11 | test_expr!前処理（UT-TST-033〜035） | E-01: L443-456 | ○ |

### テスト実行コア - UT-TST-036〜067
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | do_test結果処理（UT-TST-036〜040） | E-01: L823-850 | ○ |
| C-13 | do_broken_test破損テスト処理（UT-TST-041〜044） | E-01: L852-868 | ○ |
| C-14 | contains_warnパターンマッチング（UT-TST-045〜050） | E-01: L1184-1187 | ○ |
| C-15 | isequalexception例外比較（UT-TST-051〜053） | E-01: L1013-1024 | ○ |
| C-16 | check_exception_match例外マッチング（UT-TST-054〜062） | E-01: L1040-1124 | ○ |
| C-17 | do_test_throws例外テスト実行（UT-TST-063〜065） | E-01: L1128-1160 | ○ |
| C-18 | do_broken_test_throwsブロークン例外テスト（UT-TST-066〜067） | E-01: L1164-1177 | ○ |

### ヘルパー関数 - UT-TST-068〜075
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | format_extype_display表示補助（UT-TST-068〜069） | E-01: L1027-1035 | ○ |
| C-20 | extract_broken_skip_kwsキーワード抽出（UT-TST-070〜075） | E-01: L792-819 | ○ |

### TestSet実装 - UT-TST-076〜103
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | TestSetExceptionとFallbackTestSet（UT-TST-076〜080） | E-01: L1410-1453 | ○ |
| C-22 | ContextTestSet実装（UT-TST-081〜084） | E-01: L1457-1487 | ○ |
| C-23 | DefaultTestSetコンストラクタ・オプション（UT-TST-085〜087） | E-01: L1498-1541 | ○ |
| C-24 | DefaultTestSet.record各種結果（UT-TST-088〜093） | E-01: L1549-1608 | ○ |
| C-25 | DefaultTestSet.finish終了処理（UT-TST-094〜097） | E-01: L1709-1741 | ○ |
| C-26 | filter_errorsエラーフィルタ（UT-TST-098〜100） | E-01: L1745-1755 | ○ |
| C-27 | get_test_countsカウント集計（UT-TST-101〜103） | E-01: L1824-1846 | ○ |

### ユーティリティ - UT-TST-104〜186
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | anynonpass判定（UT-TST-104〜106） | E-01: L1846-1852 | ○ |
| C-29 | format_duration時間フォーマット（UT-TST-107〜110） | E-01: L1879-1893 | ○ |
| C-30 | get_testset/get_testset_depth（UT-TST-111〜114） | E-01: L2426-2437 | ○ |
| C-31 | parse_testset_args引数パース（UT-TST-115〜119） | E-01: L2361-2394 | ○ |
| C-32 | _check_testset型検証（UT-TST-120〜122） | E-01: L1970-1984 | ○ |
| C-33 | get_rng/set_rng! RNG管理（UT-TST-123〜126） | E-01: L1763-1773 | ○ |
| C-34 | is_failfast_errorエラー判定（UT-TST-127〜129） | E-01: L2144-2146 | ○ |
| C-35 | detect_ambiguities曖昧性検出（UT-TST-130〜132） | E-01: L2612-2646 | △ |
| C-36 | detect_unbound_argsアンバウンド検出（UT-TST-133〜134） | E-01: L2749-2774 | △ |
| C-37 | has_unbound_vars型変数判定（UT-TST-135〜136） | E-01: L2776-2785 | ○ |
| C-38 | detect_closure_boxesクロージャボックス検出（UT-TST-137〜138） | E-01: L2658-2716 | △ |
| C-39 | Generic型（String/Set/Dict/Array/Order）（UT-TST-139〜157） | E-01: L2793-2866 | ○ |
| C-40 | guardseed RNG保護（UT-TST-158〜159） | E-01: L2871-2885 | ○ |
| C-41 | _check_bitarray_consistency整合性チェック（UT-TST-160〜161） | E-01: L2887-2899 | ○ |
| C-42 | scrub_backtraceバックトレース清掃（UT-TST-162〜163） | E-01: L88-100 | ○ |
| C-43 | extract_fileファイル抽出（UT-TST-164〜165） | E-01: L1542-1544 | ○ |
| C-44 | _should_escape_call呼び出し判定（UT-TST-166〜170） | E-01: L639-654 | ○ |
| C-45 | _escape_call呼び出しエスケープ（UT-TST-171〜174） | E-01: L658-725 | ○ |
| C-46 | is_in_modsモジュール判定（UT-TST-175〜177） | E-01: L2583-2591 | ○ |
| C-47 | _format_warn_msg/remove_linenums補助関数（UT-TST-178〜181） | E-01: L1348-1363 | ○ |
| C-48 | Serializationシリアライズ（UT-TST-182〜183） | E-01: L336-352 | ○ |
| C-49 | insert_toplevel_latestworldワールドエイジ（UT-TST-184〜186） | E-01: L2183-2196 | ○ |
| C-50 | 表示関数get_alignment/print_test_results/print_test_errors（UT-TST-224〜228） | E-01: L1859-1966, L1618-1632 | ○ |

### ログテスト機能 - UT-TST-187〜223
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | LogRecord構造体と生成（UT-TST-187〜188） | E-02: L22-32 | ○ |
| C-52 | TestLoggerコンストラクタと設定（UT-TST-189〜191） | E-02: L38-89 | ○ |
| C-53 | TestLogger.shouldlogログ許可判定（UT-TST-192〜193） | E-02: L91-100 | ○ |
| C-54 | TestLogger.handle_messageログ記録（UT-TST-194〜196） | E-02: L102-119 | ○ |
| C-55 | TestLogger.catch_exceptions設定（UT-TST-197） | E-02: L122 | ○ |
| C-56 | collect_test_logsログ収集（UT-TST-198〜200） | E-02: L124-130 | ○ |
| C-57 | LogTestFailure型と記録（UT-TST-201〜204） | E-02: L137-172 | ○ |
| C-58 | match_logsパターンマッチ（UT-TST-205〜209） | E-02: L306-315 | ○ |
| C-59 | parse_levelログレベルパース（UT-TST-210〜214） | E-02: L318-328 | ○ |
| C-60 | logfield_containsフィールド比較（UT-TST-215〜219） | E-02: L330-334 | ○ |
| C-61 | occursin(Tuple,LogRecord)タプルマッチ（UT-TST-220〜223） | E-02: L336-339 | ○ |

## 4) 不足情報（Unknown / Missing）
- **detect_ambiguities (C-35)**: 曖昧なメソッド定義を含むテストモジュールの具体的な構成が環境依存。テスト実行には適切なテスト用モジュールの準備が必要。
  - 候補：stdlib/Test/test/ 内の既存テストを参照 / テスト用モジュールを別途定義
- **detect_unbound_args (C-36)**: アンバウンド型パラメータを持つメソッドの具体例が環境依存。
  - 候補：stdlib/Test/test/ 内の既存テストを参照
- **detect_closure_boxes (C-38)**: Core.Box割り当てがあるクロージャの具体例がコンパイラ内部実装に依存。
  - 候補：lowered code解析による動的テスト
- **_check_bitarray_consistency 不整合ケース**: 意図的に不整合なBitArrayを構築するのは内部フィールド操作が必要。
  - 候補：unsafe操作でchunksを直接変更

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Result型（Pass/Fail/Error/Broken）のテストケース - 構造体定義・表示ロジックはソースコードから明確に読み取れる
- **0 (低リスク)**: Generic型（GenericString/Set/Dict/Array/Order）のテストケース - 単純なラッパー型
- **0 (低リスク)**: ログテスト機能のテストケース - logging.jlのコードから直接導出
- **1 (中リスク)**: マクロ展開関連（@test, @test_throws, @testset等）のテストケースは内部関数のテストに置き換えて記述。マクロ自体のテストは統合テストで実施すべき
- **1 (中リスク)**: DefaultTestSetのスレッドセーフティ（results_lock, @atomic）に関するテストケースは並行実行環境が必要
- **2 (高リスク)**: detect_ambiguities/detect_unbound_args/detect_closure_boxesは実行環境・ロードされたモジュールに依存

## 6) レビュアーチェックリスト（最小）
- [ ] Result型（Pass/Fail/Error/Broken）のコンストラクタ・showメソッドのテストケースがソースコードと整合しているか
- [ ] do_test/do_broken_testの各分岐（Bool結果/非Bool/例外）が網羅されているか
- [ ] check_exception_matchの2引数形式と3引数形式の両方が網羅されているか
- [ ] DefaultTestSetのrecordメソッドが各Result型（Pass/Fail/Error/Broken/AbstractTestSet）に対してテストされているか
- [ ] TestLoggerのmaxlog制限テストが適切か（respect_maxlog=true/false）
- [ ] match_logsの:allモードと:anyモードの両方が網羅されているか
- [ ] detect_ambiguities/detect_unbound_args/detect_closure_boxesのテスト前提条件が実行可能か確認
- [ ] Generic型のテストケースが基本操作（iterate, length, isempty, getindex, setindex!）を網羅しているか
