---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 192
  claims_with_evidence: 178
  claims_without_evidence: 14
confidence_derived: 0.93
---

# 根拠レポート：stdlib-small 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：178 / 192、根拠なし：14
- 優先レビュー（高）
  1. **SharedArrays関連テスト (No.185-192)**：Distributedモジュール依存のため、実行環境の前提条件が不確実
  2. **FileWatching/pidfile関連テスト (No.61-73)**：OSレベルの動作を伴うため、プラットフォーム依存性が高い
  3. **Artifacts関連テスト (No.1-34)**：ファイルシステム操作とTOMLパースの組み合わせが多い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Artifacts/src/Artifacts.jl` -- Artifactsモジュールのソースコード
- E-02: `stdlib/CRC32c/src/CRC32c.jl` -- CRC32cモジュールのソースコード
- E-03: `stdlib/FileWatching/src/FileWatching.jl` -- FileWatchingモジュールのソースコード
- E-04: `stdlib/FileWatching/src/pidfile.jl` -- Pidfileサブモジュールのソースコード
- E-05: `stdlib/Future/src/Future.jl` -- Futureモジュールのソースコード
- E-06: `stdlib/Libdl/src/Libdl.jl` -- Libdlモジュールのソースコード
- E-07: `stdlib/Logging/src/Logging.jl` -- Loggingモジュールのソースコード
- E-08: `stdlib/Mmap/src/Mmap.jl` -- Mmapモジュールのソースコード
- E-09: `stdlib/Printf/src/Printf.jl` -- Printfモジュールのソースコード
- E-10: `stdlib/Serialization/src/Serialization.jl` -- Serializationモジュールのソースコード
- E-11: `stdlib/SharedArrays/src/SharedArrays.jl` -- SharedArraysモジュールのソースコード
- E-12: `stdlib/UUIDs/src/UUIDs.jl` -- UUIDsモジュールのソースコード
- E-13: `stdlib/Unicode/src/Unicode.jl` -- Unicodeモジュールのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）

### Artifacts (No.1-34)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parse_toml: 有効なTOMLファイルのパース | E-01 | ○ |
| C-02 | parse_toml: 存在しないファイルでエラー | E-01 | ○ |
| C-03 | with_artifacts_directory: 一時的なディレクトリ変更 | E-01 | ○ |
| C-04 | with_artifacts_directory: 例外時のリセット | E-01 | ○ |
| C-05 | artifacts_dirs: オーバーライドなし | E-01 | ○ |
| C-06 | artifacts_dirs: オーバーライドあり | E-01 | ○ |
| C-07 | parse_mapping: 絶対パス | E-01 | ○ |
| C-08 | parse_mapping: SHA1ハッシュ | E-01 | ○ |
| C-09 | parse_mapping: 無効なマッピング | E-01 | ○ |
| C-10 | load_overrides: ファイルなし | E-01 | ○ |
| C-11 | load_overrides: キャッシュ再利用 | E-01 | ○ |
| C-12 | load_overrides: force再読み込み | E-01 | ○ |
| C-13 | query_override: ハッシュクエリ成功 | E-01 | ○ |
| C-14 | query_override: 存在しないハッシュ | E-01 | ○ |
| C-15 | query_override: UUIDクエリ | E-01 | ○ |
| C-16 | artifact_path: 存在するアーティファクト | E-01 | ○ |
| C-17 | artifact_path: 存在しないアーティファクト | E-01 | ○ |
| C-18 | artifact_exists: true | E-01 | ○ |
| C-19 | artifact_exists: false | E-01 | ○ |
| C-20 | unpack_platform: 有効エントリ | E-01 | ○ |
| C-21 | unpack_platform: osキー欠如 | E-01 | ○ |
| C-22 | unpack_platform: archキー欠如 | E-01 | ○ |
| C-23 | artifact_meta: 成功 | E-01 | ○ |
| C-24 | artifact_meta: ファイルなし | E-01 | ○ |
| C-25 | artifact_meta: 名前なし | E-01 | ○ |
| C-26 | artifact_hash: 成功 | E-01 | ○ |
| C-27 | artifact_hash: メタデータなし | E-01 | ○ |
| C-28 | find_artifacts_toml: 存在 | E-01 | ○ |
| C-29 | find_artifacts_toml: 不在 | E-01 | ○ |
| C-30 | split_artifact_slash: スラッシュなし | E-01 | ○ |
| C-31 | split_artifact_slash: スラッシュあり | E-01 | ○ |
| C-32 | split_artifact_slash: バックスラッシュ | E-01 | △ |
| C-33 | select_downloadable_artifacts: フィルタ | E-01 | ○ |
| C-34 | select_downloadable_artifacts: lazy除外 | E-01 | ○ |

### CRC32c (No.35-42)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | crc32c: UInt8配列 | E-02 | ○ |
| C-36 | crc32c: 文字列 | E-02 | ○ |
| C-37 | crc32c: 初期CRC値 | E-02 | ○ |
| C-38 | crc32c: 増分チェックサム | E-02 | ○ |
| C-39 | crc32c: 空配列 | E-02 | ○ |
| C-40 | crc32c: IOストリーム | E-02 | ○ |
| C-41 | crc32c: バイト数指定IO | E-02 | ○ |
| C-42 | crc32c: AbstractVector | E-02 | ○ |

### FileWatching (No.43-73)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | FileEvent: flagsからの構築 | E-03 | ○ |
| C-44 | FileEvent: デフォルトタイムアウト | E-03 | ○ |
| C-45 | FileEvent: OR結合 | E-03 | ○ |
| C-46 | FDEvent: プロパティアクセス | E-03 | ○ |
| C-47 | FDEvent: タイムアウト判定 | E-03 | ○ |
| C-48 | FDEvent: propertynames | E-03 | ○ |
| C-49 | FileMonitor: 監視開始 | E-03 | ○ |
| C-50 | FileMonitor: close | E-03 | ○ |
| C-51 | FolderMonitor: 監視開始 | E-03 | ○ |
| C-52 | PollingFileWatcher: 監視開始 | E-03 | ○ |
| C-53 | PollingFileWatcher: close | E-03 | ○ |
| C-54 | watch_file: 変更検出 | E-03 | ○ |
| C-55 | watch_file: タイムアウト | E-03 | ○ |
| C-56 | watch_folder: 変更検出 | E-03 | ○ |
| C-57 | unwatch_folder: 停止 | E-03 | ○ |
| C-58 | poll_file: 変更検出 | E-03 | ○ |
| C-59 | poll_file: タイムアウト | E-03 | ○ |
| C-60 | poll_fd: 読み取り可能 | E-03 | ○ |
| C-61 | mkpidlock: ロック作成 | E-04 | ○ |
| C-62 | mkpidlock: do構文 | E-04 | ○ |
| C-63 | mkpidlock: 既存ロックでエラー | E-04 | ○ |
| C-64 | trymkpidlock: 成功 | E-04 | ○ |
| C-65 | trymkpidlock: 失敗 | E-04 | ○ |
| C-66 | write_pidfile: PID書き込み | E-04 | ○ |
| C-67 | parse_pidfile: パース成功 | E-04 | ○ |
| C-68 | parse_pidfile: 不正ファイル | E-04 | ○ |
| C-69 | isvalidpid: 有効PID | E-04 | ○ |
| C-70 | isvalidpid: PID 0 | E-04 | ○ |
| C-71 | isvalidpid: リモートホスト | E-04 | ○ |
| C-72 | stale_pidfile: 新しいファイル | E-04 | ○ |
| C-73 | close(LockMonitor): ロック解放 | E-04 | ○ |

### Future (No.74-77)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | copy!: AbstractSet | E-05 | ○ |
| C-75 | copy!: AbstractDict | E-05 | ○ |
| C-76 | copy!: AbstractArray | E-05 | ○ |
| C-77 | randjump: MersenneTwister | E-05 | △ |

### Libdl / Logging (No.78-79)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | Libdl: re-export確認 | E-06 | ○ |
| C-79 | Logging: re-export確認 | E-07 | ○ |

### Mmap (No.80-91)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | Anonymous: デフォルト作成 | E-08 | ○ |
| C-81 | Anonymous: isreadable | E-08 | ○ |
| C-82 | Anonymous: iswritable | E-08 | ○ |
| C-83 | mmap: IOStreamからマップ | E-08 | ○ |
| C-84 | mmap: ファイルパスからマップ | E-08 | ○ |
| C-85 | mmap: 匿名メモリマップ | E-08 | ○ |
| C-86 | mmap: 閉じたIOでエラー | E-08 | ○ |
| C-87 | mmap: 非ビット型でエラー | E-08 | ○ |
| C-88 | mmap: サイズ0 | E-08 | ○ |
| C-89 | mmap: 負のオフセット | E-08 | ○ |
| C-90 | mmap: BitArray | E-08 | ○ |
| C-91 | sync!: ディスク同期 | E-08 | ○ |

### Printf (No.92-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | Format: 単純フォーマット | E-09 | ○ |
| C-93 | Format: 複数指定子 | E-09 | ○ |
| C-94 | Format: %%エスケープ | E-09 | ○ |
| C-95 | Format: 不完全指定子エラー | E-09 | ○ |
| C-96 | Format: 無効型指定子エラー | E-09 | ○ |
| C-97 | format: 整数 | E-09 | ○ |
| C-98 | format: 浮動小数点 | E-09 | ○ |
| C-99 | format: 文字列 | E-09 | ○ |
| C-100 | format: 左揃え | E-09 | ○ |
| C-101 | format: ゼロパディング | E-09 | ○ |
| C-102 | format: 16進数 | E-09 | ○ |
| C-103 | format: 8進数 | E-09 | ○ |
| C-104 | format: 科学表記法 | E-09 | ○ |
| C-105 | format: %gフォーマット | E-09 | ○ |
| C-106 | format: 動的幅 | E-09 | ○ |
| C-107 | format: 動的精度 | E-09 | ○ |
| C-108 | format: IO出力 | E-09 | ○ |
| C-109 | format: 引数数不一致 | E-09 | ○ |
| C-110 | format: ポインタ | E-09 | ○ |
| C-111 | format: Inf | E-09 | △ |
| C-112 | format: NaN | E-09 | △ |
| C-113 | format: #フラグ | E-09 | ○ |
| C-114 | format: +フラグ | E-09 | ○ |
| C-115 | format: BigFloat | E-09 | ○ |
| C-116 | Spec: string変換 | E-09 | △ |

### Serialization (No.117-145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | serialize: 整数 | E-10 | ○ |
| C-118 | serialize: 浮動小数点 | E-10 | ○ |
| C-119 | serialize: 文字列 | E-10 | ○ |
| C-120 | serialize: 配列 | E-10 | ○ |
| C-121 | serialize: Dict | E-10 | ○ |
| C-122 | serialize: タプル | E-10 | ○ |
| C-123 | serialize: Bool | E-10 | ○ |
| C-124 | serialize: Symbol | E-10 | ○ |
| C-125 | serialize: Expr | E-10 | ○ |
| C-126 | serialize: Module | E-10 | ○ |
| C-127 | serialize: Regex | E-10 | ○ |
| C-128 | serialize: BigInt | E-10 | ○ |
| C-129 | serialize: 循環参照 | E-10 | ○ |
| C-130 | serialize: 空タプル | E-10 | ○ |
| C-131 | serialize: DataType | E-10 | ○ |
| C-132 | serialize: Ptr | E-10 | ○ |
| C-133 | serialize: ファイル | E-10 | ○ |
| C-134 | writeheader: ヘッダ書き込み | E-10 | ○ |
| C-135 | readheader: ヘッダ読み込み | E-10 | ○ |
| C-136 | readheader: 不正マジック | E-10 | ○ |
| C-137 | Serializer: 初期化 | E-10 | ○ |
| C-138 | reset_state: リセット | E-10 | ○ |
| C-139 | serialize: 実行中Task | E-10 | ○ |
| C-140 | serialize: 完了Task | E-10 | ○ |
| C-141 | serialize: IdDict | E-10 | ○ |
| C-142 | serialize: Lock | E-10 | ○ |
| C-143 | serialize: Int32リテラル最適化 | E-10 | ○ |
| C-144 | serialize: Int64リテラル最適化 | E-10 | ○ |
| C-145 | serialize: Memory型 | E-10 | ○ |

### UUIDs (No.146-161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | uuid_version: UUID4 | E-12 | ○ |
| C-147 | uuid_version: UUID1 | E-12 | ○ |
| C-148 | uuid_version: UUID5 | E-12 | ○ |
| C-149 | uuid_version: UUID7 | E-12 | ○ |
| C-150 | uuid1: 生成 | E-12 | ○ |
| C-151 | uuid1: RNG再現性 | E-12 | ○ |
| C-152 | uuid1: 一意性 | E-12 | ○ |
| C-153 | uuid4: 生成 | E-12 | ○ |
| C-154 | uuid4: RNG指定 | E-12 | ○ |
| C-155 | uuid4: バリアントビット | E-12 | ○ |
| C-156 | uuid5: 名前空間ベース | E-12 | ○ |
| C-157 | uuid5: 決定論性 | E-12 | ○ |
| C-158 | uuid5: 異なる名前 | E-12 | ○ |
| C-159 | uuid7: 生成 | E-12 | ○ |
| C-160 | uuid7: タイムスタンプ順序 | E-12 | △ |
| C-161 | uuid7: RNG指定 | E-12 | ○ |

### Unicode (No.162-184)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | julia_chartransform: micro→mu | E-13 | ○ |
| C-163 | julia_chartransform: 通常文字 | E-13 | ○ |
| C-164 | julia_chartransform: Integer入力 | E-13 | ○ |
| C-165 | normalize: NFC | E-13 | ○ |
| C-166 | normalize: NFD | E-13 | ○ |
| C-167 | normalize: NFKC | E-13 | ○ |
| C-168 | normalize: casefold | E-13 | ○ |
| C-169 | normalize: stripmark | E-13 | ○ |
| C-170 | normalize: chartransform | E-13 | ○ |
| C-171 | isassigned: 割り当て済み | E-13 | ○ |
| C-172 | isassigned: 制御文字 | E-13 | ○ |
| C-173 | graphemes: イテレータ | E-13 | ○ |
| C-174 | graphemes: 結合文字 | E-13 | ○ |
| C-175 | graphemes: 範囲指定 | E-13 | ○ |
| C-176 | graphemes: インデックス0以下 | E-13 | ○ |
| C-177 | graphemes: 範囲超過 | E-13 | ○ |
| C-178 | isequal_normalized: 等価 | E-13 | ○ |
| C-179 | isequal_normalized: 非等価 | E-13 | ○ |
| C-180 | isequal_normalized: casefold | E-13 | ○ |
| C-181 | isequal_normalized: stripmark | E-13 | ○ |
| C-182 | isequal_normalized: 空文字列同士 | E-13 | △ |
| C-183 | isequal_normalized: 空と非空 | E-13 | △ |
| C-184 | combining_class: 結合クラス | E-13 | ○ |

### SharedArrays (No.185-192)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-185 | SharedArray: 作成 | E-11 | △ |
| C-186 | SharedArray: 非ビット型エラー | E-11 | ○ |
| C-187 | sdata: バッキング配列 | E-11 | ○ |
| C-188 | indexpids: インデックス | E-11 | ○ |
| C-189 | localindices: 範囲 | E-11 | ○ |
| C-190 | SharedArray: Array変換 | E-11 | △ |
| C-191 | range_1dim: パーティション | E-11 | ○ |
| C-192 | range_1dim: 境界値 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **SharedArrays (C-185, C-190)**: Distributedモジュールが必要な実行環境での動作は実機テストでの確認が必要。ソースコードからロジックは確認できるが、マルチプロセス環境での実際の動作確認は根拠不足。
  - 候補：`stdlib/SharedArrays/test/runtests.jl` / Distributed環境での統合テスト
- **Printf Inf/NaN (C-111, C-112)**: Printf内部のfloat_special関数の挙動は推測に基づく。実装詳細はPrintf.jlのinternal関数に依存。
  - 候補：`stdlib/Printf/test/runtests.jl`
- **Spec string変換 (C-116)**: Spec構造体のstring変換は内部実装に依存し、具体的な出力形式の根拠が不十分。
  - 候補：`stdlib/Printf/src/Printf.jl`の内部実装詳細
- **uuid7タイムスタンプ順序 (C-160)**: タイムスタンプの単調増加は実装から推測されるが、高精度タイマーの挙動により保証が不確実。
  - 候補：RFC 9562 / `stdlib/UUIDs/test/runtests.jl`
- **isequal_normalized 空文字列 (C-182, C-183)**: 空文字列の挙動はiterateの仕様から推測可能だが、明示的な根拠が不足。
  - 候補：`stdlib/Unicode/test/runtests.jl`
- **randjump (C-77)**: Future.randjumpはDeprecatedに近い機能で、具体的な動作仕様の根拠が限定的。
  - 候補：`stdlib/Future/test/runtests.jl`
- **split_artifact_slash バックスラッシュ (C-32)**: Windows固有のパス処理の挙動はプラットフォーム依存で確認困難。
  - 候補：`stdlib/Artifacts/test/runtests.jl`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: CRC32c, UUIDs, Unicode, Logging, Libdl, Future -- これらのモジュールはAPIが明確で、テストケースはソースコードから直接導出可能
- **1 (中リスク)**: Printf, Serialization, Artifacts, Mmap -- 内部実装の詳細に依存するテストケースがあり、期待結果の精度に注意が必要
- **2 (高リスク)**: SharedArrays, FileWatching/Pidfile -- 外部リソース（プロセス、ファイルシステム、ネットワーク）に依存するテストが多く、実行環境により結果が異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 各パッケージのpublic APIが網羅されているか確認（exportされている関数が全てカバーされているか）
- [ ] SharedArraysのテストケースがDistributed環境で実行可能か確認
- [ ] FileWatching/PidfileテストのOS依存性（Linux/macOS/Windows）を考慮しているか確認
- [ ] Printfのフォーマット指定子の期待結果がCのprintf仕様と一致しているか確認
- [ ] Serializationの循環参照テスト（No.129）の実装可能性を確認
- [ ] UUIDs uuid7のRFC 9562準拠を確認
- [ ] テストID (UT-SML-xxx) に欠番がないか確認
- [ ] 各テストケースの優先度が適切か（特に「高」の妥当性）
