---
generated_at: 2026-02-04 00:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された帳票一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **バグレポート（インタラクティブ）**：report_bug 関数は BugReporting 外部パッケージに依存しており、実際の帳票出力内容はプロジェクト外部で定義されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `stdlib/Profile/src/Profile.jl` - print_flat 関数（行889）、print_tree 関数（行1238）、print 関数（行271-368）
- E-02: `stdlib/Profile/src/Profile.jl` - take_heap_snapshot 関数（行1407-1468）
- E-03: `stdlib/Profile/src/Profile.jl` - take_page_profile 関数（行1477-1482）
- E-04: `stdlib/Profile/src/Allocs.jl` - Allocs.print 関数、@profile マクロ
- E-05: `base/timing.jl` - time_print 関数（行252-303）、timev_print 関数（行305-322）、@time マクロ（行335）、@timev マクロ（行430）
- E-06: `stdlib/Test/src/Test.jl` - print_test_results 関数（行1645-1649）、finish 関数（行1709）
- E-07: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` - versioninfo 関数（行103）
- E-08: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` - report_bug 関数（行349-376）
- E-09: `doc/make.jl` - Documenter.jl によるドキュメント生成スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPUプロファイルレポート（フラットフォーマット）：Profile.print(format=:flat) でフラット形式のプロファイル結果を出力 | E-01 | ○ |
| C-02 | CPUプロファイルレポート（ツリーフォーマット）：Profile.print(format=:tree) でツリー形式のプロファイル結果を出力 | E-01 | ○ |
| C-03 | メモリアロケーションプロファイルレポート：Profile.Allocs.print() でアロケーション情報を出力 | E-04 | ○ |
| C-04 | ヒープスナップショット：Profile.take_heap_snapshot() で .heapsnapshot ファイルを出力 | E-02 | ○ |
| C-05 | ページプロファイル：Profile.take_page_profile() でページレベルのメモリ使用状況を出力 | E-03 | ○ |
| C-06 | @time レポート：@time マクロで実行時間等のパフォーマンス情報を出力 | E-05 | ○ |
| C-07 | @timev レポート：@timev マクロで詳細パフォーマンス情報を出力 | E-05 | ○ |
| C-08 | テスト結果サマリーレポート：Test.print_test_results() でテスト結果を表形式で出力 | E-06 | ○ |
| C-09 | バージョン情報レポート：versioninfo() でシステム情報をレポート | E-07 | ○ |
| C-10 | バグレポート（インタラクティブ）：report_bug() でバグレポートを生成 | E-08 | △ |
| C-11 | Documenter.jl ドキュメント生成：doc/make.jl でHTMLドキュメントを生成 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-10（バグレポート）の出力内容の詳細は BugReporting パッケージ（外部依存）で定義されており、プロジェクトコード内では report_bug 関数が BugReporting.make_interactive_report を呼び出すラッパーのみ存在する。実際の出力形式はプロジェクト外のコードに依存。
  - 候補：BugReporting パッケージのソースコード / Julia公式ドキュメント / パッケージリポジトリ
- 本プロジェクトはプログラミング言語（Julia）のランタイムおよび標準ライブラリであり、一般的なビジネスアプリケーションとは異なり、帳票（定型フォーマットの出力ドキュメント）は限定的である。上記は「構造化された出力レポート」としての機能を帳票と解釈して抽出した。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSVの帳票分類は主観的な側面があるが、ソースコードの根拠に基づいている
- 1: 中リスク - 本プロジェクトはプログラミング言語のソースコードであり、「帳票」の定義がビジネスアプリケーションとは異なる。レビュアーは帳票の範囲定義について確認が必要
- 1: 中リスク - C-10（バグレポート）は外部パッケージ依存のため、出力内容の正確性を本プロジェクト内で完全に検証できない

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票の範囲定義（プログラミング言語のランタイムにおける「帳票」とは何か）が妥当か確認
- [ ] 各帳票の説明がソースコードの実装と一致しているか確認
- [ ] Profile.print のフラット/ツリーを別帳票として分離する判断が妥当か確認
- [ ] バグレポート（C-10）の外部パッケージ依存について、帳票一覧に含めるべきか判断
- [ ] 漏れている帳票相当の出力機能がないか確認（例：ログ出力、REPL表示等を帳票に含めるかの判断）
