# 帳票設計書 10-バグレポート（インタラクティブ）

## 概要

本ドキュメントは、Julia の `InteractiveUtils.report_bug()` によって生成されるインタラクティブバグレポートの設計仕様を記述する。

### 本帳票の処理概要

本帳票は、Julia のバグ報告を対話的に作成するための機能である。`report_bug()` 関数は `BugReporting` パッケージを動的にロードし、その `make_interactive_report()` 関数を呼び出してバグレポートを生成する。バグレポートには rr（Record & Replay）トレースなどの再現情報が含まれる。

**業務上の目的・背景**：Julia のバグを正確に再現可能な形で報告するために、環境情報やプログラムの実行トレースを含む包括的なバグレポートを対話的に生成する仕組みが必要である。BugReporting パッケージを活用することで、rr トレースを含む詳細な再現情報を自動的に収集できる。

**帳票の利用シーン**：Julia の実行中にバグに遭遇した場合に、開発者がバグレポートを作成するために使用する。特に、再現が困難なバグの場合に rr トレースを添付することで、Julia 開発チームによる問題の特定を支援する。

**主要な出力内容**：
1. rr トレース（Record & Replay デバッガの実行記録）
2. 環境情報（versioninfo 相当）
3. バグの説明（ユーザー入力）
4. コマンドライン引数情報

**帳票の出力タイミング**：`InteractiveUtils.report_bug(kind)` を呼び出したとき。

**帳票の利用者**：Julia のバグに遭遇した開発者。

## 帳票種別

対話的レポート（バグ報告の生成支援）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Julia REPL | julia> | `InteractiveUtils.report_bug(kind)` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | BugReporting パッケージが決定する形式 |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | BugReporting パッケージが決定 |
| 出力方法 | BugReporting.make_interactive_report() に委譲 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

バグレポートのレイアウトは `BugReporting` パッケージの実装に依存する。`report_bug()` は以下の情報を `make_interactive_report()` に渡す：
- `kind`：バグレポートの種類
- `ARGS`：コマンドライン引数

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| kind | バグレポートの種類 | Yes |

### 改ページ条件

N/A

## データベース参照仕様

本帳票自体はデータベースを参照しない。BugReporting パッケージの内部実装に依存する。

## 計算仕様

本帳票自体は計算処理を行わない。BugReporting パッケージに処理を委譲する。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A["report_bug(kind) 呼び出し"] --> B["@info: Loading BugReporting package"]
    B --> C{BugReporting がインストール済み?}
    C -->|Yes| D["Base.require(BugReportingId)"]
    C -->|No| E["一時環境を作成"]
    E --> F["Pkg.add(BugReporting)"]
    F --> G["Base.require(BugReportingId)"]
    D --> H["@invokelatest BugReporting.make_interactive_report(kind, ARGS)"]
    G --> H
    H --> I["終了"]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パッケージ未找到 | BugReporting パッケージが見つからない | "Package `BugReporting` not found - attempting temporary installation" | 一時環境で自動インストールを試行 |
| インストール失敗 | Pkg.add が失敗 | Pkg のエラーメッセージ | ネットワーク接続を確認、手動でインストール |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回のレポート生成 |
| 目標出力時間 | パッケージのロード・インストール時間に依存 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

- バグレポートにはシステム情報やプログラムの実行トレースが含まれる可能性がある。
- rr トレースにはメモリの内容が含まれる場合があり、機密データが漏洩するリスクがある。
- BugReporting パッケージがネットワーク経由でインストールされる場合、パッケージの真正性に注意が必要。
- 一時環境の作成時に LOAD_PATH が変更されるため、他のコードに影響を与える可能性がある（処理後に復元される）。

## 備考

- `BugReporting` パッケージの UUID は `bcf9a6e7-4020-453c-b88e-690564246bb8`。
- パッケージが環境に存在しない場合、一時ディレクトリに新しい環境を作成して自動インストールを試みる。
- `LOAD_PATH` と `ACTIVE_PROJECT` は一時的に変更され、処理後に復元される。
- `@invokelatest` が使用されるのは、動的にロードされたパッケージの関数を呼び出すため。
- Pkg 標準ライブラリも動的に `Base.require_stdlib` で読み込まれる。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `report_bug(kind)` 関数（行349-376）で、BugReporting パッケージのロードと呼び出しを理解する |

**主要処理フロー**:
1. **行350**: `@info "Loading BugReporting package..."` でユーザーに通知
2. **行351-352**: `BugReportingId` の PkgId を構築（UUID: `bcf9a6e7-4020-453c-b88e-690564246bb8`）
3. **行354-373**: パッケージの存在確認と条件分岐
4. **行354**: `Base.locate_package(BugReportingId)` で存在確認
5. **行355-371**: 存在しない場合 → 一時環境を作成し Pkg.add でインストール
6. **行372-373**: 存在する場合 → `Base.require(BugReportingId)` で直接ロード
7. **行375**: `@invokelatest BugReporting.make_interactive_report(kind, ARGS)` で呼び出し

#### Step 2: 一時環境でのインストール処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | 行357-370 の一時環境作成ロジックを理解する |

**主要処理フロー**:
- **行357-358**: Pkg 標準ライブラリを `Base.require_stdlib` で動的ロード
- **行359**: `mktempdir()` で一時ディレクトリ作成
- **行360-361**: `LOAD_PATH` を一時環境の Project.toml に変更
- **行362-363**: `ACTIVE_PROJECT` を nil に設定
- **行364**: PackageSpec を作成
- **行365**: `Pkg.add(pkgspec)` でインストール
- **行366**: `Base.require(BugReportingId)` でロード
- **行367-368**: `LOAD_PATH` と `ACTIVE_PROJECT` を復元

### プログラム呼び出し階層図

```
InteractiveUtils.report_bug(kind)
    |
    +-- @info "Loading BugReporting package..."
    |
    +-- Base.locate_package(BugReportingId)
    |
    +-- (パッケージ存在) Base.require(BugReportingId) ──> BugReporting
    |
    +-- (パッケージ不在)
    |       +-- Base.require_stdlib(Pkg)
    |       +-- mktempdir()
    |       +-- LOAD_PATH 変更
    |       +-- @invokelatest Pkg.add(pkgspec)
    |       +-- Base.require(BugReportingId) ──> BugReporting
    |       +-- LOAD_PATH 復元
    |
    +-- @invokelatest BugReporting.make_interactive_report(kind, ARGS)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

kind (バグ種別) ─┐
ARGS (CLI引数) ──┤
                 ├── report_bug()
                 |       |
                 |       +-- BugReporting パッケージロード
                 |       |       |
                 |       |       +-- (不在時) 一時環境 + Pkg.add
                 |       |
                 |       +-- make_interactive_report(kind, ARGS)
                 |                   |
                 └──────────────> バグレポート出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | ソース | report_bug 関数（行349-376） |
| BugReporting パッケージ | 外部パッケージ | 外部依存 | make_interactive_report の実装（動的ロード） |
