# 帳票設計書 11-Documenter.jl ドキュメント生成

## 概要

本ドキュメントは、Julia公式ドキュメント（HTMLマニュアル / PDFマニュアル）の生成処理に関する帳票設計書である。`doc/make.jl` を起点として Documenter.jl パッケージを使用し、Julia のマニュアル・Base ドキュメント・標準ライブラリドキュメント・開発者向けドキュメントを統合的に生成する仕組みについて記述する。

### 本帳票の処理概要

本帳票は、Julia プロジェクトの公式ドキュメントをビルドし、HTML または PDF 形式で出力する処理を担う。`doc/make.jl` スクリプトが Documenter.jl の `makedocs()` 関数を呼び出し、Markdown ソースファイル群と docstring を統合して、構造化されたドキュメントサイトを生成する。

**業務上の目的・背景**：Julia はオープンソースのプログラミング言語であり、利用者が言語仕様・API・標準ライブラリ・開発者向け情報を参照できる公式ドキュメントが不可欠である。このドキュメント生成パイプラインは、ソースコード中の docstring と `doc/src/` 配下の Markdown ファイルを統合し、一貫性のある公式リファレンスを自動生成することで、ドキュメントの品質維持と更新コストの低減を実現する。

**帳票の利用シーン**：(1) Julia のリリースビルド時に公式ドキュメントサイトを生成・デプロイする場面、(2) 開発者がローカル環境でドキュメントの修正内容を確認する場面、(3) CI/CD パイプラインで doctest（ドキュメント内コード例のテスト）を実行して品質を検証する場面で利用される。

**主要な出力内容**：
1. Julia マニュアル（Getting Started、Variables、Types 等の全章）
2. Base モジュールの API リファレンス（Collections、Math、Strings、Arrays 等）
3. 標準ライブラリ（Profile、Test、LinearAlgebra 等）の API リファレンス
4. 開発者向けドキュメント（コンパイラ内部構造、ビルド手順、コントリビューションガイド等）
5. NEWS.md（リリースノート）の HTML/PDF 変換版
6. doctest の検証結果

**帳票の出力タイミング**：`make docs`（HTMLビルド）、`make -C doc pdf`（PDFビルド）、`make -C doc deploy`（デプロイ）コマンドの実行時、または CI/CD パイプラインにおけるドキュメントビルドジョブの実行時に出力される。

**帳票の利用者**：Julia のエンドユーザー（プログラマー・研究者・データサイエンティスト）、Julia コア開発者、標準ライブラリ開発者、ドキュメントコントリビューター。

## 帳票種別

技術リファレンスドキュメント（HTML サイト / PDF マニュアル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドラインインターフェース | - | `make docs` / `make -C doc html` / `make -C doc pdf` |
| - | CI/CD パイプライン（BuildKite） | - | `make -C doc deploy` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（デフォルト）/ PDF（LaTeX経由） |
| 用紙サイズ | PDF時: A4（LaTeX設定に依存） |
| 向き | PDF時: 縦 |
| ファイル名 | HTML: `doc/_build/html/en/` 配下に各ページの `.html` ファイル、PDF: `julia-{VERSION}.pdf` |
| 出力方法 | ローカルビルド: ファイルシステムへの出力、デプロイ: `docs.julialang.org` への Git push |
| 文字コード | UTF-8 |

### HTML 固有設定

| 項目 | 内容 |
|-----|------|
| prettyurls | デプロイ時: true（クリーンURL）、ローカルビルド時: false |
| canonical URL | デプロイ時: `https://docs.julialang.org/en/v1/` |
| カスタムCSS | `assets/julia-manual.css` |
| favicon | `assets/julia.ico` |
| アナリティクス | `UA-28835595-6`（Google Analytics） |
| collapselevel | 1（サイドバー折りたたみレベル） |
| sidebar_sitename | false |
| ansicolor | true（ANSIカラーコード表示対応） |
| size_threshold | 800 KiB（ページサイズ上限） |
| size_threshold_warn | 200 KiB（警告閾値） |

### PDF 固有設定（LaTeX）

| 項目 | 内容 |
|-----|------|
| platform | `native`（デフォルト）/ `docker`（`texplatform=docker` 指定時） |
| カスタムスタイル | `assets/custom.sty` |
| 表紙 | `assets/cover.tex` / `assets/cover-splash.tex` |
| プリアンブル | `assets/preamble.tex` |
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

ドキュメント全体は以下の大セクションで構成される。HTML 版はナビゲーション付きのマルチページサイト、PDF 版は単一のドキュメントとなる。

```
┌──────────────────────────────────────────────┐
│           Julia Documentation (index.md)      │
├──────────────────────────────────────────────┤
│  NEWS.md (リリースノート)                       │
├──────────────────────────────────────────────┤
│  Manual (38章)                                │
│    getting-started, variables, types, ...     │
├──────────────────────────────────────────────┤
│  Base (19セクション)                           │
│    base, collections, math, numbers, ...     │
├──────────────────────────────────────────────┤
│  Standard Library (動的生成)                   │
│    Profile, Test, LinearAlgebra, ...         │
├──────────────────────────────────────────────┤
│  Developer Documentation                      │
│    Internals / Debugging / Building / Guide  │
└──────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | サイト名 | ドキュメントサイトのタイトル | `makedocs()` の `sitename` パラメータ | "The Julia Language" |
| 2 | バージョン | Julia のバージョン番号 | `VERSION` 定数 | "v{MAJOR}.{MINOR}-dev" 等 |
| 3 | 著者 | ドキュメントの著者 | `makedocs()` の `authors` パラメータ | "The Julia Project" |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Manual セクション | Julia 言語の使い方ガイド（38ファイル） | `doc/src/manual/*.md` | Markdown -> HTML/LaTeX | - |
| 2 | Base セクション | Base モジュール API リファレンス（19ファイル） | `doc/src/base/*.md` + docstrings | Markdown + @docs ブロック | - |
| 3 | Standard Library セクション | 標準ライブラリドキュメント（動的生成） | `stdlib/*/docs/src/index.md` | シンボリックリンク経由 | - |
| 4 | Developer Documentation セクション | 開発者向けドキュメント（4サブセクション） | `doc/src/devdocs/**/*.md` | Markdown -> HTML/LaTeX | - |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NEWS | リリースノート | `NEWS.md`（`generate_markdown` 関数で変換） | Issue リンク付き Markdown |
| 2 | ビルド情報 | Documenter.jl によるフッター | Documenter.jl 自動生成 | "Powered by Documenter.jl" 等 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ソースディレクトリ | `doc/src/` 配下の Markdown ファイル群 | Yes |
| モジュール | Main, Base, Core, および全標準ライブラリモジュール | Yes |
| doctest モード | `doctest=true`/`doctest=fix`/`doctest=only`/`false`（デフォルト: false） | No |
| linkcheck | `linkcheck=true` でリンク検証を実行 | No |
| render_pdf | `pdf` 引数で PDF モードを有効化 | No |
| revise | `revise=true` で Revise.jl を使用した動的コード更新を有効化 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | PAGES 配列で定義されたセクション順 | 定義順 |
| 2 | Standard Library のソート | アルファベット昇順（特殊マッピングあり: Libdl -> "Dynamic Linker", Test -> "Unit Testing"） |

### 改ページ条件

- HTML 版: 各 Markdown ファイルが独立したページとなる
- PDF 版: LaTeX のセクション区切りに基づいて改ページが発生する

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、ファイルシステム上のソースファイルを参照する。

| テーブル名（参照元） | 用途 | 結合条件 |
|-----------|------|---------|
| `doc/src/**/*.md` | Manual、Base、DevDocs の Markdown ソース | PAGES 配列で定義されたパス |
| `stdlib/*/docs/src/index.md` | 標準ライブラリドキュメント | STDLIB_DIR から動的に検出 |
| `base/**/*.jl` | Base モジュールの docstring | `@docs` ブロックで参照 |
| `stdlib/**/*.jl` | 標準ライブラリの docstring | `@docs` ブロックで参照 |
| `stdlib/*.version` | 外部 stdlib の Git リポジトリ情報 | `parse_stdlib_version_file` で解析 |
| `NEWS.md` | リリースノート | `generate_markdown` 関数で変換 |

### テーブル別参照項目詳細

#### stdlib/*.version ファイル

| 参照項目（キー名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `{PACKAGE}_GIT_URL` | Documenter remotes の GitHub リポジトリ情報 | 全 .version ファイルを走査 | LibGit2.GITHUB_REGEX でパース |
| `{PACKAGE}_SHA1` | Documenter remotes のコミット SHA | 全 .version ファイルを走査 | ソースリンク生成に使用 |

#### NEWS.md

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Issue 番号 `[#xxxx]` | GitHub Issue へのリンク | 正規表現 `\[#([0-9]+)\]` | `https://github.com/JuliaLang/julia/issues/{N}` に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| StdlibDocs ソート順 | `sort!(StdlibDocs, by=...)` で特殊マッピング適用後に lowercase でソート | - | Libdl -> "Dynamic Linker", Test -> "Unit Testing" に置換 |
| デプロイサブフォルダ | `v{VERSION.major}.{VERSION.minor}-dev`（dev）、`v{VERSION}`（タグ付きリリース）、`v{release}-dev`（release ブランチ） | - | `deploy_folder` メソッドで決定 |
| NEWS.md Issue リンク変換 | `[#N]` -> `[#N](https://github.com/JuliaLang/julia/issues/N)` | - | `generate_markdown` 関数内の正規表現置換 |
| 外部 stdlib URL 変換 | 生成 HTML 内の `JuliaLang/julia/blob/master/stdlib/{NAME}-{SHA}/...` -> `JuliaLang/{NAME}.jl/blob/master/...` | - | ビルド後の HTML ファイル後処理 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[make docs / make -C doc html] --> B[Makefile: deps ターゲット実行]
    B --> C[UnicodeData.txt ダウンロード・チェックサム検証]
    C --> D[Julia で doc/make.jl を実行]
    D --> E[buildroot / stdlibdir パラメータ解析]
    E --> F[Documenter パッケージ依存関係インストール]
    F --> G[stdlib ドキュメントのシンボリックリンク作成]
    G --> H[stdlib .version ファイルから remotes 情報構築]
    H --> I[NEWS.md を Markdown 変換]
    I --> J[DocTestSetup 設定]
    J --> K{revise=true?}
    K -->|Yes| L[Revise.jl でモジュール追跡]
    K -->|No| M[makedocs 実行]
    L --> M
    M --> N{format?}
    N -->|HTML| O[Documenter.HTML で HTML 生成]
    N -->|PDF| P[Documenter.LaTeX で PDF 生成]
    O --> Q[外部 stdlib URL 後処理]
    P --> R{deploy?}
    Q --> R
    R -->|Yes| S[deploydocs で docs.julialang.org にデプロイ]
    R -->|No| T[ローカル出力完了]
    S --> U[終了]
    T --> U
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| stdlib .version パースエラー | .version ファイルの行が正規表現にマッチしない | `"Unable to parse line in $(path)"` (warn) | .version ファイルの書式を修正 |
| GIT_URL 未設定 | .version ファイルに `{PACKAGE}_GIT_URL` キーが存在しない | `"Missing $(git_url_key) in $version_fname"` (error) | .version ファイルに GIT_URL を追加 |
| GIT_URL パースエラー | GIT_URL が GitHub URL 形式でない | `"Unable to parse $(git_url_key)='...' in $version_fname"` (error) | GIT_URL を正しい GitHub URL 形式に修正 |
| SHA1 未設定 | .version ファイルに `{PACKAGE}_SHA1` キーが存在しない | `"Missing $(sha_key) in $version_fname"` (error) | .version ファイルに SHA1 を追加 |
| DOCUMENTER_KEY 未設定 | デプロイ時に環境変数 `DOCUMENTER_KEY` が存在しない | `"Unable to deploy the documentation: DOCUMENTER_KEY missing"` (info) | 環境変数を設定するか、デプロイをスキップ |
| デプロイ条件不一致 | タグ付きコミットでも master ブランチでも release ブランチでもない | `"Unable to deploy the documentation: invalid GIT_VERSION_INFO"` (info) | 正しいブランチまたはタグからビルドを実行 |
| ページサイズ超過 | 生成 HTML ページが 800 KiB を超える | Documenter.jl のサイズ閾値エラー | ページを分割するか、コンテンツを削減 |
| doctest 失敗 | ドキュメント内のコード例の出力が期待値と一致しない | Documenter.jl の doctest エラーメッセージ | コード例または期待出力を修正（`doctest=fix` で自動修正可能） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | Manual 38 ファイル + Base 19 ファイル + stdlib 約 20 パッケージ + DevDocs 約 30 ファイル = 合計約 110 ファイル |
| 目標出力時間 | HTML ビルド: 数分程度、doctest 付きビルド: 最大 15 分 |
| 同時出力数上限 | 1（シングルプロセスで逐次実行） |

## セキュリティ考慮事項

- デプロイ時には `DOCUMENTER_KEY` 環境変数（SSH デプロイキー）が必要であり、CI 環境でのみ設定される
- デプロイ先リポジトリ（`docs.julialang.org`）への HTTPS 認証による push を使用
- ドキュメント自体には個人情報は含まれないが、Google Analytics トラッキングコード（`UA-28835595-6`）が埋め込まれる
- `linkcheck_ignore` により特定の外部 URL を検証対象から除外している

## 備考

- Documenter.jl v1.16.1 を使用（`deps/jlutilities/documenter/Manifest.toml` で管理）
- 標準ライブラリのうち `Pkg` は外部ホスト（`EXT_STDLIB_DOCS`）として扱われ、`basedocs.md` を参照する
- 一部の標準ライブラリ（ArgTools, LibCURL, SHA, Tar）は JuliaLang 以外の GitHub Organization でホストされており、URL 後処理で正しいリポジトリに書き換えられる
- バージョンセレクターにリリース候補（RC）版を表示するための `Versions` 構造体によるハックが含まれる
- `revise=true` オプションにより、sysimage を再ビルドせずにコード変更を反映した doctest 実行が可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ドキュメント生成パイプラインで扱われるデータ構造（ページ構成、stdlib 情報、リモート情報）を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | make.jl | `doc/make.jl` | 48行目: `STDLIB_DOCS` 配列（stdlib ドキュメント情報の蓄積先）、49行目: `EXT_STDLIB_DOCS` 配列（外部ホスト stdlib の定義） |
| 1-2 | make.jl | `doc/make.jl` | 161-303行目: `Manual`, `BaseDocs`, `StdlibDocs`, `DevDocs` の各ページ配列定義。これらが `PAGES` 定数に統合される |
| 1-3 | make.jl | `doc/make.jl` | 94-140行目: `documenter_stdlib_remotes` 辞書の構築。外部 stdlib の Git リポジトリ情報を `.version` ファイルから解析し、Documenter の `remotes` 引数に渡す形式に変換する |

**読解のコツ**: Julia の `let` ブロックはスコープ制限のために使われている。`let r = ..., i = ...` のパターンは、ローカル変数を定義して直後のブロック内でのみ使用可能にするイディオムである。

#### Step 2: エントリーポイントを理解する

処理の起点は Makefile から Julia スクリプトが呼び出される部分である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Makefile | `doc/Makefile` | 62-65行目: `html` ターゲット。`deps` を先に実行し、`$(JULIA_EXECUTABLE)` で `make.jl` を呼び出す |
| 2-2 | Makefile | `doc/Makefile` | 25-26行目: `DOCUMENTER_OPTIONS` 変数。`linkcheck`, `doctest`, `buildroot`, `texplatform`, `revise`, `stdlibdir` のパラメータを make.jl に渡す |
| 2-3 | make.jl | `doc/make.jl` | 1-22行目: コマンドライン引数の解析。`buildroot=...` と `stdlibdir=...` を正規表現でパースし、グローバル定数として設定する |

**主要処理フロー**:
1. **Makefile 62行目**: `html` ターゲットが `deps` を前提条件として実行
2. **Makefile 42-44行目**: `deps` ターゲットが UnicodeData.txt のダウンロードとチェックサム検証を実行
3. **Makefile 64行目**: Julia で `make.jl` を実行（`DOCUMENTER_OPTIONS` を引数として渡す）
4. **make.jl 1-22行目**: buildroot と stdlibdir のパラメータ解析
5. **make.jl 25-31行目**: Documenter パッケージの依存関係インストール

#### Step 3: stdlib ドキュメントリンク構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | make.jl | `doc/make.jl` | 50-69行目: `cd(joinpath(buildrootdoc, "src"))` 内で `stdlib/` ディレクトリにシンボリックリンクを作成。各 stdlib パッケージの `docs/src/index.md`（または外部 stdlib の場合は `basedocs.md`）を `doc/src/stdlib/{PackageName}.md` としてリンクする |
| 3-2 | make.jl | `doc/make.jl` | 80-91行目: `parse_stdlib_version_file` 関数。`.version` ファイルの各行を `KEY := VALUE` 形式でパースし、辞書として返す |
| 3-3 | make.jl | `doc/make.jl` | 94-140行目: `documenter_stdlib_remotes` の構築。各 `.version` ファイルから `{PACKAGE}_GIT_URL` と `{PACKAGE}_SHA1` を取得し、`Documenter.Remotes.GitHub` オブジェクトに変換する |

**主要処理フロー**:
- **50行目**: `doc/src/stdlib/` ディレクトリを再作成
- **53-69行目**: STDLIB_DIR 内の各ディレクトリについてシンボリックリンクを作成
- **97-99行目**: `stdlib/` 内の `.version` ファイルを列挙
- **105-131行目**: 各 `.version` ファイルをパースし、remotes エントリを構築
- **132-139行目**: Julia リポジトリ自体のリモート情報も追加

#### Step 4: makedocs 呼び出しとオプション設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | make.jl | `doc/make.jl` | 349-390行目: DocTestSetup の設定。各 stdlib モジュールに対して `using {Module}` をセットアップし、一部のモジュール（SparseArrays, UUIDs, Pkg, Base.BinaryPlatforms）には追加の setup を設定する |
| 4-2 | make.jl | `doc/make.jl` | 392-412行目: `format` 定数の決定。`render_pdf` フラグに基づいて `Documenter.HTML` または `Documenter.LaTeX` を選択し、各種オプション（prettyurls, canonical, assets 等）を設定する |
| 4-3 | make.jl | `doc/make.jl` | 415-429行目: `makedocs()` 呼び出し。source, build, modules, doctest, linkcheck, format, pages, remotes 等の全パラメータを指定してドキュメント生成を実行する |

**主要処理フロー**:
- **415行目**: `makedocs()` の呼び出し開始
- **416行目**: `source = joinpath(buildrootdoc, "src")` でソースディレクトリを指定
- **417行目**: `build = output_path` で出力先を指定（`doc/_build/html/en` または `doc/_build/pdf/en`）
- **418行目**: `modules` に Main, Base, Core と全 stdlib モジュールを指定
- **420行目**: `doctest` オプションの設定（`:fix`, `:only`, `true`, `false` のいずれか）
- **427行目**: `pages = PAGES` でページ構成を指定

#### Step 5: ビルド後処理とデプロイを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | make.jl | `doc/make.jl` | 432-455行目: 外部 stdlib URL の後処理。生成された HTML ファイルを走査し、正規表現置換で stdlib のソースリンクを正しい GitHub リポジトリ URL に書き換える |
| 5-2 | make.jl | `doc/make.jl` | 458-486行目: `BuildBotConfig` 構造体とデプロイ制御。`deploy_folder` メソッドでタグ付きコミット、master ブランチ、release ブランチごとのデプロイサブフォルダを決定する |
| 5-3 | make.jl | `doc/make.jl` | 513-522行目: `deploydocs()` 呼び出し。`docs.julialang.org` リポジトリにドキュメントをデプロイする |

**主要処理フロー**:
- **432行目**: 出力ディレクトリ内の全 HTML ファイルを走査
- **440-452行目**: 4種類の正規表現置換で外部 stdlib の URL を修正
- **467-479行目**: GIT_VERSION_INFO に基づくデプロイ先サブフォルダの決定
- **514行目**: `deploydocs()` の実行

#### Step 6: Revise.jl 統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | make.jl | `doc/make.jl` | 325-347行目: `maybe_revise` 関数。`revise=true` が指定された場合、DocTestSetup に Revise.jl のトラッキングコードを挿入する。Core.Compiler、Base、および全 stdlib モジュールを追跡対象とする |

**主要処理フロー**:
- **330行目**: `use_revise` が false の場合は式をそのまま返す
- **332行目**: STDLIB_DIR から stdlib 名一覧を取得
- **336-346行目**: Revise.jl で Base、Core.Compiler、全 stdlib を追跡し、`Revise.revise()` を呼び出すコードを生成

### プログラム呼び出し階層図

```
make docs (Makefile)
    |
    +-- deps ターゲット
    |      +-- UnicodeData.txt ダウンロード
    |      +-- チェックサム検証 (JLCHECKSUM)
    |
    +-- html ターゲット
           +-- julia doc/make.jl [DOCUMENTER_OPTIONS]
                  |
                  +-- buildroot/stdlibdir パラメータ解析 (1-22行目)
                  +-- Pkg.activate / Pkg.instantiate (25-31行目)
                  +-- stdlib シンボリックリンク作成 (50-69行目)
                  |      +-- readdir(STDLIB_DIR)
                  |      +-- symlink_q / cp_q
                  |
                  +-- parse_stdlib_version_file (80-91行目)
                  |      +-- readlines / match
                  |
                  +-- documenter_stdlib_remotes 構築 (94-140行目)
                  |      +-- Documenter.Remotes.GitHub
                  |
                  +-- generate_markdown("NEWS") (146-159行目)
                  |      +-- read / replace / write
                  |
                  +-- DocMeta.setdocmeta! (349-390行目)
                  |      +-- maybe_revise (325-347行目)
                  |             +-- [optional] Revise.track
                  |
                  +-- makedocs() (415-429行目)
                  |      +-- Documenter.HTML / Documenter.LaTeX
                  |
                  +-- 外部 stdlib URL 後処理 (432-455行目)
                  |      +-- walkdir / replace / write
                  |
                  +-- [optional] deploydocs() (513-522行目)
                         +-- BuildBotConfig.deploy_folder (461-486行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

doc/src/**/*.md    ─────────┐
                            ├──▶ makedocs()  ──────────────────▶ doc/_build/html/en/**/*.html
base/**/*.jl (docstrings)  ─┤       |                              (HTML ドキュメント)
                            │       |
stdlib/*/docs/src/index.md ─┤       ├──▶ Documenter.HTML()         doc/_build/pdf/en/*.pdf
  (symlink経由)             │       |    Documenter.LaTeX()         (PDF ドキュメント)
                            │       |
stdlib/**/*.jl (docstrings)─┤       ├──▶ doctest 検証
                            │
NEWS.md ────────────────────┤
  (generate_markdown変換)    │
                            │
stdlib/*.version ───────────┘
  (remotes情報)                     |
                                    ▼
                            外部stdlib URL後処理
                                    |
                                    ▼
                            [optional] deploydocs()
                                    |
                                    ▼
                            docs.julialang.org
                            (Git push デプロイ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| make.jl | `doc/make.jl` | ソース | ドキュメント生成のメインスクリプト。Documenter.jl の makedocs/deploydocs を呼び出す |
| Makefile | `doc/Makefile` | 設定 | ビルドターゲット定義（html, pdf, deploy, deps 等）とパラメータ管理 |
| NEWS-update.jl | `doc/NEWS-update.jl` | ソース | NEWS.md 内の Issue 参照にフットノートリンクを自動挿入するスクリプト |
| index.md | `doc/src/index.md` | テンプレート | ドキュメントのトップページ。バージョン情報と Julia の紹介を含む |
| Project.toml | `deps/jlutilities/documenter/Project.toml` | 設定 | Documenter パッケージの依存関係定義 |
| Manifest.toml | `deps/jlutilities/documenter/Manifest.toml` | 設定 | Documenter パッケージの依存関係ロックファイル（v1.16.1） |
| julia-manual.css | `doc/src/assets/julia-manual.css` | アセット | HTML ドキュメントのカスタムスタイルシート |
| julia.ico | `doc/src/assets/julia.ico` | アセット | HTML ドキュメントの favicon |
| custom.sty | `doc/src/assets/custom.sty` | アセット | PDF 版のカスタム LaTeX スタイル |
| cover.tex | `doc/src/assets/cover.tex` | アセット | PDF 版の表紙テンプレート |
| preamble.tex | `doc/src/assets/preamble.tex` | アセット | PDF 版の LaTeX プリアンブル |
| documentation.md | `doc/src/devdocs/contributing/documentation.md` | ドキュメント | ドキュメント修正手順のガイド |
| jldoctests.md | `doc/src/devdocs/contributing/jldoctests.md` | ドキュメント | doctest の書き方ガイド |
