# 帳票設計書 5-ページプロファイル

## 概要

本ドキュメントは、Julia の `Profile.take_page_profile()` によって出力されるページプロファイルの設計仕様を記述する。

### 本帳票の処理概要

本帳票は、Julia の GC（ガベージコレクター）のプールアロケーターのページレベルのメモリ使用状況を JSON 形式でファイルに出力するレポートである。プールに割り当てられた各オブジェクトについて、それがガベージ（回収可能）なのか、使用中の型付きオブジェクトなのかを記録する。

**業務上の目的・背景**：Julia の GC のプールアロケーターがどのようにメモリページを使用しているかを詳細に把握することで、メモリフラグメンテーションの分析や GC チューニングに活用できる。ページ単位のメモリ使用パターンを可視化することで、メモリ効率の改善ポイントを特定できる。

**帳票の利用シーン**：GC のパフォーマンス問題を詳細に調査する際に使用する。特に、メモリフラグメンテーションが疑われる場合や、プールアロケーターの動作を深く理解したい場合に利用される。Julia ランタイム開発者やパフォーマンスエンジニア向けの低レベル診断ツールである。

**主要な出力内容**：
1. プール割り当てオブジェクトごとの状態（ガベージか型付きオブジェクトか）
2. 型情報（使用中の場合）
3. ページ単位のメモリ使用状況

**帳票の出力タイミング**：`Profile.take_page_profile()` を明示的に呼び出したとき。

**帳票の利用者**：Julia ランタイム開発者、GC パフォーマンスエンジニア。

## 帳票種別

スナップショット（GC ページレベルメモリ使用状況ダンプ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Julia REPL | julia> | `Profile.take_page_profile(filepath)` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | 引数で指定 |
| 出力方法 | ファイル書き出し / IOStream への書き出し |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

ページプロファイルは JSON 形式で、プールアロケーターの各ページに含まれるオブジェクトの状態を記録する。

```
┌─────────────────────────────────────────┐
│  JSON ファイル                            │
├─────────────────────────────────────────┤
│  [                                       │
│    {                                     │
│      "type": "garbage" | "TypeName",     │
│      ...                                 │
│    },                                    │
│    ...                                   │
│  ]                                       │
└─────────────────────────────────────────┘
```

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| filepath / io | 出力先（ファイルパスまたは IOStream） | Yes |

### 改ページ条件

N/A（JSON ファイル出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| GCプールページ（jl_gc_take_page_profile） | プールアロケーターのページ情報 | - |

## 計算仕様

### 計算項目一覧

本帳票は計算処理を行わず、GC 内部データをそのまま JSON として出力する。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A["take_page_profile(filepath) 呼び出し"] --> B["open(filepath, 'w')"]
    B --> C["take_page_profile(io::IOStream)"]
    C --> D["@_lock_ios(io, ccall(:jl_gc_take_page_profile))"]
    D --> E["ファイルクローズ"]
    E --> F["filepath を返却"]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイルオープン失敗 | 指定パスに書き込めない | OS レベルのエラー | 書き込み可能なパスを指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | プールページ数に依存 |
| 目標出力時間 | ヒープサイズに依存 |
| 同時出力数上限 | 1（IO ロック取得が必要） |

## セキュリティ考慮事項

ページプロファイルにはオブジェクトの型情報が含まれるため、プログラムの内部構造が推測される可能性がある。

## 備考

- `take_page_profile` は `IOStream` または `String`（ファイルパス）を受け取る。
- IOStream 版は `@_lock_ios` マクロで IO アクセスをロックして ccall を実行する。
- ファイルパス版は `open()` でファイルをオープンし、IOStream 版に委譲する。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `take_page_profile(io::IOStream)` 関数（行1477-1479）で、ccall による C 関数呼び出しを理解する |
| 1-2 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `take_page_profile(filepath::String)` 関数（行1480-1485）で、ファイルオープンとIOStream版への委譲を理解する |

**主要処理フロー**:
1. **行1480-1485**: `open(filepath, "w")` でファイルをオープン
2. **行1482**: IOStream 版の `take_page_profile(io)` を呼び出し
3. **行1478**: `@_lock_ios` でロックを取得し `jl_gc_take_page_profile` を ccall
4. **行1484**: `filepath` を返却

#### Step 2: docstring を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | docstring（行1471-1476）で、出力内容（JSON、プール割り当てオブジェクトの状態）を確認する |

### プログラム呼び出し階層図

```
Profile.take_page_profile(filepath::String)
    |
    +-- open(filepath, "w")
            |
            +-- take_page_profile(io::IOStream)
                    |
                    +-- @_lock_ios(io, ...)
                            |
                            +-- ccall(:jl_gc_take_page_profile, Cvoid, (Ptr{Cvoid},), io.handle)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GCプールページ ──ccall──> jl_gc_take_page_profile ──> JSON ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Profile.jl | `stdlib/Profile/src/Profile.jl` | ソース | take_page_profile 関数（行1471-1485） |
