# 帳票設計書 9-バージョン情報レポート

## 概要

本ドキュメントは、Julia の `versioninfo()` によって出力されるバージョン情報レポートの設計仕様を記述する。

### 本帳票の処理概要

本帳票は、Julia の実行環境に関する詳細なバージョン情報とシステム構成情報をテキスト形式で標準出力にレポートする。Julia バージョン、Git コミット情報、ビルド情報、OS/CPU 情報、LLVM バージョン、GC 実装、スレッド構成、関連する環境変数などを出力する。

**業務上の目的・背景**：バグ報告、パフォーマンス比較、環境の再現性確認のために、Julia の実行環境の完全な情報を取得する必要がある。特にバグ報告時には、問題の再現に必要な環境情報を正確に伝えることが不可欠である。

**帳票の利用シーン**：バグ報告を作成する際、環境の差異を調査する際、CI/CD のログに環境情報を記録する際に使用する。`verbose=true` オプションで、詳細なシステム情報（メモリ量、稼働時間、負荷平均等）も取得可能。

**主要な出力内容**：
1. Julia Version：Julia のバージョン番号
2. Commit：Git コミットハッシュと日付
3. Build Info：デバッグビルド情報、タグ付きリリースバナー
4. Platform Info：OS、CPU、WORD_SIZE、LLVM、GC、スレッド情報
5. Environment：JULIA_ プレフィックスの環境変数等

**帳票の出力タイミング**：`versioninfo()` を明示的に呼び出したとき。

**帳票の利用者**：Julia プログラムの開発者、バグ報告者、システム管理者。

## 帳票種別

情報レポート（環境情報の表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Julia REPL | julia> | `versioninfo()` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout）またはIOへの出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

バージョン情報レポートは、セクション区切りなしの連続テキスト形式である。

```
Julia Version 1.12.0-DEV.123
Commit abc1234 (2026-01-15 12:00 UTC)
Build Info:
  Official https://julialang.org release
Platform Info:
  OS: macOS (arm64-apple-darwin23.6.0)
  CPU: 10 x Apple M1 Pro
  WORD_SIZE: 64
  LLVM: libLLVM-18.1.7 (ORCJIT, apple-m1)
  GC: stock
Threads: 8 default, 0 interactive, 2 GC (on 10 virtual cores)
Environment:
  JULIA_EDITOR = code
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 表示条件 |
|----|-------|------|-------------|---------|---------|
| 1 | Julia Version | Juliaバージョン | `VERSION` | `"Julia Version $VERSION"` | 常に表示 |
| 2 | Commit | Gitコミットハッシュと日付 | `Base.GIT_VERSION_INFO` | `"Commit {hash} ({date})"` | コミット情報が空でない場合 |
| 3 | Build Info セクション | ビルド関連情報 | `Base.isdebugbuild()`, `Base.TAGGED_RELEASE_BANNER` | セクションヘッダー付き | デバッグビルドまたはタグ付きの場合 |
| 4 | DEBUG build | デバッグビルドフラグ | `Base.isdebugbuild()` | `"  DEBUG build"` | デバッグビルドの場合のみ |
| 5 | Release Banner | リリースバナー | `Base.TAGGED_RELEASE_BANNER` | `"  {banner}"` | バナーが空でない場合 |
| 6 | Unofficial build note | 非公式ビルド警告 | `GIT_VERSION_INFO.tagged_commit` | 複数行テキスト | タグ付き非公式ビルドの場合 |
| 7 | Platform Info | プラットフォーム情報セクション | - | `"Platform Info:"` | 常に表示 |
| 8 | OS | オペレーティングシステム | `Sys.iswindows()`, `Sys.isapple()`, `Sys.KERNEL`, `Sys.MACHINE` | `"  OS: {os} ({machine})"` | 常に表示 |
| 9 | OS詳細 | lsb_release / ver | `lsb_release -ds` (Linux), `ver` (Windows) | `"      {detail}"` | verbose=true の場合 |
| 10 | uname | カーネル情報 | `uname -mprsv` | `"  uname: {info}"` | verbose=true かつ Unix の場合 |
| 11 | CPU | CPU情報 | `Sys.cpu_info()` / `Sys.cpu_summary()` | `"  CPU: {count} x {model}"` / 詳細表示 | 常に表示（verbose で詳細化） |
| 12 | Memory | メモリ情報 | `Sys.total_memory()`, `Sys.free_memory()` | `"  Memory: {total} GB ({free} MB free)"` | verbose=true の場合 |
| 13 | Uptime | システム稼働時間 | `Sys.uptime()` | `"  Uptime: {sec} sec"` | verbose=true の場合 |
| 14 | Load Avg | 負荷平均 | `Sys.loadavg()` | マトリクス表示 | verbose=true の場合 |
| 15 | WORD_SIZE | ワードサイズ | `Sys.WORD_SIZE` | `"  WORD_SIZE: {size}"` | 常に表示 |
| 16 | LLVM | LLVMバージョン | `Base.libllvm_version`, `Sys.JIT`, `Sys.CPU_NAME` | `"  LLVM: libLLVM-{ver} ({jit}, {cpu})"` | 常に表示 |
| 17 | GC | GC実装名 | `ccall(:jl_gc_active_impl)` | `"  GC: {impl}"` | 常に表示 |
| 18 | Threads | スレッド構成 | `Threads.nthreads()`, `Threads.ngcthreads()`, `Sys.CPU_THREADS` | `"Threads: {n} default, {i} interactive, {g} GC (on {c} virtual cores)"` | 常に表示 |
| 19 | Environment | 環境変数 | `ENV` | `"  {key} = {value}"` | JULIA_ / DYLD_ / LD_ プレフィックス、verbose で追加 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| io | 出力先IO（デフォルト: stdout） | No |
| verbose | 詳細情報を含める（デフォルト: false） | No |

### 環境変数フィルタ

| フィルタ | 対象パターン | 表示条件 |
|---------|------------|---------|
| is_nonverbose_env | `^JULIA_\|^DYLD_\|^LD_` | 常に表示 |
| is_verbose_env | `PATH\|FLAG\|^TERM$\|HOME`（nonverbose除外） | verbose=true の場合のみ |

## データベース参照仕様

本帳票はデータベースを参照しない。ランタイム定数とシステム情報 API から直接取得する。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| メモリ (GB) | `Sys.total_memory() / 2^30` | なし（Float64） | verbose 時のみ |
| 空きメモリ (MB) | `Sys.free_memory() / 2^20` | なし（Float64） | verbose 時のみ |
| official_release | `Base.TAGGED_RELEASE_BANNER == "Official https://julialang.org release"` | - | ビルド情報表示制御 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A["versioninfo(io; verbose) 呼び出し"] --> B["Julia Version 出力"]
    B --> C{コミット情報あり?}
    C -->|Yes| D["Commit 行出力"]
    C -->|No| E["次へ"]
    D --> E
    E --> F{デバッグビルド or タグ付き?}
    F -->|Yes| G["Build Info セクション出力"]
    F -->|No| H["Platform Info セクション出力"]
    G --> H
    H --> I["OS 情報出力"]
    I --> J["CPU 情報出力"]
    J --> K{verbose?}
    K -->|Yes| L["Memory, Uptime, Load Avg 出力"]
    K -->|No| M["次へ"]
    L --> M
    M --> N["WORD_SIZE, LLVM, GC, Threads 出力"]
    N --> O["Environment 変数出力"]
    O --> P["終了"]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| lsb_release 失敗 | コマンドが存在しない | 静かにスキップ（try-catch） | OS 詳細は表示されない |
| Uptime 取得失敗 | システムコール失敗 | 静かにスキップ（try-catch） | Uptime は表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の情報取得 |
| 目標出力時間 | ほぼ即座（verbose時にシステムコール遅延あり） |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

**重要**：`versioninfo()` の出力には機密情報が含まれる可能性がある。公式ドキュメントにも以下の警告がある：

> "The output of this function may contain sensitive information. Before sharing the output, please review the output and remove any data that should not be shared publicly."

特に環境変数（PATH、HOME等）にはユーザー名やディレクトリ構造が含まれる場合がある。`verbose=true` ではさらに多くの環境変数が出力される。

## 備考

- `versioninfo()` は `InteractiveUtils` モジュールで定義されている。
- `verbose=false`（デフォルト）では最小限の情報のみ出力される。
- CPU 情報は `verbose=true` で `Sys.cpu_summary()` の詳細出力に変わる。
- GC 実装名は `ccall(:jl_gc_active_impl, Ptr{UInt8}, ())` で取得される。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `versioninfo(io::IO; verbose::Bool)` 関数（行103-191）で、全体のフローを理解する |

**主要処理フロー**:
1. **行104**: Julia Version を出力
2. **行105-107**: Commit 情報を出力（空でない場合）
3. **行108-127**: Build Info セクション（デバッグビルドまたはタグ付きリリースの場合）
4. **行128-131**: OS 情報を出力
5. **行132-158**: CPU 情報（verbose で詳細化）
6. **行160-166**: verbose 時の Memory, Uptime, Load Avg
7. **行167-169**: WORD_SIZE, LLVM, GC
8. **行170-171**: Threads 情報
9. **行173-191**: Environment 変数（フィルタ付き）

#### Step 2: 環境変数フィルタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `is_nonverbose_env()` 関数（行173-175）と `is_verbose_env()` 関数（行176-178）で環境変数フィルタを理解する |

**読解のコツ**: 環境変数は2段階のフィルタで選別される。JULIA_/DYLD_/LD_ プレフィックスの変数は常に表示される。PATH/FLAG/TERM/HOME パターンの変数は verbose 時のみ追加表示される。

### プログラム呼び出し階層図

```
versioninfo(io; verbose=false)
    |
    +-- println(io, "Julia Version $VERSION")
    +-- println(io, "Commit ...")            # GIT_VERSION_INFO
    +-- println(io, "Build Info:")            # 条件付き
    |       +-- isdebugbuild()
    |       +-- TAGGED_RELEASE_BANNER
    +-- println(io, "Platform Info:")
    |       +-- Sys.iswindows() / isapple() / KERNEL
    |       +-- (verbose) lsb_release / uname
    |       +-- Sys.cpu_info() / cpu_summary()
    |       +-- (verbose) total_memory() / free_memory() / uptime() / loadavg()
    +-- println(io, "  WORD_SIZE: ...")
    +-- println(io, "  LLVM: ...")
    +-- println(io, "  GC: ...")             # ccall(:jl_gc_active_impl)
    +-- println(io, "Threads: ...")
    +-- println(io, "Environment:")
            +-- is_nonverbose_env(k)
            +-- (verbose) is_verbose_env(k)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

VERSION ──────────────────> println ──────────> "Julia Version ..."
GIT_VERSION_INFO ─────────> println ──────────> "Commit ..."
Base.isdebugbuild() ──────> 条件分岐 ────────> "Build Info: ..."
Sys.KERNEL / MACHINE ─────> println ──────────> "  OS: ..."
Sys.cpu_info() ───────────> println ──────────> "  CPU: ..."
Sys.WORD_SIZE ────────────> println ──────────> "  WORD_SIZE: ..."
Base.libllvm_version ─────> println ──────────> "  LLVM: ..."
ccall(:jl_gc_active_impl) > println ──────────> "  GC: ..."
Threads.nthreads() ───────> println ──────────> "Threads: ..."
ENV (filtered) ───────────> println ──────────> "Environment: ..."
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | ソース | versioninfo 関数（行89-191） |
