---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-CPUプロファイルレポート（フラットフォーマット）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：具体的な数値根拠なし
  2. **エディタ連携の網羅性**：全エディタのテスト確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/Profile/src/Profile.jl` 行44（nmeta定数）
- E-02: `stdlib/Profile/src/Profile.jl` 行191-192（LineInfoDict型定義）
- E-03: `stdlib/Profile/src/Profile.jl` 行194-212（ProfileFormat構造体）
- E-04: `stdlib/Profile/src/Profile.jl` 行215-218（META_OFFSET定数）
- E-05: `stdlib/Profile/src/Profile.jl` 行271-361（print関数）
- E-06: `stdlib/Profile/src/Profile.jl` 行382-398（print_group関数）
- E-07: `stdlib/Profile/src/Profile.jl` 行750-815（parse_flat関数）
- E-08: `stdlib/Profile/src/Profile.jl` 行819-853（flat関数）
- E-09: `stdlib/Profile/src/Profile.jl` 行889-969（print_flat関数）
- E-10: `stdlib/Profile/src/Profile.jl` 行546-595（short_path関数）
- E-11: `stdlib/Profile/src/Profile.jl` 行857-887（editor_link関数）
- E-12: `stdlib/Profile/src/Profile.jl` 行686-703（fetch関数）
- E-13: `stdlib/Profile/src/Profile.jl` 行159-174（default_init関数）
- E-14: `stdlib/Profile/src/Profile.jl` 行363-368（print(path)関数）
- E-15: `stdlib/Profile/src/Profile.jl` 行1005（PACKAGE_FIXEDCOLORS定数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | format=:flatでフラット形式出力される | E-05, E-06 | ○ |
| C-02 | デフォルトフォーマットは:tree | E-05 (行275) | ○ |
| C-03 | Count列は最小幅6桁 | E-09 (行905) | ○ |
| C-04 | Overhead列は最小幅9桁 | E-09 (行906) | ○ |
| C-05 | nmeta=4でメタデータフィールド数 | E-01 | ○ |
| C-06 | META_OFFSET_SLEEPSTATE=2 | E-04 | ○ |
| C-07 | Utilization計算式 (1-nsleeping/totalshots)*100 | E-08 (行828) | ○ |
| C-08 | ソート順は3種類（filefuncline, count, overhead） | E-09 (行893-898) | ○ |
| C-09 | parse_flatで再帰呼び出しを除外してカウント | E-07 (行805-808) | ○ |
| C-10 | バッファデフォルトサイズ10,000,000 | E-13 (行170) | ○ |
| C-11 | デフォルトサンプル間隔0.001秒 | E-13 (行171) | ○ |
| C-12 | ファイル出力時のカラム幅デフォルト1000 | E-14 (行365) | ○ |
| C-13 | パッケージ色はPACKAGE_FIXEDCOLORSで定義 | E-15 | ○ |
| C-14 | VS Code対応のエディタリンク生成 | E-11 (行869) | ○ |
| C-15 | Sublime Text対応のエディタリンク生成 | E-11 (行871) | ○ |
| C-16 | IntelliJ IDEA対応のエディタリンク生成 | E-11 (行873) | ○ |
| C-17 | fetchでバッファフル警告を出力 | E-12 (行692-696) | ○ |
| C-18 | メタデータ欠落時にエラー | E-07 (行752) | ○ |
| C-19 | C=falseがデフォルトでC/Fortranフレーム除外 | E-05 (行276) | ○ |
| C-20 | combine=trueがデフォルト | E-05 (行277) | ○ |
| C-21 | threads/tasksでフィルタ可能 | E-05 (行284-285), E-07 (行776) | ○ |
| C-22 | groupby オプションの種類 | E-05 (行291) | ○ |
| C-23 | short_pathでパッケージプレフィックス付与 | E-10 | ○ |
| C-24 | パフォーマンス目標出力時間「データ量に依存」 | **根拠なし** | △ |
| C-25 | 全エディタでクリッカブルリンクが動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値：プロファイルデータサイズに対する出力時間のベンチマークデータが存在しない
  - 候補：パフォーマンステスト / ベンチマーク結果 / CI ログ
- エディタ連携の全エディタでの動作確認：一部エディタ（vim, emacs）はプラグイン依存の可能性がある
  - 候補：各エディタでの動作確認テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力フォーマットの記述はソースコードと完全一致
- 0: 低リスク - データ構造の記述はソースコード定数と一致
- 1: 中リスク - パフォーマンス要件は推定値であり実測データなし

## 6) レビュアーチェックリスト（最小）
- [ ] Count/Overhead の計算ロジックが parse_flat のソースコードと一致しているか
- [ ] ソート順の記述が print_flat のソースコードと一致しているか
- [ ] メタデータオフセットの記述が META_OFFSET_* 定数と一致しているか
- [ ] エディタリンクの URI フォーマットが editor_link 関数と一致しているか
