---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：11-Documenter.jl ドキュメント生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **PDF LaTeX 用紙サイズ A4**：LaTeX テンプレート内の用紙設定は直接確認していない
  2. **目標出力時間**：doctest 付きビルドの 15 分上限は AGENTS.md の記述に基づくが、HTML のみの「数分程度」は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `doc/make.jl`（1-526行目）
- E-02: `doc/Makefile`（1-84行目）
- E-03: `doc/NEWS-update.jl`（1-20行目）
- E-04: `doc/src/index.md`（1-128行目）
- E-05: `deps/jlutilities/documenter/Project.toml`（1-3行目）
- E-06: `deps/jlutilities/documenter/Manifest.toml`（Documenter v1.16.1）
- E-07: `doc/src/devdocs/contributing/documentation.md`（1-88行目）
- E-08: `doc/src/devdocs/contributing/jldoctests.md`（1-115行目）
- E-09: `doc/src/assets/` ディレクトリ一覧（julia-manual.css, julia.ico, custom.sty, cover.tex, preamble.tex 等）
- E-10: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（No.11 の定義）
- E-11: `AGENTS.md`（doctest の実行時間に関する記述）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | doc/make.jl を起点として Documenter.jl を使用してドキュメントを生成する | E-01 (37行目: `using Documenter`, 415行目: `makedocs()`) | ○ |
| C-02 | STDLIB_DOCS 配列で stdlib ドキュメント情報を蓄積する | E-01 (48行目: `const STDLIB_DOCS = []`) | ○ |
| C-03 | EXT_STDLIB_DOCS に Pkg が定義されている | E-01 (49行目: `const EXT_STDLIB_DOCS = ["Pkg"]`) | ○ |
| C-04 | stdlib ドキュメントはシンボリックリンクで doc/src/stdlib/ に配置される | E-01 (50-69行目: `symlink_q` 呼び出し) | ○ |
| C-05 | parse_stdlib_version_file で .version ファイルを解析する | E-01 (80-91行目: 関数定義) | ○ |
| C-06 | remotes 情報を documenter_stdlib_remotes 辞書で管理する | E-01 (94-140行目: let ブロック) | ○ |
| C-07 | NEWS.md を generate_markdown 関数で変換する | E-01 (146-159行目: 関数定義、159行目: `generate_markdown("NEWS")`) | ○ |
| C-08 | Issue リンクを `[#N](https://github.com/JuliaLang/julia/issues/N)` に変換する | E-01 (150行目: 正規表現置換) | ○ |
| C-09 | Manual は 38 ファイルで構成される | E-01 (161-204行目: Manual 配列) | ○ |
| C-10 | BaseDocs は 19 ファイルで構成される | E-01 (206-227行目: BaseDocs 配列) | ○ |
| C-11 | StdlibDocs は特殊マッピング付きでアルファベットソートされる | E-01 (233-238行目: sort! 呼び出し、Libdl/Test の特殊処理) | ○ |
| C-12 | DevDocs は 4 サブセクションで構成される | E-01 (240-303行目: DevDocs 配列、4つの Pair) | ○ |
| C-13 | revise=true で Revise.jl 統合が有効になる | E-01 (325行目: `const use_revise = "revise=true" in ARGS`、330-347行目: maybe_revise 関数) | ○ |
| C-14 | DocTestSetup で各 stdlib に using 設定を行う | E-01 (349-358行目: ループ内の setdocmeta! 呼び出し) | ○ |
| C-15 | SparseArrays の DocTestSetup には LinearAlgebra も含む | E-01 (361-366行目: `using SparseArrays, LinearAlgebra`) | ○ |
| C-16 | HTML 形式では prettyurls がデプロイ時のみ true になる | E-01 (398行目: `prettyurls = ("deploy" in ARGS)`) | ○ |
| C-17 | canonical URL は `https://docs.julialang.org/en/v1/` | E-01 (399行目) | ○ |
| C-18 | カスタム CSS として julia-manual.css を使用する | E-01 (401行目: `"assets/julia-manual.css"`) | ○ |
| C-19 | Google Analytics ID は UA-28835595-6 | E-01 (404行目: `analytics = "UA-28835595-6"`) | ○ |
| C-20 | size_threshold は 800 KiB、size_threshold_warn は 200 KiB | E-01 (408-409行目) | ○ |
| C-21 | makedocs の sitename は "The Julia Language" | E-01 (426行目) | ○ |
| C-22 | makedocs の authors は "The Julia Project" | E-01 (427行目) | ○ |
| C-23 | doctest オプションは :fix, :only, true, false の 4 種類 | E-01 (420行目: 三項演算子チェーン) | ○ |
| C-24 | linkcheck_ignore に KDE バグトラッカー URL が含まれる | E-01 (422行目: `linkcheck_ignore`) | ○ |
| C-25 | 外部 stdlib URL 後処理で 4 種類の正規表現置換を行う | E-01 (440-452行目: 4つの replace 呼び出し) | ○ |
| C-26 | ArgTools は JuliaIO、LibCURL は JuliaWeb、SHA は JuliaCrypto、Tar は JuliaIO に書き換えられる | E-01 (449-452行目) | ○ |
| C-27 | BuildBotConfig で HTTPS 認証を使用する | E-01 (459行目: `Documenter.authentication_method(::BuildBotConfig) = Documenter.HTTPS`) | ○ |
| C-28 | デプロイ先は docs.julialang.org.git | E-01 (460行目, 515行目) | ○ |
| C-29 | タグ付きコミットで v{VERSION} サブフォルダにデプロイ | E-01 (467-472行目) | ○ |
| C-30 | master ブランチで devurl サブフォルダにデプロイ | E-01 (473-474行目) | ○ |
| C-31 | Makefile の html ターゲットが deps を前提条件とする | E-02 (62行目: `html: deps`) | ○ |
| C-32 | Documenter.jl v1.16.1 を使用する | E-06 (version = "1.16.1") | ○ |
| C-33 | make docs コマンドでドキュメントビルドが可能 | E-07 (5-11行目: `make docs` の説明) | ○ |
| C-34 | PDF 版の用紙サイズは A4 | **根拠なし** | △ |
| C-35 | HTML のみビルドの目標出力時間は数分程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-34: PDF 版の用紙サイズについて、`doc/src/assets/custom.sty` や `preamble.tex` の内容を直接確認していないため、A4 であるかの確証がない。Documenter.jl の LaTeX バックエンドのデフォルト設定に依存する可能性がある。
  - 候補：`doc/src/assets/custom.sty` / `doc/src/assets/preamble.tex` / Documenter.jl LaTeX ソースコード
- C-35: HTML のみビルドの実行時間について、具体的なベンチマーク結果やドキュメント上の記載がない。AGENTS.md では doctest 付きビルドが最大 15 分と記載されているが、HTML のみの時間は推定値である。
  - 候補：CI ビルドログ / ベンチマーク結果 / 開発者コミュニティの報告

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードから直接確認可能であり、信頼性が高い
- 0: 低リスク - PAGES 配列やオプション設定は make.jl の該当行番号で正確に確認できる
- 1: 中リスク - PDF 関連設定（用紙サイズ等）は LaTeX テンプレートファイルの直接確認が必要
- 0: 低リスク - デプロイ設定・URL 後処理のロジックはソースコードから完全に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] PDF 版の用紙サイズ設定を `doc/src/assets/custom.sty` および `doc/src/assets/preamble.tex` で確認
- [ ] HTML ビルドの実行時間について実際の CI ビルドログと照合
- [ ] Documenter.jl v1.16.1 の仕様変更がないか、Manifest.toml のバージョンが最新のものと一致するか確認
- [ ] 外部 stdlib（ArgTools, LibCURL, SHA, Tar）の Organization マッピングが最新の状態と一致するか確認
- [ ] PAGES 配列のファイル数（Manual 38、Base 19）が実際の doc/src/ 配下のファイル数と一致するか確認
