---
generated_at: 2026-02-05 10:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：2-CPUプロファイルレポート（ツリーフォーマット）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標出力時間）**：具体的な数値根拠なし
  2. **ツリー構築の最悪計算量**：分析なし

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Profile.jl` 行974-990（StackFrameTree構造体）
- E-02: `stdlib/Profile/src/Profile.jl` 行271-361（print関数）
- E-03: `stdlib/Profile/src/Profile.jl` 行382-398（print_group関数）
- E-04: `stdlib/Profile/src/Profile.jl` 行1080-1217（tree!関数）
- E-05: `stdlib/Profile/src/Profile.jl` 行1282-1313（tree関数）
- E-06: `stdlib/Profile/src/Profile.jl` 行1238-1280（print_tree関数）
- E-07: `stdlib/Profile/src/Profile.jl` 行1007-1077（tree_format関数）
- E-08: `stdlib/Profile/src/Profile.jl` 行1219-1234（maxstats関数）
- E-09: `stdlib/Profile/src/Profile.jl` 行993-1002（indent関数）
- E-10: `stdlib/Profile/src/Profile.jl` 行275（format=:treeデフォルト）
- E-11: `stdlib/Profile/src/Profile.jl` 行297-300（ヘッダー出力）
- E-12: `stdlib/Profile/src/Profile.jl` 行1256-1268（ソート順オプション）
- E-13: `stdlib/Profile/src/Profile.jl` 行1275（noisefloor計算）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | format=:treeがデフォルト出力形式 | E-10 | ○ |
| C-02 | StackFrameTreeはPrefix Trieとして設計 | E-01 | ○ |
| C-03 | downフィールドが子ノード辞書 | E-01 (行983) | ○ |
| C-04 | overhead値が太字表示される | E-07 (行1067-1069) | ○ |
| C-05 | スリープ中フレームがグレー表示 | E-07 (行1046) | ○ |
| C-06 | インデントは"    ╎"の繰り返し | E-09 (行993) | ○ |
| C-07 | ヘッダー行の内容 | E-11 (行298-299) | ○ |
| C-08 | ソート順は4種類 | E-12 | ○ |
| C-09 | noisefloor計算式 floor(Int, noisefloor * sqrt(count)) | E-13 | ○ |
| C-10 | tree!で後方走査してツリー構築 | E-04 (行1091) | ○ |
| C-11 | ブロック末尾でメタデータ読み取り | E-04 (行1094-1106) | ○ |
| C-12 | recur=:flatで再帰圧縮 | E-04 (行1138-1158) | ○ |
| C-13 | Utilization計算式 | E-05 (行1289) | ○ |
| C-14 | worklist方式でスタックオーバーフロー回避 | E-06 (行1246) | ○ |
| C-15 | maxstatsで最大値統計を取得 | E-08 | ○ |
| C-16 | groupbyオプションの種類 | E-02 (行291) | ○ |
| C-17 | Windowsではメインスレッドのみ | E-02 (行293-294) | ○ |
| C-18 | 深いネストは+N表記で圧縮 | E-07 (行1016-1020, 1026-1028) | ○ |
| C-19 | builder_key/builder_valueは最適化用キャッシュ | E-01 (行986-987), E-04 (行1160-1201) | ○ |
| C-20 | cleanup!でビルダーキャッシュを清掃 | E-04 (行1204-1215) | ○ |
| C-21 | flat_countはルートまで遡って加算 | E-04 (行1127-1132) | ○ |
| C-22 | max_recurは再帰の最大深度 | E-01 (行980) | ○ |
| C-23 | count_recurは再帰回数の合計 | E-01 (行981) | ○ |
| C-24 | sleepingフラグはANDで伝播 | E-04 (行1153, 1173, 1195) | ○ |
| C-25 | サンプルなし時の警告メッセージ | E-05 (行1291-1299) | ○ |
| C-26 | recur値のバリデーション | E-03 (行387) | ○ |
| C-27 | パフォーマンス目標出力時間 | **根拠なし** | △ |
| C-28 | ツリー構築の計算量 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値：ツリー構築・出力の所要時間に関するベンチマークデータが存在しない
  - 候補：パフォーマンステスト / ベンチマーク結果
- ツリー構築の計算量分析：大量サンプル時のメモリ使用量や処理時間の見積もりなし
  - 候補：アルゴリズム解析 / 大規模データでのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - StackFrameTree構造体のフィールド記述はソースコードと一致
- 0: 低リスク - ツリー構築ロジックの記述はソースコードと整合
- 1: 中リスク - 大規模データでのメモリ消費に関する記述なし

## 6) レビュアーチェックリスト（最小）
- [ ] StackFrameTree のフィールド定義がソースコードと一致しているか
- [ ] tree! のツリー構築ロジックの記述が正確か
- [ ] ソート順オプション（4種類）がソースコードと一致しているか
- [ ] noisefloor の計算式がソースコードと一致しているか
- [ ] インデント文字列の記述が indent 関数と一致しているか
